/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TByteFunction;
import gnu.trove.TByteProcedure;
import gnu.trove.TFloatByteIterator;
import gnu.trove.TFloatByteProcedure;
import gnu.trove.TFloatHash;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TFloatByteHashMap
extends TFloatHash {
    protected transient byte[] _values;

    public TFloatByteHashMap() {
    }

    public TFloatByteHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TFloatByteHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TFloatByteHashMap(TFloatHashingStrategy strategy) {
        super(strategy);
    }

    public TFloatByteHashMap(int initialCapacity, TFloatHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TFloatByteHashMap(int initialCapacity, float loadFactor, TFloatHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public Object clone() {
        TFloatByteHashMap m = (TFloatByteHashMap)super.clone();
        m._values = this._values == null ? null : (byte[])this._values.clone();
        return m;
    }

    public TFloatByteIterator iterator() {
        return new TFloatByteIterator(this);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? null : new byte[capacity];
        return capacity;
    }

    public byte put(float key, byte value) {
        byte previous = 0;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        byte previousState = this._states[index];
        this._set[index] = key;
        this._states[index] = 1;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        float[] oldKeys = this._set;
        byte[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new float[newCapacity];
        this._values = new byte[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            float o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
            this._states[index] = 1;
        }
    }

    public byte get(float key) {
        int index = this.index(key);
        return index < 0 ? (byte)0 : this._values[index];
    }

    public void clear() {
        super.clear();
        float[] keys = this._set;
        byte[] vals = this._values;
        if (vals == null) {
            return;
        }
        byte[] states = this._states;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0.0f;
            vals[i] = 0;
            states[i] = 0;
        }
    }

    public byte remove(float key) {
        byte prev = 0;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TFloatByteHashMap)) {
            return false;
        }
        TFloatByteHashMap that = (TFloatByteHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    protected void removeAt(int index) {
        this._values[index] = 0;
        super.removeAt(index);
    }

    public byte[] getValues() {
        byte[] vals = new byte[this.size()];
        byte[] v = this._values;
        byte[] states = this._states;
        if (states != null) {
            int i = states.length;
            int j = 0;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                vals[j++] = v[i];
            }
        }
        return vals;
    }

    public float[] keys() {
        float[] keys = new float[this.size()];
        float[] k = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i = states.length;
            int j = 0;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                keys[j++] = k[i];
            }
        }
        return keys;
    }

    public boolean containsValue(byte val) {
        byte[] states = this._states;
        byte[] vals = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || val != vals[i]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(float key) {
        return this.contains(key);
    }

    public boolean forEachKey(TFloatProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TByteProcedure procedure) {
        byte[] states = this._states;
        byte[] values = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(values[i])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean forEachEntry(TFloatByteProcedure procedure) {
        byte[] states = this._states;
        float[] keys = this._set;
        byte[] values = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean retainEntries(TFloatByteProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        float[] keys = this._set;
        byte[] values = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        return modified;
    }

    public void transformValues(TByteFunction function) {
        byte[] states = this._states;
        byte[] values = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                values[i] = function.execute(values[i]);
            }
        }
    }

    public boolean increment(float key) {
        return this.adjustValue(key, (byte)1);
    }

    public boolean adjustValue(float key, byte amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = (byte)(this._values[n] + amount);
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            float key = stream.readFloat();
            byte val = stream.readByte();
            this.put(key, val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TFloatByteProcedure(){

            public boolean execute(float key, byte value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append(value);
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    private static final class EqProcedure
    implements TFloatByteProcedure {
        private final TFloatByteHashMap _otherMap;

        EqProcedure(TFloatByteHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(float key, byte value) {
            int index = this._otherMap.index(key);
            return index >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(byte v1, byte v2) {
            return v1 == v2;
        }
    }

    private final class HashProcedure
    implements TFloatByteProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(float key, byte value) {
            this.h += TFloatByteHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

