/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "cpptcl_member_object.h"
 *                                    created: 25/10/97 {6:42:38 pm} 
 *                                last update: 19/11/97 {1:58:10 pm} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ===================================================================
 * Copyright (c) 1997  Vince Darley
 *  
 * See the file "license.terms" for information on usage and 
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * ===================================================================
 *  Description: 
 * 
 *  History
 * 
 *  modified by  rev reason
 *  -------- --- --- -----------
 *  25/10/97 VMD 1.0 original
 * ###################################################################
 */

#ifndef _Cpptcl_cpptcl_member_object_
#define _Cpptcl_cpptcl_member_object_

#include "cpptcl_member_base.icc"
#include "cpptcl_config_mem.h"
class tcl_object;

//@Section: Cpptcl library
//@Man: 
class cpp_object_mem : public cpp_config_mem {
  protected:
    ///
    cpp_object_mem(const cpp_object_mem& c)
	:cpp_config_mem(c),required(c.required) {}
	///
	virtual bool embed_this(Tcl_Obj*,tcl_object*& e) const=0;
	///
	void remove_this_object(tcl_object *& o) const;
  public:
	Cpptcl_BaseClass(cpp_object_mem);
	/// 
	bool ensemble_behaviour(void) const { return true;}
    ///
	const meta_object* required;
	///
	cpp_object_mem(const char* n, const meta_object* required_type)
	:cpp_config_mem(n),required(required_type) {}
    ///
	~cpp_object_mem(void) {}
	///
	const char* data_type(void) const {return required->type;}
	///
	virtual tcl_object*& where_is_it(tcl_object* cont)=0;
};

//@Section: Cpptcl library
//@Man: 
class cpp_objectbag_mem : public cpp_object_mem {
  protected:
    ///
  	cpp_objectbag_mem(const cpp_objectbag_mem& c):cpp_object_mem(c) {}
	///
	virtual list<tcl_object*>& bag(tcl_object*) const=0;
	///
	tcl_object* get_bagged_item(tcl_args& arg);
	///
	virtual void remove(tcl_object* c, tcl_object* o) const=0;
	///
	virtual void append(tcl_object* c, tcl_object* o) const=0;
  public:
	///
	Cpptcl_BaseClass(cpp_objectbag_mem);
	///
	cpp_objectbag_mem(const char* n, const meta_object* r)
	:cpp_object_mem(n,r) {}
    ///
	~cpp_objectbag_mem(void) {}
	///
	int parse_tcl_command(tcl_args& arg);
    ///
	void tcl_set(tcl_object* o, tcl_args_reader& t) const;
    ///
	void tcl_get(tcl_object*, tcl_obj&) const;
	///
	tcl_object*& where_is_it(tcl_object* cont);
};

//@Section: Cpptcl library
//@Man: 
template <class T>
class cpp_objectbag_member : public cpp_objectbag_mem {
  protected:
    ///
	cpp_mem* copy(void) const {return new cpp_objectbag_member<T>(*this);}
    ///
    cpp_objectbag_member(const cpp_objectbag_member<T>& c)
	:cpp_objectbag_mem(c),loptr(c.loptr) {}
	///
	bool embed_this(Tcl_Obj* o,tcl_object*& e) const {return Cpptcl(o,(T*&)e);}
	///
	list<tcl_object*>& bag(tcl_object* c) const {
		return (list<tcl_object*>)(c->*loptr);
	}
	///
	void remove(tcl_object* c, tcl_object* o) const {(c->*loptr).remove((T*)o);}
	///
	void append(tcl_object* c, tcl_object* o) const {(c->*loptr).append((T*)o);}
	
  public:
	///
	list<T*> (tcl_object::*loptr);
	///
	cpp_objectbag_member(const char* n, list<T*> (tcl_object::*lo))
	:cpp_objectbag_mem(n,&T::_type),loptr(lo) {}
    ///
	~cpp_objectbag_member(void) {}
	///
	bool private_data(const cpp_private& data) const {
		return (data == (cpp_mptr)loptr);
	}
};

//@Section: Cpptcl library
//@Man: 
class cpp_tclobject_mem : public cpp_object_mem {
  protected:
    ///
  	cpp_tclobject_mem(const cpp_tclobject_mem& c)
	:cpp_object_mem(c),obptr(c.obptr) {}
	///
	virtual bool embed_this(Tcl_Obj*,tcl_object*& e) const=0;
  public:
	Cpptcl_BaseClass(cpp_tclobject_mem);
	/// pointer to object member of our owner
	tcl_object* (tcl_object::*obptr);
	///
	cpp_tclobject_mem(const char* n, tcl_object* (tcl_object::*optr), 
		const meta_object* required_type)
	:cpp_object_mem(n,required_type),obptr(optr) {}
    ///
	~cpp_tclobject_mem(void) {}
	///
	int parse_tcl_command(tcl_args& arg);
    ///
	void tcl_set(tcl_object* o, tcl_args_reader& t) const;
	///
	bool private_data(const cpp_private& data) const {
		return (data == (cpp_mptr)obptr);
	}
    ///
	void tcl_get(tcl_object*, tcl_obj&) const;
	///
	tcl_object*& where_is_it(tcl_object* cont) {return (cont->*obptr);}
	
};

//@Section: Cpptcl library
//@Man: 
template <class T>
class cpp_tclobject_member : public cpp_tclobject_mem {
  protected:
    ///
    cpp_tclobject_member(const cpp_tclobject_member<T>& c):cpp_tclobject_mem(c) {}
    ///
	cpp_mem* copy(void) const {return new cpp_tclobject_member<T>(*this);}
	///
	bool embed_this(Tcl_Obj* o,tcl_object*& e) const {return Cpptcl(o,(T*&)e);}
  public:
	///
	operator T* (void) { return (T*) (container->*obptr);}
	///
	cpp_tclobject_member(const char* n,tcl_object* (tcl_object::*optr))
	:cpp_tclobject_mem(n,optr,&T::_type) {}
    ///
	~cpp_tclobject_member(void) {}
};

#define cppObjmember(n,mptr,t) \
	cpp_tclobject_member<t>(n,(tcl_object* (tcl_object::*))mptr)
#define cppObjbagmember(n,mptr,t) \
	cpp_objectbag_member<t>(n,(list<t*> (tcl_object::*))mptr)

#endif
