# Arsenal Math font

## Description

Arsenal Math is an OpenType Math font, combining math glyphs from KpMath-Sans;
Latin alphabets, numerals, and basic punctuation from Arsenal font. It can be
used to complement Arsenal text font.

## Contents

  - the `otf` directory contains OpenType format fonts
  - the `woff2` directory contains Web Font format fonts
  - the `latex` directory `arsenal-math.sty` fontspec configuration
  - the `source` directory contains SFD (FontForge sources) and OpenType feature files
  - the `doc` directory has a specimen document

The OTF fonts can be used with XeLaTeX or LuaLaTeX, via `fontspec` and
`unicode-math` packages.  The math symbols covered are same as KpMath-Sans
font.

## License

Arsenal Math fonts are licensed under Open Font License, version 1.1. The
license text and FAQ are available at https://openfontlicense.org/.

## Acknowledgments

This font was commissioned by Boris Veytsman and the TeX Users Group. The
developer, Rajeesh, accepted a copy of ‘The TeXbook’ autographed by Donald
Knuth, and donated monetary payment back to TUG.

Additional thanks to:

  - Daniel Flipo for KpMath-Sans opentype font
  - Andrij Shevchenko for Arsenal text font
  - Vaishnavi Murthy for review and suggestions
  - CVR for sample math document

## Changes

  - Improved kerning of many italic glyphs (e, f, g, i, j, t, ...); updated sample
    document; version updated to 0.9.3, 04 January 2026
  - Added swash style glyphs for Math Calligraphic alphabets; and an option to set
    font scale, 11 November 2025
  - Added a fontspec file, 11 October 2025
  - Initial release, on October 2025
