// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib;
use glib::object::IsA;
use glib::translate::*;
use glib::GString;
use gst_sys;
use std::ptr;
use URIType;

glib_wrapper! {
    pub struct URIHandler(Interface<gst_sys::GstURIHandler>);

    match fn {
        get_type => || gst_sys::gst_uri_handler_get_type(),
    }
}

unsafe impl Send for URIHandler {}
unsafe impl Sync for URIHandler {}

pub const NONE_URI_HANDLER: Option<&URIHandler> = None;

pub trait URIHandlerExt: 'static {
    fn get_protocols(&self) -> Vec<GString>;

    fn get_uri(&self) -> Option<GString>;

    fn get_uri_type(&self) -> URIType;

    fn set_uri(&self, uri: &str) -> Result<(), glib::Error>;
}

impl<O: IsA<URIHandler>> URIHandlerExt for O {
    fn get_protocols(&self) -> Vec<GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(gst_sys::gst_uri_handler_get_protocols(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_uri(&self) -> Option<GString> {
        unsafe {
            from_glib_full(gst_sys::gst_uri_handler_get_uri(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_uri_type(&self) -> URIType {
        unsafe {
            from_glib(gst_sys::gst_uri_handler_get_uri_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_uri(&self, uri: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = gst_sys::gst_uri_handler_set_uri(
                self.as_ref().to_glib_none().0,
                uri.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }
}
