#if HAVE_CONFIG_H
# include "config.h"
#endif

/* #include <libtasn1.h> */

const ASN1_ARRAY_TYPE pkix_asn1_tab[] = {
  { "PKIX1", 536875024, NULL },
  { NULL, 1073741836, NULL },
  { "id-ce", 1879048204, NULL },
  { "joint-iso-ccitt", 1073741825, "2"},
  { "ds", 1073741825, "5"},
  { NULL, 1, "29"},
  { "id-ce-authorityKeyIdentifier", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "35"},
  { "AuthorityKeyIdentifier", 1610612741, NULL },
  { "keyIdentifier", 1610637314, "KeyIdentifier"},
  { NULL, 4104, "0"},
  { "authorityCertIssuer", 1610637314, "GeneralNames"},
  { NULL, 4104, "1"},
  { "authorityCertSerialNumber", 536895490, "CertificateSerialNumber"},
  { NULL, 4104, "2"},
  { "KeyIdentifier", 1073741831, NULL },
  { "id-ce-subjectKeyIdentifier", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "14"},
  { "SubjectKeyIdentifier", 1073741826, "KeyIdentifier"},
  { "id-ce-keyUsage", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "15"},
  { "KeyUsage", 1610874886, NULL },
  { "digitalSignature", 1073741825, "0"},
  { "nonRepudiation", 1073741825, "1"},
  { "keyEncipherment", 1073741825, "2"},
  { "dataEncipherment", 1073741825, "3"},
  { "keyAgreement", 1073741825, "4"},
  { "keyCertSign", 1073741825, "5"},
  { "cRLSign", 1073741825, "6"},
  { "encipherOnly", 1073741825, "7"},
  { "decipherOnly", 1, "8"},
  { "id-ce-privateKeyUsagePeriod", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "16"},
  { "PrivateKeyUsagePeriod", 1610612741, NULL },
  { "notBefore", 1619025937, NULL },
  { NULL, 4104, "0"},
  { "notAfter", 545284113, NULL },
  { NULL, 4104, "1"},
  { "id-ce-certificatePolicies", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "32"},
  { "CertificatePolicies", 1612709899, NULL },
  { "MAX", 1074266122, "1"},
  { NULL, 2, "PolicyInformation"},
  { "PolicyInformation", 1610612741, NULL },
  { "policyIdentifier", 1073741826, "CertPolicyId"},
  { "policyQualifiers", 538984459, NULL },
  { "MAX", 1074266122, "1"},
  { NULL, 2, "PolicyQualifierInfo"},
  { "CertPolicyId", 1073741836, NULL },
  { "PolicyQualifierInfo", 1610612741, NULL },
  { "policyQualifierId", 1073741826, "PolicyQualifierId"},
  { "qualifier", 541065229, NULL },
  { "policyQualifierId", 1, NULL },
  { "PolicyQualifierId", 1073741836, NULL },
  { "CPSuri", 1073741826, "IA5String"},
  { "UserNotice", 1610612741, NULL },
  { "noticeRef", 1073758210, "NoticeReference"},
  { "explicitText", 16386, "DisplayText"},
  { "NoticeReference", 1610612741, NULL },
  { "organization", 1073741826, "DisplayText"},
  { "noticeNumbers", 536870923, NULL },
  { NULL, 3, NULL },
  { "DisplayText", 1610612754, NULL },
  { "visibleString", 1612709890, "VisibleString"},
  { "200", 524298, "1"},
  { "bmpString", 1612709890, "BMPString"},
  { "200", 524298, "1"},
  { "utf8String", 538968066, "UTF8String"},
  { "200", 524298, "1"},
  { "id-ce-policyMappings", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "33"},
  { "PolicyMappings", 1612709899, NULL },
  { "MAX", 1074266122, "1"},
  { NULL, 536870917, NULL },
  { "issuerDomainPolicy", 1073741826, "CertPolicyId"},
  { "subjectDomainPolicy", 2, "CertPolicyId"},
  { "DirectoryString", 1610612754, NULL },
  { "teletexString", 1612709890, "TeletexString"},
  { "MAX", 524298, "1"},
  { "printableString", 1612709890, "PrintableString"},
  { "MAX", 524298, "1"},
  { "universalString", 1612709890, "UniversalString"},
  { "MAX", 524298, "1"},
  { "utf8String", 1612709890, "UTF8String"},
  { "MAX", 524298, "1"},
  { "bmpString", 1612709890, "BMPString"},
  { "MAX", 524298, "1"},
  { "ia5String", 538968066, "IA5String"},
  { "MAX", 524298, "1"},
  { "id-ce-subjectAltName", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "17"},
  { "SubjectAltName", 1073741826, "GeneralNames"},
  { "GeneralNames", 1612709899, NULL },
  { "MAX", 1074266122, "1"},
  { NULL, 2, "GeneralName"},
  { "GeneralName", 1610612754, NULL },
  { "otherName", 1610620930, "AnotherName"},
  { NULL, 4104, "0"},
  { "rfc822Name", 1610620930, "IA5String"},
  { NULL, 4104, "1"},
  { "dNSName", 1610620930, "IA5String"},
  { NULL, 4104, "2"},
  { "x400Address", 1610620930, "ORAddress"},
  { NULL, 4104, "3"},
  { "directoryName", 1610620930, "RDNSequence"},
  { NULL, 2056, "4"},
  { "ediPartyName", 1610620930, "EDIPartyName"},
  { NULL, 4104, "5"},
  { "uniformResourceIdentifier", 1610620930, "IA5String"},
  { NULL, 4104, "6"},
  { "iPAddress", 1610620935, NULL },
  { NULL, 4104, "7"},
  { "registeredID", 536879116, NULL },
  { NULL, 4104, "8"},
  { "AnotherName", 1610612741, NULL },
  { "type-id", 1073741836, NULL },
  { "value", 541073421, NULL },
  { NULL, 1073743880, "0"},
  { "type-id", 1, NULL },
  { "EDIPartyName", 1610612741, NULL },
  { "nameAssigner", 1610637314, "DirectoryString"},
  { NULL, 4104, "0"},
  { "partyName", 536879106, "DirectoryString"},
  { NULL, 4104, "1"},
  { "id-ce-issuerAltName", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "18"},
  { "IssuerAltName", 1073741826, "GeneralNames"},
  { "id-ce-subjectDirectoryAttributes", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "9"},
  { "SubjectDirectoryAttributes", 1612709899, NULL },
  { "MAX", 1074266122, "1"},
  { NULL, 2, "Attribute"},
  { "id-ce-basicConstraints", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "19"},
  { "BasicConstraints", 1610612741, NULL },
  { "cA", 1610645508, NULL },
  { NULL, 131081, NULL },
  { "pathLenConstraint", 537411587, NULL },
  { "0", 10, "MAX"},
  { "id-ce-nameConstraints", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "30"},
  { "NameConstraints", 1610612741, NULL },
  { "permittedSubtrees", 1610637314, "GeneralSubtrees"},
  { NULL, 4104, "0"},
  { "excludedSubtrees", 536895490, "GeneralSubtrees"},
  { NULL, 4104, "1"},
  { "GeneralSubtrees", 1612709899, NULL },
  { "MAX", 1074266122, "1"},
  { NULL, 2, "GeneralSubtree"},
  { "GeneralSubtree", 1610612741, NULL },
  { "base", 1073741826, "GeneralName"},
  { "minimum", 1610653698, "BaseDistance"},
  { NULL, 1073741833, "0"},
  { NULL, 4104, "0"},
  { "maximum", 536895490, "BaseDistance"},
  { NULL, 4104, "1"},
  { "BaseDistance", 1611137027, NULL },
  { "0", 10, "MAX"},
  { "id-ce-policyConstraints", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "36"},
  { "PolicyConstraints", 1610612741, NULL },
  { "requireExplicitPolicy", 1610637314, "SkipCerts"},
  { NULL, 4104, "0"},
  { "inhibitPolicyMapping", 536895490, "SkipCerts"},
  { NULL, 4104, "1"},
  { "SkipCerts", 1611137027, NULL },
  { "0", 10, "MAX"},
  { "id-ce-cRLDistributionPoints", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "31"},
  { "CRLDistributionPoints", 1612709899, NULL },
  { "MAX", 1074266122, "1"},
  { NULL, 2, "DistributionPoint"},
  { "DistributionPoint", 1610612741, NULL },
  { "distributionPoint", 1610637314, "DistributionPointName"},
  { NULL, 2056, "0"},
  { "reasons", 1610637314, "ReasonFlags"},
  { NULL, 4104, "1"},
  { "cRLIssuer", 536895490, "GeneralNames"},
  { NULL, 4104, "2"},
  { "DistributionPointName", 1610612754, NULL },
  { "fullName", 1610620930, "GeneralNames"},
  { NULL, 4104, "0"},
  { "nameRelativeToCRLIssuer", 536879106, "RelativeDistinguishedName"},
  { NULL, 4104, "1"},
  { "ReasonFlags", 1610874886, NULL },
  { "unused", 1073741825, "0"},
  { "keyCompromise", 1073741825, "1"},
  { "cACompromise", 1073741825, "2"},
  { "affiliationChanged", 1073741825, "3"},
  { "superseded", 1073741825, "4"},
  { "cessationOfOperation", 1073741825, "5"},
  { "certificateHold", 1073741825, "6"},
  { "privilegeWithdrawn", 1073741825, "7"},
  { "aACompromise", 1, "8"},
  { "id-ce-extKeyUsage", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "37"},
  { "ExtKeyUsageSyntax", 1612709899, NULL },
  { "MAX", 1074266122, "1"},
  { NULL, 2, "KeyPurposeId"},
  { "KeyPurposeId", 1073741836, NULL },
  { "id-kp-serverAuth", 1879048204, NULL },
  { NULL, 1073741825, "id-kp"},
  { NULL, 1, "1"},
  { "id-kp-clientAuth", 1879048204, NULL },
  { NULL, 1073741825, "id-kp"},
  { NULL, 1, "2"},
  { "id-kp-codeSigning", 1879048204, NULL },
  { NULL, 1073741825, "id-kp"},
  { NULL, 1, "3"},
  { "id-kp-emailProtection", 1879048204, NULL },
  { NULL, 1073741825, "id-kp"},
  { NULL, 1, "4"},
  { "id-kp-ipsecEndSystem", 1879048204, NULL },
  { NULL, 1073741825, "id-kp"},
  { NULL, 1, "5"},
  { "id-kp-ipsecTunnel", 1879048204, NULL },
  { NULL, 1073741825, "id-kp"},
  { NULL, 1, "6"},
  { "id-kp-ipsecUser", 1879048204, NULL },
  { NULL, 1073741825, "id-kp"},
  { NULL, 1, "7"},
  { "id-kp-timeStamping", 1879048204, NULL },
  { NULL, 1073741825, "id-kp"},
  { NULL, 1, "8"},
  { "id-pe-authorityInfoAccess", 1879048204, NULL },
  { NULL, 1073741825, "id-pe"},
  { NULL, 1, "1"},
  { "AuthorityInfoAccessSyntax", 1612709899, NULL },
  { "MAX", 1074266122, "1"},
  { NULL, 2, "AccessDescription"},
  { "AccessDescription", 1610612741, NULL },
  { "accessMethod", 1073741836, NULL },
  { "accessLocation", 2, "GeneralName"},
  { "id-ce-cRLNumber", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "20"},
  { "CRLNumber", 1611137027, NULL },
  { "0", 10, "MAX"},
  { "id-ce-issuingDistributionPoint", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "28"},
  { "IssuingDistributionPoint", 1610612741, NULL },
  { "distributionPoint", 1610637314, "DistributionPointName"},
  { NULL, 4104, "0"},
  { "onlyContainsUserCerts", 1610653700, NULL },
  { NULL, 1073872905, NULL },
  { NULL, 4104, "1"},
  { "onlyContainsCACerts", 1610653700, NULL },
  { NULL, 1073872905, NULL },
  { NULL, 4104, "2"},
  { "onlySomeReasons", 1610637314, "ReasonFlags"},
  { NULL, 4104, "3"},
  { "indirectCRL", 536911876, NULL },
  { NULL, 1073872905, NULL },
  { NULL, 4104, "4"},
  { "id-ce-deltaCRLIndicator", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "27"},
  { "BaseCRLNumber", 1073741826, "CRLNumber"},
  { "id-ce-cRLReasons", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "21"},
  { "CRLReason", 1610874901, NULL },
  { "unspecified", 1073741825, "0"},
  { "keyCompromise", 1073741825, "1"},
  { "cACompromise", 1073741825, "2"},
  { "affiliationChanged", 1073741825, "3"},
  { "superseded", 1073741825, "4"},
  { "cessationOfOperation", 1073741825, "5"},
  { "certificateHold", 1073741825, "6"},
  { "removeFromCRL", 1, "8"},
  { "id-ce-certificateIssuer", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "29"},
  { "CertificateIssuer", 1073741826, "GeneralNames"},
  { "id-ce-holdInstructionCode", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "23"},
  { "HoldInstructionCode", 1073741836, NULL },
  { "holdInstruction", 1879048204, NULL },
  { "joint-iso-itu-t", 1073741825, "2"},
  { "member-body", 1073741825, "2"},
  { "us", 1073741825, "840"},
  { "x9cm", 1073741825, "10040"},
  { NULL, 1, "2"},
  { "id-holdinstruction-none", 1879048204, NULL },
  { NULL, 1073741825, "holdInstruction"},
  { NULL, 1, "1"},
  { "id-holdinstruction-callissuer", 1879048204, NULL },
  { NULL, 1073741825, "holdInstruction"},
  { NULL, 1, "2"},
  { "id-holdinstruction-reject", 1879048204, NULL },
  { NULL, 1073741825, "holdInstruction"},
  { NULL, 1, "3"},
  { "id-ce-invalidityDate", 1879048204, NULL },
  { NULL, 1073741825, "id-ce"},
  { NULL, 1, "24"},
  { "InvalidityDate", 1082130449, NULL },
  { "VisibleString", 1610620935, NULL },
  { NULL, 4360, "26"},
  { "NumericString", 1610620935, NULL },
  { NULL, 4360, "18"},
  { "IA5String", 1610620935, NULL },
  { NULL, 4360, "22"},
  { "TeletexString", 1610620935, NULL },
  { NULL, 4360, "20"},
  { "PrintableString", 1610620935, NULL },
  { NULL, 4360, "19"},
  { "UniversalString", 1610620935, NULL },
  { NULL, 4360, "28"},
  { "BMPString", 1610620935, NULL },
  { NULL, 4360, "30"},
  { "UTF8String", 1610620935, NULL },
  { NULL, 4360, "12"},
  { "id-pkix", 1879048204, NULL },
  { "iso", 1073741825, "1"},
  { "identified-organization", 1073741825, "3"},
  { "dod", 1073741825, "6"},
  { "internet", 1073741825, "1"},
  { "security", 1073741825, "5"},
  { "mechanisms", 1073741825, "5"},
  { "pkix", 1, "7"},
  { "id-pe", 1879048204, NULL },
  { NULL, 1073741825, "id-pkix"},
  { NULL, 1, "1"},
  { "id-qt", 1879048204, NULL },
  { NULL, 1073741825, "id-pkix"},
  { NULL, 1, "2"},
  { "id-kp", 1879048204, NULL },
  { NULL, 1073741825, "id-pkix"},
  { NULL, 1, "3"},
  { "id-ad", 1879048204, NULL },
  { NULL, 1073741825, "id-pkix"},
  { NULL, 1, "48"},
  { "id-qt-cps", 1879048204, NULL },
  { NULL, 1073741825, "id-qt"},
  { NULL, 1, "1"},
  { "id-qt-unotice", 1879048204, NULL },
  { NULL, 1073741825, "id-qt"},
  { NULL, 1, "2"},
  { "id-ad-ocsp", 1879048204, NULL },
  { NULL, 1073741825, "id-ad"},
  { NULL, 1, "1"},
  { "id-ad-caIssuers", 1879048204, NULL },
  { NULL, 1073741825, "id-ad"},
  { NULL, 1, "2"},
  { "Attribute", 1610612741, NULL },
  { "type", 1073741826, "AttributeType"},
  { "values", 536870927, NULL },
  { NULL, 2, "AttributeValue"},
  { "AttributeType", 1073741836, NULL },
  { "AttributeValue", 1614807053, NULL },
  { "type", 1, NULL },
  { "AttributeTypeAndValue", 1610612741, NULL },
  { "type", 1073741826, "AttributeType"},
  { "value", 2, "AttributeValue"},
  { "id-at", 1879048204, NULL },
  { "joint-iso-ccitt", 1073741825, "2"},
  { "ds", 1073741825, "5"},
  { NULL, 1, "4"},
  { "id-at-initials", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "43"},
  { "X520initials", 1073741826, "DirectoryString"},
  { "id-at-generationQualifier", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "44"},
  { "X520generationQualifier", 1073741826, "DirectoryString"},
  { "id-at-surname", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "4"},
  { "X520surName", 1073741826, "DirectoryString"},
  { "id-at-givenName", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "42"},
  { "X520givenName", 1073741826, "DirectoryString"},
  { "id-at-name", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "41"},
  { "X520name", 1073741826, "DirectoryString"},
  { "id-at-commonName", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "3"},
  { "X520CommonName", 1073741826, "DirectoryString"},
  { "id-at-localityName", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "7"},
  { "X520LocalityName", 1073741826, "DirectoryString"},
  { "id-at-stateOrProvinceName", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "8"},
  { "X520StateOrProvinceName", 1073741826, "DirectoryString"},
  { "id-at-organizationName", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "10"},
  { "X520OrganizationName", 1073741826, "DirectoryString"},
  { "id-at-organizationalUnitName", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "11"},
  { "X520OrganizationalUnitName", 1073741826, "DirectoryString"},
  { "id-at-title", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "12"},
  { "X520Title", 1073741826, "DirectoryString"},
  { "id-at-description", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "13"},
  { "X520Description", 1073741826, "DirectoryString"},
  { "id-at-dnQualifier", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "46"},
  { "X520dnQualifier", 1073741826, "PrintableString"},
  { "id-at-countryName", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "6"},
  { "X520countryName", 1612709890, "PrintableString"},
  { NULL, 1048586, "2"},
  { "id-at-serialNumber", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "5"},
  { "X520serialNumber", 1073741826, "PrintableString"},
  { "id-at-telephoneNumber", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "20"},
  { "X520telephoneNumber", 1073741826, "PrintableString"},
  { "id-at-facsimileTelephoneNumber", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "23"},
  { "X520facsimileTelephoneNumber", 1073741826, "PrintableString"},
  { "id-at-pseudonym", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "65"},
  { "X520pseudonym", 1073741826, "DirectoryString"},
  { "id-at-name", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "41"},
  { "X520name", 1073741826, "DirectoryString"},
  { "id-at-streetAddress", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "9"},
  { "X520streetAddress", 1073741826, "DirectoryString"},
  { "id-at-postalAddress", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-at"},
  { NULL, 1, "16"},
  { "X520postalAddress", 1073741826, "PostalAddress"},
  { "PostalAddress", 1610612747, NULL },
  { NULL, 2, "DirectoryString"},
  { "pkcs", 1879048204, NULL },
  { "iso", 1073741825, "1"},
  { "member-body", 1073741825, "2"},
  { "us", 1073741825, "840"},
  { "rsadsi", 1073741825, "113549"},
  { "pkcs", 1, "1"},
  { "pkcs-9", 1879048204, NULL },
  { NULL, 1073741825, "pkcs"},
  { NULL, 1, "9"},
  { "emailAddress", 1880096780, "AttributeType"},
  { NULL, 1073741825, "pkcs-9"},
  { NULL, 1, "1"},
  { "Pkcs9email", 1612709890, "IA5String"},
  { "ub-emailaddress-length", 524298, "1"},
  { "Name", 1610612754, NULL },
  { "rdnSequence", 2, "RDNSequence"},
  { "RDNSequence", 1610612747, NULL },
  { NULL, 2, "RelativeDistinguishedName"},
  { "DistinguishedName", 1073741826, "RDNSequence"},
  { "RelativeDistinguishedName", 1612709903, NULL },
  { "MAX", 1074266122, "1"},
  { NULL, 2, "AttributeTypeAndValue"},
  { "Certificate", 1610612741, NULL },
  { "tbsCertificate", 1073741826, "TBSCertificate"},
  { "signatureAlgorithm", 1073741826, "AlgorithmIdentifier"},
  { "signature", 6, NULL },
  { "TBSCertificate", 1610612741, NULL },
  { "version", 1610653698, "Version"},
  { NULL, 1073741833, "v1"},
  { NULL, 2056, "0"},
  { "serialNumber", 1073741826, "CertificateSerialNumber"},
  { "signature", 1073741826, "AlgorithmIdentifier"},
  { "issuer", 1073741826, "Name"},
  { "validity", 1073741826, "Validity"},
  { "subject", 1073741826, "Name"},
  { "subjectPublicKeyInfo", 1073741826, "SubjectPublicKeyInfo"},
  { "issuerUniqueID", 1610637314, "UniqueIdentifier"},
  { NULL, 4104, "1"},
  { "subjectUniqueID", 1610637314, "UniqueIdentifier"},
  { NULL, 4104, "2"},
  { "extensions", 536895490, "Extensions"},
  { NULL, 2056, "3"},
  { "Version", 1610874883, NULL },
  { "v1", 1073741825, "0"},
  { "v2", 1073741825, "1"},
  { "v3", 1, "2"},
  { "CertificateSerialNumber", 1073741827, NULL },
  { "Validity", 1610612741, NULL },
  { "notBefore", 1073741826, "Time"},
  { "notAfter", 2, "Time"},
  { "Time", 1610612754, NULL },
  { "utcTime", 1090519057, NULL },
  { "generalTime", 8388625, NULL },
  { "UniqueIdentifier", 1073741830, NULL },
  { "SubjectPublicKeyInfo", 1610612741, NULL },
  { "algorithm", 1073741826, "AlgorithmIdentifier"},
  { "subjectPublicKey", 6, NULL },
  { "Extensions", 1612709899, NULL },
  { "MAX", 1074266122, "1"},
  { NULL, 2, "Extension"},
  { "Extension", 1610612741, NULL },
  { "extnID", 1073741836, NULL },
  { "critical", 1610645508, NULL },
  { NULL, 131081, NULL },
  { "extnValue", 7, NULL },
  { "CertificateList", 1610612741, NULL },
  { "tbsCertList", 1073741826, "TBSCertList"},
  { "signatureAlgorithm", 1073741826, "AlgorithmIdentifier"},
  { "signature", 6, NULL },
  { "TBSCertList", 1610612741, NULL },
  { "version", 1073758210, "Version"},
  { "signature", 1073741826, "AlgorithmIdentifier"},
  { "issuer", 1073741826, "Name"},
  { "thisUpdate", 1073741826, "Time"},
  { "nextUpdate", 1073758210, "Time"},
  { "revokedCertificates", 1610629131, NULL },
  { NULL, 536870917, NULL },
  { "userCertificate", 1073741826, "CertificateSerialNumber"},
  { "revocationDate", 1073741826, "Time"},
  { "crlEntryExtensions", 16386, "Extensions"},
  { "crlExtensions", 536895490, "Extensions"},
  { NULL, 2056, "0"},
  { "AlgorithmIdentifier", 1610612741, NULL },
  { "algorithm", 1073741836, NULL },
  { "parameters", 541081613, NULL },
  { "algorithm", 1, NULL },
  { "pkcs-1", 1879048204, NULL },
  { NULL, 1073741825, "pkcs"},
  { NULL, 1, "1"},
  { "rsaEncryption", 1879048204, NULL },
  { NULL, 1073741825, "pkcs-1"},
  { NULL, 1, "1"},
  { "md2WithRSAEncryption", 1879048204, NULL },
  { NULL, 1073741825, "pkcs-1"},
  { NULL, 1, "2"},
  { "md5WithRSAEncryption", 1879048204, NULL },
  { NULL, 1073741825, "pkcs-1"},
  { NULL, 1, "4"},
  { "sha1WithRSAEncryption", 1879048204, NULL },
  { NULL, 1073741825, "pkcs-1"},
  { NULL, 1, "5"},
  { "id-dsa-with-sha1", 1879048204, NULL },
  { "iso", 1073741825, "1"},
  { "member-body", 1073741825, "2"},
  { "us", 1073741825, "840"},
  { "x9-57", 1073741825, "10040"},
  { "x9algorithm", 1073741825, "4"},
  { NULL, 1, "3"},
  { "Dss-Sig-Value", 1610612741, NULL },
  { "r", 1073741827, NULL },
  { "s", 3, NULL },
  { "dhpublicnumber", 1879048204, NULL },
  { "iso", 1073741825, "1"},
  { "member-body", 1073741825, "2"},
  { "us", 1073741825, "840"},
  { "ansi-x942", 1073741825, "10046"},
  { "number-type", 1073741825, "2"},
  { NULL, 1, "1"},
  { "DomainParameters", 1610612741, NULL },
  { "p", 1073741827, NULL },
  { "g", 1073741827, NULL },
  { "q", 1073741827, NULL },
  { "j", 1073758211, NULL },
  { "validationParms", 16386, "ValidationParms"},
  { "ValidationParms", 1610612741, NULL },
  { "seed", 1073741830, NULL },
  { "pgenCounter", 3, NULL },
  { "id-dsa", 1879048204, NULL },
  { "iso", 1073741825, "1"},
  { "member-body", 1073741825, "2"},
  { "us", 1073741825, "840"},
  { "x9-57", 1073741825, "10040"},
  { "x9algorithm", 1073741825, "4"},
  { NULL, 1, "1"},
  { "Dss-Parms", 1610612741, NULL },
  { "p", 1073741827, NULL },
  { "q", 1073741827, NULL },
  { "g", 3, NULL },
  { "ORAddress", 1610612741, NULL },
  { "built-in-standard-attributes", 1073741826, "BuiltInStandardAttributes"},
  { "built-in-domain-defined-attributes", 1073758210, "BuiltInDomainDefinedAttributes"},
  { "extension-attributes", 16386, "ExtensionAttributes"},
  { "BuiltInStandardAttributes", 1610612741, NULL },
  { "country-name", 1073758210, "CountryName"},
  { "administration-domain-name", 1073758210, "AdministrationDomainName"},
  { "network-address", 1610637314, "NetworkAddress"},
  { NULL, 2056, "0"},
  { "terminal-identifier", 1610637314, "TerminalIdentifier"},
  { NULL, 2056, "1"},
  { "private-domain-name", 1610637314, "PrivateDomainName"},
  { NULL, 2056, "2"},
  { "organization-name", 1610637314, "OrganizationName"},
  { NULL, 2056, "3"},
  { "numeric-user-identifier", 1610637314, "NumericUserIdentifier"},
  { NULL, 2056, "4"},
  { "personal-name", 1610637314, "PersonalName"},
  { NULL, 2056, "5"},
  { "organizational-unit-names", 536895490, "OrganizationalUnitNames"},
  { NULL, 2056, "6"},
  { "CountryName", 1610620946, NULL },
  { NULL, 1073746952, "1"},
  { "x121-dcc-code", 1612709890, "NumericString"},
  { NULL, 1048586, "ub-country-name-numeric-length"},
  { "iso-3166-alpha2-code", 538968066, "PrintableString"},
  { NULL, 1048586, "ub-country-name-alpha-length"},
  { "AdministrationDomainName", 1610620946, NULL },
  { NULL, 1073744904, "2"},
  { "numeric", 1612709890, "NumericString"},
  { "ub-domain-name-length", 524298, "0"},
  { "printable", 538968066, "PrintableString"},
  { "ub-domain-name-length", 524298, "0"},
  { "NetworkAddress", 1073741826, "X121Address"},
  { "X121Address", 1612709890, "NumericString"},
  { "ub-x121-address-length", 524298, "1"},
  { "TerminalIdentifier", 1612709890, "PrintableString"},
  { "ub-terminal-id-length", 524298, "1"},
  { "PrivateDomainName", 1610612754, NULL },
  { "numeric", 1612709890, "NumericString"},
  { "ub-domain-name-length", 524298, "1"},
  { "printable", 538968066, "PrintableString"},
  { "ub-domain-name-length", 524298, "1"},
  { "OrganizationName", 1612709890, "PrintableString"},
  { "ub-organization-name-length", 524298, "1"},
  { "NumericUserIdentifier", 1612709890, "NumericString"},
  { "ub-numeric-user-id-length", 524298, "1"},
  { "PersonalName", 1610612750, NULL },
  { "surname", 1814044674, "PrintableString"},
  { NULL, 1073745928, "0"},
  { "ub-surname-length", 524298, "1"},
  { "given-name", 1814061058, "PrintableString"},
  { NULL, 1073745928, "1"},
  { "ub-given-name-length", 524298, "1"},
  { "initials", 1814061058, "PrintableString"},
  { NULL, 1073745928, "2"},
  { "ub-initials-length", 524298, "1"},
  { "generation-qualifier", 740319234, "PrintableString"},
  { NULL, 1073745928, "3"},
  { "ub-generation-qualifier-length", 524298, "1"},
  { "OrganizationalUnitNames", 1612709899, NULL },
  { "ub-organizational-units", 1074266122, "1"},
  { NULL, 2, "OrganizationalUnitName"},
  { "OrganizationalUnitName", 1612709890, "PrintableString"},
  { "ub-organizational-unit-name-length", 524298, "1"},
  { "BuiltInDomainDefinedAttributes", 1612709899, NULL },
  { "ub-domain-defined-attributes", 1074266122, "1"},
  { NULL, 2, "BuiltInDomainDefinedAttribute"},
  { "BuiltInDomainDefinedAttribute", 1610612741, NULL },
  { "type", 1612709890, "PrintableString"},
  { "ub-domain-defined-attribute-type-length", 524298, "1"},
  { "value", 538968066, "PrintableString"},
  { "ub-domain-defined-attribute-value-length", 524298, "1"},
  { "ExtensionAttributes", 1612709903, NULL },
  { "ub-extension-attributes", 1074266122, "1"},
  { NULL, 2, "ExtensionAttribute"},
  { "ExtensionAttribute", 1610612741, NULL },
  { "extension-attribute-type", 1611145219, NULL },
  { NULL, 1073743880, "0"},
  { "0", 10, "ub-extension-attributes"},
  { "extension-attribute-value", 541073421, NULL },
  { NULL, 1073743880, "1"},
  { "extension-attribute-type", 1, NULL },
  { "common-name", 1342177283, "1"},
  { "CommonName", 1612709890, "PrintableString"},
  { "ub-common-name-length", 524298, "1"},
  { "teletex-common-name", 1342177283, "2"},
  { "TeletexCommonName", 1612709890, "TeletexString"},
  { "ub-common-name-length", 524298, "1"},
  { "teletex-organization-name", 1342177283, "3"},
  { "TeletexOrganizationName", 1612709890, "TeletexString"},
  { "ub-organization-name-length", 524298, "1"},
  { "teletex-personal-name", 1342177283, "4"},
  { "TeletexPersonalName", 1610612750, NULL },
  { "surname", 1814044674, "TeletexString"},
  { NULL, 1073743880, "0"},
  { "ub-surname-length", 524298, "1"},
  { "given-name", 1814061058, "TeletexString"},
  { NULL, 1073743880, "1"},
  { "ub-given-name-length", 524298, "1"},
  { "initials", 1814061058, "TeletexString"},
  { NULL, 1073743880, "2"},
  { "ub-initials-length", 524298, "1"},
  { "generation-qualifier", 740319234, "TeletexString"},
  { NULL, 1073743880, "3"},
  { "ub-generation-qualifier-length", 524298, "1"},
  { "teletex-organizational-unit-names", 1342177283, "5"},
  { "TeletexOrganizationalUnitNames", 1612709899, NULL },
  { "ub-organizational-units", 1074266122, "1"},
  { NULL, 2, "TeletexOrganizationalUnitName"},
  { "TeletexOrganizationalUnitName", 1612709890, "TeletexString"},
  { "ub-organizational-unit-name-length", 524298, "1"},
  { "pds-name", 1342177283, "7"},
  { "PDSName", 1612709890, "PrintableString"},
  { "ub-pds-name-length", 524298, "1"},
  { "physical-delivery-country-name", 1342177283, "8"},
  { "PhysicalDeliveryCountryName", 1610612754, NULL },
  { "x121-dcc-code", 1612709890, "NumericString"},
  { NULL, 1048586, "ub-country-name-numeric-length"},
  { "iso-3166-alpha2-code", 538968066, "PrintableString"},
  { NULL, 1048586, "ub-country-name-alpha-length"},
  { "postal-code", 1342177283, "9"},
  { "PostalCode", 1610612754, NULL },
  { "numeric-code", 1612709890, "NumericString"},
  { "ub-postal-code-length", 524298, "1"},
  { "printable-code", 538968066, "PrintableString"},
  { "ub-postal-code-length", 524298, "1"},
  { "physical-delivery-office-name", 1342177283, "10"},
  { "PhysicalDeliveryOfficeName", 1073741826, "PDSParameter"},
  { "physical-delivery-office-number", 1342177283, "11"},
  { "PhysicalDeliveryOfficeNumber", 1073741826, "PDSParameter"},
  { "extension-OR-address-components", 1342177283, "12"},
  { "ExtensionORAddressComponents", 1073741826, "PDSParameter"},
  { "physical-delivery-personal-name", 1342177283, "13"},
  { "PhysicalDeliveryPersonalName", 1073741826, "PDSParameter"},
  { "physical-delivery-organization-name", 1342177283, "14"},
  { "PhysicalDeliveryOrganizationName", 1073741826, "PDSParameter"},
  { "extension-physical-delivery-address-components", 1342177283, "15"},
  { "ExtensionPhysicalDeliveryAddressComponents", 1073741826, "PDSParameter"},
  { "unformatted-postal-address", 1342177283, "16"},
  { "UnformattedPostalAddress", 1610612750, NULL },
  { "printable-address", 1814052875, NULL },
  { "ub-pds-physical-address-lines", 1074266122, "1"},
  { NULL, 538968066, "PrintableString"},
  { "ub-pds-parameter-length", 524298, "1"},
  { "teletex-string", 740311042, "TeletexString"},
  { "ub-unformatted-address-length", 524298, "1"},
  { "street-address", 1342177283, "17"},
  { "StreetAddress", 1073741826, "PDSParameter"},
  { "post-office-box-address", 1342177283, "18"},
  { "PostOfficeBoxAddress", 1073741826, "PDSParameter"},
  { "poste-restante-address", 1342177283, "19"},
  { "PosteRestanteAddress", 1073741826, "PDSParameter"},
  { "unique-postal-name", 1342177283, "20"},
  { "UniquePostalName", 1073741826, "PDSParameter"},
  { "local-postal-attributes", 1342177283, "21"},
  { "LocalPostalAttributes", 1073741826, "PDSParameter"},
  { "PDSParameter", 1610612750, NULL },
  { "printable-string", 1814052866, "PrintableString"},
  { "ub-pds-parameter-length", 524298, "1"},
  { "teletex-string", 740311042, "TeletexString"},
  { "ub-pds-parameter-length", 524298, "1"},
  { "extended-network-address", 1342177283, "22"},
  { "ExtendedNetworkAddress", 1610612754, NULL },
  { "e163-4-address", 1610612741, NULL },
  { "number", 1612718082, "NumericString"},
  { NULL, 1073743880, "0"},
  { "ub-e163-4-number-length", 524298, "1"},
  { "sub-address", 538992642, "NumericString"},
  { NULL, 1073743880, "1"},
  { "ub-e163-4-sub-address-length", 524298, "1"},
  { "psap-address", 536879106, "PresentationAddress"},
  { NULL, 2056, "0"},
  { "PresentationAddress", 1610612741, NULL },
  { "pSelector", 1610637319, NULL },
  { NULL, 2056, "0"},
  { "sSelector", 1610637319, NULL },
  { NULL, 2056, "1"},
  { "tSelector", 1610637319, NULL },
  { NULL, 2056, "2"},
  { "nAddresses", 538976271, NULL },
  { NULL, 1073743880, "3"},
  { "MAX", 1074266122, "1"},
  { NULL, 7, NULL },
  { "terminal-type", 1342177283, "23"},
  { "TerminalType", 1610874883, NULL },
  { "telex", 1073741825, "3"},
  { "teletex", 1073741825, "4"},
  { "g3-facsimile", 1073741825, "5"},
  { "g4-facsimile", 1073741825, "6"},
  { "ia5-terminal", 1073741825, "7"},
  { "videotex", 1, "8"},
  { "teletex-domain-defined-attributes", 1342177283, "6"},
  { "TeletexDomainDefinedAttributes", 1612709899, NULL },
  { "ub-domain-defined-attributes", 1074266122, "1"},
  { NULL, 2, "TeletexDomainDefinedAttribute"},
  { "TeletexDomainDefinedAttribute", 1610612741, NULL },
  { "type", 1612709890, "TeletexString"},
  { "ub-domain-defined-attribute-type-length", 524298, "1"},
  { "value", 538968066, "TeletexString"},
  { "ub-domain-defined-attribute-value-length", 524298, "1"},
  { "ub-name", 1342177283, "32768"},
  { "ub-common-name", 1342177283, "64"},
  { "ub-locality-name", 1342177283, "128"},
  { "ub-state-name", 1342177283, "128"},
  { "ub-organization-name", 1342177283, "64"},
  { "ub-organizational-unit-name", 1342177283, "64"},
  { "ub-title", 1342177283, "64"},
  { "ub-match", 1342177283, "128"},
  { "ub-emailaddress-length", 1342177283, "128"},
  { "ub-common-name-length", 1342177283, "64"},
  { "ub-country-name-alpha-length", 1342177283, "2"},
  { "ub-country-name-numeric-length", 1342177283, "3"},
  { "ub-domain-defined-attributes", 1342177283, "4"},
  { "ub-domain-defined-attribute-type-length", 1342177283, "8"},
  { "ub-domain-defined-attribute-value-length", 1342177283, "128"},
  { "ub-domain-name-length", 1342177283, "16"},
  { "ub-extension-attributes", 1342177283, "256"},
  { "ub-e163-4-number-length", 1342177283, "15"},
  { "ub-e163-4-sub-address-length", 1342177283, "40"},
  { "ub-generation-qualifier-length", 1342177283, "3"},
  { "ub-given-name-length", 1342177283, "16"},
  { "ub-initials-length", 1342177283, "5"},
  { "ub-integer-options", 1342177283, "256"},
  { "ub-numeric-user-id-length", 1342177283, "32"},
  { "ub-organization-name-length", 1342177283, "64"},
  { "ub-organizational-unit-name-length", 1342177283, "32"},
  { "ub-organizational-units", 1342177283, "4"},
  { "ub-pds-name-length", 1342177283, "16"},
  { "ub-pds-parameter-length", 1342177283, "30"},
  { "ub-pds-physical-address-lines", 1342177283, "6"},
  { "ub-postal-code-length", 1342177283, "16"},
  { "ub-surname-length", 1342177283, "40"},
  { "ub-terminal-id-length", 1342177283, "24"},
  { "ub-unformatted-address-length", 1342177283, "180"},
  { "ub-x121-address-length", 1342177283, "16"},
  { "pkcs-7-ContentInfo", 1610612741, NULL },
  { "contentType", 1073741826, "pkcs-7-ContentType"},
  { "content", 541073421, NULL },
  { NULL, 1073743880, "0"},
  { "contentType", 1, NULL },
  { "pkcs-7-DigestInfo", 1610612741, NULL },
  { "digestAlgorithm", 1073741826, "pkcs-7-DigestAlgorithmIdentifier"},
  { "digest", 2, "pkcs-7-Digest"},
  { "pkcs-7-Digest", 1073741831, NULL },
  { "pkcs-7-ContentType", 1073741836, NULL },
  { "pkcs-7-SignedData", 1610612741, NULL },
  { "version", 1073741826, "pkcs-7-CMSVersion"},
  { "digestAlgorithms", 1073741826, "pkcs-7-DigestAlgorithmIdentifiers"},
  { "encapContentInfo", 1073741826, "pkcs-7-EncapsulatedContentInfo"},
  { "certificates", 1610637314, "pkcs-7-CertificateSet"},
  { NULL, 4104, "0"},
  { "crls", 1610637314, "pkcs-7-CertificateRevocationLists"},
  { NULL, 4104, "1"},
  { "signerInfos", 2, "pkcs-7-SignerInfos"},
  { "pkcs-7-CMSVersion", 1610874883, NULL },
  { "v0", 1073741825, "0"},
  { "v1", 1073741825, "1"},
  { "v2", 1073741825, "2"},
  { "v3", 1073741825, "3"},
  { "v4", 1, "4"},
  { "pkcs-7-DigestAlgorithmIdentifiers", 1610612751, NULL },
  { NULL, 2, "pkcs-7-DigestAlgorithmIdentifier"},
  { "pkcs-7-DigestAlgorithmIdentifier", 1073741826, "AlgorithmIdentifier"},
  { "pkcs-7-EncapsulatedContentInfo", 1610612741, NULL },
  { "eContentType", 1073741826, "pkcs-7-ContentType"},
  { "eContent", 536895495, NULL },
  { NULL, 2056, "0"},
  { "pkcs-7-CertificateRevocationLists", 1610612751, NULL },
  { NULL, 13, NULL },
  { "pkcs-7-CertificateChoices", 1610612754, NULL },
  { "certificate", 13, NULL },
  { "pkcs-7-CertificateSet", 1610612751, NULL },
  { NULL, 2, "pkcs-7-CertificateChoices"},
  { "pkcs-7-SignerInfos", 1610612751, NULL },
  { NULL, 13, NULL },
  { "pkcs-10-CertificationRequestInfo", 1610612741, NULL },
  { "version", 1610874883, NULL },
  { "v1", 1, "0"},
  { "subject", 1073741826, "Name"},
  { "subjectPKInfo", 1073741826, "SubjectPublicKeyInfo"},
  { "attributes", 536879106, "Attributes"},
  { NULL, 4104, "0"},
  { "Attributes", 1610612751, NULL },
  { NULL, 2, "Attribute"},
  { "pkcs-10-CertificationRequest", 1610612741, NULL },
  { "certificationRequestInfo", 1073741826, "pkcs-10-CertificationRequestInfo"},
  { "signatureAlgorithm", 1073741826, "AlgorithmIdentifier"},
  { "signature", 6, NULL },
  { "pkcs-9-ub-challengePassword", 1342177283, "255"},
  { "pkcs-9-certTypes", 1879048204, NULL },
  { NULL, 1073741825, "pkcs-9"},
  { NULL, 1, "22"},
  { "pkcs-9-crlTypes", 1879048204, NULL },
  { NULL, 1073741825, "pkcs-9"},
  { NULL, 1, "23"},
  { "pkcs-9-at-challengePassword", 1879048204, NULL },
  { NULL, 1073741825, "pkcs-9"},
  { NULL, 1, "7"},
  { "pkcs-9-challengePassword", 1610612754, NULL },
  { "printableString", 1612709890, "PrintableString"},
  { "pkcs-9-ub-challengePassword", 524298, "1"},
  { "utf8String", 538968066, "UTF8String"},
  { "pkcs-9-ub-challengePassword", 524298, "1"},
  { "pkcs-9-at-localKeyId", 1879048204, NULL },
  { NULL, 1073741825, "pkcs-9"},
  { NULL, 1, "21"},
  { "pkcs-9-localKeyId", 1073741831, NULL },
  { "pkcs-9-at-friendlyName", 1879048204, NULL },
  { NULL, 1073741825, "pkcs-9"},
  { NULL, 1, "20"},
  { "pkcs-9-friendlyName", 1612709890, "BMPString"},
  { "255", 524298, "1"},
  { "pkcs-8-PrivateKeyInfo", 1610612741, NULL },
  { "version", 1073741826, "pkcs-8-Version"},
  { "privateKeyAlgorithm", 1073741826, "AlgorithmIdentifier"},
  { "privateKey", 1073741826, "pkcs-8-PrivateKey"},
  { "attributes", 536895490, "Attributes"},
  { NULL, 4104, "0"},
  { "pkcs-8-Version", 1610874883, NULL },
  { "v1", 1, "0"},
  { "pkcs-8-PrivateKey", 1073741831, NULL },
  { "pkcs-8-Attributes", 1610612751, NULL },
  { NULL, 2, "Attribute"},
  { "pkcs-8-EncryptedPrivateKeyInfo", 1610612741, NULL },
  { "encryptionAlgorithm", 1073741826, "AlgorithmIdentifier"},
  { "encryptedData", 2, "pkcs-8-EncryptedData"},
  { "pkcs-8-EncryptedData", 1073741831, NULL },
  { "pkcs-5", 1879048204, NULL },
  { NULL, 1073741825, "pkcs"},
  { NULL, 1, "5"},
  { "pkcs-5-encryptionAlgorithm", 1879048204, NULL },
  { "iso", 1073741825, "1"},
  { "member-body", 1073741825, "2"},
  { "us", 1073741825, "840"},
  { "rsadsi", 1073741825, "113549"},
  { NULL, 1, "3"},
  { "pkcs-5-des-EDE3-CBC", 1879048204, NULL },
  { NULL, 1073741825, "pkcs-5-encryptionAlgorithm"},
  { NULL, 1, "7"},
  { "pkcs-5-des-EDE3-CBC-params", 1612709895, NULL },
  { NULL, 1048586, "8"},
  { "pkcs-5-des-CBC-params", 1612709895, NULL },
  { NULL, 1048586, "8"},
  { "pkcs-5-rc2-CBC-params", 1610612741, NULL },
  { "rc2ParameterVersion", 1073758211, NULL },
  { "iv", 538968071, NULL },
  { NULL, 1048586, "8"},
  { "pkcs-5-PBE-params", 1610612741, NULL },
  { "salt", 1612709895, NULL },
  { NULL, 1048586, "8"},
  { "iterationCount", 3, NULL },
  { "pkcs-5-id-PBES2", 1879048204, NULL },
  { NULL, 1073741825, "pkcs-5"},
  { NULL, 1, "13"},
  { "pkcs-5-PBES2-params", 1610612741, NULL },
  { "keyDerivationFunc", 1073741826, "AlgorithmIdentifier"},
  { "encryptionScheme", 2, "AlgorithmIdentifier"},
  { "pkcs-5-id-PBKDF2", 1879048204, NULL },
  { NULL, 1073741825, "pkcs-5"},
  { NULL, 1, "12"},
  { "pkcs-5-PBKDF2-params", 1610612741, NULL },
  { "salt", 1610612754, NULL },
  { "specified", 1073741831, NULL },
  { "otherSource", 2, "AlgorithmIdentifier"},
  { "iterationCount", 1611137027, NULL },
  { "1", 10, "MAX"},
  { "keyLength", 1611153411, NULL },
  { "1", 10, "MAX"},
  { "prf", 16386, "AlgorithmIdentifier"},
  { "pkcs-12", 1879048204, NULL },
  { NULL, 1073741825, "pkcs"},
  { NULL, 1, "12"},
  { "pkcs-12-PFX", 1610612741, NULL },
  { "version", 1610874883, NULL },
  { "v3", 1, "3"},
  { "authSafe", 1073741826, "pkcs-7-ContentInfo"},
  { "macData", 16386, "pkcs-12-MacData"},
  { "pkcs-12-PbeParams", 1610612741, NULL },
  { "salt", 1073741831, NULL },
  { "iterations", 3, NULL },
  { "pkcs-12-MacData", 1610612741, NULL },
  { "mac", 1073741826, "pkcs-7-DigestInfo"},
  { "macSalt", 1073741831, NULL },
  { "iterations", 536903683, NULL },
  { NULL, 9, "1"},
  { "pkcs-12-AuthenticatedSafe", 1610612747, NULL },
  { NULL, 2, "pkcs-7-ContentInfo"},
  { "pkcs-12-SafeContents", 1610612747, NULL },
  { NULL, 2, "pkcs-12-SafeBag"},
  { "pkcs-12-SafeBag", 1610612741, NULL },
  { "bagId", 1073741836, NULL },
  { "bagValue", 1614815245, NULL },
  { NULL, 1073743880, "0"},
  { "badId", 1, NULL },
  { "bagAttributes", 536887311, NULL },
  { NULL, 2, "pkcs-12-PKCS12Attribute"},
  { "pkcs-12-bagtypes", 1879048204, NULL },
  { NULL, 1073741825, "pkcs-12"},
  { NULL, 1073741825, "10"},
  { NULL, 1, "1"},
  { "pkcs-12-keyBag", 1879048204, NULL },
  { NULL, 1073741825, "pkcs-12-bagtypes"},
  { NULL, 1, "1"},
  { "pkcs-12-pkcs8ShroudedKeyBag", 1879048204, NULL },
  { NULL, 1073741825, "pkcs-12-bagtypes"},
  { NULL, 1, "2"},
  { "pkcs-12-certBag", 1879048204, NULL },
  { NULL, 1073741825, "pkcs-12-bagtypes"},
  { NULL, 1, "3"},
  { "pkcs-12-crlBag", 1879048204, NULL },
  { NULL, 1073741825, "pkcs-12-bagtypes"},
  { NULL, 1, "4"},
  { "pkcs-12-KeyBag", 1073741826, "pkcs-8-PrivateKeyInfo"},
  { "pkcs-12-PKCS8ShroudedKeyBag", 1073741826, "pkcs-8-EncryptedPrivateKeyInfo"},
  { "pkcs-12-CertBag", 1610612741, NULL },
  { "certId", 1073741836, NULL },
  { "certValue", 541073421, NULL },
  { NULL, 1073743880, "0"},
  { "certId", 1, NULL },
  { "pkcs-12-CRLBag", 1610612741, NULL },
  { "crlId", 1073741836, NULL },
  { "crlValue", 541073421, NULL },
  { NULL, 1073743880, "0"},
  { "crlId", 1, NULL },
  { "pkcs-12-PKCS12Attribute", 1073741826, "Attribute"},
  { "pkcs-7-data", 1879048204, NULL },
  { "iso", 1073741825, "1"},
  { "member-body", 1073741825, "2"},
  { "us", 1073741825, "840"},
  { "rsadsi", 1073741825, "113549"},
  { "pkcs", 1073741825, "1"},
  { "pkcs7", 1073741825, "7"},
  { NULL, 1, "1"},
  { "pkcs-7-encryptedData", 1879048204, NULL },
  { "iso", 1073741825, "1"},
  { "member-body", 1073741825, "2"},
  { "us", 1073741825, "840"},
  { "rsadsi", 1073741825, "113549"},
  { "pkcs", 1073741825, "1"},
  { "pkcs7", 1073741825, "7"},
  { NULL, 1, "6"},
  { "pkcs-7-Data", 1073741831, NULL },
  { "pkcs-7-EncryptedData", 1610612741, NULL },
  { "version", 1073741826, "pkcs-7-CMSVersion"},
  { "encryptedContentInfo", 1073741826, "pkcs-7-EncryptedContentInfo"},
  { "unprotectedAttrs", 536895490, "pkcs-7-UnprotectedAttributes"},
  { NULL, 4104, "1"},
  { "pkcs-7-EncryptedContentInfo", 1610612741, NULL },
  { "contentType", 1073741826, "pkcs-7-ContentType"},
  { "contentEncryptionAlgorithm", 1073741826, "pkcs-7-ContentEncryptionAlgorithmIdentifier"},
  { "encryptedContent", 536895490, "pkcs-7-EncryptedContent"},
  { NULL, 4104, "0"},
  { "pkcs-7-ContentEncryptionAlgorithmIdentifier", 1073741826, "AlgorithmIdentifier"},
  { "pkcs-7-EncryptedContent", 1073741831, NULL },
  { "pkcs-7-UnprotectedAttributes", 1612709903, NULL },
  { "MAX", 1074266122, "1"},
  { NULL, 2, "Attribute"},
  { "id-at-domainComponent", 1880096780, "AttributeType"},
  { NULL, 1073741825, "0"},
  { NULL, 1073741825, "9"},
  { NULL, 1073741825, "2342"},
  { NULL, 1073741825, "19200300"},
  { NULL, 1073741825, "100"},
  { NULL, 1073741825, "1"},
  { NULL, 1, "25"},
  { "domainComponent", 1073741826, "IA5String"},
  { "id-at-userId", 1880096780, "AttributeType"},
  { NULL, 1073741825, "0"},
  { NULL, 1073741825, "9"},
  { NULL, 1073741825, "2342"},
  { NULL, 1073741825, "19200300"},
  { NULL, 1073741825, "100"},
  { NULL, 1073741825, "1"},
  { NULL, 1, "1"},
  { "userId", 1073741826, "DirectoryString"},
  { "id-pda", 1879048204, NULL },
  { NULL, 1073741825, "id-pkix"},
  { NULL, 1, "9"},
  { "id-pda-dateOfBirth", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-pda"},
  { NULL, 1, "1"},
  { "DateOfBirth", 1082130449, NULL },
  { "id-pda-placeOfBirth", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-pda"},
  { NULL, 1, "2"},
  { "PlaceOfBirth", 1073741826, "DirectoryString"},
  { "id-pda-gender", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-pda"},
  { NULL, 1, "3"},
  { "Gender", 1612709890, "PrintableString"},
  { NULL, 1048586, "1"},
  { "id-pda-countryOfCitizenship", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-pda"},
  { NULL, 1, "4"},
  { "CountryOfCitizenship", 1612709890, "PrintableString"},
  { NULL, 1048586, "2"},
  { "id-pda-countryOfResidence", 1880096780, "AttributeType"},
  { NULL, 1073741825, "id-pda"},
  { NULL, 1, "5"},
  { "CountryOfResidence", 1612709890, "PrintableString"},
  { NULL, 1048586, "2"},
  { "PublicKeyAndChallenge", 1610612741, NULL },
  { "spki", 1073741826, "SubjectPublicKeyInfo"},
  { "challenge", 2, "IA5String"},
  { "SignedPublicKeyAndChallenge", 1610612741, NULL },
  { "publicKeyAndChallenge", 1073741826, "PublicKeyAndChallenge"},
  { "signatureAlgorithm", 1073741826, "AlgorithmIdentifier"},
  { "signature", 6, NULL },
  { "ExtensionRequest", 536870923, NULL },
  { NULL, 2, "Extension"},
  { NULL, 0, NULL }
};
