/* game-view.c generated by valac 0.27.1.12-a3c8, the Vala compiler
 * generated from game-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This file is part of Iagno.
 *
 * Iagno is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Iagno is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Iagno. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <librsvg/rsvg.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _Block2Data Block2Data;

#define TYPE_PLAYER (player_get_type ())
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

struct _GameView {
	GtkDrawingArea parent_instance;
	GameViewPrivate * priv;
};

struct _GameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _GameViewPrivate {
	GtkDrawingArea* _scoreboard;
	gchar* pieces_file;
	gdouble background_red;
	gdouble background_green;
	gdouble background_blue;
	gdouble mark_red;
	gdouble mark_green;
	gdouble mark_blue;
	gint mark_width;
	gdouble border_red;
	gdouble border_green;
	gdouble border_blue;
	gint border_width;
	gdouble spacing_red;
	gdouble spacing_green;
	gdouble spacing_blue;
	gint spacing_width;
	gchar* _sound_flip;
	gchar* _sound_gameover;
	gint tile_size;
	gint board_size;
	guint render_size;
	cairo_pattern_t* tiles_pattern;
	cairo_pattern_t* scoreboard_tiles_pattern;
	gint* pixmaps;
	gint pixmaps_length1;
	gint pixmaps_length2;
	guint animate_timeout;
	gint current_player_number;
	gboolean flip_final_result_now;
	Game* _game;
	gchar* _theme;
};

struct _Block2Data {
	int _ref_count_;
	GameView* self;
	gint x;
	gint y;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;


static gpointer game_view_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY,
	GAME_VIEW_SCOREBOARD,
	GAME_VIEW_SOUND_FLIP,
	GAME_VIEW_SOUND_GAMEOVER,
	GAME_VIEW_GAME,
	GAME_VIEW_THEME
};
#define GAME_VIEW_PIXMAP_FLIP_DELAY 20
static void game_view_set_default_theme (GameView* self, GKeyFile** key);
static void game_view_load_theme (GameView* self, GKeyFile* key);
static void game_view_set_sound_flip (GameView* self, const gchar* value);
static void game_view_set_sound_gameover (GameView* self, const gchar* value);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static void game_view_calculate (GameView* self);
Game* game_view_get_game (GameView* self);
gint game_get_size (Game* self);
static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr);
static void game_view_load_image (GameView* self, cairo_t* c, gint width, gint height);
static gint game_view_get_x_offset (GameView* self);
static gint game_view_get_y_offset (GameView* self);
static void game_view_square_changed_cb (GameView* self, gint x, gint y);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
GType player_get_type (void) G_GNUC_CONST;
static gint game_view_get_pixmap (GameView* self, Player color);
Player game_get_owner (Game* self, gint x, gint y);
gboolean game_get_is_complete (Game* self);
gint game_get_n_light_tiles (Game* self);
gint game_get_n_dark_tiles (Game* self);
static void game_view_set_square (GameView* self, gint x, gint y, gint pixmap);
static gboolean ___lambda6_ (Block2Data* _data2_);
static gboolean ____lambda6__gsource_func (gpointer self);
static gboolean game_view_animate_cb (GameView* self);
static gboolean _game_view_animate_cb_gsource_func (gpointer self);
static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static gboolean game_view_draw_scoreboard (GameView* self, cairo_t* cr);
static GtkDrawingArea* game_view_get_scoreboard (GameView* self);
void game_view_update_scoreboard (GameView* self);
Player game_get_current_color (Game* self);
void game_view_set_scoreboard (GameView* self, GtkDrawingArea* value);
static gboolean _game_view_draw_scoreboard_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
const gchar* game_view_get_sound_flip (GameView* self);
const gchar* game_view_get_sound_gameover (GameView* self);
void game_view_set_game (GameView* self, Game* value);
static void _game_view_square_changed_cb_game_square_changed (Game* _sender, gint x, gint y, gpointer self);
const gchar* game_view_get_theme (GameView* self);
void game_view_set_theme (GameView* self, const gchar* value);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void game_view_finalize (GObject* obj);
static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 190 "game-view.c"
}


static void game_view_set_default_theme (GameView* self, GKeyFile** key) {
	GtkSettings* defaults = NULL;
	GtkSettings* _tmp0_ = NULL;
	GtkSettings* _tmp1_ = NULL;
	gchar* filename = NULL;
	GtkSettings* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar* filepath = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (*key != NULL);
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = gtk_settings_get_default ();
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	defaults = _tmp1_;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = defaults;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_get (_tmp2_, "gtk-theme-name", &_tmp3_, NULL);
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp4_ = _tmp3_;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp5_ = _tmp4_;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp6_ = g_strcmp0 (_tmp5_, "HighContrast") == 0;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (_tmp5_);
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp6_) {
#line 232 "game-view.c"
		gchar* _tmp7_ = NULL;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp7_ = g_strdup ("high_contrast.theme");
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_free0 (filename);
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		filename = _tmp7_;
#line 240 "game-view.c"
	} else {
		GtkSettings* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp8_ = defaults;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_object_get (_tmp8_, "gtk-application-prefer-dark-theme", &_tmp9_, NULL);
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp10_ = _tmp9_;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp10_ == TRUE) {
#line 253 "game-view.c"
			gchar* _tmp11_ = NULL;
#line 153 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp11_ = g_strdup ("adwaita.theme");
#line 153 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (filename);
#line 153 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			filename = _tmp11_;
#line 261 "game-view.c"
		} else {
			gchar* _tmp12_ = NULL;
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp12_ = g_strdup ("classic.theme");
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (filename);
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			filename = _tmp12_;
#line 270 "game-view.c"
		}
	}
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp13_ = filename;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp14_ = g_build_filename (DATA_DIRECTORY, "themes", "key", _tmp13_, NULL);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	filepath = _tmp14_;
#line 279 "game-view.c"
	{
		GKeyFile* _tmp15_ = NULL;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp15_ = *key;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_key_file_load_from_file (_tmp15_, filepath, G_KEY_FILE_NONE, &_inner_error_);
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 288 "game-view.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_clear_error (&_inner_error_);
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_inner_error_ = NULL;
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_assert_not_reached ();
#line 301 "game-view.c"
	}
	__finally0:
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_free0 (filepath);
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_free0 (filename);
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_object_unref0 (defaults);
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_clear_error (&_inner_error_);
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		return;
#line 318 "game-view.c"
	}
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (filepath);
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (filename);
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_object_unref0 (defaults);
#line 326 "game-view.c"
}


static void game_view_load_theme (GameView* self, GKeyFile* key) {
	GError * _inner_error_ = NULL;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (key != NULL);
#line 336 "game-view.c"
	{
		gchar* svg_path = NULL;
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		GKeyFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		gdouble _tmp14_ = 0.0;
		GKeyFile* _tmp15_ = NULL;
		gdouble _tmp16_ = 0.0;
		gdouble _tmp17_ = 0.0;
		GKeyFile* _tmp18_ = NULL;
		gdouble _tmp19_ = 0.0;
		gdouble _tmp20_ = 0.0;
		GKeyFile* _tmp21_ = NULL;
		gdouble _tmp22_ = 0.0;
		gdouble _tmp23_ = 0.0;
		GKeyFile* _tmp24_ = NULL;
		gdouble _tmp25_ = 0.0;
		gdouble _tmp26_ = 0.0;
		GKeyFile* _tmp27_ = NULL;
		gdouble _tmp28_ = 0.0;
		gdouble _tmp29_ = 0.0;
		GKeyFile* _tmp30_ = NULL;
		gdouble _tmp31_ = 0.0;
		gint _tmp32_ = 0;
		GKeyFile* _tmp33_ = NULL;
		gint _tmp34_ = 0;
		gdouble _tmp35_ = 0.0;
		GKeyFile* _tmp36_ = NULL;
		gdouble _tmp37_ = 0.0;
		gdouble _tmp38_ = 0.0;
		GKeyFile* _tmp39_ = NULL;
		gdouble _tmp40_ = 0.0;
		gdouble _tmp41_ = 0.0;
		GKeyFile* _tmp42_ = NULL;
		gdouble _tmp43_ = 0.0;
		gint _tmp44_ = 0;
		GKeyFile* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gdouble _tmp47_ = 0.0;
		GKeyFile* _tmp48_ = NULL;
		gdouble _tmp49_ = 0.0;
		gdouble _tmp50_ = 0.0;
		GKeyFile* _tmp51_ = NULL;
		gdouble _tmp52_ = 0.0;
		gdouble _tmp53_ = 0.0;
		GKeyFile* _tmp54_ = NULL;
		gdouble _tmp55_ = 0.0;
		gint _tmp56_ = 0;
		GKeyFile* _tmp57_ = NULL;
		gint _tmp58_ = 0;
		gchar* _tmp59_ = NULL;
		GKeyFile* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
		gchar* _tmp62_ = NULL;
		GKeyFile* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp0_ = g_build_filename (DATA_DIRECTORY, "themes", "svg", NULL);
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		svg_path = _tmp0_;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp2_ = key;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp3_ = g_key_file_get_string (_tmp2_, "Pieces", "File", &_inner_error_);
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp1_ = _tmp3_;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 418 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 429 "game-view.c"
		}
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp4_ = svg_path;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp5_ = _tmp1_;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp1_ = NULL;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp6_ = g_build_filename (_tmp4_, _tmp5_, NULL);
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_free0 (self->priv->pieces_file);
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->pieces_file = _tmp6_;
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp7_ = self->priv->pieces_file;
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp8_ = g_path_get_dirname (_tmp7_);
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp9_ = _tmp8_;
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp10_ = svg_path;
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp11_ = g_strcmp0 (_tmp9_, _tmp10_) != 0;
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_free0 (_tmp9_);
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp11_) {
#line 457 "game-view.c"
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp12_ = svg_path;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp13_ = g_build_filename (_tmp12_, "black_and_white.svg", NULL);
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (self->priv->pieces_file);
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			self->priv->pieces_file = _tmp13_;
#line 468 "game-view.c"
		}
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp15_ = key;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp16_ = g_key_file_get_double (_tmp15_, "Background", "Red", &_inner_error_);
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp14_ = _tmp16_;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 484 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 497 "game-view.c"
		}
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->background_red = _tmp14_;
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp18_ = key;
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp19_ = g_key_file_get_double (_tmp18_, "Background", "Green", &_inner_error_);
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp17_ = _tmp19_;
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 515 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 528 "game-view.c"
		}
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->background_green = _tmp17_;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp21_ = key;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp22_ = g_key_file_get_double (_tmp21_, "Background", "Blue", &_inner_error_);
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp20_ = _tmp22_;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 546 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 559 "game-view.c"
		}
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->background_blue = _tmp20_;
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp24_ = key;
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp25_ = g_key_file_get_double (_tmp24_, "Mark", "Red", &_inner_error_);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp23_ = _tmp25_;
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 577 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 590 "game-view.c"
		}
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->mark_red = _tmp23_;
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp27_ = key;
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp28_ = g_key_file_get_double (_tmp27_, "Mark", "Green", &_inner_error_);
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp26_ = _tmp28_;
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 608 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 621 "game-view.c"
		}
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->mark_green = _tmp26_;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp30_ = key;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp31_ = g_key_file_get_double (_tmp30_, "Mark", "Blue", &_inner_error_);
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp29_ = _tmp31_;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 639 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 652 "game-view.c"
		}
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->mark_blue = _tmp29_;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp33_ = key;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp34_ = g_key_file_get_integer (_tmp33_, "Mark", "Width", &_inner_error_);
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp32_ = _tmp34_;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 670 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 683 "game-view.c"
		}
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->mark_width = _tmp32_;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp36_ = key;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp37_ = g_key_file_get_double (_tmp36_, "Border", "Red", &_inner_error_);
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp35_ = _tmp37_;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 701 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 714 "game-view.c"
		}
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->border_red = _tmp35_;
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp39_ = key;
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp40_ = g_key_file_get_double (_tmp39_, "Border", "Green", &_inner_error_);
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp38_ = _tmp40_;
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 732 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 745 "game-view.c"
		}
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->border_green = _tmp38_;
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp42_ = key;
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp43_ = g_key_file_get_double (_tmp42_, "Border", "Blue", &_inner_error_);
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp41_ = _tmp43_;
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 763 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 776 "game-view.c"
		}
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->border_blue = _tmp41_;
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp45_ = key;
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp46_ = g_key_file_get_integer (_tmp45_, "Border", "Width", &_inner_error_);
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp44_ = _tmp46_;
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 794 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 807 "game-view.c"
		}
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->border_width = _tmp44_;
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp48_ = key;
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp49_ = g_key_file_get_double (_tmp48_, "Spacing", "Red", &_inner_error_);
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp47_ = _tmp49_;
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 825 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 838 "game-view.c"
		}
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->spacing_red = _tmp47_;
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp51_ = key;
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp52_ = g_key_file_get_double (_tmp51_, "Spacing", "Green", &_inner_error_);
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp50_ = _tmp52_;
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 856 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 869 "game-view.c"
		}
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->spacing_green = _tmp50_;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp54_ = key;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp55_ = g_key_file_get_double (_tmp54_, "Spacing", "Blue", &_inner_error_);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp53_ = _tmp55_;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 887 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 900 "game-view.c"
		}
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->spacing_blue = _tmp53_;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp57_ = key;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp58_ = g_key_file_get_integer (_tmp57_, "Spacing", "Width", &_inner_error_);
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp56_ = _tmp58_;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 918 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 931 "game-view.c"
		}
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->spacing_width = _tmp56_;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp60_ = key;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp61_ = g_key_file_get_string (_tmp60_, "Sound", "Flip", &_inner_error_);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp59_ = _tmp61_;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 949 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 962 "game-view.c"
		}
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		game_view_set_sound_flip (self, _tmp59_);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp63_ = key;
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp64_ = g_key_file_get_string (_tmp63_, "Sound", "GameOver", &_inner_error_);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp62_ = _tmp64_;
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp59_);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 982 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp59_);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 997 "game-view.c"
		}
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		game_view_set_sound_gameover (self, _tmp62_);
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_free0 (_tmp62_);
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_free0 (_tmp59_);
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_free0 (_tmp1_);
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_free0 (svg_path);
#line 1009 "game-view.c"
	}
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp65_ = NULL;
		const gchar* _tmp66_ = NULL;
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		e = _inner_error_;
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_inner_error_ = NULL;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp65_ = e;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp66_ = _tmp65_->message;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_warning ("game-view.vala:200: Errors when loading theme: %s", _tmp66_);
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_error_free0 (e);
#line 1029 "game-view.c"
	}
	__finally1:
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_clear_error (&_inner_error_);
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		return;
#line 1040 "game-view.c"
	}
}


GameView* game_view_construct (GType object_type) {
	GameView * self = NULL;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self = (GameView*) g_object_new (object_type, NULL);
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	gtk_widget_set_events ((GtkWidget*) self, (gint) (GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK));
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, 350, 350);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return self;
#line 1055 "game-view.c"
}


GameView* game_view_new (void) {
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return game_view_construct (TYPE_GAME_VIEW);
#line 1062 "game-view.c"
}


static void game_view_calculate (GameView* self) {
	gint size = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	Game* _tmp5_ = NULL;
	Game* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	Game* _tmp10_ = NULL;
	Game* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = MIN (_tmp0_, _tmp1_);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	size = _tmp2_;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp3_ = self->priv->border_width;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp4_ = self->priv->spacing_width;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp5_ = game_view_get_game (self);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp6_ = _tmp5_;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp7_ = game_get_size (_tmp6_);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp8_ = _tmp7_;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->tile_size = ((size - (2 * _tmp3_)) + _tmp4_) / _tmp8_;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp9_ = self->priv->tile_size;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp10_ = game_view_get_game (self);
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp11_ = _tmp10_;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp12_ = game_get_size (_tmp11_);
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp13_ = _tmp12_;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp14_ = self->priv->spacing_width;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp15_ = self->priv->border_width;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->board_size = ((_tmp9_ * _tmp13_) - _tmp14_) + (2 * _tmp15_);
#line 1124 "game-view.c"
}


static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr) {
	GameView * self;
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	cairo_pattern_t* _tmp3_ = NULL;
	cairo_t* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	cairo_t* _tmp24_ = NULL;
	gdouble _tmp25_ = 0.0;
	gdouble _tmp26_ = 0.0;
	gdouble _tmp27_ = 0.0;
	cairo_t* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	cairo_t* _tmp35_ = NULL;
	cairo_t* _tmp36_ = NULL;
	gdouble _tmp37_ = 0.0;
	gdouble _tmp38_ = 0.0;
	gdouble _tmp39_ = 0.0;
	cairo_t* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	cairo_t* _tmp63_ = NULL;
	cairo_t* _tmp64_ = NULL;
	gdouble _tmp65_ = 0.0;
	gdouble _tmp66_ = 0.0;
	gdouble _tmp67_ = 0.0;
	cairo_t* _tmp68_ = NULL;
	gint _tmp69_ = 0;
	cairo_t* _tmp70_ = NULL;
	gint _tmp71_ = 0;
	gint _tmp72_ = 0;
	gint _tmp73_ = 0;
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	gint _tmp76_ = 0;
	cairo_t* _tmp77_ = NULL;
	cairo_t* _tmp78_ = NULL;
	gint _tmp79_ = 0;
	gint _tmp80_ = 0;
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self = (GameView*) base;
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = game_view_get_game (self);
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp1_ == NULL) {
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		result = FALSE;
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		return result;
#line 1190 "game-view.c"
	}
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	game_view_calculate (self);
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp3_ = self->priv->tiles_pattern;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp3_ == NULL) {
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp2_ = TRUE;
#line 1200 "game-view.c"
	} else {
		guint _tmp4_ = 0U;
		gint _tmp5_ = 0;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp4_ = self->priv->render_size;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp5_ = self->priv->tile_size;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp2_ = _tmp4_ != ((guint) _tmp5_);
#line 1210 "game-view.c"
	}
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp2_) {
#line 1214 "game-view.c"
		gint _tmp6_ = 0;
		cairo_surface_t* surface = NULL;
		cairo_t* _tmp7_ = NULL;
		cairo_surface_t* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		cairo_surface_t* _tmp11_ = NULL;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp12_ = NULL;
		cairo_t* _tmp13_ = NULL;
		cairo_t* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		cairo_surface_t* _tmp17_ = NULL;
		cairo_pattern_t* _tmp18_ = NULL;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp6_ = self->priv->tile_size;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->render_size = (guint) _tmp6_;
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp7_ = cr;
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp8_ = cairo_get_target (_tmp7_);
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp9_ = self->priv->tile_size;
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp10_ = self->priv->tile_size;
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp11_ = cairo_surface_create_similar (_tmp8_, CAIRO_CONTENT_COLOR_ALPHA, _tmp9_ * 8, _tmp10_ * 4);
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		surface = _tmp11_;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp12_ = surface;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp13_ = cairo_create (_tmp12_);
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		c = _tmp13_;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp14_ = c;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp15_ = self->priv->tile_size;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp16_ = self->priv->tile_size;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		game_view_load_image (self, _tmp14_, _tmp15_ * 8, _tmp16_ * 4);
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp17_ = surface;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp18_ = cairo_pattern_create_for_surface (_tmp17_);
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_cairo_pattern_destroy0 (self->priv->tiles_pattern);
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->tiles_pattern = _tmp18_;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_cairo_destroy0 (c);
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_cairo_surface_destroy0 (surface);
#line 1272 "game-view.c"
	}
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp19_ = cr;
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp20_ = game_view_get_x_offset (self);
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp21_ = _tmp20_;
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp22_ = game_view_get_y_offset (self);
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp23_ = _tmp22_;
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_translate (_tmp19_, (gdouble) _tmp21_, (gdouble) _tmp23_);
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp24_ = cr;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp25_ = self->priv->background_red;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp26_ = self->priv->background_green;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp27_ = self->priv->background_blue;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_set_source_rgba (_tmp24_, _tmp25_, _tmp26_, _tmp27_, 1.0);
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp28_ = cr;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp29_ = self->priv->border_width;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp30_ = self->priv->border_width;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp31_ = self->priv->board_size;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp32_ = self->priv->border_width;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp33_ = self->priv->board_size;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp34_ = self->priv->border_width;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_rectangle (_tmp28_, (-_tmp29_) / 2.0, (-_tmp30_) / 2.0, (gdouble) (_tmp31_ - _tmp32_), (gdouble) (_tmp33_ - _tmp34_));
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp35_ = cr;
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_fill (_tmp35_);
#line 243 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp36_ = cr;
#line 243 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp37_ = self->priv->spacing_red;
#line 243 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp38_ = self->priv->spacing_green;
#line 243 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp39_ = self->priv->spacing_blue;
#line 243 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_set_source_rgba (_tmp36_, _tmp37_, _tmp38_, _tmp39_, 1.0);
#line 244 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp40_ = cr;
#line 244 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp41_ = self->priv->spacing_width;
#line 244 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_set_line_width (_tmp40_, (gdouble) _tmp41_);
#line 1332 "game-view.c"
	{
		gint i = 0;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		i = 1;
#line 1337 "game-view.c"
		{
			gboolean _tmp42_ = FALSE;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp42_ = TRUE;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			while (TRUE) {
#line 1344 "game-view.c"
				gint _tmp44_ = 0;
				Game* _tmp45_ = NULL;
				Game* _tmp46_ = NULL;
				gint _tmp47_ = 0;
				gint _tmp48_ = 0;
				cairo_t* _tmp49_ = NULL;
				gint _tmp50_ = 0;
				gint _tmp51_ = 0;
				gint _tmp52_ = 0;
				cairo_t* _tmp53_ = NULL;
				gint _tmp54_ = 0;
				gint _tmp55_ = 0;
				cairo_t* _tmp56_ = NULL;
				gint _tmp57_ = 0;
				gint _tmp58_ = 0;
				gint _tmp59_ = 0;
				cairo_t* _tmp60_ = NULL;
				gint _tmp61_ = 0;
				gint _tmp62_ = 0;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				if (!_tmp42_) {
#line 1366 "game-view.c"
					gint _tmp43_ = 0;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp43_ = i;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					i = _tmp43_ + 1;
#line 1372 "game-view.c"
				}
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp42_ = FALSE;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp44_ = i;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp45_ = game_view_get_game (self);
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp46_ = _tmp45_;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp47_ = game_get_size (_tmp46_);
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp48_ = _tmp47_;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				if (!(_tmp44_ < _tmp48_)) {
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					break;
#line 1390 "game-view.c"
				}
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp49_ = cr;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp50_ = i;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp51_ = self->priv->tile_size;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp52_ = self->priv->spacing_width;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				cairo_move_to (_tmp49_, (_tmp50_ * _tmp51_) - (_tmp52_ / 2.0), (gdouble) 0);
#line 248 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp53_ = cr;
#line 248 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp54_ = self->priv->board_size;
#line 248 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp55_ = self->priv->border_width;
#line 248 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				cairo_rel_line_to (_tmp53_, (gdouble) 0, (gdouble) (_tmp54_ - _tmp55_));
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp56_ = cr;
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp57_ = i;
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp58_ = self->priv->tile_size;
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp59_ = self->priv->spacing_width;
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				cairo_move_to (_tmp56_, (gdouble) 0, (_tmp57_ * _tmp58_) - (_tmp59_ / 2.0));
#line 251 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp60_ = cr;
#line 251 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp61_ = self->priv->board_size;
#line 251 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp62_ = self->priv->border_width;
#line 251 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				cairo_rel_line_to (_tmp60_, (gdouble) (_tmp61_ - _tmp62_), (gdouble) 0);
#line 1428 "game-view.c"
			}
		}
	}
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp63_ = cr;
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_stroke (_tmp63_);
#line 256 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp64_ = cr;
#line 256 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp65_ = self->priv->border_red;
#line 256 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp66_ = self->priv->border_green;
#line 256 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp67_ = self->priv->border_blue;
#line 256 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_set_source_rgba (_tmp64_, _tmp65_, _tmp66_, _tmp67_, 1.0);
#line 257 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp68_ = cr;
#line 257 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp69_ = self->priv->border_width;
#line 257 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_set_line_width (_tmp68_, (gdouble) _tmp69_);
#line 258 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp70_ = cr;
#line 258 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp71_ = self->priv->border_width;
#line 258 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp72_ = self->priv->border_width;
#line 258 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp73_ = self->priv->board_size;
#line 258 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp74_ = self->priv->border_width;
#line 258 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp75_ = self->priv->board_size;
#line 258 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp76_ = self->priv->border_width;
#line 258 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_rectangle (_tmp70_, (-_tmp71_) / 2.0, (-_tmp72_) / 2.0, (gdouble) (_tmp73_ - _tmp74_), (gdouble) (_tmp75_ - _tmp76_));
#line 259 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp77_ = cr;
#line 259 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_stroke (_tmp77_);
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp78_ = cr;
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp79_ = self->priv->spacing_width;
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp80_ = self->priv->spacing_width;
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_translate (_tmp78_, (gdouble) ((-_tmp79_) / 2), (gdouble) ((-_tmp80_) / 2));
#line 1480 "game-view.c"
	{
		gint x = 0;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		x = 0;
#line 1485 "game-view.c"
		{
			gboolean _tmp81_ = FALSE;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp81_ = TRUE;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			while (TRUE) {
#line 1492 "game-view.c"
				gint _tmp83_ = 0;
				Game* _tmp84_ = NULL;
				Game* _tmp85_ = NULL;
				gint _tmp86_ = 0;
				gint _tmp87_ = 0;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				if (!_tmp81_) {
#line 1500 "game-view.c"
					gint _tmp82_ = 0;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp82_ = x;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					x = _tmp82_ + 1;
#line 1506 "game-view.c"
				}
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp81_ = FALSE;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp83_ = x;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp84_ = game_view_get_game (self);
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp85_ = _tmp84_;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp86_ = game_get_size (_tmp85_);
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp87_ = _tmp86_;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				if (!(_tmp83_ < _tmp87_)) {
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					break;
#line 1524 "game-view.c"
				}
				{
					gint y = 0;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					y = 0;
#line 1530 "game-view.c"
					{
						gboolean _tmp88_ = FALSE;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
						_tmp88_ = TRUE;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
						while (TRUE) {
#line 1537 "game-view.c"
							gint _tmp90_ = 0;
							Game* _tmp91_ = NULL;
							Game* _tmp92_ = NULL;
							gint _tmp93_ = 0;
							gint _tmp94_ = 0;
							gint* _tmp95_ = NULL;
							gint _tmp95__length1 = 0;
							gint _tmp95__length2 = 0;
							gint _tmp96_ = 0;
							gint _tmp97_ = 0;
							gint _tmp98_ = 0;
							gint tile_x = 0;
							gint _tmp99_ = 0;
							gint _tmp100_ = 0;
							gint tile_y = 0;
							gint _tmp101_ = 0;
							gint _tmp102_ = 0;
							gint texture_x = 0;
							gint* _tmp103_ = NULL;
							gint _tmp103__length1 = 0;
							gint _tmp103__length2 = 0;
							gint _tmp104_ = 0;
							gint _tmp105_ = 0;
							gint _tmp106_ = 0;
							gint _tmp107_ = 0;
							gint texture_y = 0;
							gint* _tmp108_ = NULL;
							gint _tmp108__length1 = 0;
							gint _tmp108__length2 = 0;
							gint _tmp109_ = 0;
							gint _tmp110_ = 0;
							gint _tmp111_ = 0;
							gint _tmp112_ = 0;
							cairo_matrix_t matrix = {0};
							gint _tmp113_ = 0;
							gint _tmp114_ = 0;
							gint _tmp115_ = 0;
							gint _tmp116_ = 0;
							cairo_pattern_t* _tmp117_ = NULL;
							cairo_matrix_t _tmp118_ = {0};
							cairo_t* _tmp119_ = NULL;
							cairo_pattern_t* _tmp120_ = NULL;
							cairo_t* _tmp121_ = NULL;
							gint _tmp122_ = 0;
							gint _tmp123_ = 0;
							gint _tmp124_ = 0;
							gint _tmp125_ = 0;
							cairo_t* _tmp126_ = NULL;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							if (!_tmp88_) {
#line 1588 "game-view.c"
								gint _tmp89_ = 0;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp89_ = y;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								y = _tmp89_ + 1;
#line 1594 "game-view.c"
							}
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp88_ = FALSE;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp90_ = y;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp91_ = game_view_get_game (self);
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp92_ = _tmp91_;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp93_ = game_get_size (_tmp92_);
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp94_ = _tmp93_;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							if (!(_tmp90_ < _tmp94_)) {
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								break;
#line 1612 "game-view.c"
							}
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp95_ = self->priv->pixmaps;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp95__length1 = self->priv->pixmaps_length1;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp95__length2 = self->priv->pixmaps_length2;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp96_ = x;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp97_ = y;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp98_ = _tmp95_[(_tmp96_ * _tmp95__length2) + _tmp97_];
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							if (_tmp98_ == 0) {
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								continue;
#line 1630 "game-view.c"
							}
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp99_ = x;
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp100_ = self->priv->tile_size;
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							tile_x = _tmp99_ * _tmp100_;
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp101_ = y;
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp102_ = self->priv->tile_size;
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							tile_y = _tmp101_ * _tmp102_;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp103_ = self->priv->pixmaps;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp103__length1 = self->priv->pixmaps_length1;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp103__length2 = self->priv->pixmaps_length2;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp104_ = x;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp105_ = y;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp106_ = _tmp103_[(_tmp104_ * _tmp103__length2) + _tmp105_];
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp107_ = self->priv->tile_size;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							texture_x = (_tmp106_ % 8) * _tmp107_;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp108_ = self->priv->pixmaps;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp108__length1 = self->priv->pixmaps_length1;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp108__length2 = self->priv->pixmaps_length2;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp109_ = x;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp110_ = y;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp111_ = _tmp108_[(_tmp109_ * _tmp108__length2) + _tmp110_];
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp112_ = self->priv->tile_size;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							texture_y = (_tmp111_ / 8) * _tmp112_;
#line 275 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							cairo_matrix_init_identity (&matrix);
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp113_ = texture_x;
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp114_ = tile_x;
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp115_ = texture_y;
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp116_ = tile_y;
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							cairo_matrix_translate (&matrix, (gdouble) (_tmp113_ - _tmp114_), (gdouble) (_tmp115_ - _tmp116_));
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp117_ = self->priv->tiles_pattern;
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp118_ = matrix;
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							cairo_pattern_set_matrix (_tmp117_, &_tmp118_);
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp119_ = cr;
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp120_ = self->priv->tiles_pattern;
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							cairo_set_source (_tmp119_, _tmp120_);
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp121_ = cr;
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp122_ = tile_x;
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp123_ = tile_y;
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp124_ = self->priv->tile_size;
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp125_ = self->priv->tile_size;
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							cairo_rectangle (_tmp121_, (gdouble) _tmp122_, (gdouble) _tmp123_, (gdouble) _tmp124_, (gdouble) _tmp125_);
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp126_ = cr;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							cairo_fill (_tmp126_);
#line 1716 "game-view.c"
						}
					}
				}
			}
		}
	}
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = FALSE;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 1727 "game-view.c"
}


static void game_view_load_image (GameView* self, cairo_t* c, gint width, gint height) {
	GError * _inner_error_ = NULL;
#line 286 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 286 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (c != NULL);
#line 1737 "game-view.c"
	{
		RsvgHandle* h = NULL;
		const gchar* _tmp0_ = NULL;
		RsvgHandle* _tmp1_ = NULL;
		cairo_matrix_t m = {0};
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		cairo_t* _tmp8_ = NULL;
		cairo_matrix_t _tmp9_ = {0};
		cairo_t* _tmp10_ = NULL;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp0_ = self->priv->pieces_file;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp1_ = rsvg_handle_new_from_file (_tmp0_, &_inner_error_);
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		h = _tmp1_;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1760 "game-view.c"
			goto __catch2_g_error;
		}
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		cairo_matrix_init_identity (&m);
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp2_ = width;
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_object_get (h, "width", &_tmp3_, NULL);
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp4_ = _tmp3_;
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp5_ = height;
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_object_get (h, "height", &_tmp6_, NULL);
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp7_ = _tmp6_;
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		cairo_matrix_scale (&m, ((gdouble) _tmp2_) / _tmp4_, ((gdouble) _tmp5_) / _tmp7_);
#line 294 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp8_ = c;
#line 294 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp9_ = m;
#line 294 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		cairo_set_matrix (_tmp8_, &_tmp9_);
#line 295 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp10_ = c;
#line 295 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		rsvg_handle_render_cairo (h, _tmp10_);
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_object_unref0 (h);
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		return;
#line 1793 "game-view.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
#line 288 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		e = _inner_error_;
#line 288 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_inner_error_ = NULL;
#line 288 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_error_free0 (e);
#line 1805 "game-view.c"
	}
	__finally2:
#line 288 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 288 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 288 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_clear_error (&_inner_error_);
#line 288 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		return;
#line 1816 "game-view.c"
	}
	{
		GdkPixbuf* p = NULL;
		const gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		GdkPixbuf* _tmp14_ = NULL;
		cairo_t* _tmp15_ = NULL;
		GdkPixbuf* _tmp16_ = NULL;
		cairo_t* _tmp17_ = NULL;
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp11_ = self->priv->pieces_file;
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp12_ = width;
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp13_ = height;
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp14_ = gdk_pixbuf_new_from_file_at_scale (_tmp11_, _tmp12_, _tmp13_, FALSE, &_inner_error_);
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		p = _tmp14_;
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1839 "game-view.c"
			goto __catch3_g_error;
		}
#line 307 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp15_ = c;
#line 307 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp16_ = p;
#line 307 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		gdk_cairo_set_source_pixbuf (_tmp15_, _tmp16_, (gdouble) 0, (gdouble) 0);
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp17_ = c;
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		cairo_paint (_tmp17_);
#line 304 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_object_unref0 (p);
#line 1854 "game-view.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp18_ = NULL;
		GError* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
#line 304 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		e = _inner_error_;
#line 304 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_inner_error_ = NULL;
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp18_ = self->priv->pieces_file;
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp19_ = e;
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp20_ = _tmp19_->message;
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_warning ("game-view.vala:312: Failed to load theme image %s: %s", _tmp18_, _tmp20_);
#line 304 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_error_free0 (e);
#line 1877 "game-view.c"
	}
	__finally3:
#line 304 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 304 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 304 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_clear_error (&_inner_error_);
#line 304 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		return;
#line 1888 "game-view.c"
	}
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return _data2_;
#line 1898 "game-view.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1907 "game-view.c"
		GameView* self;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self = _data2_->self;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_object_unref0 (self);
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_slice_free (Block2Data, _data2_);
#line 1915 "game-view.c"
	}
}


static gboolean ___lambda6_ (Block2Data* _data2_) {
	GameView* self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self = _data2_->self;
#line 358 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->flip_final_result_now = TRUE;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = _data2_->x;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = _data2_->y;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	game_view_square_changed_cb (self, _tmp0_, _tmp1_);
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = G_SOURCE_REMOVE;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 1939 "game-view.c"
}


static gboolean ____lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda6_ (self);
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 1948 "game-view.c"
}


static void game_view_square_changed_cb (GameView* self, gint x, gint y) {
	Block2Data* _data2_;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint pixmap = 0;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Player _tmp6_ = 0;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gint _tmp44_ = 0;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	Game* _tmp49_ = NULL;
	Game* _tmp50_ = NULL;
	gboolean _tmp51_ = FALSE;
	gboolean _tmp52_ = FALSE;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_data2_->_ref_count_ = 1;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_data2_->self = g_object_ref (self);
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = x;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_data2_->x = _tmp0_;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = y;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_data2_->y = _tmp1_;
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = game_view_get_game (self);
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp3_ = _tmp2_;
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp4_ = _data2_->x;
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp5_ = _data2_->y;
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp6_ = game_get_owner (_tmp3_, _tmp4_, _tmp5_);
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp7_ = game_view_get_pixmap (self, _tmp6_);
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	pixmap = _tmp7_;
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp9_ = self->priv->flip_final_result_now;
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp9_) {
#line 2008 "game-view.c"
		Game* _tmp10_ = NULL;
		Game* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp10_ = game_view_get_game (self);
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp11_ = _tmp10_;
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp12_ = game_get_is_complete (_tmp11_);
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp13_ = _tmp12_;
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp8_ = _tmp13_;
#line 2023 "game-view.c"
	} else {
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp8_ = FALSE;
#line 2027 "game-view.c"
	}
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp8_) {
#line 2031 "game-view.c"
		gint n = 0;
		gint _tmp14_ = 0;
		Game* _tmp15_ = NULL;
		Game* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		Player winning_color = 0;
		Player losing_color = 0;
		gint n_winning_tiles = 0;
		Game* _tmp20_ = NULL;
		Game* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gint n_losing_tiles = 0;
		Game* _tmp24_ = NULL;
		Game* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp14_ = _data2_->y;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp15_ = game_view_get_game (self);
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp16_ = _tmp15_;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp17_ = game_get_size (_tmp16_);
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp18_ = _tmp17_;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp19_ = _data2_->x;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		n = (_tmp14_ * _tmp18_) + _tmp19_;
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		winning_color = PLAYER_LIGHT;
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		losing_color = PLAYER_DARK;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp20_ = game_view_get_game (self);
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp21_ = _tmp20_;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp22_ = game_get_n_light_tiles (_tmp21_);
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp23_ = _tmp22_;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		n_winning_tiles = _tmp23_;
#line 327 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp24_ = game_view_get_game (self);
#line 327 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp25_ = _tmp24_;
#line 327 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp26_ = game_get_n_dark_tiles (_tmp25_);
#line 327 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp27_ = _tmp26_;
#line 327 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		n_losing_tiles = _tmp27_;
#line 328 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp28_ = n_losing_tiles;
#line 328 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp29_ = n_winning_tiles;
#line 328 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp28_ > _tmp29_) {
#line 2099 "game-view.c"
			gint t = 0;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
#line 330 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			winning_color = PLAYER_DARK;
#line 331 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			losing_color = PLAYER_LIGHT;
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp30_ = n_winning_tiles;
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			t = _tmp30_;
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp31_ = n_losing_tiles;
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			n_winning_tiles = _tmp31_;
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp32_ = t;
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			n_losing_tiles = _tmp32_;
#line 2120 "game-view.c"
		}
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp33_ = n;
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp34_ = n_winning_tiles;
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp33_ < _tmp34_) {
#line 2128 "game-view.c"
			Player _tmp35_ = 0;
			gint _tmp36_ = 0;
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp35_ = winning_color;
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp36_ = game_view_get_pixmap (self, _tmp35_);
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			pixmap = _tmp36_;
#line 2137 "game-view.c"
		} else {
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
			gint _tmp39_ = 0;
#line 338 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp37_ = n;
#line 338 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp38_ = n_winning_tiles;
#line 338 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp39_ = n_losing_tiles;
#line 338 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_tmp37_ < (_tmp38_ + _tmp39_)) {
#line 2150 "game-view.c"
				Player _tmp40_ = 0;
				gint _tmp41_ = 0;
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp40_ = losing_color;
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp41_ = game_view_get_pixmap (self, _tmp40_);
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				pixmap = _tmp41_;
#line 2159 "game-view.c"
			} else {
				gint _tmp42_ = 0;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp42_ = game_view_get_pixmap (self, PLAYER_NONE);
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				pixmap = _tmp42_;
#line 2166 "game-view.c"
			}
		}
	} else {
		gboolean _tmp43_ = FALSE;
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp43_ = self->priv->flip_final_result_now;
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp43_) {
#line 346 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			self->priv->flip_final_result_now = FALSE;
#line 2177 "game-view.c"
		}
	}
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp44_ = _data2_->x;
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp45_ = _data2_->y;
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp46_ = pixmap;
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	game_view_set_square (self, _tmp44_, _tmp45_, _tmp46_);
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp49_ = game_view_get_game (self);
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp50_ = _tmp49_;
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp51_ = game_get_is_complete (_tmp50_);
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp52_ = _tmp51_;
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp52_) {
#line 2198 "game-view.c"
		Game* _tmp53_ = NULL;
		Game* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp53_ = game_view_get_game (self);
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp54_ = _tmp53_;
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp55_ = game_get_n_light_tiles (_tmp54_);
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp56_ = _tmp55_;
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp48_ = _tmp56_ > 0;
#line 2213 "game-view.c"
	} else {
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp48_ = FALSE;
#line 2217 "game-view.c"
	}
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp48_) {
#line 2221 "game-view.c"
		Game* _tmp57_ = NULL;
		Game* _tmp58_ = NULL;
		gint _tmp59_ = 0;
		gint _tmp60_ = 0;
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp57_ = game_view_get_game (self);
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp58_ = _tmp57_;
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp59_ = game_get_n_dark_tiles (_tmp58_);
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp60_ = _tmp59_;
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp47_ = _tmp60_ > 0;
#line 2236 "game-view.c"
	} else {
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp47_ = FALSE;
#line 2240 "game-view.c"
	}
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp47_) {
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, ____lambda6__gsource_func, block2_data_ref (_data2_), block2_data_unref);
#line 2246 "game-view.c"
	}
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	block2_data_unref (_data2_);
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_data2_ = NULL;
#line 2252 "game-view.c"
}


static gboolean _game_view_animate_cb_gsource_func (gpointer self) {
	gboolean result;
	result = game_view_animate_cb ((GameView*) self);
#line 379 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 2261 "game-view.c"
}


static void game_view_set_square (GameView* self, gint x, gint y, gint pixmap) {
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
#line 365 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 367 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = self->priv->pixmaps;
#line 367 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0__length1 = self->priv->pixmaps_length1;
#line 367 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0__length2 = self->priv->pixmaps_length2;
#line 367 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = x;
#line 367 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = y;
#line 367 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 367 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp4_ = pixmap;
#line 367 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp3_ == _tmp4_) {
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		return;
#line 2305 "game-view.c"
	}
#line 370 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp6_ = pixmap;
#line 370 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp6_ == 0) {
#line 370 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp5_ = TRUE;
#line 2313 "game-view.c"
	} else {
		gint* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gint _tmp7__length2 = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 370 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp7_ = self->priv->pixmaps;
#line 370 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp7__length1 = self->priv->pixmaps_length1;
#line 370 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp7__length2 = self->priv->pixmaps_length2;
#line 370 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp8_ = x;
#line 370 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp9_ = y;
#line 370 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
#line 370 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp5_ = _tmp10_ == 0;
#line 2335 "game-view.c"
	}
#line 370 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp5_) {
#line 2339 "game-view.c"
		gint* _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gint _tmp11__length2 = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
#line 371 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp11_ = self->priv->pixmaps;
#line 371 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp11__length1 = self->priv->pixmaps_length1;
#line 371 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp11__length2 = self->priv->pixmaps_length2;
#line 371 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp12_ = x;
#line 371 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp13_ = y;
#line 371 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp14_ = pixmap;
#line 371 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_] = _tmp14_;
#line 371 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp15_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
#line 2363 "game-view.c"
	} else {
		gint _tmp16_ = 0;
		gint* _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		gint _tmp17__length2 = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		guint _tmp29_ = 0U;
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp16_ = pixmap;
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp17_ = self->priv->pixmaps;
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp17__length1 = self->priv->pixmaps_length1;
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp17__length2 = self->priv->pixmaps_length2;
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp18_ = x;
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp19_ = y;
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp20_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp16_ > _tmp20_) {
#line 2389 "game-view.c"
			gint* _tmp21_ = NULL;
			gint _tmp21__length1 = 0;
			gint _tmp21__length2 = 0;
			gint _tmp22_ = 0;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp21_ = self->priv->pixmaps;
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp21__length1 = self->priv->pixmaps_length1;
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp21__length2 = self->priv->pixmaps_length2;
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp22_ = x;
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp23_ = y;
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp24_ = _tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_];
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_] = _tmp24_ + 1;
#line 2410 "game-view.c"
		} else {
			gint* _tmp25_ = NULL;
			gint _tmp25__length1 = 0;
			gint _tmp25__length2 = 0;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp25_ = self->priv->pixmaps;
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp25__length1 = self->priv->pixmaps_length1;
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp25__length2 = self->priv->pixmaps_length2;
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp26_ = x;
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp27_ = y;
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_] = _tmp28_ - 1;
#line 2432 "game-view.c"
		}
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp29_ = self->priv->animate_timeout;
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp29_ == ((guint) 0)) {
#line 2438 "game-view.c"
			guint _tmp30_ = 0U;
#line 379 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp30_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GAME_VIEW_PIXMAP_FLIP_DELAY, _game_view_animate_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 379 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			self->priv->animate_timeout = _tmp30_;
#line 2444 "game-view.c"
		}
	}
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp31_ = game_view_get_x_offset (self);
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp32_ = _tmp31_;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp33_ = x;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp34_ = self->priv->tile_size;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp35_ = game_view_get_y_offset (self);
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp36_ = _tmp35_;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp37_ = y;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp38_ = self->priv->tile_size;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp39_ = self->priv->tile_size;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp40_ = self->priv->tile_size;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	gtk_widget_queue_draw_area ((GtkWidget*) self, _tmp32_ + (_tmp33_ * _tmp34_), _tmp36_ + (_tmp37_ * _tmp38_), _tmp39_, _tmp40_);
#line 2469 "game-view.c"
}


static gboolean game_view_animate_cb (GameView* self) {
	gboolean result = FALSE;
	gboolean animating = FALSE;
	gboolean _tmp25_ = FALSE;
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 386 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	animating = FALSE;
#line 2481 "game-view.c"
	{
		gint x = 0;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		x = 0;
#line 2486 "game-view.c"
		{
			gboolean _tmp0_ = FALSE;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp0_ = TRUE;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			while (TRUE) {
#line 2493 "game-view.c"
				gint _tmp2_ = 0;
				Game* _tmp3_ = NULL;
				Game* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				if (!_tmp0_) {
#line 2501 "game-view.c"
					gint _tmp1_ = 0;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp1_ = x;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					x = _tmp1_ + 1;
#line 2507 "game-view.c"
				}
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp0_ = FALSE;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp2_ = x;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp3_ = game_view_get_game (self);
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp4_ = _tmp3_;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp5_ = game_get_size (_tmp4_);
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp6_ = _tmp5_;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				if (!(_tmp2_ < _tmp6_)) {
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					break;
#line 2525 "game-view.c"
				}
				{
					gint y = 0;
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					y = 0;
#line 2531 "game-view.c"
					{
						gboolean _tmp7_ = FALSE;
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
						_tmp7_ = TRUE;
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
						while (TRUE) {
#line 2538 "game-view.c"
							gint _tmp9_ = 0;
							Game* _tmp10_ = NULL;
							Game* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint old = 0;
							gint* _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							gint* _tmp20_ = NULL;
							gint _tmp20__length1 = 0;
							gint _tmp20__length2 = 0;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							if (!_tmp7_) {
#line 2562 "game-view.c"
								gint _tmp8_ = 0;
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp8_ = y;
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								y = _tmp8_ + 1;
#line 2568 "game-view.c"
							}
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp7_ = FALSE;
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp9_ = y;
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp10_ = game_view_get_game (self);
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp11_ = _tmp10_;
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp12_ = game_get_size (_tmp11_);
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp13_ = _tmp12_;
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							if (!(_tmp9_ < _tmp13_)) {
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								break;
#line 2586 "game-view.c"
							}
#line 392 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp14_ = self->priv->pixmaps;
#line 392 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp14__length1 = self->priv->pixmaps_length1;
#line 392 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp14__length2 = self->priv->pixmaps_length2;
#line 392 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp15_ = x;
#line 392 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp16_ = y;
#line 392 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 392 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							old = _tmp17_;
#line 393 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp18_ = x;
#line 393 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp19_ = y;
#line 393 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							game_view_square_changed_cb (self, _tmp18_, _tmp19_);
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp20_ = self->priv->pixmaps;
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp20__length1 = self->priv->pixmaps_length1;
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp20__length2 = self->priv->pixmaps_length2;
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp21_ = x;
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp22_ = y;
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp23_ = _tmp20_[(_tmp21_ * _tmp20__length2) + _tmp22_];
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp24_ = old;
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							if (_tmp23_ != _tmp24_) {
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								animating = TRUE;
#line 2626 "game-view.c"
							}
						}
					}
				}
			}
		}
	}
#line 399 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp25_ = animating;
#line 399 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (!_tmp25_) {
#line 401 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->animate_timeout = (guint) 0;
#line 402 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		result = G_SOURCE_REMOVE;
#line 402 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		return result;
#line 2644 "game-view.c"
	}
#line 405 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = G_SOURCE_CONTINUE;
#line 405 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 2650 "game-view.c"
}


static gint game_view_get_pixmap (GameView* self, Player color) {
	gint result = 0;
	Player _tmp0_ = 0;
#line 408 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 410 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = color;
#line 410 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	switch (_tmp0_) {
#line 2663 "game-view.c"
		default:
#line 410 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case PLAYER_NONE:
#line 2667 "game-view.c"
		{
#line 414 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			result = 0;
#line 414 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return result;
#line 2673 "game-view.c"
		}
#line 410 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case PLAYER_DARK:
#line 2677 "game-view.c"
		{
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			result = 1;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return result;
#line 2683 "game-view.c"
		}
#line 410 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case PLAYER_LIGHT:
#line 2687 "game-view.c"
		{
#line 418 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			result = 31;
#line 418 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return result;
#line 2693 "game-view.c"
		}
	}
}


static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	GameView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
#line 422 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self = (GameView*) base;
#line 422 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 424 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = event;
#line 424 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = _tmp1_->button;
#line 424 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp2_ == ((guint) GDK_BUTTON_PRIMARY)) {
#line 424 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp0_ = TRUE;
#line 2717 "game-view.c"
	} else {
		GdkEventButton* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
#line 424 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp3_ = event;
#line 424 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp4_ = _tmp3_->button;
#line 424 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp0_ = _tmp4_ == ((guint) GDK_BUTTON_SECONDARY);
#line 2727 "game-view.c"
	}
#line 424 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp0_) {
#line 2731 "game-view.c"
		gint x = 0;
		GdkEventButton* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint y = 0;
		GdkEventButton* _tmp10_ = NULL;
		gdouble _tmp11_ = 0.0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gint _tmp18_ = 0;
#line 426 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp5_ = event;
#line 426 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp6_ = _tmp5_->x;
#line 426 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp7_ = game_view_get_x_offset (self);
#line 426 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp8_ = _tmp7_;
#line 426 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp9_ = self->priv->tile_size;
#line 426 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		x = ((gint) (_tmp6_ - _tmp8_)) / _tmp9_;
#line 427 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp10_ = event;
#line 427 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp11_ = _tmp10_->y;
#line 427 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp12_ = game_view_get_y_offset (self);
#line 427 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp13_ = _tmp12_;
#line 427 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp14_ = self->priv->tile_size;
#line 427 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		y = ((gint) (_tmp11_ - _tmp13_)) / _tmp14_;
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp18_ = x;
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp18_ >= 0) {
#line 2776 "game-view.c"
			gint _tmp19_ = 0;
			Game* _tmp20_ = NULL;
			Game* _tmp21_ = NULL;
			gint _tmp22_ = 0;
			gint _tmp23_ = 0;
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp19_ = x;
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp20_ = game_view_get_game (self);
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp21_ = _tmp20_;
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp22_ = game_get_size (_tmp21_);
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp23_ = _tmp22_;
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp17_ = _tmp19_ < _tmp23_;
#line 2794 "game-view.c"
		} else {
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp17_ = FALSE;
#line 2798 "game-view.c"
		}
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp17_) {
#line 2802 "game-view.c"
			gint _tmp24_ = 0;
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp24_ = y;
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp16_ = _tmp24_ >= 0;
#line 2808 "game-view.c"
		} else {
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp16_ = FALSE;
#line 2812 "game-view.c"
		}
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp16_) {
#line 2816 "game-view.c"
			gint _tmp25_ = 0;
			Game* _tmp26_ = NULL;
			Game* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp25_ = y;
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp26_ = game_view_get_game (self);
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp27_ = _tmp26_;
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp28_ = game_get_size (_tmp27_);
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp29_ = _tmp28_;
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp15_ = _tmp25_ < _tmp29_;
#line 2834 "game-view.c"
		} else {
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp15_ = FALSE;
#line 2838 "game-view.c"
		}
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp15_) {
#line 2842 "game-view.c"
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
#line 429 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp30_ = x;
#line 429 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp31_ = y;
#line 429 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_signal_emit_by_name (self, "move", _tmp30_, _tmp31_);
#line 2851 "game-view.c"
		}
	}
#line 432 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = TRUE;
#line 432 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 2858 "game-view.c"
}


static gboolean game_view_draw_scoreboard (GameView* self, cairo_t* cr) {
	gboolean result = FALSE;
	gint height = 0;
	GtkDrawingArea* _tmp0_ = NULL;
	GtkDrawingArea* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint width = 0;
	GtkDrawingArea* _tmp3_ = NULL;
	GtkDrawingArea* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	cairo_t* _tmp6_ = NULL;
	cairo_t* _tmp7_ = NULL;
	cairo_t* _tmp8_ = NULL;
	cairo_t* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	cairo_t* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	cairo_t* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	cairo_t* _tmp17_ = NULL;
	cairo_t* _tmp18_ = NULL;
	cairo_t* _tmp19_ = NULL;
	cairo_t* _tmp20_ = NULL;
	cairo_t* _tmp21_ = NULL;
	cairo_surface_t* surface = NULL;
	cairo_t* _tmp22_ = NULL;
	cairo_surface_t* _tmp23_ = NULL;
	cairo_surface_t* _tmp24_ = NULL;
	cairo_t* c = NULL;
	cairo_t* _tmp25_ = NULL;
	cairo_pattern_t* _tmp26_ = NULL;
	cairo_t* _tmp27_ = NULL;
	cairo_matrix_t matrix = {0};
	cairo_pattern_t* _tmp28_ = NULL;
	cairo_matrix_t _tmp29_ = {0};
	cairo_t* _tmp30_ = NULL;
	cairo_pattern_t* _tmp31_ = NULL;
	cairo_t* _tmp32_ = NULL;
	cairo_t* _tmp33_ = NULL;
	cairo_pattern_t* _tmp34_ = NULL;
	cairo_matrix_t _tmp35_ = {0};
	cairo_t* _tmp36_ = NULL;
	cairo_pattern_t* _tmp37_ = NULL;
	cairo_t* _tmp38_ = NULL;
	cairo_t* _tmp39_ = NULL;
#line 439 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 439 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = game_view_get_scoreboard (self);
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp1_);
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	height = _tmp2_;
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp3_ = game_view_get_scoreboard (self);
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp4_ = _tmp3_;
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp5_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp4_);
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	width = _tmp5_;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp6_ = cr;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_set_line_cap (_tmp6_, CAIRO_LINE_CAP_ROUND);
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp7_ = cr;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_set_line_join (_tmp7_, CAIRO_LINE_JOIN_ROUND);
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp8_ = cr;
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_save (_tmp8_);
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp9_ = cr;
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp10_ = self->priv->mark_red;
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp11_ = self->priv->mark_green;
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp12_ = self->priv->mark_blue;
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_set_source_rgba (_tmp9_, _tmp10_, _tmp11_, _tmp12_, 1.0);
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp13_ = cr;
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp14_ = self->priv->mark_width;
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_set_line_width (_tmp13_, (gdouble) _tmp14_);
#line 452 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp15_ = cr;
#line 452 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp16_ = self->priv->current_player_number;
#line 452 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_translate (_tmp15_, (gdouble) 0, (_tmp16_ * height) / 2.0);
#line 453 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp17_ = cr;
#line 453 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_move_to (_tmp17_, height / 4.0, height / 8.0);
#line 454 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp18_ = cr;
#line 454 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_line_to (_tmp18_, width - ((5.0 * height) / 8.0), height / 4.0);
#line 455 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp19_ = cr;
#line 455 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_line_to (_tmp19_, height / 4.0, (3.0 * height) / 8.0);
#line 456 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp20_ = cr;
#line 456 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_stroke (_tmp20_);
#line 458 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp21_ = cr;
#line 458 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_restore (_tmp21_);
#line 463 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp22_ = cr;
#line 463 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp23_ = cairo_get_target (_tmp22_);
#line 463 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp24_ = cairo_surface_create_similar (_tmp23_, CAIRO_CONTENT_COLOR_ALPHA, height * 4, height * 2);
#line 463 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	surface = _tmp24_;
#line 464 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp25_ = cairo_create (surface);
#line 464 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	c = _tmp25_;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	game_view_load_image (self, c, height * 4, height * 2);
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp26_ = cairo_pattern_create_for_surface (surface);
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_cairo_pattern_destroy0 (self->priv->scoreboard_tiles_pattern);
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->scoreboard_tiles_pattern = _tmp26_;
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp27_ = cr;
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_translate (_tmp27_, width - (height / 2.0), (gdouble) 0);
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_matrix_init_identity (&matrix);
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_matrix_translate (&matrix, height / 2.0, (gdouble) 0);
#line 473 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp28_ = self->priv->scoreboard_tiles_pattern;
#line 473 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp29_ = matrix;
#line 473 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_pattern_set_matrix (_tmp28_, &_tmp29_);
#line 474 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp30_ = cr;
#line 474 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp31_ = self->priv->scoreboard_tiles_pattern;
#line 474 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_set_source (_tmp30_, _tmp31_);
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp32_ = cr;
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_rectangle (_tmp32_, (gdouble) 0, (gdouble) 0, height / 2.0, height / 2.0);
#line 476 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp33_ = cr;
#line 476 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_fill (_tmp33_);
#line 479 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_matrix_translate (&matrix, (gdouble) (3 * height), (gdouble) height);
#line 480 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp34_ = self->priv->scoreboard_tiles_pattern;
#line 480 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp35_ = matrix;
#line 480 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_pattern_set_matrix (_tmp34_, &_tmp35_);
#line 481 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp36_ = cr;
#line 481 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp37_ = self->priv->scoreboard_tiles_pattern;
#line 481 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_set_source (_tmp36_, _tmp37_);
#line 482 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp38_ = cr;
#line 482 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_rectangle (_tmp38_, (gdouble) 0, height / 2.0, height / 2.0, height / 2.0);
#line 483 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp39_ = cr;
#line 483 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_fill (_tmp39_);
#line 502 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = TRUE;
#line 502 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_cairo_destroy0 (c);
#line 502 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_cairo_surface_destroy0 (surface);
#line 502 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 3061 "game-view.c"
}


void game_view_update_scoreboard (GameView* self) {
	gint _tmp0_ = 0;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	GtkDrawingArea* _tmp5_ = NULL;
	GtkDrawingArea* _tmp6_ = NULL;
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = game_view_get_game (self);
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = _tmp1_;
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp3_ = game_get_current_color (_tmp2_);
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp4_ = _tmp3_;
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp4_ == PLAYER_DARK) {
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp0_ = 0;
#line 3087 "game-view.c"
	} else {
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp0_ = 1;
#line 3091 "game-view.c"
	}
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->current_player_number = _tmp0_;
#line 508 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp5_ = game_view_get_scoreboard (self);
#line 508 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp6_ = _tmp5_;
#line 508 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
#line 3101 "game-view.c"
}


static GtkDrawingArea* game_view_get_scoreboard (GameView* self) {
	GtkDrawingArea* result;
	GtkDrawingArea* _tmp0_ = NULL;
#line 25 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 25 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_scoreboard;
#line 25 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = _tmp0_;
#line 25 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 3116 "game-view.c"
}


static gboolean _game_view_draw_scoreboard_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = game_view_draw_scoreboard ((GameView*) self, cr);
#line 29 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 3125 "game-view.c"
}


void game_view_set_scoreboard (GameView* self, GtkDrawingArea* value) {
	GtkDrawingArea* _tmp0_ = NULL;
	GtkDrawingArea* _tmp1_ = NULL;
	GtkDrawingArea* _tmp2_ = NULL;
#line 26 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 28 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = value;
#line 28 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 28 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_object_unref0 (self->priv->_scoreboard);
#line 28 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->_scoreboard = _tmp1_;
#line 29 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = self->priv->_scoreboard;
#line 29 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp2_, "draw", (GCallback) _game_view_draw_scoreboard_gtk_widget_draw, self, 0);
#line 26 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_notify ((GObject *) self, "scoreboard");
#line 3149 "game-view.c"
}


const gchar* game_view_get_sound_flip (GameView* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 57 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 57 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_sound_flip;
#line 57 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = _tmp0_;
#line 57 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 3164 "game-view.c"
}


static void game_view_set_sound_flip (GameView* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 57 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 57 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = value;
#line 57 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 57 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (self->priv->_sound_flip);
#line 57 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->_sound_flip = _tmp1_;
#line 57 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_notify ((GObject *) self, "sound-flip");
#line 3183 "game-view.c"
}


const gchar* game_view_get_sound_gameover (GameView* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_sound_gameover;
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = _tmp0_;
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 3198 "game-view.c"
}


static void game_view_set_sound_gameover (GameView* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = value;
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (self->priv->_sound_gameover);
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->_sound_gameover = _tmp1_;
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_notify ((GObject *) self, "sound-gameover");
#line 3217 "game-view.c"
}


static gint game_view_get_x_offset (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = self->priv->board_size;
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = self->priv->border_width;
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = ((_tmp0_ - _tmp1_) / 2) + _tmp2_;
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 3238 "game-view.c"
}


static gint game_view_get_y_offset (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = self->priv->board_size;
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = self->priv->border_width;
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = ((_tmp0_ - _tmp1_) / 2) + _tmp2_;
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 3259 "game-view.c"
}


Game* game_view_get_game (GameView* self) {
	Game* result;
	Game* _tmp0_ = NULL;
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_game;
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = _tmp0_;
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 3274 "game-view.c"
}


static void _game_view_square_changed_cb_game_square_changed (Game* _sender, gint x, gint y, gpointer self) {
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	game_view_square_changed_cb ((GameView*) self, x, y);
#line 3281 "game-view.c"
}


void game_view_set_game (GameView* self, Game* value) {
	Game* _tmp0_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	Game* _tmp8_ = NULL;
	Game* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint* _tmp12_ = NULL;
	Game* _tmp13_ = NULL;
#line 92 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_game;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp0_ != NULL) {
#line 3305 "game-view.c"
		Game* _tmp1_ = NULL;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp1_ = self->priv->_game;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
#line 3311 "game-view.c"
	}
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = value;
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->_game = _tmp3_;
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp4_ = game_view_get_game (self);
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp5_ = _tmp4_;
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp6_ = game_get_size (_tmp5_);
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp7_ = _tmp6_;
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp8_ = game_view_get_game (self);
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp9_ = _tmp8_;
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp10_ = game_get_size (_tmp9_);
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp11_ = _tmp10_;
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp12_ = g_new0 (gint, _tmp7_ * _tmp11_);
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->pixmaps = (g_free (self->priv->pixmaps), NULL);
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->pixmaps = _tmp12_;
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->pixmaps_length1 = _tmp7_;
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->pixmaps_length2 = _tmp11_;
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp13_ = self->priv->_game;
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp13_ != NULL) {
#line 3351 "game-view.c"
		Game* _tmp14_ = NULL;
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp14_ = self->priv->_game;
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_signal_connect_object (_tmp14_, "square-changed", (GCallback) _game_view_square_changed_cb_game_square_changed, self, 0);
#line 3357 "game-view.c"
		{
			gint x = 0;
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			x = 0;
#line 3362 "game-view.c"
			{
				gboolean _tmp15_ = FALSE;
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp15_ = TRUE;
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				while (TRUE) {
#line 3369 "game-view.c"
					gint _tmp17_ = 0;
					Game* _tmp18_ = NULL;
					Game* _tmp19_ = NULL;
					gint _tmp20_ = 0;
					gint _tmp21_ = 0;
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					if (!_tmp15_) {
#line 3377 "game-view.c"
						gint _tmp16_ = 0;
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
						_tmp16_ = x;
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
						x = _tmp16_ + 1;
#line 3383 "game-view.c"
					}
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp15_ = FALSE;
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp17_ = x;
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp18_ = game_view_get_game (self);
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp19_ = _tmp18_;
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp20_ = game_get_size (_tmp19_);
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp21_ = _tmp20_;
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					if (!(_tmp17_ < _tmp21_)) {
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
						break;
#line 3401 "game-view.c"
					}
					{
						gint y = 0;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
						y = 0;
#line 3407 "game-view.c"
						{
							gboolean _tmp22_ = FALSE;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp22_ = TRUE;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							while (TRUE) {
#line 3414 "game-view.c"
								gint _tmp24_ = 0;
								Game* _tmp25_ = NULL;
								Game* _tmp26_ = NULL;
								gint _tmp27_ = 0;
								gint _tmp28_ = 0;
								gint* _tmp29_ = NULL;
								gint _tmp29__length1 = 0;
								gint _tmp29__length2 = 0;
								gint _tmp30_ = 0;
								gint _tmp31_ = 0;
								Game* _tmp32_ = NULL;
								gint _tmp33_ = 0;
								gint _tmp34_ = 0;
								Player _tmp35_ = 0;
								gint _tmp36_ = 0;
								gint _tmp37_ = 0;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								if (!_tmp22_) {
#line 3433 "game-view.c"
									gint _tmp23_ = 0;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									_tmp23_ = y;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									y = _tmp23_ + 1;
#line 3439 "game-view.c"
								}
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp22_ = FALSE;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp24_ = y;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp25_ = game_view_get_game (self);
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp26_ = _tmp25_;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp27_ = game_get_size (_tmp26_);
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp28_ = _tmp27_;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								if (!(_tmp24_ < _tmp28_)) {
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									break;
#line 3457 "game-view.c"
								}
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp29_ = self->priv->pixmaps;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp29__length1 = self->priv->pixmaps_length1;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp29__length2 = self->priv->pixmaps_length2;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp30_ = x;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp31_ = y;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp32_ = self->priv->_game;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp33_ = x;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp34_ = y;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp35_ = game_get_owner (_tmp32_, _tmp33_, _tmp34_);
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp36_ = game_view_get_pixmap (self, _tmp35_);
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_] = _tmp36_;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp37_ = _tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_];
#line 3483 "game-view.c"
							}
						}
					}
				}
			}
		}
	}
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 92 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_notify ((GObject *) self, "game");
#line 3495 "game-view.c"
}


const gchar* game_view_get_theme (GameView* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 112 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 112 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_theme;
#line 112 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = _tmp0_;
#line 112 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 3510 "game-view.c"
}


void game_view_set_theme (GameView* self, const gchar* value) {
	GKeyFile* key = NULL;
	GKeyFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GKeyFile* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	GtkDrawingArea* _tmp19_ = NULL;
	GtkDrawingArea* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
#line 113 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 114 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = g_key_file_new ();
#line 114 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	key = _tmp0_;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = value;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (g_strcmp0 (_tmp1_, "default") == 0) {
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		game_view_set_default_theme (self, &key);
#line 3536 "game-view.c"
	} else {
		{
			gchar* key_path = NULL;
			gchar* _tmp2_ = NULL;
			gchar* filepath = NULL;
			const gchar* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
			GKeyFile* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp2_ = g_build_filename (DATA_DIRECTORY, "themes", "key", NULL);
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			key_path = _tmp2_;
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp3_ = key_path;
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp4_ = value;
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp5_ = g_build_filename (_tmp3_, _tmp4_, NULL);
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			filepath = _tmp5_;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp6_ = filepath;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp7_ = g_path_get_dirname (_tmp6_);
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp8_ = _tmp7_;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp9_ = key_path;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp10_ = g_strcmp0 (_tmp8_, _tmp9_) != 0;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp8_);
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_tmp10_) {
#line 3578 "game-view.c"
				GError* _tmp11_ = NULL;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp11_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, "Theme file is not in the \"key\" directory.");
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_inner_error_ = _tmp11_;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_g_free0 (filepath);
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_g_free0 (key_path);
#line 3588 "game-view.c"
				goto __catch4_g_error;
			}
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp12_ = key;
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp13_ = filepath;
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_key_file_load_from_file (_tmp12_, _tmp13_, G_KEY_FILE_NONE, &_inner_error_);
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_g_free0 (filepath);
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_g_free0 (key_path);
#line 3603 "game-view.c"
				goto __catch4_g_error;
			}
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (filepath);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (key_path);
#line 3610 "game-view.c"
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			GError* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			e = _inner_error_;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_inner_error_ = NULL;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp14_ = e;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp15_ = _tmp14_->message;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_warning ("game-view.vala:129: Failed to load theme: %s", _tmp15_);
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			game_view_set_default_theme (self, &key);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			value = "default";
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_error_free0 (e);
#line 3634 "game-view.c"
		}
		__finally4:
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_key_file_unref0 (key);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 3647 "game-view.c"
		}
	}
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp16_ = key;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	game_view_load_theme (self, _tmp16_);
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp17_ = value;
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp18_ = g_strdup (_tmp17_);
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (self->priv->_theme);
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->_theme = _tmp18_;
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->tiles_pattern = NULL;
#line 140 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp19_ = game_view_get_scoreboard (self);
#line 140 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp20_ = _tmp19_;
#line 140 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp20_);
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 113 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_key_file_unref0 (key);
#line 113 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_notify ((GObject *) self, "theme");
#line 3678 "game-view.c"
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (n_param_values == 3);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		data1 = closure->data;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		data2 = param_values->data[0].v_pointer;
#line 3697 "game-view.c"
	} else {
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		data1 = param_values->data[0].v_pointer;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		data2 = closure->data;
#line 3703 "game-view.c"
	}
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
#line 3709 "game-view.c"
}


static void game_view_class_init (GameViewClass * klass) {
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	game_view_parent_class = g_type_class_peek_parent (klass);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	((GtkWidgetClass *) klass)->draw = game_view_real_draw;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	((GtkWidgetClass *) klass)->button_press_event = game_view_real_button_press_event;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_SCOREBOARD, g_param_spec_object ("scoreboard", "scoreboard", "scoreboard", gtk_drawing_area_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_SOUND_FLIP, g_param_spec_string ("sound-flip", "sound-flip", "sound-flip", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_SOUND_GAMEOVER, g_param_spec_string ("sound-gameover", "sound-gameover", "sound-gameover", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME, g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_THEME, g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_signal_new ("move", TYPE_GAME_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
#line 3740 "game-view.c"
}


static void game_view_instance_init (GameView * self) {
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv = GAME_VIEW_GET_PRIVATE (self);
#line 36 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->background_red = 0.2;
#line 37 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->background_green = 0.6;
#line 38 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->background_blue = 0.4;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->mark_red = 0.2;
#line 41 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->mark_green = 0.6;
#line 42 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->mark_blue = 0.4;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->mark_width = 2;
#line 45 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->border_red = 0.1;
#line 46 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->border_green = 0.1;
#line 47 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->border_blue = 0.1;
#line 48 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->border_width = 3;
#line 50 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->spacing_red = 0.1;
#line 51 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->spacing_green = 0.3;
#line 52 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->spacing_blue = 0.2;
#line 53 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->spacing_width = 2;
#line 70 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->render_size = (guint) 0;
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->tiles_pattern = NULL;
#line 72 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->scoreboard_tiles_pattern = NULL;
#line 78 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->animate_timeout = (guint) 0;
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->current_player_number = 0;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->flip_final_result_now = FALSE;
#line 88 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->_game = NULL;
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->_theme = NULL;
#line 3793 "game-view.c"
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_object_unref0 (self->priv->_scoreboard);
#line 34 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (self->priv->pieces_file);
#line 57 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (self->priv->_sound_flip);
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (self->priv->_sound_gameover);
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
#line 72 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_cairo_pattern_destroy0 (self->priv->scoreboard_tiles_pattern);
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->pixmaps = (g_free (self->priv->pixmaps), NULL);
#line 88 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (self->priv->_theme);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
#line 3821 "game-view.c"
}


GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}


static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	switch (property_id) {
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case GAME_VIEW_SCOREBOARD:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_value_set_object (value, game_view_get_scoreboard (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case GAME_VIEW_SOUND_FLIP:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_value_set_string (value, game_view_get_sound_flip (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case GAME_VIEW_SOUND_GAMEOVER:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_value_set_string (value, game_view_get_sound_gameover (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case GAME_VIEW_GAME:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_value_set_object (value, game_view_get_game (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case GAME_VIEW_THEME:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_value_set_string (value, game_view_get_theme (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 3872 "game-view.c"
		default:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 3878 "game-view.c"
	}
}


static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	switch (property_id) {
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case GAME_VIEW_SCOREBOARD:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		game_view_set_scoreboard (self, g_value_get_object (value));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case GAME_VIEW_SOUND_FLIP:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		game_view_set_sound_flip (self, g_value_get_string (value));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case GAME_VIEW_SOUND_GAMEOVER:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		game_view_set_sound_gameover (self, g_value_get_string (value));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case GAME_VIEW_GAME:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		game_view_set_game (self, g_value_get_object (value));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case GAME_VIEW_THEME:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		game_view_set_theme (self, g_value_get_string (value));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 3918 "game-view.c"
		default:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 3924 "game-view.c"
	}
}



