/* game.c generated by valac 0.30.0, the Vala compiler
 * generated from game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This file is part of Iagno.
 *
 * Iagno is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Iagno is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Iagno. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;

#define TYPE_PLAYER (player_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
};

struct _GameClass {
	GObjectClass parent_class;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

struct _GamePrivate {
	Player* tiles;
	gint tiles_length1;
	gint tiles_length2;
	gint _size;
	gint** undo_stack;
	gint undo_stack_length1;
	gint _undo_stack_size_;
	gint history_index;
	Player _current_color;
	gint _number_of_moves;
	gboolean _current_player_can_move;
	gboolean _is_complete;
	gint _initial_number_of_tiles;
	gint _n_light_tiles;
	gint _n_dark_tiles;
};


static gpointer game_parent_class = NULL;

GType game_get_type (void) G_GNUC_CONST;
GType player_get_type (void) G_GNUC_CONST;
#define GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME, GamePrivate))
enum  {
	GAME_DUMMY_PROPERTY,
	GAME_SIZE,
	GAME_CURRENT_COLOR,
	GAME_NUMBER_OF_MOVES,
	GAME_CURRENT_PLAYER_CAN_MOVE,
	GAME_IS_COMPLETE,
	GAME_INITIAL_NUMBER_OF_TILES,
	GAME_N_TILES,
	GAME_N_LIGHT_TILES,
	GAME_N_DARK_TILES,
	GAME_N_CURRENT_TILES,
	GAME_N_OPPONENT_TILES
};
Game* game_new (gboolean alternative_start, gint tmp_size);
Game* game_construct (GType object_type, gboolean alternative_start, gint tmp_size);
static void game_set_size (Game* self, gint value);
gint game_get_size (Game* self);
static void game_set_initial_number_of_tiles (Game* self, gint value);
static void game_set_n_current_tiles (Game* self, gint value);
static void game_set_n_opponent_tiles (Game* self, gint value);
Game* game_new_from_strings (gchar** setup, int setup_length1, Player to_move, gint tmp_size);
Game* game_construct_from_strings (GType object_type, gchar** setup, int setup_length1, Player to_move, gint tmp_size);
Player player_from_char (gchar c);
static void game_set_current_color (Game* self, Player value);
gchar* game_to_string (Game* self);
gchar* player_to_string (Player self);
Game* game_new_copy (Game* game);
Game* game_construct_copy (GType object_type, Game* game);
gint game_get_number_of_moves (Game* self);
static void game_set_number_of_moves (Game* self, gint value);
Player game_get_current_color (Game* self);
gint game_get_n_current_tiles (Game* self);
gint game_get_n_opponent_tiles (Game* self);
gboolean game_is_valid_location (Game* self, gint x, gint y);
Player game_get_owner (Game* self, gint x, gint y);
gboolean game_can_place (Game* self, gint x, gint y, Player color);
static gint game_can_flip_tiles (Game* self, gint x, gint y, gint x_step, gint y_step, Player color);
gint game_place_tile (Game* self, gint x, gint y, gboolean apply);
static gint game_flip_tiles (Game* self, gint x, gint y, gint x_step, gint y_step, gboolean apply);
static void game_set_tile (Game* self, gint x, gint y);
static void game_end_of_turn (Game* self);
void game_pass (Game* self);
gboolean game_get_current_player_can_move (Game* self);
Player player_flip_color (Player p);
static void game_update_who_can_move (Game* self);
static void game_set_current_player_can_move (Game* self, gboolean value);
static void game_set_is_complete (Game* self, gboolean value);
static gint* _int_dup (gint* self);
void game_undo (Game* self, gint count);
static void game_unset_tile (Game* self, gint tile_number, Player replacement_color);
gboolean game_get_is_complete (Game* self);
gint game_get_initial_number_of_tiles (Game* self);
gint game_get_n_tiles (Game* self);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
static void g_cclosure_user_marshal_VOID__INT_INT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void game_finalize (GObject* obj);
static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


Game* game_construct (GType object_type, gboolean alternative_start, gint tmp_size) {
	Game * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Player* _tmp6_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint** _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
#line 99 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = tmp_size;
#line 99 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_vala_return_val_if_fail (_tmp0_ >= 4, "tmp_size >= 4", NULL);
#line 99 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self = (Game*) g_object_new (object_type, NULL);
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp1_ = tmp_size;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	game_set_size (self, _tmp1_);
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp2_ = game_get_size (self);
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp3_ = _tmp2_;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp4_ = game_get_size (self);
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp5_ = _tmp4_;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp6_ = g_new0 (Player, _tmp3_ * _tmp5_);
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->tiles = (g_free (self->priv->tiles), NULL);
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->tiles = _tmp6_;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->tiles_length1 = _tmp3_;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->tiles_length2 = _tmp5_;
#line 194 "game.c"
	{
		gint x = 0;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		x = 0;
#line 199 "game.c"
		{
			gboolean _tmp7_ = FALSE;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp7_ = TRUE;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			while (TRUE) {
#line 206 "game.c"
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				if (!_tmp7_) {
#line 212 "game.c"
					gint _tmp8_ = 0;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp8_ = x;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					x = _tmp8_ + 1;
#line 218 "game.c"
				}
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp7_ = FALSE;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp9_ = x;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp10_ = game_get_size (self);
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp11_ = _tmp10_;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				if (!(_tmp9_ < _tmp11_)) {
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					break;
#line 232 "game.c"
				}
				{
					gint y = 0;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					y = 0;
#line 238 "game.c"
					{
						gboolean _tmp12_ = FALSE;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
						_tmp12_ = TRUE;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
						while (TRUE) {
#line 245 "game.c"
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							Player* _tmp17_ = NULL;
							gint _tmp17__length1 = 0;
							gint _tmp17__length2 = 0;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							Player _tmp20_ = 0;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							if (!_tmp12_) {
#line 257 "game.c"
								gint _tmp13_ = 0;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
								_tmp13_ = y;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
								y = _tmp13_ + 1;
#line 263 "game.c"
							}
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp12_ = FALSE;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp14_ = y;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp15_ = game_get_size (self);
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp16_ = _tmp15_;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							if (!(_tmp14_ < _tmp16_)) {
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
								break;
#line 277 "game.c"
							}
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp17_ = self->priv->tiles;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp17__length1 = self->priv->tiles_length1;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp17__length2 = self->priv->tiles_length2;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp18_ = x;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp19_ = y;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_] = PLAYER_NONE;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp20_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
#line 293 "game.c"
						}
					}
				}
			}
		}
	}
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp21_ = game_get_size (self);
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp22_ = _tmp21_;
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp23_ = g_new0 (gint*, 180 * (_tmp22_ - 1));
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->undo_stack = (_vala_array_free (self->priv->undo_stack, self->priv->undo_stack_length1, (GDestroyNotify) g_free), NULL);
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->undo_stack = _tmp23_;
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->undo_stack_length1 = 180 * (_tmp22_ - 1);
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->_undo_stack_size_ = self->priv->undo_stack_length1;
#line 113 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp24_ = game_get_size (self);
#line 113 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp25_ = _tmp24_;
#line 113 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if ((_tmp25_ % 2) == 0) {
#line 320 "game.c"
		Player _tmp26_ = 0;
		gboolean _tmp27_ = FALSE;
		Player* _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		gint _tmp28__length2 = 0;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		Player _tmp33_ = 0;
		Player* _tmp34_ = NULL;
		gint _tmp34__length1 = 0;
		gint _tmp34__length2 = 0;
		gint _tmp35_ = 0;
		gint _tmp36_ = 0;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		Player _tmp39_ = 0;
		Player _tmp40_ = 0;
		gboolean _tmp41_ = FALSE;
		Player* _tmp42_ = NULL;
		gint _tmp42__length1 = 0;
		gint _tmp42__length2 = 0;
		gint _tmp43_ = 0;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
		gint _tmp46_ = 0;
		Player _tmp47_ = 0;
		Player* _tmp48_ = NULL;
		gint _tmp48__length1 = 0;
		gint _tmp48__length2 = 0;
		gint _tmp49_ = 0;
		gint _tmp50_ = 0;
		gint _tmp51_ = 0;
		gint _tmp52_ = 0;
		Player _tmp53_ = 0;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_set_initial_number_of_tiles (self, 4);
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp27_ = alternative_start;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		if (_tmp27_) {
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp26_ = PLAYER_DARK;
#line 365 "game.c"
		} else {
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp26_ = PLAYER_LIGHT;
#line 369 "game.c"
		}
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp28_ = self->priv->tiles;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp28__length1 = self->priv->tiles_length1;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp28__length2 = self->priv->tiles_length2;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp29_ = game_get_size (self);
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp30_ = _tmp29_;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp31_ = game_get_size (self);
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp32_ = _tmp31_;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp28_[(((_tmp30_ / 2) - 1) * _tmp28__length2) + ((_tmp32_ / 2) - 1)] = _tmp26_;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp33_ = _tmp28_[(((_tmp30_ / 2) - 1) * _tmp28__length2) + ((_tmp32_ / 2) - 1)];
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp34_ = self->priv->tiles;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp34__length1 = self->priv->tiles_length1;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp34__length2 = self->priv->tiles_length2;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp35_ = game_get_size (self);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp36_ = _tmp35_;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp37_ = game_get_size (self);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp38_ = _tmp37_;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp34_[(((_tmp36_ / 2) - 1) * _tmp34__length2) + (_tmp38_ / 2)] = PLAYER_DARK;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp39_ = _tmp34_[(((_tmp36_ / 2) - 1) * _tmp34__length2) + (_tmp38_ / 2)];
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp41_ = alternative_start;
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		if (_tmp41_) {
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp40_ = PLAYER_LIGHT;
#line 413 "game.c"
		} else {
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp40_ = PLAYER_DARK;
#line 417 "game.c"
		}
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp42_ = self->priv->tiles;
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp42__length1 = self->priv->tiles_length1;
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp42__length2 = self->priv->tiles_length2;
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp43_ = game_get_size (self);
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp44_ = _tmp43_;
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp45_ = game_get_size (self);
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp46_ = _tmp45_;
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp42_[((_tmp44_ / 2) * _tmp42__length2) + ((_tmp46_ / 2) - 1)] = _tmp40_;
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp47_ = _tmp42_[((_tmp44_ / 2) * _tmp42__length2) + ((_tmp46_ / 2) - 1)];
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp48_ = self->priv->tiles;
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp48__length1 = self->priv->tiles_length1;
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp48__length2 = self->priv->tiles_length2;
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp49_ = game_get_size (self);
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp50_ = _tmp49_;
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp51_ = game_get_size (self);
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp52_ = _tmp51_;
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp48_[((_tmp50_ / 2) * _tmp48__length2) + (_tmp52_ / 2)] = PLAYER_LIGHT;
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp53_ = _tmp48_[((_tmp50_ / 2) * _tmp48__length2) + (_tmp52_ / 2)];
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_set_n_current_tiles (self, 2);
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_set_n_opponent_tiles (self, 2);
#line 459 "game.c"
	} else {
		Player* _tmp54_ = NULL;
		gint _tmp54__length1 = 0;
		gint _tmp54__length2 = 0;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
		gint _tmp58_ = 0;
		Player _tmp59_ = 0;
		Player _tmp60_ = 0;
		gboolean _tmp61_ = FALSE;
		Player* _tmp62_ = NULL;
		gint _tmp62__length1 = 0;
		gint _tmp62__length2 = 0;
		gint _tmp63_ = 0;
		gint _tmp64_ = 0;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		Player _tmp67_ = 0;
		Player _tmp68_ = 0;
		gboolean _tmp69_ = FALSE;
		Player* _tmp70_ = NULL;
		gint _tmp70__length1 = 0;
		gint _tmp70__length2 = 0;
		gint _tmp71_ = 0;
		gint _tmp72_ = 0;
		gint _tmp73_ = 0;
		gint _tmp74_ = 0;
		Player _tmp75_ = 0;
		Player* _tmp76_ = NULL;
		gint _tmp76__length1 = 0;
		gint _tmp76__length2 = 0;
		gint _tmp77_ = 0;
		gint _tmp78_ = 0;
		gint _tmp79_ = 0;
		gint _tmp80_ = 0;
		Player _tmp81_ = 0;
		Player _tmp82_ = 0;
		gboolean _tmp83_ = FALSE;
		Player* _tmp84_ = NULL;
		gint _tmp84__length1 = 0;
		gint _tmp84__length2 = 0;
		gint _tmp85_ = 0;
		gint _tmp86_ = 0;
		gint _tmp87_ = 0;
		gint _tmp88_ = 0;
		Player _tmp89_ = 0;
		Player _tmp90_ = 0;
		gboolean _tmp91_ = FALSE;
		Player* _tmp92_ = NULL;
		gint _tmp92__length1 = 0;
		gint _tmp92__length2 = 0;
		gint _tmp93_ = 0;
		gint _tmp94_ = 0;
		gint _tmp95_ = 0;
		gint _tmp96_ = 0;
		Player _tmp97_ = 0;
		Player* _tmp98_ = NULL;
		gint _tmp98__length1 = 0;
		gint _tmp98__length2 = 0;
		gint _tmp99_ = 0;
		gint _tmp100_ = 0;
		gint _tmp101_ = 0;
		gint _tmp102_ = 0;
		Player _tmp103_ = 0;
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_set_initial_number_of_tiles (self, 7);
#line 128 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp54_ = self->priv->tiles;
#line 128 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp54__length1 = self->priv->tiles_length1;
#line 128 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp54__length2 = self->priv->tiles_length2;
#line 128 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp55_ = game_get_size (self);
#line 128 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp56_ = _tmp55_;
#line 128 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp57_ = game_get_size (self);
#line 128 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp58_ = _tmp57_;
#line 128 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp54_[(((_tmp56_ - 1) / 2) * _tmp54__length2) + ((_tmp58_ - 1) / 2)] = PLAYER_DARK;
#line 128 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp59_ = _tmp54_[(((_tmp56_ - 1) / 2) * _tmp54__length2) + ((_tmp58_ - 1) / 2)];
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp61_ = alternative_start;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		if (_tmp61_) {
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp60_ = PLAYER_LIGHT;
#line 551 "game.c"
		} else {
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp60_ = PLAYER_DARK;
#line 555 "game.c"
		}
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp62_ = self->priv->tiles;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp62__length1 = self->priv->tiles_length1;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp62__length2 = self->priv->tiles_length2;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp63_ = game_get_size (self);
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp64_ = _tmp63_;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp65_ = game_get_size (self);
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp66_ = _tmp65_;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp62_[(((_tmp64_ + 1) / 2) * _tmp62__length2) + ((_tmp66_ - 3) / 2)] = _tmp60_;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp67_ = _tmp62_[(((_tmp64_ + 1) / 2) * _tmp62__length2) + ((_tmp66_ - 3) / 2)];
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp69_ = alternative_start;
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		if (_tmp69_) {
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp68_ = PLAYER_LIGHT;
#line 581 "game.c"
		} else {
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp68_ = PLAYER_DARK;
#line 585 "game.c"
		}
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp70_ = self->priv->tiles;
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp70__length1 = self->priv->tiles_length1;
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp70__length2 = self->priv->tiles_length2;
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp71_ = game_get_size (self);
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp72_ = _tmp71_;
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp73_ = game_get_size (self);
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp74_ = _tmp73_;
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp70_[(((_tmp72_ - 3) / 2) * _tmp70__length2) + ((_tmp74_ + 1) / 2)] = _tmp68_;
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp75_ = _tmp70_[(((_tmp72_ - 3) / 2) * _tmp70__length2) + ((_tmp74_ + 1) / 2)];
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp76_ = self->priv->tiles;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp76__length1 = self->priv->tiles_length1;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp76__length2 = self->priv->tiles_length2;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp77_ = game_get_size (self);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp78_ = _tmp77_;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp79_ = game_get_size (self);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp80_ = _tmp79_;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp76_[(((_tmp78_ - 1) / 2) * _tmp76__length2) + ((_tmp80_ - 3) / 2)] = PLAYER_LIGHT;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp81_ = _tmp76_[(((_tmp78_ - 1) / 2) * _tmp76__length2) + ((_tmp80_ - 3) / 2)];
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp83_ = alternative_start;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		if (_tmp83_) {
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp82_ = PLAYER_DARK;
#line 629 "game.c"
		} else {
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp82_ = PLAYER_LIGHT;
#line 633 "game.c"
		}
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp84_ = self->priv->tiles;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp84__length1 = self->priv->tiles_length1;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp84__length2 = self->priv->tiles_length2;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp85_ = game_get_size (self);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp86_ = _tmp85_;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp87_ = game_get_size (self);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp88_ = _tmp87_;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp84_[(((_tmp86_ - 3) / 2) * _tmp84__length2) + ((_tmp88_ - 1) / 2)] = _tmp82_;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp89_ = _tmp84_[(((_tmp86_ - 3) / 2) * _tmp84__length2) + ((_tmp88_ - 1) / 2)];
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp91_ = alternative_start;
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		if (_tmp91_) {
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp90_ = PLAYER_DARK;
#line 659 "game.c"
		} else {
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp90_ = PLAYER_LIGHT;
#line 663 "game.c"
		}
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp92_ = self->priv->tiles;
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp92__length1 = self->priv->tiles_length1;
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp92__length2 = self->priv->tiles_length2;
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp93_ = game_get_size (self);
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp94_ = _tmp93_;
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp95_ = game_get_size (self);
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp96_ = _tmp95_;
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp92_[(((_tmp94_ + 1) / 2) * _tmp92__length2) + ((_tmp96_ - 1) / 2)] = _tmp90_;
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp97_ = _tmp92_[(((_tmp94_ + 1) / 2) * _tmp92__length2) + ((_tmp96_ - 1) / 2)];
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp98_ = self->priv->tiles;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp98__length1 = self->priv->tiles_length1;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp98__length2 = self->priv->tiles_length2;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp99_ = game_get_size (self);
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp100_ = _tmp99_;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp101_ = game_get_size (self);
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp102_ = _tmp101_;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp98_[(((_tmp100_ - 1) / 2) * _tmp98__length2) + ((_tmp102_ + 1) / 2)] = PLAYER_LIGHT;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp103_ = _tmp98_[(((_tmp100_ - 1) / 2) * _tmp98__length2) + ((_tmp102_ + 1) / 2)];
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_set_n_current_tiles (self, 3);
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_set_n_opponent_tiles (self, 4);
#line 705 "game.c"
	}
#line 99 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return self;
#line 709 "game.c"
}


Game* game_new (gboolean alternative_start, gint tmp_size) {
#line 99 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return game_construct (TYPE_GAME, alternative_start, tmp_size);
#line 716 "game.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 734 "game.c"
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 964 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = separator;
#line 964 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp0_ == NULL) {
#line 965 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		separator = "";
#line 751 "game.c"
	}
#line 967 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3_ = str_array;
#line 967 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3__length1 = str_array_length1;
#line 967 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 967 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp2_ = TRUE;
#line 761 "game.c"
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 967 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = str_array;
#line 967 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4__length1 = str_array_length1;
#line 967 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp4__length1 > 0;
#line 771 "game.c"
	}
#line 967 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp2_) {
#line 967 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 777 "game.c"
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
#line 967 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6_ = str_array;
#line 967 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6__length1 = str_array_length1;
#line 967 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		if (_tmp6__length1 == -1) {
#line 788 "game.c"
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
#line 967 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp7_ = str_array;
#line 967 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp7__length1 = str_array_length1;
#line 967 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp8_ = _tmp7_[0];
#line 967 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp5_ = _tmp8_ != NULL;
#line 800 "game.c"
		} else {
#line 967 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp5_ = FALSE;
#line 804 "game.c"
		}
#line 967 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp1_ = _tmp5_;
#line 808 "game.c"
	}
#line 967 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 812 "game.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
#line 969 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		len = (gsize) 1;
#line 835 "game.c"
		{
			gboolean _tmp9_ = FALSE;
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
			i = 0;
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp9_ = TRUE;
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 844 "game.c"
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				if (!_tmp9_) {
#line 857 "game.c"
					gint _tmp10_ = 0;
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp10_ = i;
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					i = _tmp10_ + 1;
#line 863 "game.c"
				}
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp9_ = FALSE;
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp13_ = str_array;
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp13__length1 = str_array_length1;
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				if (_tmp13__length1 != -1) {
#line 873 "game.c"
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp14_ = i;
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp15_ = str_array;
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp15__length1 = str_array_length1;
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp12_ = _tmp14_ < _tmp15__length1;
#line 885 "game.c"
				} else {
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp12_ = FALSE;
#line 889 "game.c"
				}
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				if (_tmp12_) {
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp11_ = TRUE;
#line 895 "game.c"
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp17_ = str_array;
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp17__length1 = str_array_length1;
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					if (_tmp17__length1 == -1) {
#line 906 "game.c"
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
						_tmp18_ = str_array;
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
						_tmp18__length1 = str_array_length1;
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
						_tmp19_ = i;
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
						_tmp20_ = _tmp18_[_tmp19_];
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
						_tmp16_ = _tmp20_ != NULL;
#line 921 "game.c"
					} else {
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
						_tmp16_ = FALSE;
#line 925 "game.c"
					}
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp11_ = _tmp16_;
#line 929 "game.c"
				}
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				if (!_tmp11_) {
#line 970 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					break;
#line 935 "game.c"
				}
#line 971 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp22_ = str_array;
#line 971 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp22__length1 = str_array_length1;
#line 971 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp23_ = i;
#line 971 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp24_ = _tmp22_[_tmp23_];
#line 971 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				if (_tmp24_ != NULL) {
#line 947 "game.c"
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
#line 971 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp25_ = str_array;
#line 971 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp25__length1 = str_array_length1;
#line 971 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp26_ = i;
#line 971 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp27_ = _tmp25_[_tmp26_];
#line 971 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp28_ = strlen ((const gchar*) _tmp27_);
#line 971 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp29_ = _tmp28_;
#line 971 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp21_ = _tmp29_;
#line 968 "game.c"
				} else {
#line 971 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp21_ = 0;
#line 972 "game.c"
				}
#line 971 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp30_ = len;
#line 971 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				len = _tmp30_ + _tmp21_;
#line 978 "game.c"
			}
		}
#line 973 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp31_ = i;
#line 973 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		if (_tmp31_ == 0) {
#line 985 "game.c"
			gchar* _tmp32_ = NULL;
#line 974 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp32_ = g_strdup ("");
#line 974 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
			result = _tmp32_;
#line 974 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
			return result;
#line 993 "game.c"
		}
#line 976 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp33_ = i;
#line 976 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		str_array_length1 = _tmp33_;
#line 976 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp34_ = str_array_length1;
#line 977 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp35_ = len;
#line 977 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp36_ = separator;
#line 977 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp37_ = strlen ((const gchar*) _tmp36_);
#line 977 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp38_ = _tmp37_;
#line 977 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp39_ = i;
#line 977 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
#line 979 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp40_ = len;
#line 979 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp41_ = g_malloc (_tmp40_);
#line 979 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		res = _tmp41_;
#line 980 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp42_ = res;
#line 980 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp43_ = str_array;
#line 980 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp43__length1 = str_array_length1;
#line 980 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp44_ = _tmp43_[0];
#line 980 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
#line 980 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		ptr = _tmp45_;
#line 1031 "game.c"
		{
			gboolean _tmp46_ = FALSE;
#line 981 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
			i = 1;
#line 981 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp46_ = TRUE;
#line 981 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 1040 "game.c"
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
#line 981 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				if (!_tmp46_) {
#line 1056 "game.c"
					gint _tmp47_ = 0;
#line 981 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp47_ = i;
#line 981 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					i = _tmp47_ + 1;
#line 1062 "game.c"
				}
#line 981 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp46_ = FALSE;
#line 981 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp48_ = i;
#line 981 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp49_ = str_array;
#line 981 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp49__length1 = str_array_length1;
#line 981 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				if (!(_tmp48_ < _tmp49__length1)) {
#line 981 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					break;
#line 1076 "game.c"
				}
#line 982 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp50_ = ptr;
#line 982 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp51_ = separator;
#line 982 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
#line 982 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				ptr = _tmp52_;
#line 983 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp54_ = str_array;
#line 983 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp54__length1 = str_array_length1;
#line 983 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp55_ = i;
#line 983 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp56_ = _tmp54_[_tmp55_];
#line 983 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				if (_tmp56_ != NULL) {
#line 1096 "game.c"
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
#line 983 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp57_ = str_array;
#line 983 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp57__length1 = str_array_length1;
#line 983 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp58_ = i;
#line 983 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp59_ = _tmp57_[_tmp58_];
#line 983 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp53_ = (const gchar*) _tmp59_;
#line 1111 "game.c"
				} else {
#line 983 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp53_ = "";
#line 1115 "game.c"
				}
#line 983 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp60_ = ptr;
#line 983 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
#line 983 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
				ptr = _tmp61_;
#line 1123 "game.c"
			}
		}
#line 986 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp62_ = res;
#line 986 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		res = NULL;
#line 986 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		result = (gchar*) _tmp62_;
#line 986 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 1134 "game.c"
	} else {
		gchar* _tmp63_ = NULL;
#line 988 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp63_ = g_strdup ("");
#line 988 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		result = _tmp63_;
#line 988 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 1143 "game.c"
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1115 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1116 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1116 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1117 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1117 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1118 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _result_;
#line 1118 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 1167 "game.c"
}


Game* game_construct_from_strings (GType object_type, gchar** setup, int setup_length1, Player to_move, gint tmp_size) {
	Game * self = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	Player* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint** _tmp10_ = NULL;
	Player _tmp38_ = 0;
	gchar** _tmp39_ = NULL;
	gint _tmp39__length1 = 0;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
#line 140 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = setup;
#line 140 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0__length1 = setup_length1;
#line 140 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp1_ = tmp_size;
#line 140 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_vala_return_val_if_fail (_tmp0__length1 == _tmp1_, "setup.length == tmp_size", NULL);
#line 140 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self = (Game*) g_object_new (object_type, NULL);
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp2_ = tmp_size;
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	game_set_size (self, _tmp2_);
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp3_ = game_get_size (self);
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp4_ = _tmp3_;
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp5_ = game_get_size (self);
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp6_ = _tmp5_;
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp7_ = g_new0 (Player, _tmp4_ * _tmp6_);
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->tiles = (g_free (self->priv->tiles), NULL);
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->tiles = _tmp7_;
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->tiles_length1 = _tmp4_;
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->tiles_length2 = _tmp6_;
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp8_ = game_get_size (self);
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp9_ = _tmp8_;
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp10_ = g_new0 (gint*, 180 * (_tmp9_ - 1));
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->undo_stack = (_vala_array_free (self->priv->undo_stack, self->priv->undo_stack_length1, (GDestroyNotify) g_free), NULL);
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->undo_stack = _tmp10_;
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->undo_stack_length1 = 180 * (_tmp9_ - 1);
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->_undo_stack_size_ = self->priv->undo_stack_length1;
#line 1242 "game.c"
	{
		gint y = 0;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		y = 0;
#line 1247 "game.c"
		{
			gboolean _tmp11_ = FALSE;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp11_ = TRUE;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			while (TRUE) {
#line 1254 "game.c"
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gchar** _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				gint _tmp17_ = 0;
				const gchar* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				if (!_tmp11_) {
#line 1268 "game.c"
					gint _tmp12_ = 0;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp12_ = y;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					y = _tmp12_ + 1;
#line 1274 "game.c"
				}
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp11_ = FALSE;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp13_ = y;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp14_ = game_get_size (self);
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp15_ = _tmp14_;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				if (!(_tmp13_ < _tmp15_)) {
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					break;
#line 1288 "game.c"
				}
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp16_ = setup;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp16__length1 = setup_length1;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp17_ = y;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp18_ = _tmp16_[_tmp17_];
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp19_ = strlen (_tmp18_);
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp20_ = _tmp19_;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp21_ = game_get_size (self);
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp22_ = _tmp21_;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				if (_tmp20_ != (_tmp22_ * 2)) {
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					g_warn_if_reached ();
#line 1310 "game.c"
				}
				{
					gint x = 0;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					x = 0;
#line 1316 "game.c"
					{
						gboolean _tmp23_ = FALSE;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
						_tmp23_ = TRUE;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
						while (TRUE) {
#line 1323 "game.c"
							gint _tmp25_ = 0;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							Player* _tmp28_ = NULL;
							gint _tmp28__length1 = 0;
							gint _tmp28__length2 = 0;
							gint _tmp29_ = 0;
							gint _tmp30_ = 0;
							gchar** _tmp31_ = NULL;
							gint _tmp31__length1 = 0;
							gint _tmp32_ = 0;
							const gchar* _tmp33_ = NULL;
							gint _tmp34_ = 0;
							gchar _tmp35_ = '\0';
							Player _tmp36_ = 0;
							Player _tmp37_ = 0;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							if (!_tmp23_) {
#line 1342 "game.c"
								gint _tmp24_ = 0;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
								_tmp24_ = x;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
								x = _tmp24_ + 1;
#line 1348 "game.c"
							}
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp23_ = FALSE;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp25_ = x;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp26_ = game_get_size (self);
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp27_ = _tmp26_;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							if (!(_tmp25_ < _tmp27_)) {
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
								break;
#line 1362 "game.c"
							}
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp28_ = self->priv->tiles;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp28__length1 = self->priv->tiles_length1;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp28__length2 = self->priv->tiles_length2;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp29_ = x;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp30_ = y;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp31_ = setup;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp31__length1 = setup_length1;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp32_ = y;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp33_ = _tmp31_[_tmp32_];
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp34_ = x;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp35_ = string_get (_tmp33_, (glong) ((_tmp34_ * 2) + 1));
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp36_ = player_from_char (_tmp35_);
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp28_[(_tmp29_ * _tmp28__length2) + _tmp30_] = _tmp36_;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp37_ = _tmp28_[(_tmp29_ * _tmp28__length2) + _tmp30_];
#line 1392 "game.c"
						}
					}
				}
			}
		}
	}
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp38_ = to_move;
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	game_set_current_color (self, _tmp38_);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp39_ = setup;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp39__length1 = setup_length1;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp40_ = _vala_g_strjoinv ("\n", _tmp39_, _tmp39__length1);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp41_ = _tmp40_;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp42_ = string_strip (_tmp41_);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp43_ = _tmp42_;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp44_ = game_to_string (self);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp45_ = _tmp44_;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp46_ = string_strip (_tmp45_);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp47_ = _tmp46_;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_warn_if_fail (g_strcmp0 (_tmp43_, _tmp47_) == 0);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_g_free0 (_tmp47_);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_g_free0 (_tmp45_);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_g_free0 (_tmp43_);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_g_free0 (_tmp41_);
#line 140 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return self;
#line 1435 "game.c"
}


Game* game_new_from_strings (gchar** setup, int setup_length1, Player to_move, gint tmp_size) {
#line 140 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return game_construct_from_strings (TYPE_GAME, setup, setup_length1, to_move, tmp_size);
#line 1442 "game.c"
}


gchar* game_to_string (Game* self) {
	gchar* result = NULL;
	gchar* s = NULL;
	gchar* _tmp0_ = NULL;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = g_strdup ("\n");
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	s = _tmp0_;
#line 1456 "game.c"
	{
		gint y = 0;
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		y = 0;
#line 1461 "game.c"
		{
			gboolean _tmp1_ = FALSE;
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp1_ = TRUE;
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			while (TRUE) {
#line 1468 "game.c"
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				if (!_tmp1_) {
#line 1476 "game.c"
					gint _tmp2_ = 0;
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp2_ = y;
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					y = _tmp2_ + 1;
#line 1482 "game.c"
				}
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp1_ = FALSE;
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp3_ = y;
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp4_ = game_get_size (self);
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp5_ = _tmp4_;
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				if (!(_tmp3_ < _tmp5_)) {
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					break;
#line 1496 "game.c"
				}
				{
					gint x = 0;
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					x = 0;
#line 1502 "game.c"
					{
						gboolean _tmp6_ = FALSE;
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
						_tmp6_ = TRUE;
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
						while (TRUE) {
#line 1509 "game.c"
							gint _tmp8_ = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							const gchar* _tmp11_ = NULL;
							Player* _tmp12_ = NULL;
							gint _tmp12__length1 = 0;
							gint _tmp12__length2 = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							Player _tmp15_ = 0;
							gchar* _tmp16_ = NULL;
							gchar* _tmp17_ = NULL;
							gchar* _tmp18_ = NULL;
							gchar* _tmp19_ = NULL;
							gchar* _tmp20_ = NULL;
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							if (!_tmp6_) {
#line 1527 "game.c"
								gint _tmp7_ = 0;
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
								_tmp7_ = x;
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
								x = _tmp7_ + 1;
#line 1533 "game.c"
							}
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp6_ = FALSE;
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp8_ = x;
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp9_ = game_get_size (self);
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp10_ = _tmp9_;
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							if (!(_tmp8_ < _tmp10_)) {
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
								break;
#line 1547 "game.c"
							}
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp11_ = s;
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp12_ = self->priv->tiles;
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp12__length1 = self->priv->tiles_length1;
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp12__length2 = self->priv->tiles_length2;
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp13_ = x;
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp14_ = y;
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp15_ = _tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_];
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp16_ = player_to_string (_tmp15_);
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp17_ = _tmp16_;
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp18_ = g_strconcat (" ", _tmp17_, NULL);
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp19_ = _tmp18_;
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp20_ = g_strconcat (_tmp11_, _tmp19_, NULL);
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_g_free0 (s);
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							s = _tmp20_;
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_g_free0 (_tmp19_);
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_g_free0 (_tmp17_);
#line 1581 "game.c"
						}
					}
				}
#line 168 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp21_ = s;
#line 168 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp22_ = g_strconcat (_tmp21_, "\n", NULL);
#line 168 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_g_free0 (s);
#line 168 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				s = _tmp22_;
#line 1593 "game.c"
			}
		}
	}
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	result = s;
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return result;
#line 1601 "game.c"
}


Game* game_construct_copy (GType object_type, Game* game) {
	Game * self = NULL;
	Game* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	Player* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint** _tmp10_ = NULL;
	Game* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	Game* _tmp32_ = NULL;
	Player _tmp33_ = 0;
	Game* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	Game* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self = (Game*) g_object_new (object_type, NULL);
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = game;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp1_ = game_get_size (_tmp0_);
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp2_ = _tmp1_;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	game_set_size (self, _tmp2_);
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp3_ = game_get_size (self);
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp4_ = _tmp3_;
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp5_ = game_get_size (self);
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp6_ = _tmp5_;
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp7_ = g_new0 (Player, _tmp4_ * _tmp6_);
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->tiles = (g_free (self->priv->tiles), NULL);
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->tiles = _tmp7_;
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->tiles_length1 = _tmp4_;
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->tiles_length2 = _tmp6_;
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp8_ = game_get_size (self);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp9_ = _tmp8_;
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp10_ = g_new0 (gint*, 180 * (_tmp9_ - 1));
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->undo_stack = (_vala_array_free (self->priv->undo_stack, self->priv->undo_stack_length1, (GDestroyNotify) g_free), NULL);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->undo_stack = _tmp10_;
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->undo_stack_length1 = 180 * (_tmp9_ - 1);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->_undo_stack_size_ = self->priv->undo_stack_length1;
#line 1672 "game.c"
	{
		gint x = 0;
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		x = 0;
#line 1677 "game.c"
		{
			gboolean _tmp11_ = FALSE;
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp11_ = TRUE;
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			while (TRUE) {
#line 1684 "game.c"
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				if (!_tmp11_) {
#line 1690 "game.c"
					gint _tmp12_ = 0;
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp12_ = x;
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					x = _tmp12_ + 1;
#line 1696 "game.c"
				}
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp11_ = FALSE;
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp13_ = x;
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp14_ = game_get_size (self);
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp15_ = _tmp14_;
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				if (!(_tmp13_ < _tmp15_)) {
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					break;
#line 1710 "game.c"
				}
				{
					gint y = 0;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					y = 0;
#line 1716 "game.c"
					{
						gboolean _tmp16_ = FALSE;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
						_tmp16_ = TRUE;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
						while (TRUE) {
#line 1723 "game.c"
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							Player* _tmp21_ = NULL;
							gint _tmp21__length1 = 0;
							gint _tmp21__length2 = 0;
							gint _tmp22_ = 0;
							gint _tmp23_ = 0;
							Game* _tmp24_ = NULL;
							Player* _tmp25_ = NULL;
							gint _tmp25__length1 = 0;
							gint _tmp25__length2 = 0;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							Player _tmp28_ = 0;
							Player _tmp29_ = 0;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							if (!_tmp16_) {
#line 1742 "game.c"
								gint _tmp17_ = 0;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
								_tmp17_ = y;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
								y = _tmp17_ + 1;
#line 1748 "game.c"
							}
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp16_ = FALSE;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp18_ = y;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp19_ = game_get_size (self);
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp20_ = _tmp19_;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							if (!(_tmp18_ < _tmp20_)) {
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
								break;
#line 1762 "game.c"
							}
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp21_ = self->priv->tiles;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp21__length1 = self->priv->tiles_length1;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp21__length2 = self->priv->tiles_length2;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp22_ = x;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp23_ = y;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp24_ = game;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp25_ = _tmp24_->priv->tiles;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp25__length1 = _tmp24_->priv->tiles_length1;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp25__length2 = _tmp24_->priv->tiles_length2;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp26_ = x;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp27_ = y;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_] = _tmp28_;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp29_ = _tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_];
#line 1792 "game.c"
						}
					}
				}
			}
		}
	}
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp30_ = game;
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp31_ = _tmp30_->priv->_number_of_moves;
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	game_set_number_of_moves (self, _tmp31_);
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp32_ = game;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp33_ = _tmp32_->priv->_current_color;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	game_set_current_color (self, _tmp33_);
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp34_ = game;
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp35_ = game_get_n_current_tiles (_tmp34_);
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp36_ = _tmp35_;
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	game_set_n_current_tiles (self, _tmp36_);
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp37_ = game;
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp38_ = game_get_n_opponent_tiles (_tmp37_);
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp39_ = _tmp38_;
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	game_set_n_opponent_tiles (self, _tmp39_);
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return self;
#line 1829 "game.c"
}


Game* game_new_copy (Game* game) {
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return game_construct_copy (TYPE_GAME, game);
#line 1836 "game.c"
}


gboolean game_is_valid_location (Game* self, gint x, gint y) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp3_ = x;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp3_ >= 0) {
#line 1852 "game.c"
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp4_ = x;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp5_ = game_get_size (self);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp6_ = _tmp5_;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp2_ = _tmp4_ < _tmp6_;
#line 1864 "game.c"
	} else {
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp2_ = FALSE;
#line 1868 "game.c"
	}
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp2_) {
#line 1872 "game.c"
		gint _tmp7_ = 0;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp7_ = y;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp1_ = _tmp7_ >= 0;
#line 1878 "game.c"
	} else {
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp1_ = FALSE;
#line 1882 "game.c"
	}
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp1_) {
#line 1886 "game.c"
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp8_ = y;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp9_ = game_get_size (self);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp10_ = _tmp9_;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp0_ = _tmp8_ < _tmp10_;
#line 1898 "game.c"
	} else {
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp0_ = FALSE;
#line 1902 "game.c"
	}
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	result = _tmp0_;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return result;
#line 1908 "game.c"
}


Player game_get_owner (Game* self, gint x, gint y) {
	Player result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	Player* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp3__length2 = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Player _tmp6_ = 0;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = x;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp1_ = y;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp2_ = game_is_valid_location (self, _tmp0_, _tmp1_);
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_vala_return_val_if_fail (_tmp2_, "is_valid_location (x, y)", 0);
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp3_ = self->priv->tiles;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp3__length1 = self->priv->tiles_length1;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp3__length2 = self->priv->tiles_length2;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp4_ = x;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp5_ = y;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp6_ = _tmp3_[(_tmp4_ * _tmp3__length2) + _tmp5_];
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	result = _tmp6_;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return result;
#line 1949 "game.c"
}


gboolean game_can_place (Game* self, gint x, gint y, Player color) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	Player _tmp3_ = 0;
	Player* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	Player _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	Player _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	Player _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	Player _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	Player _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	Player _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	Player _tmp30_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	Player _tmp34_ = 0;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	Player _tmp38_ = 0;
	gint _tmp39_ = 0;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = x;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp1_ = y;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp2_ = game_is_valid_location (self, _tmp0_, _tmp1_);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_vala_return_val_if_fail (_tmp2_, "is_valid_location (x, y)", FALSE);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp3_ = color;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_vala_return_val_if_fail (_tmp3_ != PLAYER_NONE, "color != Player.NONE", FALSE);
#line 208 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp4_ = self->priv->tiles;
#line 208 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp4__length1 = self->priv->tiles_length1;
#line 208 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp4__length2 = self->priv->tiles_length2;
#line 208 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp5_ = x;
#line 208 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp6_ = y;
#line 208 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
#line 208 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp7_ != PLAYER_NONE) {
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		result = FALSE;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		return result;
#line 2029 "game.c"
	}
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp8_ = x;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp9_ = y;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp10_ = color;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp11_ = game_can_flip_tiles (self, _tmp8_, _tmp9_, 1, 0, _tmp10_);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp11_ > 0) {
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		result = TRUE;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		return result;
#line 2045 "game.c"
	}
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp12_ = x;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp13_ = y;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp14_ = color;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp15_ = game_can_flip_tiles (self, _tmp12_, _tmp13_, 1, 1, _tmp14_);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp15_ > 0) {
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		result = TRUE;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		return result;
#line 2061 "game.c"
	}
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp16_ = x;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp17_ = y;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp18_ = color;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp19_ = game_can_flip_tiles (self, _tmp16_, _tmp17_, 0, 1, _tmp18_);
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp19_ > 0) {
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		result = TRUE;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		return result;
#line 2077 "game.c"
	}
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp20_ = x;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp21_ = y;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp22_ = color;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp23_ = game_can_flip_tiles (self, _tmp20_, _tmp21_, -1, 1, _tmp22_);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp23_ > 0) {
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		result = TRUE;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		return result;
#line 2093 "game.c"
	}
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp24_ = x;
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp25_ = y;
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp26_ = color;
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp27_ = game_can_flip_tiles (self, _tmp24_, _tmp25_, -1, 0, _tmp26_);
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp27_ > 0) {
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		result = TRUE;
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		return result;
#line 2109 "game.c"
	}
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp28_ = x;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp29_ = y;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp30_ = color;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp31_ = game_can_flip_tiles (self, _tmp28_, _tmp29_, -1, -1, _tmp30_);
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp31_ > 0) {
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		result = TRUE;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		return result;
#line 2125 "game.c"
	}
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp32_ = x;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp33_ = y;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp34_ = color;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp35_ = game_can_flip_tiles (self, _tmp32_, _tmp33_, 0, -1, _tmp34_);
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp35_ > 0) {
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		result = TRUE;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		return result;
#line 2141 "game.c"
	}
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp36_ = x;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp37_ = y;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp38_ = color;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp39_ = game_can_flip_tiles (self, _tmp36_, _tmp37_, 1, -1, _tmp38_);
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp39_ > 0) {
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		result = TRUE;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		return result;
#line 2157 "game.c"
	}
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	result = FALSE;
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return result;
#line 2163 "game.c"
}


gint game_place_tile (Game* self, gint x, gint y, gboolean apply) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	Player* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp3__length2 = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Player _tmp6_ = 0;
	gint tiles_turned = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gboolean _tmp15_ = FALSE;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gboolean _tmp20_ = FALSE;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gboolean _tmp25_ = FALSE;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gboolean _tmp30_ = FALSE;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gboolean _tmp35_ = FALSE;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	gboolean _tmp40_ = FALSE;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	gboolean _tmp45_ = FALSE;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	gboolean _tmp48_ = FALSE;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = x;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp1_ = y;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp2_ = game_is_valid_location (self, _tmp0_, _tmp1_);
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_vala_return_val_if_fail (_tmp2_, "is_valid_location (x, y)", 0);
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp3_ = self->priv->tiles;
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp3__length1 = self->priv->tiles_length1;
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp3__length2 = self->priv->tiles_length2;
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp4_ = x;
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp5_ = y;
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp6_ = _tmp3_[(_tmp4_ * _tmp3__length2) + _tmp5_];
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp6_ != PLAYER_NONE) {
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		result = 0;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		return result;
#line 2249 "game.c"
	}
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	tiles_turned = 0;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp7_ = tiles_turned;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp8_ = x;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp9_ = y;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp10_ = apply;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp11_ = game_flip_tiles (self, _tmp8_, _tmp9_, 1, 0, _tmp10_);
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	tiles_turned = _tmp7_ + _tmp11_;
#line 234 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp12_ = tiles_turned;
#line 234 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp13_ = x;
#line 234 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp14_ = y;
#line 234 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp15_ = apply;
#line 234 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp16_ = game_flip_tiles (self, _tmp13_, _tmp14_, 1, 1, _tmp15_);
#line 234 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	tiles_turned = _tmp12_ + _tmp16_;
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp17_ = tiles_turned;
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp18_ = x;
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp19_ = y;
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp20_ = apply;
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp21_ = game_flip_tiles (self, _tmp18_, _tmp19_, 0, 1, _tmp20_);
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	tiles_turned = _tmp17_ + _tmp21_;
#line 236 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp22_ = tiles_turned;
#line 236 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp23_ = x;
#line 236 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp24_ = y;
#line 236 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp25_ = apply;
#line 236 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp26_ = game_flip_tiles (self, _tmp23_, _tmp24_, -1, 1, _tmp25_);
#line 236 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	tiles_turned = _tmp22_ + _tmp26_;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp27_ = tiles_turned;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp28_ = x;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp29_ = y;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp30_ = apply;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp31_ = game_flip_tiles (self, _tmp28_, _tmp29_, -1, 0, _tmp30_);
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	tiles_turned = _tmp27_ + _tmp31_;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp32_ = tiles_turned;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp33_ = x;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp34_ = y;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp35_ = apply;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp36_ = game_flip_tiles (self, _tmp33_, _tmp34_, -1, -1, _tmp35_);
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	tiles_turned = _tmp32_ + _tmp36_;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp37_ = tiles_turned;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp38_ = x;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp39_ = y;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp40_ = apply;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp41_ = game_flip_tiles (self, _tmp38_, _tmp39_, 0, -1, _tmp40_);
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	tiles_turned = _tmp37_ + _tmp41_;
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp42_ = tiles_turned;
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp43_ = x;
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp44_ = y;
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp45_ = apply;
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp46_ = game_flip_tiles (self, _tmp43_, _tmp44_, 1, -1, _tmp45_);
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	tiles_turned = _tmp42_ + _tmp46_;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp47_ = tiles_turned;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp47_ == 0) {
#line 243 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		result = 0;
#line 243 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		return result;
#line 2357 "game.c"
	}
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp48_ = apply;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp48_) {
#line 2363 "game.c"
		gint _tmp49_ = 0;
		gint _tmp50_ = 0;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp49_ = x;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp50_ = y;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_set_tile (self, _tmp49_, _tmp50_);
#line 248 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_end_of_turn (self);
#line 2374 "game.c"
	}
#line 251 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	result = tiles_turned;
#line 251 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return result;
#line 2380 "game.c"
}


void game_pass (Game* self) {
	gboolean _tmp0_ = FALSE;
#line 254 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_if_fail (self != NULL);
#line 254 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = self->priv->_current_player_can_move;
#line 254 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_vala_return_if_fail (!_tmp0_, "!current_player_can_move");
#line 257 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	game_end_of_turn (self);
#line 2394 "game.c"
}


static void game_end_of_turn (Game* self) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gint _tmp8_ = 0;
	gint* _tmp9_ = NULL;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_if_fail (self != NULL);
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = self->priv->history_index;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp1_ = self->priv->history_index;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp2_ = self->priv->undo_stack;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp2__length1 = self->priv->undo_stack_length1;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_vala_return_if_fail ((_tmp0_ >= -1) && (_tmp1_ < (_tmp2__length1 - 2)), "history_index >= -1 && history_index < undo_stack.length - 2");
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp3_ = self->priv->_current_color;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp4_ = player_flip_color (_tmp3_);
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	game_set_current_color (self, _tmp4_);
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp5_ = self->priv->_number_of_moves;
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	game_set_number_of_moves (self, _tmp5_ + 1);
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp6_ = self->priv->history_index;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->history_index = _tmp6_ + 1;
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp7_ = self->priv->undo_stack;
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp7__length1 = self->priv->undo_stack_length1;
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp8_ = self->priv->history_index;
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_g_free0 (_tmp7_[_tmp8_]);
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp7_[_tmp8_] = NULL;
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp9_ = _tmp7_[_tmp8_];
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	game_update_who_can_move (self);
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_signal_emit_by_name (self, "turn-ended");
#line 2453 "game.c"
}


static void game_update_who_can_move (Game* self) {
	Player enemy = 0;
	Player _tmp0_ = 0;
	Player _tmp1_ = 0;
	gboolean opponent_can_move = FALSE;
	gboolean _tmp20_ = FALSE;
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_if_fail (self != NULL);
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = self->priv->_current_color;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp1_ = player_flip_color (_tmp0_);
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	enemy = _tmp1_;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	opponent_can_move = FALSE;
#line 2473 "game.c"
	{
		gint x = 0;
#line 275 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		x = 0;
#line 2478 "game.c"
		{
			gboolean _tmp2_ = FALSE;
#line 275 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp2_ = TRUE;
#line 275 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			while (TRUE) {
#line 2485 "game.c"
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
#line 275 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				if (!_tmp2_) {
#line 2491 "game.c"
					gint _tmp3_ = 0;
#line 275 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp3_ = x;
#line 275 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					x = _tmp3_ + 1;
#line 2497 "game.c"
				}
#line 275 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp2_ = FALSE;
#line 275 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp4_ = x;
#line 275 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp5_ = game_get_size (self);
#line 275 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp6_ = _tmp5_;
#line 275 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				if (!(_tmp4_ < _tmp6_)) {
#line 275 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					break;
#line 2511 "game.c"
				}
				{
					gint y = 0;
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					y = 0;
#line 2517 "game.c"
					{
						gboolean _tmp7_ = FALSE;
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
						_tmp7_ = TRUE;
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
						while (TRUE) {
#line 2524 "game.c"
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							Player _tmp14_ = 0;
							gboolean _tmp15_ = FALSE;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							Player _tmp18_ = 0;
							gboolean _tmp19_ = FALSE;
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							if (!_tmp7_) {
#line 2538 "game.c"
								gint _tmp8_ = 0;
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
								_tmp8_ = y;
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
								y = _tmp8_ + 1;
#line 2544 "game.c"
							}
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp7_ = FALSE;
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp9_ = y;
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp10_ = game_get_size (self);
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp11_ = _tmp10_;
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							if (!(_tmp9_ < _tmp11_)) {
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
								break;
#line 2558 "game.c"
							}
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp12_ = x;
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp13_ = y;
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp14_ = self->priv->_current_color;
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp15_ = game_can_place (self, _tmp12_, _tmp13_, _tmp14_);
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							if (_tmp15_) {
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
								game_set_current_player_can_move (self, TRUE);
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
								return;
#line 2574 "game.c"
							}
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp16_ = x;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp17_ = y;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp18_ = enemy;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							_tmp19_ = game_can_place (self, _tmp16_, _tmp17_, _tmp18_);
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
							if (_tmp19_) {
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
								opponent_can_move = TRUE;
#line 2588 "game.c"
							}
						}
					}
				}
			}
		}
	}
#line 288 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	game_set_current_player_can_move (self, FALSE);
#line 289 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp20_ = opponent_can_move;
#line 289 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (!_tmp20_) {
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_set_is_complete (self, TRUE);
#line 2604 "game.c"
	}
}


static gint game_flip_tiles (Game* self, gint x, gint y, gint x_step, gint y_step, gboolean apply) {
	gint result = 0;
	gint enemy_count = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	Player _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = x;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp1_ = y;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp2_ = x_step;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp3_ = y_step;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp4_ = self->priv->_current_color;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp5_ = game_can_flip_tiles (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	enemy_count = _tmp5_;
#line 300 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp6_ = enemy_count;
#line 300 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp6_ == 0) {
#line 301 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		result = 0;
#line 301 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		return result;
#line 2644 "game.c"
	}
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp7_ = apply;
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp7_) {
#line 2650 "game.c"
		{
			gint i = 0;
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			i = 1;
#line 2655 "game.c"
			{
				gboolean _tmp8_ = FALSE;
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp8_ = TRUE;
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				while (TRUE) {
#line 2662 "game.c"
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					gint _tmp13_ = 0;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					if (!_tmp8_) {
#line 2675 "game.c"
						gint _tmp9_ = 0;
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
						_tmp9_ = i;
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
						i = _tmp9_ + 1;
#line 2681 "game.c"
					}
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp8_ = FALSE;
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp10_ = i;
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp11_ = enemy_count;
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					if (!(_tmp10_ <= _tmp11_)) {
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
						break;
#line 2693 "game.c"
					}
#line 307 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp12_ = game_get_n_opponent_tiles (self);
#line 307 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp13_ = _tmp12_;
#line 307 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					game_set_n_opponent_tiles (self, _tmp13_ - 1);
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp14_ = x;
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp15_ = i;
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp16_ = x_step;
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp17_ = y;
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp18_ = i;
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp19_ = y_step;
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					game_set_tile (self, _tmp14_ + (_tmp15_ * _tmp16_), _tmp17_ + (_tmp18_ * _tmp19_));
#line 2715 "game.c"
				}
			}
		}
	}
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	result = enemy_count;
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return result;
#line 2724 "game.c"
}


static gint game_can_flip_tiles (Game* self, gint x, gint y, gint x_step, gint y_step, Player color) {
	gint result = 0;
	Player enemy = 0;
	Player _tmp0_ = 0;
	Player _tmp1_ = 0;
	gint enemy_count = 0;
	gint xt = 0;
	gint _tmp2_ = 0;
	gint yt = 0;
	gint _tmp3_ = 0;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gint _tmp21_ = 0;
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = color;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp1_ = player_flip_color (_tmp0_);
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	enemy = _tmp1_;
#line 319 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	enemy_count = -1;
#line 320 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp2_ = x;
#line 320 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	xt = _tmp2_;
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp3_ = y;
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	yt = _tmp3_;
#line 2759 "game.c"
	{
		gboolean _tmp4_ = FALSE;
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp4_ = TRUE;
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		while (TRUE) {
#line 2766 "game.c"
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			if (!_tmp4_) {
#line 2774 "game.c"
				gboolean _tmp5_ = FALSE;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gboolean _tmp8_ = FALSE;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp6_ = xt;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp7_ = yt;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp8_ = game_is_valid_location (self, _tmp6_, _tmp7_);
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				if (_tmp8_) {
#line 2787 "game.c"
					Player* _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gint _tmp9__length2 = 0;
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
					Player _tmp12_ = 0;
					Player _tmp13_ = 0;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp9_ = self->priv->tiles;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp9__length1 = self->priv->tiles_length1;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp9__length2 = self->priv->tiles_length2;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp10_ = xt;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp11_ = yt;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp13_ = enemy;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp5_ = _tmp12_ == _tmp13_;
#line 2811 "game.c"
				} else {
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					_tmp5_ = FALSE;
#line 2815 "game.c"
				}
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				if (!_tmp5_) {
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
					break;
#line 2821 "game.c"
				}
			}
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp4_ = FALSE;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp14_ = enemy_count;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			enemy_count = _tmp14_ + 1;
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp15_ = xt;
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp16_ = x_step;
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			xt = _tmp15_ + _tmp16_;
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp17_ = yt;
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp18_ = y_step;
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			yt = _tmp17_ + _tmp18_;
#line 2842 "game.c"
		}
	}
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp21_ = enemy_count;
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp21_ == 0) {
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp20_ = TRUE;
#line 2851 "game.c"
	} else {
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gboolean _tmp24_ = FALSE;
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp22_ = xt;
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp23_ = yt;
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp24_ = game_is_valid_location (self, _tmp22_, _tmp23_);
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp20_ = !_tmp24_;
#line 2864 "game.c"
	}
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp20_) {
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp19_ = TRUE;
#line 2870 "game.c"
	} else {
		Player* _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		gint _tmp25__length2 = 0;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		Player _tmp28_ = 0;
		Player _tmp29_ = 0;
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp25_ = self->priv->tiles;
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp25__length1 = self->priv->tiles_length1;
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp25__length2 = self->priv->tiles_length2;
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp26_ = xt;
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp27_ = yt;
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp29_ = color;
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp19_ = _tmp28_ != _tmp29_;
#line 2895 "game.c"
	}
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp19_) {
#line 330 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		result = 0;
#line 330 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		return result;
#line 2903 "game.c"
	}
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	result = enemy_count;
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return result;
#line 2909 "game.c"
}


static gint* _int_dup (gint* self) {
	gint* dup;
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	dup = g_new0 (gint, 1);
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	memcpy (dup, self, sizeof (gint));
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return dup;
#line 2921 "game.c"
}


static gpointer __int_dup0 (gpointer self) {
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return self ? _int_dup (self) : NULL;
#line 2928 "game.c"
}


static void game_set_tile (Game* self, gint x, gint y) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint* _tmp13_ = NULL;
	gint* _tmp14_ = NULL;
	Player* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gint _tmp15__length2 = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	Player _tmp18_ = 0;
	Player _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	Player _tmp22_ = 0;
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_if_fail (self != NULL);
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = self->priv->history_index;
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp1_ = self->priv->history_index;
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp2_ = self->priv->undo_stack;
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp2__length1 = self->priv->undo_stack_length1;
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_vala_return_if_fail ((_tmp0_ >= -1) && (_tmp1_ < (_tmp2__length1 - 2)), "history_index >= -1 && history_index < undo_stack.length - 2");
#line 338 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp3_ = game_get_n_current_tiles (self);
#line 338 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp4_ = _tmp3_;
#line 338 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	game_set_n_current_tiles (self, _tmp4_ + 1);
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp5_ = self->priv->history_index;
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->history_index = _tmp5_ + 1;
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp6_ = self->priv->undo_stack;
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp6__length1 = self->priv->undo_stack_length1;
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp7_ = self->priv->history_index;
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp8_ = x;
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp9_ = y;
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp10_ = game_get_size (self);
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp11_ = _tmp10_;
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp12_ = _tmp8_ + (_tmp9_ * _tmp11_);
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp13_ = __int_dup0 (&_tmp12_);
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_g_free0 (_tmp6_[_tmp7_]);
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp6_[_tmp7_] = _tmp13_;
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp14_ = _tmp6_[_tmp7_];
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp15_ = self->priv->tiles;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp15__length1 = self->priv->tiles_length1;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp15__length2 = self->priv->tiles_length2;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp16_ = x;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp17_ = y;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp18_ = self->priv->_current_color;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_] = _tmp18_;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp19_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
#line 342 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp20_ = x;
#line 342 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp21_ = y;
#line 342 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp22_ = self->priv->_current_color;
#line 342 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_signal_emit_by_name (self, "square-changed", _tmp20_, _tmp21_, _tmp22_);
#line 3030 "game.c"
}


void game_undo (Game* self, gint count) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	Player enemy = 0;
	Player _tmp6_ = 0;
	Player _tmp7_ = 0;
	Player _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gint _tmp12_ = 0;
	gint* _tmp13_ = NULL;
	gint _tmp28_ = 0;
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_if_fail (self != NULL);
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = count;
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp1_ = count;
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_vala_return_if_fail ((_tmp0_ == 1) || (_tmp1_ == 2), "count == 1 || count == 2");
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp2_ = self->priv->_number_of_moves;
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp3_ = count;
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_vala_return_if_fail (_tmp2_ >= _tmp3_, "number_of_moves >= count");
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp4_ = self->priv->history_index;
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp5_ = self->priv->undo_stack;
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp5__length1 = self->priv->undo_stack_length1;
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_vala_return_if_fail (_tmp4_ < _tmp5__length1, "history_index < undo_stack.length");
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp6_ = self->priv->_current_color;
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	enemy = _tmp6_;
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp7_ = self->priv->_current_color;
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp8_ = player_flip_color (_tmp7_);
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	game_set_current_color (self, _tmp8_);
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp9_ = self->priv->_number_of_moves;
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	game_set_number_of_moves (self, _tmp9_ - 1);
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp10_ = self->priv->history_index;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->history_index = _tmp10_ - 1;
#line 362 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp11_ = self->priv->undo_stack;
#line 362 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp11__length1 = self->priv->undo_stack_length1;
#line 362 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp12_ = self->priv->history_index;
#line 362 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp13_ = _tmp11_[_tmp12_];
#line 362 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp13_ != NULL) {
#line 3103 "game.c"
		gint** _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		gint _tmp15_ = 0;
		gint* _tmp16_ = NULL;
#line 365 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp14_ = self->priv->undo_stack;
#line 365 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp14__length1 = self->priv->undo_stack_length1;
#line 365 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp15_ = self->priv->history_index;
#line 365 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp16_ = _tmp14_[_tmp15_];
#line 365 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_unset_tile (self, *_tmp16_, PLAYER_NONE);
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		while (TRUE) {
#line 3120 "game.c"
			gboolean _tmp17_ = FALSE;
			gint _tmp18_ = 0;
			gint _tmp22_ = 0;
			gint _tmp23_ = 0;
			gint** _tmp24_ = NULL;
			gint _tmp24__length1 = 0;
			gint _tmp25_ = 0;
			gint* _tmp26_ = NULL;
			Player _tmp27_ = 0;
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp18_ = self->priv->history_index;
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			if (_tmp18_ > -1) {
#line 3134 "game.c"
				gint** _tmp19_ = NULL;
				gint _tmp19__length1 = 0;
				gint _tmp20_ = 0;
				gint* _tmp21_ = NULL;
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp19_ = self->priv->undo_stack;
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp19__length1 = self->priv->undo_stack_length1;
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp20_ = self->priv->history_index;
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp21_ = _tmp19_[_tmp20_];
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp17_ = _tmp21_ != NULL;
#line 3149 "game.c"
			} else {
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				_tmp17_ = FALSE;
#line 3153 "game.c"
			}
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			if (!_tmp17_) {
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
				break;
#line 3159 "game.c"
			}
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp22_ = game_get_n_opponent_tiles (self);
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp23_ = _tmp22_;
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			game_set_n_opponent_tiles (self, _tmp23_ + 1);
#line 369 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp24_ = self->priv->undo_stack;
#line 369 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp24__length1 = self->priv->undo_stack_length1;
#line 369 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp25_ = self->priv->history_index;
#line 369 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp26_ = _tmp24_[_tmp25_];
#line 369 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			_tmp27_ = enemy;
#line 369 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
			game_unset_tile (self, *_tmp26_, _tmp27_);
#line 3179 "game.c"
		}
	}
#line 373 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp28_ = count;
#line 373 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp28_ == 1) {
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_set_is_complete (self, FALSE);
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_update_who_can_move (self);
#line 3190 "game.c"
	} else {
		gint _tmp29_ = 0;
#line 380 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp29_ = count;
#line 380 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_undo (self, _tmp29_ - 1);
#line 3197 "game.c"
	}
}


static void game_unset_tile (Game* self, gint tile_number, Player replacement_color) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint x = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint y = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	Player* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp9__length2 = 0;
	Player _tmp10_ = 0;
	Player _tmp11_ = 0;
	Player _tmp12_ = 0;
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_if_fail (self != NULL);
#line 386 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = game_get_n_current_tiles (self);
#line 386 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp1_ = _tmp0_;
#line 386 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	game_set_n_current_tiles (self, _tmp1_ - 1);
#line 387 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp2_ = self->priv->history_index;
#line 387 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->history_index = _tmp2_ - 1;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp3_ = tile_number;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp4_ = game_get_size (self);
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp5_ = _tmp4_;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	x = _tmp3_ % _tmp5_;
#line 389 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp6_ = tile_number;
#line 389 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp7_ = game_get_size (self);
#line 389 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp8_ = _tmp7_;
#line 389 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	y = _tmp6_ / _tmp8_;
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp9_ = self->priv->tiles;
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp9__length1 = self->priv->tiles_length1;
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp9__length2 = self->priv->tiles_length2;
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp10_ = replacement_color;
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp9_[(x * _tmp9__length2) + y] = _tmp10_;
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp11_ = _tmp9_[(x * _tmp9__length2) + y];
#line 391 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp12_ = replacement_color;
#line 391 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_signal_emit_by_name (self, "square-changed", x, y, _tmp12_);
#line 3264 "game.c"
}


gint game_get_size (Game* self) {
	gint result;
	gint _tmp0_ = 0;
#line 29 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 29 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = self->priv->_size;
#line 29 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	result = _tmp0_;
#line 29 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return result;
#line 3279 "game.c"
}


static void game_set_size (Game* self, gint value) {
	gint _tmp0_ = 0;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_if_fail (self != NULL);
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = value;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->_size = _tmp0_;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_object_notify ((GObject *) self, "size");
#line 3293 "game.c"
}


Player game_get_current_color (Game* self) {
	Player result;
	Player _tmp0_ = 0;
#line 39 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 39 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = self->priv->_current_color;
#line 39 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	result = _tmp0_;
#line 39 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return result;
#line 3308 "game.c"
}


static void game_set_current_color (Game* self, Player value) {
	Player _tmp0_ = 0;
#line 39 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_if_fail (self != NULL);
#line 39 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = value;
#line 39 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->_current_color = _tmp0_;
#line 39 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_object_notify ((GObject *) self, "current-color");
#line 3322 "game.c"
}


gint game_get_number_of_moves (Game* self) {
	gint result;
	gint _tmp0_ = 0;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = self->priv->_number_of_moves;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	result = _tmp0_;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return result;
#line 3337 "game.c"
}


static void game_set_number_of_moves (Game* self, gint value) {
	gint _tmp0_ = 0;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_if_fail (self != NULL);
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = value;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->_number_of_moves = _tmp0_;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_object_notify ((GObject *) self, "number-of-moves");
#line 3351 "game.c"
}


gboolean game_get_current_player_can_move (Game* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = self->priv->_current_player_can_move;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	result = _tmp0_;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return result;
#line 3366 "game.c"
}


static void game_set_current_player_can_move (Game* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_if_fail (self != NULL);
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = value;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->_current_player_can_move = _tmp0_;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_object_notify ((GObject *) self, "current-player-can-move");
#line 3380 "game.c"
}


gboolean game_get_is_complete (Game* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = self->priv->_is_complete;
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	result = _tmp0_;
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return result;
#line 3395 "game.c"
}


static void game_set_is_complete (Game* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_if_fail (self != NULL);
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = value;
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->_is_complete = _tmp0_;
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_object_notify ((GObject *) self, "is-complete");
#line 3409 "game.c"
}


gint game_get_initial_number_of_tiles (Game* self) {
	gint result;
	gint _tmp0_ = 0;
#line 55 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 55 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = self->priv->_initial_number_of_tiles;
#line 55 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	result = _tmp0_;
#line 55 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return result;
#line 3424 "game.c"
}


static void game_set_initial_number_of_tiles (Game* self, gint value) {
	gint _tmp0_ = 0;
#line 55 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_if_fail (self != NULL);
#line 55 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = value;
#line 55 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->_initial_number_of_tiles = _tmp0_;
#line 55 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_object_notify ((GObject *) self, "initial-number-of-tiles");
#line 3438 "game.c"
}


gint game_get_n_tiles (Game* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = game_get_n_dark_tiles (self);
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp1_ = _tmp0_;
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp2_ = game_get_n_light_tiles (self);
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp3_ = _tmp2_;
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	result = _tmp1_ + _tmp3_;
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return result;
#line 3462 "game.c"
}


gint game_get_n_light_tiles (Game* self) {
	gint result;
	gint _tmp0_ = 0;
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = self->priv->_n_light_tiles;
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	result = _tmp0_;
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return result;
#line 3477 "game.c"
}


gint game_get_n_dark_tiles (Game* self) {
	gint result;
	gint _tmp0_ = 0;
#line 70 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 70 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = self->priv->_n_dark_tiles;
#line 70 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	result = _tmp0_;
#line 70 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return result;
#line 3492 "game.c"
}


gint game_get_n_current_tiles (Game* self) {
	gint result;
	gint _tmp0_ = 0;
	Player _tmp1_ = 0;
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp1_ = self->priv->_current_color;
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp1_ == PLAYER_LIGHT) {
#line 3506 "game.c"
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp2_ = game_get_n_light_tiles (self);
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp3_ = _tmp2_;
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp0_ = _tmp3_;
#line 3515 "game.c"
	} else {
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp4_ = game_get_n_dark_tiles (self);
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp5_ = _tmp4_;
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp0_ = _tmp5_;
#line 3525 "game.c"
	}
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	result = _tmp0_;
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return result;
#line 3531 "game.c"
}


static void game_set_n_current_tiles (Game* self, gint value) {
	Player _tmp0_ = 0;
#line 76 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_if_fail (self != NULL);
#line 77 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = self->priv->_current_color;
#line 77 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp0_ == PLAYER_LIGHT) {
#line 3543 "game.c"
		gint _tmp1_ = 0;
#line 78 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp1_ = value;
#line 78 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		self->priv->_n_light_tiles = _tmp1_;
#line 3549 "game.c"
	} else {
		gint _tmp2_ = 0;
#line 80 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp2_ = value;
#line 80 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		self->priv->_n_dark_tiles = _tmp2_;
#line 3556 "game.c"
	}
#line 76 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_object_notify ((GObject *) self, "n-current-tiles");
#line 3560 "game.c"
}


gint game_get_n_opponent_tiles (Game* self) {
	gint result;
	gint _tmp0_ = 0;
	Player _tmp1_ = 0;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp1_ = self->priv->_current_color;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp1_ == PLAYER_DARK) {
#line 3574 "game.c"
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp2_ = game_get_n_light_tiles (self);
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp3_ = _tmp2_;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp0_ = _tmp3_;
#line 3583 "game.c"
	} else {
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp4_ = game_get_n_dark_tiles (self);
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp5_ = _tmp4_;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp0_ = _tmp5_;
#line 3593 "game.c"
	}
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	result = _tmp0_;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	return result;
#line 3599 "game.c"
}


static void game_set_n_opponent_tiles (Game* self, gint value) {
	Player _tmp0_ = 0;
#line 87 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_if_fail (self != NULL);
#line 88 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	_tmp0_ = self->priv->_current_color;
#line 88 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (_tmp0_ == PLAYER_DARK) {
#line 3611 "game.c"
		gint _tmp1_ = 0;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp1_ = value;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		self->priv->_n_light_tiles = _tmp1_;
#line 3617 "game.c"
	} else {
		gint _tmp2_ = 0;
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		_tmp2_ = value;
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		self->priv->_n_dark_tiles = _tmp2_;
#line 3624 "game.c"
	}
#line 87 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_object_notify ((GObject *) self, "n-opponent-tiles");
#line 3628 "game.c"
}


static void g_cclosure_user_marshal_VOID__INT_INT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT_ENUM) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_return_if_fail (n_param_values == 4);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		data1 = closure->data;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		data2 = param_values->data[0].v_pointer;
#line 3647 "game.c"
	} else {
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		data1 = param_values->data[0].v_pointer;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		data2 = closure->data;
#line 3653 "game.c"
	}
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	callback = (GMarshalFunc_VOID__INT_INT_ENUM) (marshal_data ? marshal_data : cc->callback);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_enum (param_values + 3), data2);
#line 3659 "game.c"
}


static void game_class_init (GameClass * klass) {
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	game_parent_class = g_type_class_peek_parent (klass);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_type_class_add_private (klass, sizeof (GamePrivate));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_CURRENT_COLOR, g_param_spec_enum ("current-color", "current-color", "current-color", TYPE_PLAYER, PLAYER_DARK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_NUMBER_OF_MOVES, g_param_spec_int ("number-of-moves", "number-of-moves", "number-of-moves", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_CURRENT_PLAYER_CAN_MOVE, g_param_spec_boolean ("current-player-can-move", "current-player-can-move", "current-player-can-move", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_IS_COMPLETE, g_param_spec_boolean ("is-complete", "is-complete", "is-complete", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_INITIAL_NUMBER_OF_TILES, g_param_spec_int ("initial-number-of-tiles", "initial-number-of-tiles", "initial-number-of-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_N_TILES, g_param_spec_int ("n-tiles", "n-tiles", "n-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_N_LIGHT_TILES, g_param_spec_int ("n-light-tiles", "n-light-tiles", "n-light-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_N_DARK_TILES, g_param_spec_int ("n-dark-tiles", "n-dark-tiles", "n-dark-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_N_CURRENT_TILES, g_param_spec_int ("n-current-tiles", "n-current-tiles", "n-current-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_N_OPPONENT_TILES, g_param_spec_int ("n-opponent-tiles", "n-opponent-tiles", "n-opponent-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_signal_new ("turn_ended", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	g_signal_new ("square_changed", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_ENUM, G_TYPE_NONE, 3, G_TYPE_INT, G_TYPE_INT, TYPE_PLAYER);
#line 3700 "game.c"
}


static void game_instance_init (Game * self) {
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv = GAME_GET_PRIVATE (self);
#line 35 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->history_index = -1;
#line 39 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->_current_color = PLAYER_DARK;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->_number_of_moves = 0;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->_current_player_can_move = TRUE;
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->_is_complete = FALSE;
#line 61 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->_n_light_tiles = 2;
#line 67 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->_n_dark_tiles = 2;
#line 3721 "game.c"
}


static void game_finalize (GObject* obj) {
	Game * self;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
#line 24 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->tiles = (g_free (self->priv->tiles), NULL);
#line 34 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	self->priv->undo_stack = (_vala_array_free (self->priv->undo_stack, self->priv->undo_stack_length1, (GDestroyNotify) g_free), NULL);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
#line 3735 "game.c"
}


GType game_get_type (void) {
	static volatile gsize game_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
		GType game_type_id;
		game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
		g_once_init_leave (&game_type_id__volatile, game_type_id);
	}
	return game_type_id__volatile;
}


static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	switch (property_id) {
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		case GAME_SIZE:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		g_value_set_int (value, game_get_size (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		case GAME_CURRENT_COLOR:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		g_value_set_enum (value, game_get_current_color (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		case GAME_NUMBER_OF_MOVES:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		g_value_set_int (value, game_get_number_of_moves (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		case GAME_CURRENT_PLAYER_CAN_MOVE:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		g_value_set_boolean (value, game_get_current_player_can_move (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		case GAME_IS_COMPLETE:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		g_value_set_boolean (value, game_get_is_complete (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		case GAME_INITIAL_NUMBER_OF_TILES:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		g_value_set_int (value, game_get_initial_number_of_tiles (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		case GAME_N_TILES:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		g_value_set_int (value, game_get_n_tiles (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		case GAME_N_LIGHT_TILES:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		g_value_set_int (value, game_get_n_light_tiles (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		case GAME_N_DARK_TILES:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		g_value_set_int (value, game_get_n_dark_tiles (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		case GAME_N_CURRENT_TILES:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		g_value_set_int (value, game_get_n_current_tiles (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		case GAME_N_OPPONENT_TILES:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		g_value_set_int (value, game_get_n_opponent_tiles (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 3822 "game.c"
		default:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 3828 "game.c"
	}
}


static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
	switch (property_id) {
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		case GAME_SIZE:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_set_size (self, g_value_get_int (value));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		case GAME_CURRENT_COLOR:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_set_current_color (self, g_value_get_enum (value));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		case GAME_NUMBER_OF_MOVES:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_set_number_of_moves (self, g_value_get_int (value));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		case GAME_CURRENT_PLAYER_CAN_MOVE:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_set_current_player_can_move (self, g_value_get_boolean (value));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		case GAME_IS_COMPLETE:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_set_is_complete (self, g_value_get_boolean (value));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		case GAME_INITIAL_NUMBER_OF_TILES:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_set_initial_number_of_tiles (self, g_value_get_int (value));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		case GAME_N_CURRENT_TILES:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_set_n_current_tiles (self, g_value_get_int (value));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		case GAME_N_OPPONENT_TILES:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		game_set_n_opponent_tiles (self, g_value_get_int (value));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 3886 "game.c"
		default:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game.vala"
		break;
#line 3892 "game.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



