/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined (__LIBICAL_GLIB_H_INSIDE__) && !defined (LIBICAL_GLIB_COMPILATION)
#error "Only <libical-glib/libical-glib.h> can be included directly."
#endif

#ifndef I_CAL_VALUE_H
#define I_CAL_VALUE_H

#include <string.h>
#include <libical-glib/i-cal-object.h>
#include <libical-glib/i-cal-derived-parameter.h>
#include <libical-glib/i-cal-derived-value.h>

G_BEGIN_DECLS

#define I_CAL_VALUE_TYPE \
        (i_cal_value_get_type ())
#define I_CAL_VALUE(obj) \
        (G_TYPE_CHECK_INSTANCE_CAST \
        ((obj), I_CAL_VALUE_TYPE, ICalValue))
#define I_CAL_VALUE_CLASS(klass) \
        (G_TYPE_CHECK_CLASS_CAST \
        ((klass), I_CAL_VALUE_TYPE, ICalValueClass))
#define I_CAL_IS_VALUE(obj) \
        (G_TYPE_CHECK_INSTANCE_TYPE \
        ((obj), I_CAL_VALUE_TYPE))
#define I_CAL_IS_VALUE_CLASS(klass) \
        (G_TYPE_CHECK_CLASS_TYPE \
        ((klass), I_CAL_VALUE_TYPE))

/**
 * ICalValue:
 *
 * This is the ICalValue instance.
 */
typedef struct _ICalValue ICalValue;

/**
 * ICalValueClass:
 *
 * This is the ICalValue class.
 */
typedef struct _ICalValueClass ICalValueClass;

struct _ICalValue {
	/*< private >*/
	ICalObject parent;
};

struct _ICalValueClass {
	/*< private >*/
	ICalObjectClass parent;
};

ICalValue *	i_cal_value_new_full		(icalvalue *native,
						 GObject *owner);
GType 		i_cal_value_get_type		(void);
ICalValue *	i_cal_value_new			(ICalValueKind kind);
ICalValue *	i_cal_value_new_clone		(const ICalValue *value);
ICalValue *	i_cal_value_new_from_string	(ICalValueKind kind,
						 const gchar *str);
void		i_cal_value_free		(ICalValue *value);
gint 		i_cal_value_is_valid		(const ICalValue *value);
gchar *		i_cal_value_as_ical_string_r	(const ICalValue *value);
ICalValueKind 	i_cal_value_isa			(const ICalValue *value);
gint 		i_cal_value_isa_value		(ICalValue *value);
ICalParameterXliccomparetype 
		i_cal_value_compare		(const ICalValue *a,
						 const ICalValue *b);
ICalValueKind 	i_cal_value_string_to_kind	(const gchar *str);
const gchar *	i_cal_value_kind_to_string	(const ICalValueKind kind);
gint 		i_cal_value_kind_is_valid	(const ICalValueKind kind);
gchar *		i_cal_value_encode_ical_string	(const gchar *szText);
gchar *		i_cal_value_decode_ical_string	(const gchar *szText);

G_END_DECLS

#endif /* I_CAL_VALUE_H */