/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */

/*
 *  Medusa
 *
 *  Copyright (C) 2001 Eazel, Inc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Rebecca Schulman <rebecka@eazel.com>
 *
 *  medusa-enable-indexing.c -- Command line tool to turn regular indexing on and off.
 */

#include <glib.h>
#include <popt.h>
#include <stdlib.h>
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-i18n.h>
#include <libgnome/gnome-popt.h>

#include <libmedusa/medusa-system-state.h>

int
main (int argc, char **argv) 
{
        gboolean turn_on_regular_indexing, turn_off_regular_indexing;
        const char **unparsed_arguments;
        struct poptOption command_line_options[] = {
                { "on", '\0', POPT_ARG_NONE, &turn_on_regular_indexing,
                  0, N_("Turn on regular medusa indexing and searching"),
                  NULL },
                { "off", '\0', POPT_ARG_NONE, &turn_off_regular_indexing,
                  0, N_("Turn off regular medusa indexing and searching"),
                  NULL },
                POPT_AUTOHELP
                { NULL, '\0', 0, NULL, 0, NULL, NULL }
        };
        poptContext popt_context;

        turn_on_regular_indexing = FALSE;
        turn_off_regular_indexing = FALSE;
        gnomelib_register_popt_table (command_line_options, 
                                      _("Medusa Command Line Tool to Enable and Disable Indexing"));
        popt_context = gnomelib_parse_args (argc, argv, 0);

        unparsed_arguments = poptGetArgs (popt_context);
        poptFreeContext (popt_context);

        if (unparsed_arguments != NULL) {
                fprintf (stderr, _("medusa-enable-indexing: Invalid argument:%s\n"), unparsed_arguments[0]);
                exit (1);
        }

        if (turn_on_regular_indexing &&
            turn_off_regular_indexing) {
                fprintf (stderr, _("medusa-enable-indexing: Options --on and --off are mutually exclusive.\n"));
                exit (1);
        }
        
        if (!turn_on_regular_indexing && 
            !turn_off_regular_indexing) {
                fprintf (stderr, _("medusa-enable-indexing: Either option --on or option --off must be used to turn indexing on or off.\n"));
                exit (1);
        }

        if (turn_on_regular_indexing) {
                if (!medusa_enable_medusa_services (TRUE)) {
                        if (medusa_system_services_are_blocked ()) {
                                fprintf (stderr, _("Indexing could not be enabled because medusa usage "
                                                   "has been blocked on your system by the system administrator."));
                                exit (1);
                        }
                        else {
                                fprintf (stderr, _("Enabling indexing failed on your system, even though medusa services should be "
                                                   "available to you.  Tell rebecka@eazel.com.\n"));
                                exit (1);
                        }
                }
                
                fprintf (stderr, _("Medusa index services have been enabled.\n"));
        }

        if (turn_off_regular_indexing) {
                if (!medusa_enable_medusa_services (FALSE)) {
                        fprintf (stderr, _("There was a problem disabling medusa services. Tell rebecka@eazel.com.\n"));
                        exit (1);
                }
                
                fprintf (stderr, _("Medusa index services have been disabled.\n"));
        }

        return 0;
}

