/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evomodel.continuous.CartogramDiffusionModel;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.geo.cartogram.CartogramMapping;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class MixtureCartogramDiffusionModel
extends CartogramDiffusionModel {
    public static final String DIFFUSION_PROCESS = "mixtureCartogramDiffusionModel";
    public static final String MIXTURE = "mixture";
    public static final String MAP = "map";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Parameter.class), new ElementRule("mixture", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), CartogramDiffusionModel.boundingBoxRules};

        @Override
        public String getParserName() {
            return MixtureCartogramDiffusionModel.DIFFUSION_PROCESS;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Rectangle2D rectangle2D = CartogramDiffusionModel.parseRectangle2D(xMLObject);
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            Parameter parameter2 = (Parameter)xMLObject.getChild(MixtureCartogramDiffusionModel.MIXTURE).getChild(Parameter.class);
            MixtureCartogramDiffusionModel mixtureCartogramDiffusionModel = new MixtureCartogramDiffusionModel(xMLObject.getId(), parameter, parameter2);
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                if (!xMLObject.getChildName(i).equals(MixtureCartogramDiffusionModel.MAP)) continue;
                XMLObject xMLObject2 = (XMLObject)xMLObject.getChild(i);
                CartogramMapping cartogramMapping = CartogramDiffusionModel.parseCartogramMapping(xMLObject2, rectangle2D);
                mixtureCartogramDiffusionModel.addMapping(cartogramMapping);
            }
            return mixtureCartogramDiffusionModel;
        }

        @Override
        public String getParserDescription() {
            return "Describes a bivariate diffusion process using cartogram distances.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return MultivariateDiffusionModel.class;
        }
    };
    private final Parameter mixture;
    private List<CartogramMapping> mappingList;

    public MixtureCartogramDiffusionModel(String string, Parameter parameter, Parameter parameter2) {
        super(string, parameter);
        this.mixture = parameter2;
        Logger.getLogger("dr.evomodel.continuous").info("\tMixture: " + parameter2.getId());
        this.addVariable(parameter2);
    }

    @Override
    public void addMapping(CartogramMapping cartogramMapping) {
        if (this.mappingList == null) {
            this.mappingList = new ArrayList<CartogramMapping>();
        }
        this.mappingList.add(cartogramMapping);
        Logger.getLogger("dr.evomodel.continuous").info("\tMapping  : " + cartogramMapping.toString() + " with density " + cartogramMapping.getAverageDensity());
    }

    @Override
    protected CartogramMapping getMapping() {
        int n = (int)this.mixture.getParameterValue(0) - 1;
        return this.mappingList.get(n);
    }
}

