/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.markovjumps;

import dr.inference.markovjumps.StateChange;
import dr.inference.markovjumps.StateHistory;
import dr.inference.markovjumps.SubordinatedProcess;
import dr.math.MathUtils;

public class UniformizedStateHistory
extends StateHistory {
    private final SubordinatedProcess subordinator;

    public UniformizedStateHistory(double d, int n, int n2, double[] dArray) {
        this(d, n, n2, new SubordinatedProcess(dArray, n2));
    }

    protected UniformizedStateHistory(double d, int n, int n2, SubordinatedProcess subordinatedProcess) {
        super(d, n, n2);
        this.subordinator = subordinatedProcess;
    }

    public SubordinatedProcess getSubordinatedProcess() {
        return this.subordinator;
    }

    public static StateHistory simulateUnconditionalOnEndingState(double d, int n, double d2, double[] dArray, int n2) {
        throw new RuntimeException("Impossible to simulate an unconditioned CTMC using Uniformization");
    }

    public static StateHistory simulateConditionalOnEndingState(double d, int n, double d2, int n2, double d3, double[] dArray, int n3) throws SubordinatedProcess.Exception {
        return UniformizedStateHistory.simulateConditionalOnEndingState(d, n, d2, n2, d3, n3, new SubordinatedProcess(dArray, n3));
    }

    public static StateHistory simulateConditionalOnEndingState(double d, int n, double d2, int n2, double d3, int n3, SubordinatedProcess subordinatedProcess) throws SubordinatedProcess.Exception {
        UniformizedStateHistory uniformizedStateHistory = new UniformizedStateHistory(d, n, n3, subordinatedProcess);
        double d4 = d2 - d;
        int n4 = subordinatedProcess.drawNumberOfChanges(n, n2, d4, d3);
        if (n4 != 0) {
            if (n4 == 1) {
                if (n != n2) {
                    double d5 = d4 * MathUtils.nextDouble();
                    uniformizedStateHistory.addChange(new StateChange(d + d5, n2));
                }
            } else {
                double[] dArray = subordinatedProcess.drawTransitionTimes(d4, n4);
                int n5 = n;
                for (int i = 1; i < n4; ++i) {
                    int n6 = subordinatedProcess.drawNextChainState(n5, n2, n4, i);
                    if (n6 == n5) continue;
                    uniformizedStateHistory.addChange(new StateChange(d + dArray[i - 1], n6));
                    n5 = n6;
                }
                if (n5 != n2) {
                    uniformizedStateHistory.addChange(new StateChange(d + dArray[n4 - 1], n2));
                }
            }
        }
        uniformizedStateHistory.addEndingState(new StateChange(d2, n2));
        return uniformizedStateHistory;
    }
}

