/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.BorderFactory;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.data.ExDefaultTableModel;
import org.rosuda.deducer.plots.LegendPanel;
import org.rosuda.deducer.plots.ParamScaleLegend;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamWidget;

public class ParamScaleWidget
extends ParamWidget {
    private LegendPanel legendPanel;

    public ParamScaleWidget() {
    }

    public ParamScaleWidget(Param param) {
        this.setModel(param);
    }

    @Override
    public void setModel(Param param) {
        Object object;
        this.model = param;
        this.initAsScale();
        if (this.model.getValue() != null) {
            object = (Vector)this.model.getValue();
            String string = (String)((Vector)object).get(0);
            Boolean bl = (Boolean)((Vector)object).get(1);
            ExDefaultTableModel exDefaultTableModel = (ExDefaultTableModel)((Vector)object).get(2);
            this.legendPanel.setName(string);
            this.legendPanel.setTableModel(exDefaultTableModel);
        }
        this.legendPanel.setNumeric(((ParamScaleLegend)param).isNumeric());
        this.legendPanel.getBreaksWidget().setModel(((ParamScaleLegend)this.model).getBreaksModel());
        this.legendPanel.getLabelsWidget().setModel(((ParamScaleLegend)this.model).getLabelsModel());
        this.legendPanel.getGuideWidget().setModel(((ParamScaleLegend)this.model).getGuideModel());
        object = ((ParamScaleLegend)this.model).getAes();
        this.legendPanel.showGuide(!((String)object).equals("y") && !((String)object).equals("x"));
        if (((String)object).equals("y") || ((String)object).equals("x")) {
            this.legendPanel.setBorder(BorderFactory.createTitledBorder((String)object + "-axis"));
            this.legendPanel.showGuide(false);
        } else {
            this.legendPanel.setBorder(BorderFactory.createTitledBorder("Legend"));
        }
    }

    @Override
    public void updateModel() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.legendPanel.getName());
        vector.add(new Boolean(true));
        ExDefaultTableModel exDefaultTableModel = this.legendPanel.getTableModel();
        if (((ParamScaleLegend)this.model).isNumeric()) {
            for (int i = 0; i < exDefaultTableModel.getRowCount(); ++i) {
                String string = (String)exDefaultTableModel.getValueAt(i, 0);
                try {
                    Double.parseDouble(string);
                    continue;
                }
                catch (Exception exception) {
                    exDefaultTableModel.setValueAt("", i, 0);
                }
            }
        }
        this.legendPanel.setTableModel(exDefaultTableModel);
        vector.add(exDefaultTableModel);
        this.model.setValue(vector);
        this.legendPanel.getBreaksWidget().updateModel();
        this.legendPanel.getLabelsWidget().updateModel();
        this.legendPanel.getGuideWidget().updateModel();
    }

    @Override
    public Param getModel() {
        this.updateModel();
        return this.model;
    }

    private void initAsScale() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.setLayout((LayoutManager)anchorLayout);
            this.setPreferredSize(new Dimension(291, 166));
            int n = 58;
            int n2 = Math.max(n + 22, 80);
            this.legendPanel = new LegendPanel();
            this.add((Component)this.legendPanel, new AnchorConstraint(15, 820, 1003, 180, 2, 1, 1, 1));
            this.legendPanel.setPreferredSize(new Dimension(255, 255));
            this.legendPanel.setMaximumSize(new Dimension(255, 700));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setPreferredSize(new Dimension(300, 325));
        this.setMaximumSize(new Dimension(500, 325));
    }
}

