/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.DT_GA.C45;

import java.util.Enumeration;
import keel.Algorithms.Decision_Trees.DT_GA.C45.Cut;
import keel.Algorithms.Decision_Trees.DT_GA.C45.Dataset;
import keel.Algorithms.Decision_Trees.DT_GA.C45.Itemset;

public class Classification {
    private double[][] perClassPerValue;
    private double[] perValue;
    private double[] perClass;
    private double total;

    public Classification(int numValues, int numClasses) {
        this.perClassPerValue = new double[numValues][0];
        this.perValue = new double[numValues];
        this.perClass = new double[numClasses];
        for (int i = 0; i < numValues; ++i) {
            this.perClassPerValue[i] = new double[numClasses];
        }
        this.total = 0.0;
    }

    public Classification(Dataset source) throws Exception {
        this.perClassPerValue = new double[1][0];
        this.perValue = new double[1];
        this.total = 0.0;
        this.perClass = new double[source.numClasses()];
        this.perClassPerValue[0] = new double[source.numClasses()];
        Enumeration enum2 = source.enumerateItemsets();
        while (enum2.hasMoreElements()) {
            this.add(0, (Itemset)enum2.nextElement());
        }
    }

    public Classification(Dataset source, Cut model) throws Exception {
        this.perClassPerValue = new double[model.numSubsets()][0];
        this.perValue = new double[model.numSubsets()];
        this.total = 0.0;
        this.perClass = new double[source.numClasses()];
        for (int i = 0; i < model.numSubsets(); ++i) {
            this.perClassPerValue[i] = new double[source.numClasses()];
        }
        Enumeration enum2 = source.enumerateItemsets();
        while (enum2.hasMoreElements()) {
            Itemset itemset = (Itemset)enum2.nextElement();
            int index = model.whichSubset(itemset);
            if (index != -1) {
                this.add(index, itemset);
                continue;
            }
            double[] weights = model.weights(itemset);
            this.addWeights(itemset, weights);
        }
    }

    public Classification(Classification toMerge) {
        this.total = toMerge.total;
        this.perClass = new double[toMerge.numClasses()];
        System.arraycopy(toMerge.perClass, 0, this.perClass, 0, toMerge.numClasses());
        this.perClassPerValue = new double[1][0];
        this.perClassPerValue[0] = new double[toMerge.numClasses()];
        System.arraycopy(toMerge.perClass, 0, this.perClassPerValue[0], 0, toMerge.numClasses());
        this.perValue = new double[1];
        this.perValue[0] = this.total;
    }

    public final void add(int valueIndex, Itemset itemset) {
        int classIndex = (int)itemset.getClassValue();
        double weight = itemset.getWeight();
        this.perClassPerValue[valueIndex][classIndex] = this.perClassPerValue[valueIndex][classIndex] + weight;
        this.perValue[valueIndex] = this.perValue[valueIndex] + weight;
        this.perClass[classIndex] = this.perClass[classIndex] + weight;
        this.total += weight;
    }

    public final void addWithUnknownValue(Dataset source, int attIndex) {
        int j;
        double[] probs = new double[this.perValue.length];
        for (j = 0; j < this.perValue.length; ++j) {
            probs[j] = this.total == 0.0 ? 1.0 / (double)probs.length : this.perValue[j] / this.total;
        }
        Enumeration enum2 = source.enumerateItemsets();
        while (enum2.hasMoreElements()) {
            Itemset itemset = (Itemset)enum2.nextElement();
            if (!itemset.isMissing(attIndex)) continue;
            int classIndex = (int)itemset.getClassValue();
            double weight = itemset.getWeight();
            this.perClass[classIndex] = this.perClass[classIndex] + weight;
            this.total += weight;
            for (j = 0; j < this.perValue.length; ++j) {
                double newWeight = probs[j] * weight;
                this.perClassPerValue[j][classIndex] = this.perClassPerValue[j][classIndex] + newWeight;
                this.perValue[j] = this.perValue[j] + newWeight;
            }
        }
    }

    public final void addRange(int valueIndex, Dataset source, int start, int end) {
        double sumOfWeights = 0.0;
        for (int i = start; i < end; ++i) {
            Itemset itemset = source.itemset(i);
            int classIndex = (int)itemset.getClassValue();
            sumOfWeights += itemset.getWeight();
            double[] dArray = this.perClassPerValue[valueIndex];
            int n = classIndex;
            dArray[n] = dArray[n] + itemset.getWeight();
            int n2 = classIndex;
            this.perClass[n2] = this.perClass[n2] + itemset.getWeight();
        }
        int n = valueIndex;
        this.perValue[n] = this.perValue[n] + sumOfWeights;
        this.total += sumOfWeights;
    }

    public final void addWeights(Itemset itemset, double[] weights) {
        int classIndex = (int)itemset.getClassValue();
        for (int i = 0; i < this.perValue.length; ++i) {
            double weight = itemset.getWeight() * weights[i];
            this.perClassPerValue[i][classIndex] = this.perClassPerValue[i][classIndex] + weight;
            this.perValue[i] = this.perValue[i] + weight;
            this.perClass[classIndex] = this.perClass[classIndex] + weight;
            this.total += weight;
        }
    }

    public final boolean check(double minItemsets) {
        int counter = 0;
        for (int i = 0; i < this.perValue.length; ++i) {
            if (!(this.perValue[i] >= minItemsets)) continue;
            ++counter;
        }
        return counter > 1;
    }

    public final int maxValue() {
        double max = 0.0;
        int maxIndex = -1;
        for (int i = 0; i < this.perValue.length; ++i) {
            if (!(this.perValue[i] >= max)) continue;
            max = this.perValue[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    public final int maxClass() {
        double maxCount = 0.0;
        int maxIndex = 0;
        for (int i = 0; i < this.perClass.length; ++i) {
            if (!(this.perClass[i] > maxCount)) continue;
            maxCount = this.perClass[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    public final int maxClass(int index) {
        double maxCount = 0.0;
        int maxIndex = 0;
        if (this.perValue[index] > 0.0) {
            for (int i = 0; i < this.perClass.length; ++i) {
                if (!(this.perClassPerValue[index][i] > maxCount)) continue;
                maxCount = this.perClassPerValue[index][i];
                maxIndex = i;
            }
            return maxIndex;
        }
        return this.maxClass();
    }

    public final int numValues() {
        return this.perValue.length;
    }

    public final int numClasses() {
        return this.perClass.length;
    }

    public final double numCorrect() {
        return this.perClass[this.maxClass()];
    }

    public final double numIncorrect() {
        return this.total - this.numCorrect();
    }

    public final double numIncorrect(int index) {
        return this.perValue[index] - this.numCorrect(index);
    }

    public final double numCorrect(int index) {
        return this.perClassPerValue[index][this.maxClass(index)];
    }

    public final double getTotal() {
        return this.total;
    }

    public final double perClassPerValue(int valueIndex, int classIndex) {
        return this.perClassPerValue[valueIndex][classIndex];
    }

    public final double perValue(int valueIndex) {
        return this.perValue[valueIndex];
    }

    public final double perClass(int classIndex) {
        return this.perClass[classIndex];
    }

    public final double probability(int classIndex) {
        if (this.total != 0.0) {
            return this.perClass[classIndex] / this.total;
        }
        return 0.0;
    }

    public final double probability(int classIndex, int attIndex) {
        if (this.perValue[attIndex] > 0.0) {
            return this.perClassPerValue[attIndex][classIndex] / this.perValue[attIndex];
        }
        return this.probability(classIndex);
    }

    public final void shiftRange(int from, int to, Dataset source, int start, int end) {
        for (int i = start; i < end; ++i) {
            Itemset itemset = source.itemset(i);
            int classIndex = (int)itemset.getClassValue();
            double weight = itemset.getWeight();
            double[] dArray = this.perClassPerValue[from];
            int n = classIndex;
            dArray[n] = dArray[n] - weight;
            double[] dArray2 = this.perClassPerValue[to];
            int n2 = classIndex;
            dArray2[n2] = dArray2[n2] + weight;
            int n3 = from;
            this.perValue[n3] = this.perValue[n3] - weight;
            int n4 = to;
            this.perValue[n4] = this.perValue[n4] + weight;
        }
    }
}

