## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")

## ----message=FALSE, echo=F, warning=F-----------------------------------------
# Load SemanticDistance
library(SemanticDistance)

## ----eval=T, message=F, warning=F, echo=F-------------------------------------
knitr::kable(head(Word_Pairs, 5), format = "simple")

## ----message=FALSE------------------------------------------------------------
WordPairs_Clean <- clean_paired_cols(dat=Word_Pairs, wordcol1='word1', wordcol2='word2', lemmatize=TRUE)
knitr::kable(head(WordPairs_Clean, 6), format = "simple", digits=2) 

## ----message=FALSE------------------------------------------------------------
Columns_Dists <- dist_paired_cols(dat=WordPairs_Clean) 
knitr::kable(head(Columns_Dists, 6), format = "simple", digits=2) 

