/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.ExponentialDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class ExponentialGen
extends RandomVariateGen {
    protected double lambda;

    public ExponentialGen(RandomStream s, double lambda) {
        super(s, new ExponentialDist(lambda));
        this.setParams(lambda);
    }

    public ExponentialGen(RandomStream s, ExponentialDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getLambda());
        }
    }

    public static double nextDouble(RandomStream s, double lambda) {
        return ExponentialDist.inverseF(lambda, s.nextDouble());
    }

    public double getLambda() {
        return this.lambda;
    }

    protected void setParams(double lam) {
        if (lam <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.lambda = lam;
    }
}

