## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
#> Install from CRAN (not yet available)
#install.packages("pervasive")

#> Install the development version from GitHub
#devtools::install_github("dlajoiemoncton/pervasive")

#load the package
library(pervasive)


## ----message=FALSE------------------------------------------------------------
#>Example using the spi dataset from the psychTools package. 

#>Big 5 factor scores are calculated as suggested in the psych package documentation. Variables should be scored prior to the analysis.
sc <- psych::scoreVeryFast(psychTools::spi.keys, psychTools::spi)

#>scores for traits are combined to the original dataset
spi_sc <- cbind(psychTools::spi, sc)

#>Let's use age as the outcome of interest and the Big 5 as predictors for the regression models and sex as the outcome for binomial logistic regression models

spi_sc_age_sex_B5 <- spi_sc |>
 dplyr::select(age, sex, Agree, Consc, Neuro, Extra, Open) |> 
  na.omit()

spi_sc_age <- spi_sc_age_sex_B5 |>
dplyr::select(age, Agree, Consc, Neuro, Extra, Open)

spi_sc_sex <- spi_sc_age_sex_B5 |>
 dplyr::select(sex, Agree, Consc, Neuro, Extra, Open)
 
#>The glm() function expects outputs to be coded as 0 and 1 but sex is coded 1 and 2. There are some NAs for sex.
spi_sc_sex$sex = spi_sc_sex$sex -1

## -----------------------------------------------------------------------------
OPCP_mat(spi_sc_age_sex_B5)



## -----------------------------------------------------------------------------
formula <- age ~ Agree + Consc + Neuro + Extra + Open 

formula_glm <- sex ~ Agree + Consc + Neuro + Extra + Open

#>This would also be acceptable: formula <- formula(age ~ Agree + Consc + Neuro + Extra + Open)
#>It is possible to include a single predictor if one is working in a bivariate case 


## -----------------------------------------------------------------------------
OPCP(formula = formula, data = spi_sc_age)
OPCP_glm(formula = formula_glm, data = spi_sc_sex)

## ----message=FALSE------------------------------------------------------------
example <- pervasive_tric(formula = formula, data = spi_sc_age, min_support = .03)

example


#> or print(pervasive_tric(formula = formula, data = spi_sc_age, min_support = .03))

## -----------------------------------------------------------------------------
example$freq_tables

## ----message=FALSE------------------------------------------------------------

example_dic <- pervasive_dic(formula = formula, data = spi_sc_age, min_support = .03)

example_dic

example_dic$freq_tables


## ----message=FALSE------------------------------------------------------------

 example_dic_glm <- pervasive_dic_glm(formula = formula_glm, data = spi_sc_sex, min_support = .03)
 example_dic_glm
 
 example_tric_glm <- pervasive_tric_glm(formula = formula_glm, data = spi_sc_sex, min_support = .03)
 example_tric_glm

