/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff.ui;

import com.qarks.util.files.diff.FileDiffResult;
import com.qarks.util.files.diff.FileLine;
import com.qarks.util.files.diff.ParsedFile;
import com.qarks.util.files.diff.ui.DiffInputDialog;
import com.qarks.util.files.diff.ui.FileDiffMonitorDialog;
import com.qarks.util.files.diff.ui.FileOverview;
import com.qarks.util.files.diff.ui.LineCellRenderer;
import com.qarks.util.files.diff.ui.ResourceKeyDiff;
import com.qarks.util.stream.FileHelper;
import com.qarks.util.ui.CharsetCombo;
import com.qarks.util.ui.DialogUtilities;
import com.qarks.util.ui.resources.ResourceKey;
import com.qarks.util.ui.resources.ResourceManager;
import com.qarks.util.ui.swing.FileDropHandler;
import com.qarks.util.ui.swing.FileDropListener;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class DiffPanel
extends JPanel
implements FileDropListener {
    private JCheckBox ignoreLeadingSpaces;
    private JCheckBox showEndOfLines;
    private CharsetCombo charsetChooser;
    private JList leftFile;
    private DefaultListModel leftFileModel;
    private JList rightFile;
    private DefaultListModel rightFileModel;
    private String leftText;
    private String rightText;
    private File[] files = null;
    private FileOverview leftFileOverview;
    private FileOverview rightFileOverview;
    private JScrollPane scroll1;
    private JScrollPane scroll2;
    private boolean scrolling = false;
    private LineCellRenderer leftRenderer;
    private LineCellRenderer rightRenderer;
    private TitledBorder leftTitleBorder;
    private TitledBorder rightTitleBorder;
    private JPanel diffPanel;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JCheckBox verticalSplit;
    private JPanel optionsPanel;
    private JPanel toolbar;

    public DiffPanel(String string) {
        this.setLayout(new BorderLayout(5, 5));
        this.leftFileModel = new DefaultListModel();
        this.rightFileModel = new DefaultListModel();
        this.leftFile = new JList(this.leftFileModel);
        this.leftRenderer = new LineCellRenderer();
        this.rightRenderer = new LineCellRenderer();
        this.leftFile.setCellRenderer(this.leftRenderer);
        this.rightFile = new JList(this.rightFileModel);
        this.rightFile.setCellRenderer(this.rightRenderer);
        this.scroll1 = new JScrollPane(this.leftFile);
        this.scroll2 = new JScrollPane(this.rightFile);
        this.leftFile.setDragEnabled(true);
        this.rightFile.setDragEnabled(true);
        this.leftFile.setSelectionMode(1);
        this.rightFile.setSelectionMode(1);
        this.leftFileOverview = new FileOverview();
        this.rightFileOverview = new FileOverview();
        this.verticalSplit = new JCheckBox(ResourceManager.getString((Object)ResourceKeyDiff.VERTICAL_SPLIT));
        this.ignoreLeadingSpaces = new JCheckBox(ResourceManager.getString((Object)ResourceKeyDiff.IGNORE_LEADING));
        this.showEndOfLines = new JCheckBox(ResourceManager.getString((Object)ResourceKeyDiff.SHOW_EOL));
        this.charsetChooser = new CharsetCombo();
        this.charsetChooser.select(string);
        this.leftPanel = new JPanel(new BorderLayout(5, 5));
        this.leftPanel.add((Component)this.scroll1, "Center");
        this.leftPanel.add((Component)this.leftFileOverview, "East");
        this.leftTitleBorder = new TitledBorder("-");
        this.leftPanel.setBorder(this.leftTitleBorder);
        this.rightPanel = new JPanel(new BorderLayout(5, 5));
        this.rightPanel.add((Component)this.scroll2, "Center");
        this.rightPanel.add((Component)this.rightFileOverview, "East");
        this.rightTitleBorder = new TitledBorder("-");
        this.rightPanel.setBorder(this.rightTitleBorder);
        this.diffPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        this.diffPanel.add((Component)this.leftPanel, 0);
        this.diffPanel.add((Component)this.rightPanel, 1);
        this.optionsPanel = new JPanel(new BorderLayout(5, 5));
        JLabel jLabel = new JLabel(ResourceManager.getString((Object)ResourceKeyDiff.OPTIONS));
        jLabel.setForeground(Color.blue);
        this.optionsPanel.add((Component)jLabel, "North");
        this.add((Component)this.diffPanel, "Center");
        this.toolbar = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel = new JPanel(new GridLayout(4, 1, 1, 1));
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.add((Component)new JLabel(ResourceManager.getString((Object)ResourceKeyDiff.CURRENT_CHARSET)), "West");
        jPanel2.add((Component)this.charsetChooser, "Center");
        jPanel.add(jPanel2);
        jPanel.add(this.ignoreLeadingSpaces);
        jPanel.add(this.showEndOfLines);
        jPanel.add(this.verticalSplit);
        this.toolbar.add(jPanel);
        this.toolbar.setVisible(false);
        this.optionsPanel.add((Component)this.toolbar, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 5));
        jPanel3.add((Component)this.optionsPanel, "West");
        this.add((Component)jPanel3, "South");
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                if (aWTEvent instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                    boolean bl = DiffPanel.this.isIncluded(DiffPanel.this.optionsPanel, mouseEvent);
                    DiffPanel.this.showOptions(bl);
                }
            }
        }, 32L);
        this.leftFile.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                DiffPanel.this.rightFile.getSelectionModel().clearSelection();
            }
        });
        this.rightFile.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                DiffPanel.this.leftFile.getSelectionModel().clearSelection();
            }
        });
        this.verticalSplit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DiffPanel.this.verticalSplit.isSelected()) {
                    DiffPanel.this.diffPanel.setLayout(new GridLayout(2, 1, 5, 5));
                } else {
                    DiffPanel.this.diffPanel.setLayout(new GridLayout(1, 2, 5, 5));
                }
                DiffPanel.this.diffPanel.invalidate();
                DiffPanel.this.validate();
            }
        });
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DiffPanel.this.runDiff();
            }
        };
        this.ignoreLeadingSpaces.addItemListener(itemListener);
        this.charsetChooser.addItemListener(itemListener);
        this.showEndOfLines.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DiffPanel.this.leftRenderer.setShowEndOfLines(DiffPanel.this.showEndOfLines.isSelected());
                DiffPanel.this.rightRenderer.setShowEndOfLines(DiffPanel.this.showEndOfLines.isSelected());
                DiffPanel.this.repaint();
            }
        });
        this.scroll1.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (!DiffPanel.this.scrolling) {
                    DiffPanel.this.scrolling = true;
                    DiffPanel.this.scroll2.getVerticalScrollBar().setValue(DiffPanel.this.scroll1.getVerticalScrollBar().getValue());
                    DiffPanel.this.scrolling = false;
                }
            }
        });
        this.scroll2.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (!DiffPanel.this.scrolling) {
                    DiffPanel.this.scrolling = true;
                    DiffPanel.this.scroll1.getVerticalScrollBar().setValue(DiffPanel.this.scroll2.getVerticalScrollBar().getValue());
                    DiffPanel.this.scrolling = false;
                }
            }
        });
        this.scroll1.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (!DiffPanel.this.scrolling) {
                    DiffPanel.this.scrolling = true;
                    DiffPanel.this.scroll2.getHorizontalScrollBar().setValue(DiffPanel.this.scroll1.getHorizontalScrollBar().getValue());
                    DiffPanel.this.scrolling = false;
                }
            }
        });
        this.scroll2.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (!DiffPanel.this.scrolling) {
                    DiffPanel.this.scrolling = true;
                    DiffPanel.this.scroll1.getHorizontalScrollBar().setValue(DiffPanel.this.scroll2.getHorizontalScrollBar().getValue());
                    DiffPanel.this.scrolling = false;
                }
            }
        });
    }

    private void showOptions(boolean bl) {
        this.toolbar.setVisible(bl);
        this.optionsPanel.invalidate();
        this.validate();
    }

    private boolean isIncluded(Container container, MouseEvent mouseEvent) {
        boolean bl = false;
        if (this.optionsPanel.isShowing()) {
            Point point = mouseEvent.getLocationOnScreen();
            Point point2 = this.optionsPanel.getLocationOnScreen();
            Dimension dimension = this.optionsPanel.getSize();
            if (point.x > point2.x && point.x < point2.x + dimension.width && point.y > point2.y && point.y < point2.y + dimension.height) {
                bl = true;
            }
        }
        return bl;
    }

    public Charset getSelectedCharset() {
        return this.charsetChooser.getSelectedCharset();
    }

    public void enableFileDrop() {
        FileDropHandler.addFileDropListener(this.leftFile, this);
        FileDropHandler.addFileDropListener(this.rightFile, this);
    }

    @Override
    public void onFileDropped(File[] fileArray) {
        try {
            if (fileArray.length == 2) {
                this.leftText = FileHelper.getFileContent(fileArray[0], this.getSelectedCharset().name());
                this.rightText = FileHelper.getFileContent(fileArray[1], this.getSelectedCharset().name());
                this.leftTitleBorder.setTitle(fileArray[0].getName());
                this.rightTitleBorder.setTitle(fileArray[1].getName());
                this.repaint();
                this.runDiff();
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{ResourceManager.getString((Object)ResourceKey.OK)};
            JOptionPane.showOptionDialog(this, exception.getMessage(), ResourceManager.getString((Object)ResourceKeyDiff.DIFF), -1, 0, null, objectArray, objectArray[0]);
        }
    }

    public void openInputDialog(Window window, String string, String string2) {
        DiffInputDialog diffInputDialog = new DiffInputDialog(window, string, string2);
        DialogUtilities.centerWindow(diffInputDialog, window);
        if (!diffInputDialog.isCancelled()) {
            File file = new File(diffInputDialog.getLeftFilePath());
            File file2 = new File(diffInputDialog.getRightFilePath());
            this.onFileDropped(new File[]{file, file2});
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Font font = this.getFont();
        int n = this.getFontMetrics(font).getHeight();
        this.leftFile.setFixedCellHeight(n);
        this.rightFile.setFixedCellHeight(n);
        this.leftRenderer.setFont(font.deriveFont(0));
        this.rightRenderer.setFont(font.deriveFont(0));
    }

    public void setContent(FileDiffResult fileDiffResult) {
        this.leftFileModel.clear();
        this.rightFileModel.clear();
        ParsedFile parsedFile = fileDiffResult.getLeftFile();
        ParsedFile parsedFile2 = fileDiffResult.getRightFile();
        for (FileLine fileLine : parsedFile.getLines()) {
            this.leftFileModel.addElement(fileLine);
        }
        for (FileLine fileLine : parsedFile2.getLines()) {
            this.rightFileModel.addElement(fileLine);
        }
        this.leftFileOverview.setParsedFile(parsedFile);
        this.rightFileOverview.setParsedFile(parsedFile2);
        this.repaint();
    }

    public void launchDiff(File file, File file2) {
        this.onFileDropped(new File[]{file, file2});
    }

    public void launchDiff(String string, String string2, String string3, String string4) {
        this.leftText = string2;
        this.rightText = string4;
        this.leftTitleBorder.setTitle(string);
        this.rightTitleBorder.setTitle(string3);
        this.repaint();
        this.runDiff();
    }

    private void runDiff() {
        if (this.leftText == null || this.rightText == null) {
            return;
        }
        try {
            this.leftFileModel.clear();
            this.rightFileModel.clear();
            Window window = SwingUtilities.getWindowAncestor(this.leftFile);
            FileDiffMonitorDialog fileDiffMonitorDialog = new FileDiffMonitorDialog(window, this.leftText, this.rightText, this.ignoreLeadingSpaces.isSelected(), this);
            fileDiffMonitorDialog.start();
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{"Ok"};
            JOptionPane.showOptionDialog(this, "An error occured while comparing files: " + exception.getMessage(), "Diff", -1, 0, null, objectArray, objectArray[0]);
        }
    }
}

