/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;

public class FieldNameUtil {
    private FieldNameUtil() {
    }

    public static String create(DataType dataType, Object ... args) {
        return FieldNameUtil.create(dataType.name().toLowerCase(), args);
    }

    public static String create(OpType opType, Object ... args) {
        return FieldNameUtil.create(opType.name().toLowerCase(), args);
    }

    public static String create(DefineFunction defineFunction, Object ... args) {
        return FieldNameUtil.create(defineFunction.requireName(), args);
    }

    public static String create(String function, Object ... args) {
        return FieldNameUtil.format(function, Arrays.asList(args));
    }

    public static String create(String function, List<?> args) {
        return FieldNameUtil.format(function, args);
    }

    public static String select(String name, int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        return name + "[" + index + "]";
    }

    private static String format(String function, List<?> args) {
        if (args == null || args.isEmpty()) {
            return function;
        }
        Stream<Object> argStream = args.size() <= 5 ? args.stream() : Stream.of(args.subList(0, 2).stream(), Stream.of(".."), args.subList(args.size() - 2, args.size()).stream()).flatMap(x -> x);
        return argStream.map(FieldNameUtil::toString).collect(Collectors.joining(", ", function + "(", ")"));
    }

    private static String toString(Object object) {
        if (object instanceof Feature) {
            Feature feature = (Feature)object;
            object = FeatureUtil.getName(feature);
        }
        return String.valueOf(object);
    }
}

