/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import gnu.trove.set.hash.TIntHashSet;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.set.PropCardinality;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.delta.SetDelta;
import org.chocosolver.solver.variables.delta.monitor.SetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.solver.variables.impl.scheduler.SetEvtScheduler;
import org.chocosolver.util.iterators.EvtScheduler;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.objects.setDataStructures.Set_ReadOnly;

public class SetVarImpl
extends AbstractVariable
implements SetVar {
    private final ISet lb;
    private final ISet ub;
    private final ISet lbReadOnly;
    private final ISet ubReadOnly;
    private SetDelta delta;
    private boolean reactOnModification;
    private IntVar cardinality = null;

    public SetVarImpl(String name, int[] ker, SetType kerType, int[] env, SetType envType, Model model) {
        super(name, model);
        ker = new TIntHashSet(ker).toArray();
        env = new TIntHashSet(env).toArray();
        int offSet = env.length > 0 ? env[0] : 0;
        for (int i : env) {
            offSet = Math.min(offSet, i);
        }
        this.lb = SetFactory.makeStoredSet(kerType, offSet, model);
        this.ub = SetFactory.makeStoredSet(envType, offSet, model);
        this.lbReadOnly = new Set_ReadOnly(this.lb);
        this.ubReadOnly = new Set_ReadOnly(this.ub);
        for (int i : env) {
            this.ub.add(i);
        }
        for (int i : ker) {
            this.lb.add(i);
            if (this.ub.contains(i)) continue;
            throw new UnsupportedOperationException("Invalid SetVar domain definition : " + i + " is in the LB but not in the UB.");
        }
    }

    public SetVarImpl(String name, ISet lb, ISet ub, Model model) {
        super(name, model);
        this.lb = lb;
        this.ub = ub;
        this.lbReadOnly = new Set_ReadOnly(lb);
        this.ubReadOnly = new Set_ReadOnly(ub);
        ISetIterator iSetIterator = lb.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (ub.contains(i)) continue;
            throw new UnsupportedOperationException("Invalid SetVar domain definition : " + i + " is in the LB but not in the UB.");
        }
    }

    public SetVarImpl(String name, ISet value, Model model) {
        super(name, model);
        this.ub = this.lb = value;
        this.lbReadOnly = new Set_ReadOnly(this.lb);
        this.ubReadOnly = new Set_ReadOnly(this.ub);
    }

    public SetVarImpl(String name, int[] value, Model model) {
        super(name, model);
        this.ub = this.lb = SetFactory.makeConstantSet(new TIntHashSet(value).toArray());
        this.lbReadOnly = new Set_ReadOnly(this.lb);
        this.ubReadOnly = new Set_ReadOnly(this.ub);
    }

    @Override
    public boolean isInstantiated() {
        return this.ub.size() == this.lb.size();
    }

    @Override
    public ISet getLB() {
        return this.lbReadOnly;
    }

    @Override
    public ISet getUB() {
        return this.ubReadOnly;
    }

    @Override
    public IntVar getCard() {
        if (!this.hasCard()) {
            int lbc;
            int ubc = this.ub.size();
            if (ubc == (lbc = this.lb.size())) {
                this.cardinality = this.model.intVar(ubc);
            } else {
                this.cardinality = this.model.intVar(this.name + ".card", lbc, ubc);
                new Constraint("SETCARD", new PropCardinality(this, this.cardinality)).post();
            }
        }
        return this.cardinality;
    }

    @Override
    public boolean hasCard() {
        return this.cardinality != null;
    }

    @Override
    public void setCard(IntVar card) {
        if (!this.hasCard()) {
            this.cardinality = card;
            new Constraint("SETCARD", new PropCardinality(this, card)).post();
        } else {
            this.model.arithm(this.cardinality, "=", card).post();
        }
    }

    @Override
    public boolean force(int element, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (!this.ub.contains(element)) {
            this.contradiction(cause, "");
            return true;
        }
        if (this.lb.add(element)) {
            if (this.reactOnModification) {
                this.delta.add(element, 0, cause);
            }
            SetEventType e = SetEventType.ADD_TO_KER;
            this.notifyPropagators(e, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(int element, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (this.lb.contains(element)) {
            this.contradiction(cause, "");
            return true;
        }
        if (this.ub.remove(element)) {
            if (this.reactOnModification) {
                this.delta.add(element, 1, cause);
            }
            SetEventType e = SetEventType.REMOVE_FROM_ENVELOPE;
            this.notifyPropagators(e, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean instantiateTo(int[] value, ICause cause) throws ContradictionException {
        boolean changed = !this.isInstantiated();
        for (int i : value) {
            this.force(i, cause);
        }
        if (this.lb.size() != value.length) {
            this.contradiction(cause, "");
        }
        if (this.ub.size() != value.length) {
            Object object = this.getUB().iterator();
            while (object.hasNext()) {
                int i = (Integer)object.next();
                if (this.getLB().contains(i)) continue;
                this.remove(i, cause);
            }
        }
        return changed;
    }

    @Override
    public ISetDeltaMonitor monitorDelta(ICause propagator) {
        this.createDelta();
        return new SetDeltaMonitor(this.getDelta(), propagator);
    }

    @Override
    public SetDelta getDelta() {
        return this.delta;
    }

    @Override
    public int getTypeAndKind() {
        return 33;
    }

    protected EvtScheduler createScheduler() {
        return new SetEvtScheduler();
    }

    @Override
    public String toString() {
        if (this.isInstantiated()) {
            return this.getName() + " = " + this.getLB().toString();
        }
        return this.getName() + " = [" + this.getLB() + ", " + this.getUB() + "]";
    }

    @Override
    public void createDelta() {
        if (!this.reactOnModification) {
            this.reactOnModification = true;
            this.delta = new SetDelta(this.model.getEnvironment());
        }
    }
}

