/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import java.util.ArrayList;
import java.util.BitSet;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class PropTableStr2
extends Propagator<IntVar> {
    private final int[][] table;
    private final Str2_var[] str2vars;
    private final ISet tuples;
    private final ArrayList<Str2_var> ssup;
    private final ArrayList<Str2_var> sval;
    private boolean firstProp = true;
    private final Tuples tuplesObject;
    private final int star;

    public PropTableStr2(IntVar[] vars_, Tuples tuplesObject) {
        super((Variable[])vars_, (Priority)PropagatorPriority.LINEAR, false);
        this.table = tuplesObject.toMatrix();
        this.tuplesObject = tuplesObject;
        int size = 0;
        if (this.table.length > 0) {
            size = this.table[0].length;
        }
        this.str2vars = new Str2_var[size];
        int max = 0;
        for (int i = 0; i < size; ++i) {
            this.str2vars[i] = new Str2_var(this.model.getEnvironment(), vars_[i], i);
            max = Math.max(max, vars_[i].getUB());
        }
        this.star = tuplesObject.allowUniversalValue() ? tuplesObject.getStarValue() : max + 1;
        this.tuples = SetFactory.makeStoredSet(SetType.BIPARTITESET, 0, this.model);
        this.ssup = new ArrayList();
        this.sval = new ArrayList();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.firstProp) {
            this.firstProp = false;
            this.model.getEnvironment().save(() -> {
                this.firstProp = true;
            });
            this.initialPropagate();
        }
        this.Filter();
    }

    @Override
    public ESat isEntailed() {
        if (this.firstProp) {
            return this.tuplesObject.check((IntVar[])this.vars);
        }
        boolean hasSupport = false;
        ISetIterator iSetIterator = this.tuples.iterator();
        while (iSetIterator.hasNext()) {
            int tuple = (Integer)iSetIterator.next();
            if (!this.is_tuple_supported(tuple)) continue;
            hasSupport = true;
        }
        if (hasSupport) {
            if (this.isCompletelyInstantiated()) {
                return ESat.TRUE;
            }
            return ESat.UNDEFINED;
        }
        return ESat.FALSE;
    }

    @Override
    public String toString() {
        return "STR2 table constraint with " + ((IntVar[])this.vars).length + "vars and " + this.table.length + "tuples";
    }

    private boolean is_tuple_supported(int tuple_index) {
        for (int i = 0; i < this.sval.size(); ++i) {
            Str2_var v = this.sval.get(i);
            if (this.table[tuple_index][v.index] == this.star || v.var.contains(this.table[tuple_index][v.index])) continue;
            return false;
        }
        return true;
    }

    private void initialPropagate() throws ContradictionException {
        for (int t = 0; t < this.table.length; ++t) {
            this.tuples.add(t);
        }
        if (this.tuples.isEmpty()) {
            this.fails();
        }
    }

    private void Filter() throws ContradictionException {
        this.ssup.clear();
        this.sval.clear();
        for (int i = 0; i < this.str2vars.length; ++i) {
            Str2_var tmp = this.str2vars[i];
            this.ssup.add(tmp);
            tmp.reset();
            if (tmp.last_size.get() == tmp.cnt) continue;
            this.sval.add(tmp);
            tmp.last_size.set(tmp.cnt);
        }
        ISetIterator i = this.tuples.iterator();
        while (i.hasNext()) {
            int tuple = (Integer)i.next();
            if (this.is_tuple_supported(tuple)) {
                for (int var = 0; var < this.ssup.size(); ++var) {
                    Str2_var v = this.ssup.get(var);
                    int a2 = this.table[tuple][v.index];
                    if (a2 == this.star) {
                        v.cnt = 0;
                        this.ssup.set(var, this.ssup.get(this.ssup.size() - 1));
                        this.ssup.remove(this.ssup.size() - 1);
                        --var;
                        continue;
                    }
                    if (v.ac.get(a2 - v.offset)) continue;
                    v.ac.set(a2 - v.offset);
                    if (--v.cnt != 0) continue;
                    this.ssup.set(var, this.ssup.get(this.ssup.size() - 1));
                    this.ssup.remove(this.ssup.size() - 1);
                    --var;
                }
                continue;
            }
            this.tuples.remove(tuple);
        }
        for (int i2 = 0; i2 < this.ssup.size(); ++i2) {
            this.ssup.get(i2).remove_unsupported_value(this);
        }
    }

    private static class Str2_var {
        private final IntVar var;
        private final int index;
        private final IStateInt last_size;
        private final BitSet ac;
        private int offset;
        private int cnt;

        private Str2_var(IEnvironment env, IntVar var_, int index_) {
            this.var = var_;
            this.last_size = env.makeInt(0);
            this.index = index_;
            this.ac = new BitSet();
        }

        private void reset() {
            this.ac.clear();
            this.offset = this.var.getLB();
            this.cnt = this.var.getDomainSize();
        }

        private void remove_unsupported_value(ICause cause) throws ContradictionException {
            int val = this.var.getLB();
            while (this.cnt > 0 && val <= this.var.getUB()) {
                if (!this.ac.get(val - this.offset)) {
                    this.var.removeValue(val, cause);
                    --this.cnt;
                }
                val = this.var.nextValue(val);
            }
        }
    }
}

