/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.cost.tsp;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropCycleCostSimple
extends Propagator<Variable> {
    protected UndirectedGraphVar g;
    protected int n;
    protected IntVar sum;
    protected int[][] distMatrix;
    protected int[] replacementCost;

    public PropCycleCostSimple(UndirectedGraphVar graph, IntVar obj, int[][] costMatrix) {
        super(new Variable[]{graph, obj}, (Priority)PropagatorPriority.LINEAR, false);
        this.g = graph;
        this.sum = obj;
        this.n = this.g.getNbMaxNodes();
        this.distMatrix = costMatrix;
        this.replacementCost = new int[this.n];
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return GraphEventType.REMOVE_EDGE.getMask() + GraphEventType.ADD_EDGE.getMask();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public ESat isEntailed() {
        int minSum = 0;
        int maxSum = 0;
        for (int i = 0; i < this.n; ++i) {
            ISet env = this.g.getPotentialNeighborsOf(i);
            ISet ker = this.g.getMandatoryNeighborsOf(i);
            ISetIterator iSetIterator = env.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (i > j) continue;
                maxSum += this.distMatrix[i][j];
                if (!ker.contains(j)) continue;
                minSum += this.distMatrix[i][j];
            }
        }
        if (maxSum < 0) {
            maxSum = Integer.MAX_VALUE;
        }
        if (minSum > this.sum.getUB() || maxSum < this.sum.getLB()) {
            return ESat.FALSE;
        }
        if (maxSum == minSum && this.sum.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int minSum = 0;
        int maxSum = 0;
        for (int i = 0; i < this.n; ++i) {
            minSum += this.findTwoBest(i);
            maxSum += this.findTwoWorst(i);
        }
        if (maxSum % 2 != 0) {
            ++maxSum;
        }
        if (minSum % 2 != 0) {
            --minSum;
        }
        minSum /= 2;
        if ((maxSum /= 2) < 0) {
            maxSum = Integer.MAX_VALUE;
        }
        this.sum.updateLowerBound(minSum, (ICause)this);
        this.sum.updateUpperBound(maxSum, (ICause)this);
        this.filter(minSum);
    }

    protected void filter(int minSum) throws ContradictionException {
        int delta = this.sum.getUB() - minSum;
        for (int i = 0; i < this.n; ++i) {
            ISet succs = this.g.getPotentialNeighborsOf(i);
            ISetIterator iSetIterator = succs.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (i >= j || this.g.getMandatoryNeighborsOf(i).contains(j)) continue;
                if (this.replacementCost[i] == -1 || this.replacementCost[j] == -1) {
                    this.g.removeEdge(i, j, this);
                }
                if ((2 * this.distMatrix[i][j] - this.replacementCost[i] - this.replacementCost[j]) / 2 <= delta) continue;
                this.g.removeEdge(i, j, this);
            }
        }
    }

    protected int findTwoBest(int i) throws ContradictionException {
        int cost;
        if (this.g.getMandatoryNeighborsOf(i).isEmpty()) {
            int cost2;
            int mc1 = this.getBestNot(i, -2);
            this.replacementCost[i] = cost2 = this.distMatrix[i][this.getBestNot(i, mc1)];
            return this.distMatrix[i][mc1] + cost2;
        }
        ISetIterator it = this.g.getMandatoryNeighborsOf(i).iterator();
        int mc1 = (Integer)it.next();
        if (it.hasNext()) {
            int mc2 = (Integer)it.next();
            this.replacementCost[i] = -1;
            return this.distMatrix[i][mc1] + this.distMatrix[i][mc2];
        }
        this.replacementCost[i] = cost = this.distMatrix[i][this.getBestNot(i, mc1)];
        return this.distMatrix[i][mc1] + cost;
    }

    protected int getBestNot(int i, int not) throws ContradictionException {
        ISet nei = this.g.getPotentialNeighborsOf(i);
        int cost = -1;
        int idx = -1;
        ISetIterator iSetIterator = nei.iterator();
        while (iSetIterator.hasNext()) {
            int j = (Integer)iSetIterator.next();
            if (j == not || idx != -1 && cost <= this.distMatrix[i][j]) continue;
            idx = j;
            cost = this.distMatrix[i][j];
        }
        if (idx == -1) {
            this.fails();
        }
        return idx;
    }

    protected int findTwoWorst(int i) throws ContradictionException {
        if (this.g.getMandatoryNeighborsOf(i).isEmpty()) {
            int mc1 = this.getWorstNot(i, -2);
            return this.distMatrix[i][mc1] + this.distMatrix[i][this.getWorstNot(i, mc1)];
        }
        ISetIterator it = this.g.getMandatoryNeighborsOf(i).iterator();
        int mc1 = (Integer)it.next();
        if (it.hasNext()) {
            return this.distMatrix[i][mc1] + this.distMatrix[i][(Integer)it.next()];
        }
        return this.distMatrix[i][mc1] + this.distMatrix[i][this.getWorstNot(i, mc1)];
    }

    protected int getWorstNot(int i, int not) throws ContradictionException {
        ISet nei = this.g.getPotentialNeighborsOf(i);
        int cost = -1;
        int idx = -1;
        ISetIterator iSetIterator = nei.iterator();
        while (iSetIterator.hasNext()) {
            int j = (Integer)iSetIterator.next();
            if (j == not || idx != -1 && cost >= this.distMatrix[i][j]) continue;
            idx = j;
            cost = this.distMatrix[i][j];
        }
        if (idx == -1) {
            this.fails();
        }
        return idx;
    }
}

