/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

import java.lang.ref.WeakReference;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DefaultAttribute;
import org.vikamine.kernel.data.IDataRecordSet;
import org.vikamine.kernel.data.SingleValue;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.util.DistinctionFinder;
import org.vikamine.kernel.util.VKMUtil;

public class DateAttribute
extends DefaultAttribute {
    static final String ARFF_ATTRIBUTE_DATE_IDENTIFIER = "date";
    private SimpleDateFormat dateFormat;
    private BitSet usedInstancesForAttributeValues;
    private WeakReference<IDataRecordSet> weakDatasetReference;

    public DateAttribute(String attributeName) {
        this(attributeName, null);
    }

    public DateAttribute(String id, String dateFormat) {
        super(id);
        this.dateFormat = dateFormat != null ? new SimpleDateFormat(dateFormat) : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.dateFormat.setLenient(false);
    }

    @Override
    public DateAttribute copy() {
        DateAttribute copiedDateAttribute = new DateAttribute(this.getId());
        copiedDateAttribute.usedInstancesForAttributeValues = this.usedInstancesForAttributeValues;
        copiedDateAttribute.weakDatasetReference = this.weakDatasetReference;
        return copiedDateAttribute;
    }

    private void createUsedInstancesForAttributeValues() {
        this.usedInstancesForAttributeValues = new BitSet();
        LinkedList<Integer> sortedInstances = new LinkedList<Integer>();
        int i = 0;
        while (i < ((IDataRecordSet)this.weakDatasetReference.get()).getNumInstances()) {
            sortedInstances.add(i);
            ++i;
        }
        Collections.sort(sortedInstances, new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                DataRecord inst1 = ((IDataRecordSet)DateAttribute.this.weakDatasetReference.get()).get(i1);
                DataRecord inst2 = ((IDataRecordSet)DateAttribute.this.weakDatasetReference.get()).get(i2);
                return Double.compare(inst1.getValue(DateAttribute.this), inst2.getValue(DateAttribute.this));
            }
        });
        DistinctionFinder distinct = new DistinctionFinder();
        int previous = 0;
        Iterator iter = sortedInstances.iterator();
        while (iter.hasNext()) {
            int i2 = (Integer)iter.next();
            DataRecord inst = ((IDataRecordSet)this.weakDatasetReference.get()).get(i2);
            distinct.addValue(inst.getValue(this));
            if (distinct.isNewValue()) {
                this.usedInstancesForAttributeValues.set(previous);
            }
            previous = i2;
        }
        this.usedInstancesForAttributeValues.set(previous);
    }

    public String formatDate(double date) {
        return this.dateFormat.format(new Date((long)date));
    }

    @Override
    public double getValue(DataRecord instance) {
        return instance.getValue(instance.getDataset().getIndex(this));
    }

    @Override
    public boolean isDate() {
        return true;
    }

    @Override
    public boolean isMissingValue(DataRecord record) {
        return Value.isMissingValue(record.getValue(this));
    }

    public double parseDate(String string) throws ParseException {
        long time = this.dateFormat.parse(string).getTime();
        return time;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("@attribute").append(" ").append(VKMUtil.quote(this.getId())).append(" ");
        text.append(ARFF_ATTRIBUTE_DATE_IDENTIFIER).append(" ").append(VKMUtil.quote(this.dateFormat.toPattern()));
        return text.toString();
    }

    @Override
    public Iterator<Value> usedValuesIterator(IDataRecordSet dataset) {
        if (this.usedInstancesForAttributeValues == null || this.weakDatasetReference == null || !((IDataRecordSet)this.weakDatasetReference.get()).equals(dataset)) {
            this.weakDatasetReference = new WeakReference<IDataRecordSet>(dataset);
            this.createUsedInstancesForAttributeValues();
        }
        class NumericIterator
        implements Iterator<Value> {
            int currentBit = -1;

            NumericIterator() {
                this.nextBit();
            }

            @Override
            public boolean hasNext() {
                return this.currentBit != -1 && this.currentBit < DateAttribute.this.usedInstancesForAttributeValues.size();
            }

            @Override
            public SingleValue next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("no more elements");
                }
                DataRecord inst = ((IDataRecordSet)DateAttribute.this.weakDatasetReference.get()).get(this.currentBit);
                this.nextBit();
                double value = inst.getValue(DateAttribute.this);
                long ms = (long)value;
                return SingleValue.createSimpleSingleValue(DateAttribute.this, value, Long.toString(ms));
            }

            private void nextBit() {
                do {
                    ++this.currentBit;
                } while (!DateAttribute.this.usedInstancesForAttributeValues.get(this.currentBit) && this.currentBit < DateAttribute.this.usedInstancesForAttributeValues.size());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported");
            }
        }
        return new NumericIterator();
    }
}

