/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import java.util.HashSet;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGStatistics;
import org.vikamine.kernel.subgroup.quality.AbstractQFStatisticBased;
import org.vikamine.kernel.util.VKMUtil;

public class DyadicWeightedLiftCompletedQF
extends AbstractQFStatisticBased {
    private static final String ID = "DyadicWeightedLiftQF";
    private static final String NAME = "DyadicWeightedLiftQF";

    @Override
    public String getID() {
        return "DyadicWeightedLiftQF";
    }

    @Override
    public String getName() {
        return "DyadicWeightedLiftQF";
    }

    @Override
    public AbstractQFStatisticBased clone() {
        return new DyadicWeightedLiftCompletedQF();
    }

    @Override
    public boolean isApplicable(SG subgroup) {
        return true;
    }

    @Override
    public double evaluate(SGStatistics statistics) {
        SG subgroup = statistics.getSubgroup();
        double weightedObservedDyads = statistics.getTargetQuantitySG() * statistics.getSubgroupSize();
        HashSet<String> nodes = new HashSet<String>();
        for (DataRecord record : subgroup) {
            String valSrc = ((NominalAttribute)record.getDataset().getAttribute(0)).getNominalValue(record).getId();
            String valDst = ((NominalAttribute)record.getDataset().getAttribute(1)).getNominalValue(record).getId();
            nodes.add(valSrc);
            nodes.add(valDst);
        }
        int count = nodes.size();
        double expectedDyads = VKMUtil.asList(subgroup.subgroupInstanceIterator()).size();
        return Math.abs(weightedObservedDyads / expectedDyads);
    }
}

