/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.distribution.GammaStatisticsProvider;
import dr.inference.distribution.ParametricMultivariateDistributionModel;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.GammaDistribution;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.Reportable;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class MultivariateGammaLikelihood
extends AbstractModelLikelihood
implements ParametricMultivariateDistributionModel,
GradientWrtParameterProvider,
GammaStatisticsProvider,
Reportable {
    protected final Parameter shape;
    protected final Parameter scale;
    protected final Parameter data;
    protected final int dim;
    public static final String TYPE = "multivariateGamma";
    private static final String SCALE = "scale";
    private static final String SHAPE = "shape";
    private static final String DATA = "data";
    private static final String MULTIVARIATE_GAMMA_LIKELIHOOD = "multivariateGammaLikelihood";
    public static final AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter = (Parameter)xMLObject.getChild(MultivariateGammaLikelihood.DATA).getChild(Parameter.class);
            Parameter parameter2 = (Parameter)xMLObject.getChild(MultivariateGammaLikelihood.SHAPE).getChild(Parameter.class);
            Parameter parameter3 = (Parameter)xMLObject.getChild(MultivariateGammaLikelihood.SCALE).getChild(Parameter.class);
            if (parameter.getDimension() != parameter2.getDimension() || parameter.getDimension() != parameter3.getDimension()) {
                throw new XMLParseException("All parameters must have the same dimension. The components currently have the following dimensions:\n\tdata: " + parameter.getDimension() + "\n\t" + MultivariateGammaLikelihood.SHAPE + ": " + parameter2.getDimension() + "\n\t" + MultivariateGammaLikelihood.SCALE + ": " + parameter3.getDimension() + "\n");
            }
            return new MultivariateGammaLikelihood(MultivariateGammaLikelihood.MULTIVARIATE_GAMMA_LIKELIHOOD, parameter2, parameter3, parameter);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(MultivariateGammaLikelihood.DATA, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule(MultivariateGammaLikelihood.SCALE, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule(MultivariateGammaLikelihood.SHAPE, new XMLSyntaxRule[]{new ElementRule(Parameter.class)})};
        }

        @Override
        public String getParserDescription() {
            return "independent gamma distributions with common parameter";
        }

        @Override
        public Class getReturnType() {
            return MultivariateGammaLikelihood.class;
        }

        @Override
        public String getParserName() {
            return MultivariateGammaLikelihood.MULTIVARIATE_GAMMA_LIKELIHOOD;
        }
    };

    public MultivariateGammaLikelihood(String string, Parameter parameter, Parameter parameter2, Parameter parameter3) {
        super(string);
        this.data = parameter3;
        this.shape = parameter;
        this.scale = parameter2;
        this.dim = parameter3.getDimension();
        this.addVariable(parameter);
        this.addVariable(parameter2);
        this.addVariable(parameter3);
    }

    @Override
    public double[] nextRandom() {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public Variable<Double> getLocationVariable() {
        throw new RuntimeException("not implemented");
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    public double logPdf(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            d += GammaDistribution.logPdf(dArray[i], this.shape.getParameterValue(i), this.scale.getParameterValue(i));
        }
        return d;
    }

    @Override
    public double[][] getScaleMatrix() {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public double[] getMean() {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Likelihood getLikelihood() {
        return this;
    }

    @Override
    public Parameter getParameter() {
        return this.data;
    }

    @Override
    public int getDimension() {
        return this.dim;
    }

    @Override
    public double[] getGradientLogDensity() {
        double[] dArray = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            dArray[i] = GammaDistribution.gradLogPdf(this.data.getParameterValue(i), this.shape.getParameterValue(i), this.scale.getParameterValue(i));
        }
        return dArray;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        double[] dArray = this.data.getParameterValues();
        return this.logPdf(dArray);
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public double getShape(int n) {
        return this.shape.getParameterValue(n);
    }

    @Override
    public double getRate(int n) {
        return 1.0 / this.scale.getParameterValue(n);
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder("MultivariateGammaLikelihood report:\n");
        double d = this.getLogLikelihood();
        stringBuilder.append("\tloglikelihood: " + d + "\n");
        double[] dArray = this.getGradientLogDensity();
        stringBuilder.append("\tgradient:");
        for (int i = 0; i < this.dim; ++i) {
            stringBuilder.append(" " + dArray[i]);
        }
        stringBuilder.append("\n\n");
        return stringBuilder.toString();
    }
}

