/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.DigitalSequence;

public class FaureSequence
extends DigitalSequence {
    private static final int MAXDIM = 500;
    private int[][][] v;
    static final int[] primes = new int[]{1, 2, 3, 5, 5, 7, 7, 11, 11, 11, 11, 13, 13, 17, 17, 17, 17, 19, 19, 23, 23, 23, 23, 29, 29, 29, 29, 29, 29, 31, 31, 37, 37, 37, 37, 37, 37, 41, 41, 41, 41, 43, 43, 47, 47, 47, 47, 53, 53, 53, 53, 53, 53, 59, 59, 59, 59, 59, 59, 61, 61, 67, 67, 67, 67, 67, 67, 71, 71, 71, 71, 73, 73, 79, 79, 79, 79, 79, 79, 83, 83, 83, 83, 89, 89, 89, 89, 89, 89, 97, 97, 97, 97, 97, 97, 97, 97, 101, 101, 101, 101, 103, 103, 107, 107, 107, 107, 109, 109, 113, 113, 113, 113, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 131, 131, 131, 131, 137, 137, 137, 137, 137, 137, 139, 139, 149, 149, 149, 149, 149, 149, 149, 149, 149, 149, 151, 151, 157, 157, 157, 157, 157, 157, 163, 163, 163, 163, 163, 163, 167, 167, 167, 167, 173, 173, 173, 173, 173, 173, 179, 179, 179, 179, 179, 179, 181, 181, 191, 191, 191, 191, 191, 191, 191, 191, 191, 191, 193, 193, 197, 197, 197, 197, 199, 199, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 227, 227, 227, 227, 229, 229, 233, 233, 233, 233, 239, 239, 239, 239, 239, 239, 241, 241, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 257, 257, 257, 257, 257, 257, 263, 263, 263, 263, 263, 263, 269, 269, 269, 269, 269, 269, 271, 271, 277, 277, 277, 277, 277, 277, 281, 281, 281, 281, 283, 283, 293, 293, 293, 293, 293, 293, 293, 293, 293, 293, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 311, 311, 311, 311, 313, 313, 317, 317, 317, 317, 331, 331, 331, 331, 331, 331, 331, 331, 331, 331, 331, 331, 331, 331, 337, 337, 337, 337, 337, 337, 347, 347, 347, 347, 347, 347, 347, 347, 347, 347, 349, 349, 353, 353, 353, 353, 359, 359, 359, 359, 359, 359, 367, 367, 367, 367, 367, 367, 367, 367, 373, 373, 373, 373, 373, 373, 379, 379, 379, 379, 379, 379, 383, 383, 383, 383, 389, 389, 389, 389, 389, 389, 397, 397, 397, 397, 397, 397, 397, 397, 401, 401, 401, 401, 409, 409, 409, 409, 409, 409, 409, 409, 419, 419, 419, 419, 419, 419, 419, 419, 419, 419, 421, 421, 431, 431, 431, 431, 431, 431, 431, 431, 431, 431, 433, 433, 439, 439, 439, 439, 439, 439, 443, 443, 443, 443, 449, 449, 449, 449, 449, 449, 457, 457, 457, 457, 457, 457, 457, 457, 461, 461, 461, 461, 463, 463, 467, 467, 467, 467, 479, 479, 479, 479, 479, 479, 479, 479, 479, 479, 479, 479, 487, 487, 487, 487, 487, 487, 487, 487, 491, 491, 491, 491, 499, 499, 499, 499, 499, 499, 499, 499, 503};

    public FaureSequence(int n, int n2, int n3, int n4, int n5) {
        this.init(n, n2, n3, n4, n5);
    }

    private void init(int n, int n2, int n3, int n4, int n5) {
        if (n5 < 1) {
            throw new IllegalArgumentException("Dimension for FaureSequence must be > 1");
        }
        if ((double)n2 * Math.log(n) > 31.0 * Math.log(2.0)) {
            throw new IllegalArgumentException("Trying to construct a FaureSequence with too many points");
        }
        if (n3 < n2 || n4 < n3) {
            throw new IllegalArgumentException("One must have k <= r <= w for FaureSequence");
        }
        this.b = n;
        this.numCols = n2;
        this.numRows = n3;
        this.outDigits = n4;
        this.dim = n5;
        this.numPoints = n;
        for (int i = 1; i < n2; ++i) {
            this.numPoints *= n;
        }
        this.normFactor = 1.0 / Math.pow(n, this.outDigits);
        double d = 1.0 / (double)n;
        this.factor = new double[this.outDigits];
        this.factor[0] = d;
        for (int i = 1; i < this.outDigits; ++i) {
            this.factor[i] = this.factor[i - 1] * d;
        }
        this.genMat = new int[n5 * this.numCols][this.numRows];
        this.initGenMat();
    }

    public FaureSequence(int n, int n2) {
        if (n2 < 1 || n2 > 500) {
            throw new IllegalArgumentException("Dimension for Faure net must be > 1 and < 500");
        }
        this.b = this.getSmallestPrime(n2);
        this.numCols = (int)Math.ceil(Math.log(n) / Math.log(this.b));
        this.outDigits = (int)Math.floor(Math.log(1.073741824E9) / Math.log(this.b));
        this.numRows = this.outDigits = Math.max(this.outDigits, this.numCols);
        this.init(this.b, this.numCols, this.numRows, this.outDigits, n2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Faure sequence:\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    public void extendSequence(int n) {
        this.init(this.b, n, this.numRows, this.outDigits, this.dim);
    }

    private void initGenMat() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.numCols; ++n2) {
            for (n = 0; n < this.numRows; ++n) {
                this.genMat[n2][n] = 0;
            }
            this.genMat[n2][n2] = 1;
        }
        for (int i = 1; i < this.dim; ++i) {
            this.genMat[i * this.numCols][0] = 1;
            for (n2 = 1; n2 < this.numCols; ++n2) {
                this.genMat[i * this.numCols + n2][n2] = 1;
                this.genMat[i * this.numCols + n2][0] = i * this.genMat[i * this.numCols + n2 - 1][0] % this.b;
            }
            for (n2 = 2; n2 < this.numCols; ++n2) {
                for (n = 1; n < n2; ++n) {
                    this.genMat[i * this.numCols + n2][n] = (this.genMat[i * this.numCols + n2 - 1][n - 1] + i * this.genMat[i * this.numCols + n2 - 1][n]) % this.b;
                }
            }
            for (n2 = 0; n2 < this.numCols; ++n2) {
                for (n = n2 + 1; n < this.numRows; ++n) {
                    this.genMat[i * this.numCols + n2][n] = 0;
                }
            }
        }
    }

    private int getSmallestPrime(int n) {
        return primes[n - 1];
    }
}

