/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri.test;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIFactory;
import com.hp.hpl.jena.iri.Violation;
import com.hp.hpl.jena.iri.ViolationCodes;
import com.hp.hpl.jena.iri.impl.IRIExamples;
import com.hp.hpl.jena.iri.impl.Specification;
import com.hp.hpl.jena.iri.impl.ViolationCodeInfo;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestExample
extends TestCase
implements ViolationCodes {
    static Specification[] specs;
    static IRIFactory[][] all;
    String uri;
    ViolationCodeInfo violation;
    int specID;
    boolean good;

    static {
        new ViolationCodes.Initialize();
        specs = Specification.all.values().toArray(new Specification[0]);
        all = new IRIFactory[specs.length][5];
        int i = 0;
        while (i < specs.length) {
            int j = 0;
            while (j < 5) {
                TestExample.all[i][j] = new IRIFactory();
                all[i][j].dnsViolation(false, false);
                all[i][j].mintingViolation(false, false);
                all[i][j].shouldViolation(false, false);
                all[i][j].securityViolation(false, false);
                switch (j) {
                    case 1: {
                        all[i][j].dnsViolation(false, true);
                        break;
                    }
                    case 2: {
                        all[i][j].mintingViolation(false, true);
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 3: {
                        all[i][j].securityViolation(false, true);
                        break;
                    }
                    case 0: {
                        all[i][j].shouldViolation(false, true);
                    }
                }
                if (specs[i].name().equals("IRI")) {
                    all[i][j].useSpecificationIRI(false);
                }
                if (specs[i].name().equals("URI")) {
                    all[i][j].useSpecificationURI(false);
                }
                if (specs[i].name().equals("XLink")) {
                    all[i][j].useSpecificationXLink(false);
                }
                if (specs[i].name().equals("RDF")) {
                    all[i][j].useSpecificationRDF(false);
                }
                if (specs[i].name().equals("XML")) {
                    all[i][j].useSpecificationXMLSystemID(false);
                }
                if (specs[i].name().equals("Schema")) {
                    all[i][j].useSpecificationXMLSchema(false);
                }
                ++j;
            }
            ++i;
        }
    }

    public TestExample(int spec, String uri, ViolationCodeInfo info, boolean good) {
        super(TestExample.escapeAndShorten(uri));
        this.uri = uri;
        this.violation = info;
        this.specID = spec;
        this.good = good;
    }

    private static String escapeAndShorten(String uri2) {
        StringBuffer rslt = new StringBuffer();
        int ln = uri2.length();
        if (ln > 80) {
            ln = 80;
        }
        int i = 0;
        while (i < ln) {
            char ch = uri2.charAt(i);
            if (ch > '\u007f' || ch < ' ') {
                rslt.append("&#");
                rslt.append((int)ch);
                rslt.append(";");
            } else {
                rslt.append(ch);
            }
            ++i;
        }
        return rslt.toString();
    }

    public void runTest() {
        if (this.specID == -1) {
            this.runTestErrorCode();
        } else if (this.violation == null) {
            this.runTestJustSpec();
        } else {
            this.runTestSpec();
        }
    }

    private void runTestJustSpec() {
        IRIFactory f = specs[this.specID].isSchemeSpec() ? IRIFactory.iriImplementation() : all[this.specID][4];
        IRI iri = f.create(this.uri);
        if (iri.hasViolation(false)) {
            if (this.good) {
                TestExample.fail((String)("Unexpected violation found: " + ((Violation)iri.violations(false).next()).codeName()));
            }
        } else if (!this.good) {
            TestExample.fail((String)"Expected a violation, none found.");
        }
    }

    private void runTestErrorCode() {
        IRIFactory f = new IRIFactory();
        f.setIsError(this.violation.getCode(), true);
        this.runTest(f, true, false, "Just this error");
    }

    private void runTestSpec() {
        boolean inSpec = this.violation.appliesTo(specs[this.specID]);
        int force = this.violation.getForce();
        int f = 0;
        while (f < 5) {
            this.runTest(all[this.specID][f], (force & 0x10) != 0 && inSpec, (force & 1 << f) != 0 && inSpec, "Force: " + f + "; spec: " + specs[this.specID].name());
            ++f;
        }
    }

    private void runTest(IRIFactory f, boolean expectError, boolean expectWarning, String desc) {
        IRI iri = f.create(this.uri);
        boolean implemented = this.violation.isImplemented();
        expectError = expectError && implemented;
        boolean bl = expectWarning = expectWarning && !expectError && implemented;
        if (this.good) {
            expectWarning = false;
            expectError = false;
        }
        boolean hasError = false;
        boolean hasWarning = false;
        Iterator it = iri.violations(true);
        while (it.hasNext()) {
            Violation v = (Violation)it.next();
            if (v.getViolationCode() != this.violation.getCode()) continue;
            if (v.isError()) {
                if (!expectError) {
                    TestExample.fail((String)("Unexpected error, " + desc));
                }
                hasError = true;
                break;
            }
            if (!expectWarning) {
                TestExample.fail((String)("Unexpected warning, " + desc));
            }
            hasWarning = true;
            break;
        }
        if (expectWarning && !hasWarning) {
            TestExample.fail((String)("No warning detected: " + expectError));
        }
        if (expectError && !hasError) {
            TestExample.fail((String)("No error detected: " + expectError));
        }
    }

    public static TestSuite suite() {
        TestSuite rslt = new TestSuite();
        rslt.setName("Bad IRI Examples");
        int sp = 0;
        while (sp < specs.length) {
            TestSuite spec = new TestSuite();
            String specName = specs[sp].name();
            spec.setName(specName);
            if (specs[sp].isIRISpec()) {
                TestExample.addAllTestsFromExamples(sp, spec);
            }
            TestExample.addExamples(sp, null, specs[sp], spec);
            if (spec.countTestCases() > 0) {
                rslt.addTest((Test)spec);
            }
            ++sp;
        }
        TestExample.addAllTestsFromExamples(-1, rslt);
        return rslt;
    }

    private static void addAllTestsFromExamples(int sp, TestSuite spec) {
        int i = 0;
        while (i < ViolationCodeInfo.all.length) {
            TestExample.addTestsFromExamples(spec, sp, ViolationCodeInfo.all[i]);
            ++i;
        }
    }

    private static void addTestsFromExamples(TestSuite rslt, int sp, ViolationCodeInfo violationCodeInfo) {
        if (violationCodeInfo != null) {
            TestSuite ex = new TestSuite();
            ex.setName(violationCodeInfo.getCodeName());
            TestExample.addExamples(sp, violationCodeInfo, violationCodeInfo, ex);
            if (ex.countTestCases() > 0) {
                rslt.addTest((Test)ex);
            }
        }
    }

    private static void addExamples(int sp, ViolationCodeInfo violationCodeInfo, IRIExamples examples, TestSuite ex) {
        String[] e = examples.getBadExamples();
        int j = 0;
        while (j < e.length) {
            ex.addTest((Test)new TestExample(sp, e[j], violationCodeInfo, false));
            ++j;
        }
        e = examples.getGoodExamples();
        j = 0;
        while (j < e.length) {
            ex.addTest((Test)new TestExample(sp, e[j], violationCodeInfo, true));
            ++j;
        }
    }
}

