/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.binarray;

import java.util.StringTokenizer;
import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;
import net.sf.jclec.IFitness;
import net.sf.jclec.IIndividual;
import net.sf.jclec.base.AbstractIndividual;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinArrayIndividual
extends AbstractIndividual<byte[]> {
    protected static final XmlFormat<BinArrayIndividual> XML = new XmlFormat<BinArrayIndividual>(BinArrayIndividual.class){

        @Override
        public void format(BinArrayIndividual source, XmlElement xml) {
            BinArrayIndividual.access$0().format(source, xml);
            int genotypeLenght = ((byte[])source.genotype).length;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < genotypeLenght) {
                sb.append(((byte[])source.genotype)[i]);
                if (i != genotypeLenght - 1) {
                    sb.append(" ");
                }
                ++i;
            }
            xml.add(sb.toString(), "genotype", STRING_XML);
        }

        @Override
        public BinArrayIndividual parse(XmlElement xml) {
            BinArrayIndividual result = (BinArrayIndividual)BinArrayIndividual.access$0().parse(xml);
            String genotypeString = (String)xml.get("genotype", STRING_XML);
            StringTokenizer st = new StringTokenizer(genotypeString);
            result.genotype = new byte[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                ((byte[])((BinArrayIndividual)result).genotype)[i] = Byte.parseByte(st.nextToken());
                ++i;
            }
            return result;
        }

        @Override
        public String defaultName() {
            return "bin-array-individual";
        }
    };
    private static final long serialVersionUID = 6227386750669278917L;

    public BinArrayIndividual() {
    }

    public BinArrayIndividual(byte[] genotype) {
        super(genotype);
    }

    public BinArrayIndividual(byte[] genotype, IFitness fitness) {
        super(genotype, fitness);
    }

    @Override
    public IIndividual copy() {
        int gl = ((byte[])this.genotype).length;
        byte[] gother = new byte[((byte[])this.genotype).length];
        System.arraycopy(this.genotype, 0, gother, 0, gl);
        if (this.fitness != null) {
            return new BinArrayIndividual(gother, this.fitness.copy());
        }
        return new BinArrayIndividual(gother);
    }

    @Override
    public double distance(IIndividual other) {
        byte[] gother = (byte[])((BinArrayIndividual)other).genotype;
        int distance = 0;
        int gl = ((byte[])this.genotype).length;
        int i = 0;
        while (i < gl) {
            if (((byte[])this.genotype)[i] != gother[i]) {
                ++distance;
            }
            ++i;
        }
        return distance;
    }

    public boolean equals(Object other) {
        if (other instanceof BinArrayIndividual) {
            BinArrayIndividual baother = (BinArrayIndividual)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append((byte[])this.genotype, (byte[])baother.genotype);
            eb.append(this.fitness, baother.fitness);
            return eb.isEquals();
        }
        return false;
    }

    static /* synthetic */ XmlFormat access$0() {
        return AbstractIndividual.XML;
    }
}

