/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.algorithm.memetic;

import java.util.ArrayList;
import net.sf.jclec.IConfigure;
import net.sf.jclec.algorithm.memetic.AbstractOptimizer;
import net.sf.jclec.base.AbstractIndividual;
import net.sf.jclec.realarray.RealArrayIndividual;
import org.apache.commons.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolisWetsOptimizer<I extends RealArrayIndividual>
extends AbstractOptimizer<I>
implements IConfigure {
    private static final long serialVersionUID = 8738809707545923540L;
    protected double contractionFactor;
    protected double expansionFactor;
    protected int maxSuccesses;
    protected int maxFailures;
    protected int maxIterations;
    protected double minValue;
    protected double desviacionEstandar;
    protected double desviacionEstandarAux;

    public double getContractionFactor() {
        return this.contractionFactor;
    }

    public void setContractionFactor(double contractionFactor) {
        this.contractionFactor = contractionFactor;
    }

    public double getExpansionFactor() {
        return this.expansionFactor;
    }

    public void setExpansionFactor(double expansionFactor) {
        this.expansionFactor = expansionFactor;
    }

    public int getMaxSuccesses() {
        return this.maxSuccesses;
    }

    public void setMaxSuccesses(int maxSuccesses) {
        this.maxSuccesses = maxSuccesses;
    }

    public int getMaxFailures() {
        return this.maxFailures;
    }

    public void setMaxFailures(int maxFailures) {
        this.maxFailures = maxFailures;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public double getDesviacionEstandar() {
        return this.desviacionEstandar;
    }

    public void setDesviacionEstandar(double desviacionEstandar) {
        this.desviacionEstandar = desviacionEstandar;
    }

    @Override
    public I optimize(I ind) {
        int failures = 0;
        int successes = 0;
        ArrayList<RealArrayIndividual> lbestSolution = new ArrayList<RealArrayIndividual>();
        ArrayList<RealArrayIndividual> lnewSolution = new ArrayList<RealArrayIndividual>();
        this.desviacionEstandarAux = this.desviacionEstandar;
        RealArrayIndividual newSolution = (RealArrayIndividual)((RealArrayIndividual)ind).copy();
        double[] actualCromosoma = (double[])((AbstractIndividual)ind).getGenotype();
        int longitudCromosoma = actualCromosoma.length;
        double[] nuevoCromosoma = new double[actualCromosoma.length];
        double[] D = new double[longitudCromosoma];
        double[] b = new double[longitudCromosoma];
        RealArrayIndividual bestSolution = (RealArrayIndividual)((RealArrayIndividual)ind).copy();
        lbestSolution.add(bestSolution);
        lnewSolution.add(newSolution);
        this.evaluator.evaluate(lbestSolution);
        this.evaluator.evaluate(lnewSolution);
        int i = 0;
        while (i < longitudCromosoma) {
            b[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.maxIterations && this.desviacionEstandarAux > this.minValue) {
            int h;
            int j = 0;
            while (j < longitudCromosoma) {
                D[j] = b[j] + this.randgen.gaussian() * this.desviacionEstandarAux;
                nuevoCromosoma[j] = actualCromosoma[j] + D[j];
                ++j;
            }
            newSolution.setGenotype(nuevoCromosoma);
            this.evaluator.evaluate(lnewSolution);
            if (this.evaluator.getComparator().compare(bestSolution.getFitness(), newSolution.getFitness()) == -1) {
                failures = 0;
                ++successes;
                h = 0;
                while (h < longitudCromosoma) {
                    b[h] = 0.4 * D[h] + 0.2 * b[h];
                    ++h;
                }
                bestSolution.setGenotype((double[])newSolution.getGenotype());
                this.evaluator.evaluate(lbestSolution);
            } else {
                h = 0;
                while (h < longitudCromosoma) {
                    nuevoCromosoma[h] = actualCromosoma[h] - D[h];
                    ++h;
                }
                newSolution.setGenotype(nuevoCromosoma);
                this.evaluator.evaluate(lnewSolution);
                if (this.evaluator.getComparator().compare(bestSolution.getFitness(), newSolution.getFitness()) == -1) {
                    failures = 0;
                    ++successes;
                    h = 0;
                    while (h < longitudCromosoma) {
                        b[h] = b[h] - 0.4 * D[h];
                        ++h;
                    }
                    bestSolution.setGenotype((double[])newSolution.getGenotype());
                    this.evaluator.evaluate(lbestSolution);
                } else {
                    ++failures;
                    successes = 0;
                    h = 0;
                    while (h < longitudCromosoma) {
                        b[h] = 0.5 * b[h];
                        ++h;
                    }
                }
            }
            if (successes >= this.maxSuccesses) {
                failures = 0;
                successes = 0;
                this.desviacionEstandarAux = this.expansionFactor * this.desviacionEstandarAux;
            }
            if (failures >= this.maxFailures) {
                failures = 0;
                successes = 0;
                this.desviacionEstandarAux = this.contractionFactor * this.desviacionEstandarAux;
            }
            ++i;
        }
        return (I)bestSolution;
    }

    @Override
    public void configure(Configuration configuration) {
        double contractionFactor = configuration.getDouble("contraction-factor");
        this.setContractionFactor(contractionFactor);
        double expansionFactor = configuration.getDouble("expansion-factor");
        this.setExpansionFactor(expansionFactor);
        double minValue = configuration.getDouble("min-value");
        this.setMinValue(minValue);
        int maxSuccesses = configuration.getInt("max-successes");
        this.setMaxSuccesses(maxSuccesses);
        int maxFailures = configuration.getInt("max-failures");
        this.setMaxFailures(maxFailures);
        int maxIterations = configuration.getInt("max-iterations");
        this.setMaxIterations(maxIterations);
    }
}

