/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.base;

import java.util.ArrayList;
import java.util.List;
import net.sf.jclec.IConfigure;
import net.sf.jclec.IIndividual;
import net.sf.jclec.IRecombinator;
import net.sf.jclec.ISystem;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiRecombinator<I extends IIndividual>
implements IRecombinator<I>,
IConfigure {
    private static final long serialVersionUID = -6300502786816813015L;
    protected IRecombinator<I>[] components;
    protected transient ISystem<I> context;

    public final IRecombinator<I>[] getComponents() {
        return this.components;
    }

    public final void setComponents(IRecombinator<I>[] components) {
        this.components = components;
        if (this.context != null) {
            IRecombinator<I>[] iRecombinatorArray = components;
            int n = 0;
            int n2 = iRecombinatorArray.length;
            while (n < n2) {
                IRecombinator<I> component = iRecombinatorArray[n];
                component.contextualize(this.context);
                ++n;
            }
        }
    }

    @Override
    public void contextualize(ISystem<I> context) {
        this.context = context;
        if (this.components != null) {
            IRecombinator<I>[] iRecombinatorArray = this.components;
            int n = 0;
            int n2 = iRecombinatorArray.length;
            while (n < n2) {
                IRecombinator<I> component = iRecombinatorArray[n];
                component.contextualize(context);
                ++n;
            }
        }
    }

    @Override
    public int getPpl() {
        throw new UnsupportedOperationException("Number of parent per litter depends on component recombinators");
    }

    @Override
    public int getSpl() {
        throw new UnsupportedOperationException("Number of sons per litter depends on component recombinators");
    }

    @Override
    public List<I> recombine(List<I> parents) {
        ArrayList result = new ArrayList();
        IRecombinator<I>[] iRecombinatorArray = this.components;
        int n = 0;
        int n2 = iRecombinatorArray.length;
        while (n < n2) {
            IRecombinator<I> component = iRecombinatorArray[n];
            result.addAll(component.recombine(parents));
            ++n;
        }
        return result;
    }

    @Override
    public void configure(Configuration settings) {
        int numberOfComponents = settings.getList("component[@type]").size();
        IRecombinator[] components = new IRecombinator[numberOfComponents];
        int i = 0;
        while (i < numberOfComponents) {
            String header = "component(" + i + ")";
            try {
                String componentClassname = settings.getString(String.valueOf(header) + "[@type");
                Class<?> componentClass = Class.forName(componentClassname);
                IRecombinator component = (IRecombinator)componentClass.newInstance();
                if (component instanceof IConfigure) {
                    ((IConfigure)((Object)component)).configure(settings.subset(header));
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.setComponents(components);
    }

    public boolean equals(Object other) {
        if (other instanceof MultiRecombinator) {
            MultiRecombinator o = (MultiRecombinator)other;
            int cl = this.components.length;
            if (cl == o.components.length) {
                EqualsBuilder eb = new EqualsBuilder();
                int i = 0;
                while (i < cl) {
                    eb.append(this.components[i], o.components[i]);
                    ++i;
                }
                return eb.isEquals();
            }
            return false;
        }
        return false;
    }
}

