## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 10,  
  fig.height = 6 
  
  
)

## ----setup--------------------------------------------------------------------
library(crimedatasets)

library(ggplot2)

library(dplyr)


## ----ggplot2_001--------------------------------------------------------------

# Bar Chart with Abilene_tbl_df data set

Abilene_tbl_df %>%
  ggplot(aes(x = factor(year), y = number, fill = crimetype)) +
  geom_bar(stat = "identity", position = "dodge") +
  labs(title = "Number of Violent Crimes by Year in Abilene, Texas",
       x = "Year",
       y = "Number of Violent Crimes") +
  theme_minimal()





## ----ggplot2_002--------------------------------------------------------------

# Convert the ts object into a data.frame
wmurders_df <- data.frame(
  year = as.numeric(time(wmurders_ts)), # Extract the time values as numeric
  murder_rate = as.numeric(wmurders_ts) # Convert ts values to numeric
)

# Plot using ggplot2
ggplot(wmurders_df, aes(x = year, y = murder_rate)) +
  geom_line(color = "red") +
  labs(
    title = "Annual Female Murder Rate in the USA (1950-2004)",
    x = "Year",
    y = "Murder Rate per 100,000 Women"
  ) +
  theme_minimal()





