/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.toolkit.ColorBridge;
import org.rosuda.ibase.toolkit.PPrimBase;
import org.rosuda.pograss.PoGraSS;

public class PPrimCircle
extends PPrimBase {
    public int x;
    public int y;
    public int diam;
    public boolean filled = true;
    public boolean drawBorder = false;
    public boolean allowColorBrushing = true;
    public boolean brushClockwise = false;
    public int startArc;
    public boolean intersectionByArea = true;
    private int[] pieces;

    public boolean intersects(Rectangle rectangle) {
        if (this.intersectionByArea) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            Ellipse2D.Double double_2 = new Ellipse2D.Double(this.x - this.diam / 2, this.y - this.diam / 2, this.diam, this.diam);
            return double_2.intersects(double_);
        }
        return rectangle.contains(this.x, this.y);
    }

    public void paint(PoGraSS poGraSS, int n, SMarker sMarker) {
        if (this.visible) {
            if (!this.allowColorBrushing || sMarker.getSecCount() < 1) {
                this.pieces = null;
                poGraSS.setColor(this.fillColor);
                if (this.filled) {
                    poGraSS.fillOval(this.x - this.diam / 2, this.y - this.diam / 2, this.diam, this.diam);
                }
                poGraSS.setColor(this.borderColor);
                if (this.drawBorder) {
                    poGraSS.drawOval(this.x - this.diam / 2, this.y - this.diam / 2, this.diam, this.diam);
                }
            } else if (this.ref != null && this.ref.length == 1) {
                this.pieces = null;
                poGraSS.setColor(ColorBridge.getMain().getColor(sMarker.getSec(this.ref[0])));
                if (this.filled) {
                    poGraSS.fillOval(this.x - this.diam / 2, this.y - this.diam / 2, this.diam, this.diam);
                }
                if (this.drawBorder) {
                    poGraSS.drawOval(this.x - this.diam / 2, this.y - this.diam / 2, this.diam, this.diam);
                }
            } else {
                int n2;
                double d = 0.0;
                double[] dArray = new double[sMarker.getMaxMark() + 1];
                for (n2 = 0; n2 <= sMarker.getMaxMark(); ++n2) {
                    dArray[n2] = this.getMarkedProportion(sMarker, n2);
                    d += dArray[n2];
                }
                this.pieces = this.roundProportions(dArray, d, 360);
                n2 = 0;
                for (int i = 0; i <= sMarker.getMaxMark(); ++i) {
                    int n3;
                    poGraSS.setColor(ColorBridge.getMain().getColor(i));
                    int n4 = n3 = this.brushClockwise ? n2 + this.startArc - this.pieces[i] : n2 + this.startArc;
                    if (this.filled) {
                        poGraSS.fillArc(this.x - this.diam / 2, this.y - this.diam / 2, this.diam, this.diam, n3, this.pieces[i]);
                    }
                    if (this.drawBorder) {
                        poGraSS.drawArc(this.x - this.diam / 2, this.y - this.diam / 2, this.diam, this.diam, n3, this.pieces[i]);
                    }
                    n2 += (this.brushClockwise ? -1 : 1) * this.pieces[i];
                }
            }
        }
    }

    public void paintSelected(PoGraSS poGraSS, int n, SMarker sMarker) {
        if (this.visible && this.ref != null) {
            if (this.allowColorBrushing && this.ref.length > 1 && this.pieces != null) {
                int n2 = 0;
                for (int i = 0; i < this.pieces.length; ++i) {
                    if (this.pieces[i] <= 0) continue;
                    double d = this.getRelativeMarkedProportion(sMarker, i);
                    if (d > 0.0) {
                        poGraSS.setColor(this.fillColorSel);
                        if (this.filled) {
                            poGraSS.fillArc(this.x - this.diam / 2, this.y - this.diam / 2, this.diam, this.diam, n2 + this.startArc, this.getPropSize(this.pieces[i], d));
                        }
                        poGraSS.setColor(this.borderColorSel);
                        if (this.drawBorder) {
                            poGraSS.drawArc(this.x - this.diam / 2, this.y - this.diam / 2, this.diam, this.diam, n2 + this.startArc, this.getPropSize(this.pieces[i], d));
                        }
                    }
                    n2 += this.pieces[i];
                }
            } else {
                int n3 = sMarker.get(this.ref[0]);
                if (n3 == -1) {
                    poGraSS.setColor(this.fillColorSel);
                    if (this.filled) {
                        poGraSS.fillOval(this.x - this.diam / 2, this.y - this.diam / 2, this.diam, this.diam);
                    }
                    poGraSS.setColor(this.borderColorSel);
                    if (this.drawBorder) {
                        poGraSS.drawOval(this.x - this.diam / 2, this.y - this.diam / 2, this.diam, this.diam);
                    }
                    return;
                }
            }
        }
    }

    public boolean contains(int n, int n2) {
        if (this.intersectionByArea) {
            return (n - this.x) * (n - this.x) + (n2 - this.y) * (n2 - this.y) <= this.diam * this.diam / 4;
        }
        return n == this.x && n2 == this.y;
    }

    public String toString() {
        return "PPrimCircle(x=" + this.x + ", y=" + this.y + ", diam=" + this.diam + ")";
    }

    public void move(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void moveX(int n) {
        this.move(n, this.y);
    }

    public void moveY(int n) {
        this.move(this.x, n);
    }

    public void setDiam(int n) {
        this.diam = n;
    }
}

