/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import java.util.Arrays;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropInverse
extends Propagator<SetVar> {
    private final int n;
    private final int n2;
    private int idx;
    private final SetVar[] sets;
    private final SetVar[] invsets;
    private SetVar[] toFilter;
    private final int offSet1;
    private final int offSet2;
    private int offSet;
    private final ISetDeltaMonitor[] sdm;
    private final IntProcedure elementForced;
    private final IntProcedure elementRemoved;

    public PropInverse(SetVar[] sets, SetVar[] invsets, int offSet1, int offSet2) {
        super((Variable[])ArrayUtils.append(sets, invsets), (Priority)PropagatorPriority.LINEAR, true);
        this.n = sets.length;
        this.n2 = invsets.length;
        this.offSet1 = offSet1;
        this.offSet2 = offSet2;
        this.sets = Arrays.copyOfRange((SetVar[])this.vars, 0, sets.length);
        this.invsets = Arrays.copyOfRange((SetVar[])this.vars, sets.length, ((SetVar[])this.vars).length);
        this.sdm = new ISetDeltaMonitor[this.n + this.n2];
        for (int i = 0; i < this.n + this.n2; ++i) {
            this.sdm[i] = ((SetVar[])this.vars)[i].monitorDelta(this);
        }
        this.elementForced = element -> this.toFilter[element - this.offSet].force(this.idx, this);
        this.elementRemoved = element -> this.toFilter[element - this.offSet].remove(this.idx, this);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int j;
        ISetIterator iter;
        int i;
        for (i = 0; i < this.n; ++i) {
            iter = this.sets[i].getUB().iterator();
            while (iter.hasNext()) {
                j = iter.nextInt();
                if (j >= this.offSet1 && j < this.n2 + this.offSet1 && this.invsets[j - this.offSet2].getUB().contains(i + this.offSet1)) continue;
                this.sets[i].remove(j, this);
            }
            iter = this.sets[i].getLB().iterator();
            while (iter.hasNext()) {
                this.invsets[iter.nextInt() - this.offSet2].force(i + this.offSet1, this);
            }
        }
        for (i = 0; i < this.n2; ++i) {
            iter = this.invsets[i].getUB().iterator();
            while (iter.hasNext()) {
                j = iter.nextInt();
                if (j >= this.offSet2 && j < this.n + this.offSet2 && this.sets[j - this.offSet1].getUB().contains(i + this.offSet2)) continue;
                this.invsets[i].remove(j, this);
            }
            iter = this.invsets[i].getLB().iterator();
            while (iter.hasNext()) {
                this.sets[iter.nextInt() - this.offSet1].force(i + this.offSet2, this);
            }
        }
        for (i = 0; i < this.n + this.n2; ++i) {
            this.sdm[i].startMonitoring();
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.idx = idxVarInProp;
        this.toFilter = this.invsets;
        if (this.idx >= this.n) {
            this.idx -= this.n;
            this.toFilter = this.sets;
            this.idx += this.offSet2;
            this.offSet = this.offSet1;
        } else {
            this.idx += this.offSet1;
            this.offSet = this.offSet2;
        }
        this.sdm[idxVarInProp].forEach(this.elementForced, SetEventType.ADD_TO_KER);
        this.sdm[idxVarInProp].forEach(this.elementRemoved, SetEventType.REMOVE_FROM_ENVELOPE);
    }

    @Override
    public ESat isEntailed() {
        int j;
        ISetIterator iSetIterator;
        int i;
        for (i = 0; i < this.n; ++i) {
            iSetIterator = this.sets[i].getLB().iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                if (this.invsets[j - this.offSet2].getUB().contains(i + this.offSet1)) continue;
                return ESat.FALSE;
            }
        }
        for (i = 0; i < this.n2; ++i) {
            iSetIterator = this.invsets[i].getLB().iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                if (this.sets[j - this.offSet1].getUB().contains(i + this.offSet2)) continue;
                return ESat.FALSE;
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

