/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.circuit;

import java.util.Random;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.circuit.CircuitConf;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.graphOperations.dominance.AbstractLengauerTarjanDominatorsFinder;
import org.chocosolver.util.graphOperations.dominance.SimpleDominatorsFinder;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class PropCircuit_ArboFiltering
extends Propagator<IntVar> {
    protected DirectedGraph connectedGraph;
    protected int n;
    protected AbstractLengauerTarjanDominatorsFinder domFinder;
    protected int offSet;
    protected Random rd;
    protected CircuitConf conf;

    public PropCircuit_ArboFiltering(IntVar[] succs, int offSet, CircuitConf conf) {
        super((Variable[])succs, (Priority)PropagatorPriority.QUADRATIC, false);
        this.conf = conf;
        this.n = succs.length;
        this.offSet = offSet;
        this.connectedGraph = new DirectedGraph(this.n + 1, SetType.BITSET, false);
        this.domFinder = new SimpleDominatorsFinder(this.n, this.connectedGraph);
        if (conf == CircuitConf.RD) {
            this.rd = new Random(((IntVar[])this.vars)[0].getModel().getSeed());
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            for (i = 0; i < this.n; ++i) {
                ((IntVar[])this.vars)[i].updateBounds(this.offSet, this.n - 1 + this.offSet, this);
            }
        }
        switch (this.conf) {
            case FIRST: {
                this.filterFromDom(0);
                break;
            }
            default: {
                this.filterFromDom(this.rd.nextInt(this.n));
                break;
            }
            case ALL: {
                for (i = 0; i < this.n; ++i) {
                    this.filterFromDom(i);
                }
            }
        }
    }

    protected void filterFromDom(int duplicatedNode) throws ContradictionException {
        int y;
        int ub;
        int i;
        for (i = 0; i < this.n + 1; ++i) {
            this.connectedGraph.getSuccessorsOf(i).clear();
            this.connectedGraph.getPredecessorsOf(i).clear();
        }
        for (i = 0; i < this.n; ++i) {
            ub = ((IntVar[])this.vars)[i].getUB();
            y = ((IntVar[])this.vars)[i].getLB();
            while (y <= ub) {
                if (i == duplicatedNode) {
                    this.connectedGraph.addEdge(this.n, y - this.offSet);
                } else {
                    this.connectedGraph.addEdge(i, y - this.offSet);
                }
                y = ((IntVar[])this.vars)[i].nextValue(y);
            }
        }
        if (this.domFinder.findDominators()) {
            for (int x = 0; x < this.n; ++x) {
                if (x == duplicatedNode) continue;
                ub = ((IntVar[])this.vars)[x].getUB();
                y = ((IntVar[])this.vars)[x].getLB();
                while (y <= ub) {
                    if (this.domFinder.isDomminatedBy(x, y - this.offSet)) {
                        ((IntVar[])this.vars)[x].removeValue(y, (ICause)this);
                    }
                    y = ((IntVar[])this.vars)[x].nextValue(y);
                }
            }
        } else {
            this.fails();
        }
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }
}

