/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.min_max;

import java.util.stream.IntStream;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropArgmax
extends Propagator<IntVar> {
    private final int n;
    private final int o;
    private final IStateInt ubi;
    private final IStateInt lbi;
    private final IIntDeltaMonitor delta;
    private final IntProcedure proc;

    public PropArgmax(IntVar z, int offset, IntVar[] x) {
        super((Variable[])ArrayUtils.append(x, {z}), (Priority)PropagatorPriority.LINEAR, true);
        this.n = x.length;
        this.o = offset;
        this.delta = z.monitorDelta(this);
        this.ubi = z.getModel().getEnvironment().makeInt(-1);
        this.lbi = z.getModel().getEnvironment().makeInt(-1);
        this.proc = j -> {
            if ((j -= this.o) == this.ubi.get()) {
                this.filterUb();
            } else {
                ((IntVar[])this.vars)[j - this.o].updateUpperBound(((IntVar[])this.vars)[this.ubi.get()].getUB() - (j < this.lbi.get() ? 1 : 0), (ICause)this);
            }
        };
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx < this.n) {
            return IntEventType.boundAndInst();
        }
        return IntEventType.all();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ((IntVar[])this.vars)[this.n].updateBounds(0, this.n - 1, this);
        this.filterUb();
        this.lbi.set(this.argmax(IntVar::getLB));
        this.filterZ();
        if (((IntVar[])this.vars)[this.n].isInstantiated()) {
            this.filterLb(((IntVar[])this.vars)[this.n].getValue() - this.o);
        }
        this.delta.startMonitoring();
    }

    @Override
    public void propagate(int j, int mask) throws ContradictionException {
        if (j == this.n) {
            if (IntEventType.isRemove(mask)) {
                this.delta.forEachRemVal(this.proc);
            }
            if (((IntVar[])this.vars)[this.n].isInstantiated()) {
                this.filterLb(((IntVar[])this.vars)[this.n].getValue() - this.o);
            }
        } else {
            if (IntEventType.isDecupp(mask) || IntEventType.isInstantiate(mask)) {
                if (j == this.ubi.get()) {
                    this.filterUb();
                }
                if (((IntVar[])this.vars)[j].getUB() <= ((IntVar[])this.vars)[this.lbi.get()].getLB() - (j <= this.lbi.get() ? 1 : 0)) {
                    ((IntVar[])this.vars)[this.n].removeValue(j + this.o, (ICause)this);
                }
            }
            if ((IntEventType.isInclow(mask) || IntEventType.isInstantiate(mask)) && ((IntVar[])this.vars)[j].getLB() > ((IntVar[])this.vars)[this.lbi.get()].getLB() - (j <= this.lbi.get() ? 1 : 0)) {
                this.lbi.set(j);
                if (((IntVar[])this.vars)[this.n].isInstantiated()) {
                    this.filterLb(((IntVar[])this.vars)[this.n].getValue() - this.o);
                } else {
                    this.filterZ();
                }
            }
        }
    }

    private int argmax(Bound bnd) {
        int ubi = ((IntVar[])this.vars)[this.n].getLB();
        int ub = bnd.bound(((IntVar[])this.vars)[ubi - this.o]);
        int i = ((IntVar[])this.vars)[this.n].nextValue(ubi);
        while (i <= ((IntVar[])this.vars)[this.n].getUB()) {
            int _ub = bnd.bound(((IntVar[])this.vars)[i - this.o]);
            if (_ub > ub) {
                ub = _ub;
                ubi = i;
            }
            i = ((IntVar[])this.vars)[this.n].nextValue(i);
        }
        return ubi - this.o;
    }

    private void filterUb() throws ContradictionException {
        this.ubi.set(this.argmax(IntVar::getUB));
        int ub = ((IntVar[])this.vars)[this.ubi.get()].getUB();
        int j = ((IntVar[])this.vars)[this.n].nextValueOut(-1 + this.o);
        while (j < this.n + this.o) {
            int jj = j - this.o;
            ((IntVar[])this.vars)[jj].updateUpperBound(ub - (jj < this.ubi.get() ? 1 : 0), (ICause)this);
            j = ((IntVar[])this.vars)[this.n].nextValueOut(j);
        }
    }

    private void filterZ() throws ContradictionException {
        int lb = ((IntVar[])this.vars)[this.lbi.get()].getLB();
        int j = ((IntVar[])this.vars)[this.n].getLB();
        while (j <= ((IntVar[])this.vars)[this.n].getUB()) {
            int jj = j - this.o;
            if (((IntVar[])this.vars)[jj].getUB() <= lb - (jj <= this.lbi.get() ? 1 : 0)) {
                ((IntVar[])this.vars)[this.n].removeValue(j, (ICause)this);
            }
            j = ((IntVar[])this.vars)[this.n].nextValue(j);
        }
    }

    private void filterLb(int j) throws ContradictionException {
        ((IntVar[])this.vars)[j].updateLowerBound(((IntVar[])this.vars)[this.lbi.get()].getLB() + (this.lbi.get() < j ? 1 : 0), (ICause)this);
        this.lbi.set(j);
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            int max = IntStream.range(0, this.n).map(i -> ((IntVar[])this.vars)[i].getValue()).max().getAsInt();
            int frst = IntStream.range(0, this.n).filter(i -> ((IntVar[])this.vars)[i].getValue() == max).findFirst().getAsInt();
            return ESat.eval(((IntVar[])this.vars)[this.n].getValue() == frst + this.o && ((IntVar[])this.vars)[frst].getValue() == max);
        }
        return ESat.UNDEFINED;
    }

    @FunctionalInterface
    private static interface Bound {
        public int bound(IntVar var1);
    }
}

