/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.tests;

import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.dstats.Normal;
import jdplus.toolkit.base.core.dstats.T;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;

public class SampleMean {
    public static final double SMALL = 1.0E-38;
    private final double sampleMean;
    private final int sampleSize;
    private double populationMean;
    private double populationVariance;
    private int sampleSizeForVariance;
    private boolean normalPopulation;

    public SampleMean(double sampleMean, int sampleSize) {
        this.sampleMean = sampleMean;
        this.sampleSize = sampleSize;
    }

    public SampleMean populationMean(double value) {
        this.populationMean = value;
        return this;
    }

    public SampleMean populationVariance(double value) {
        this.populationVariance = value;
        this.sampleSizeForVariance = 0;
        return this;
    }

    public SampleMean normalDistribution(boolean value) {
        this.normalPopulation = value;
        return this;
    }

    public SampleMean estimatedPopulationVariance(double value, int sampleSize) {
        this.populationVariance = value;
        this.sampleSizeForVariance = sampleSize;
        return this;
    }

    public StatisticalTest build() {
        if (this.populationVariance == 0.0) {
            throw new IllegalStateException("undefined population variance");
        }
        double val = (this.sampleMean - this.populationMean) / Math.sqrt(this.populationVariance / (double)this.sampleSize);
        if (this.sampleSizeForVariance > 0) {
            return TestsUtility.testOf(val, new T(this.sampleSizeForVariance - 1), TestType.TwoSided);
        }
        return TestsUtility.testOf(val, new Normal(), TestType.TwoSided);
    }
}

