## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
set.seed(1)

## ----setup--------------------------------------------------------------------
library(segtest)

## -----------------------------------------------------------------------------
o1 <- multidog_to_g(ufit, ploidy = 4, type = "all_g", p1 = "indigocrisp", p2 = "sweetcrisp")
o2 <- multidog_to_g(ufit, ploidy = 4, type = "all_gl", p1 = "indigocrisp", p2 = "sweetcrisp")

## -----------------------------------------------------------------------------
o3 <- multidog_to_g(ufit2, ploidy = 4, type = "off_g")
o4 <- multidog_to_g(ufit2, ploidy = 4, type = "off_gl")
o5 <- multidog_to_g(ufit3, ploidy = 4, type = "off_g")
o6 <- multidog_to_g(ufit3, ploidy = 4, type = "off_gl")

## -----------------------------------------------------------------------------
future::availableCores()

## ----echo = TRUE, eval = FALSE------------------------------------------------
# future::plan(future::multisession(workers = 2))
# mout1 <- seg_multi(
#   g = o2$g,
#   p1 = o2$p1,
#   p2 = o2$p2,
#   p1_ploidy = 4,
#   p2_ploidy = 4,
#   ret_out = TRUE)
# future::plan(future::sequential())

## ----echo = FALSE, eval = TRUE------------------------------------------------
future::plan(future::sequential())
mout1 <- seg_multi(
  g = o2$g, 
  p1 = o2$p1,
  p2 = o2$p2, 
  p1_ploidy = 4, 
  p2_ploidy = 4,
  ret_out = TRUE)

## -----------------------------------------------------------------------------
mout1[c("snp", "p_value")]

## -----------------------------------------------------------------------------
round(mout1$q0[mout1$snp == "12_31029646"][[1]], digits = 4)
o1$g["12_31029646", ] / sum(o1$g["12_31029646", ])

## ----echo = TRUE, eval = FALSE------------------------------------------------
# future::plan(future::multisession(workers = 2))
# mout2 <- seg_multi(
#   g = o2$g,
#   p1 = o2$p1,
#   p2 = o2$p2,
#   p1_ploidy = 4,
#   p2_ploidy = 4,
#   outlier = FALSE)
# future::plan(future::sequential())

## ----echo = FALSE, eval = TRUE------------------------------------------------
future::plan(future::sequential())
mout2 <- seg_multi(
  g = o2$g,
  p1 = o2$p1, 
  p2 = o2$p2, 
  p1_ploidy = 4, 
  p2_ploidy = 4,
  outlier = FALSE)

## -----------------------------------------------------------------------------
mout2[, c("snp", "p_value")]

## -----------------------------------------------------------------------------
o1$g["2_20070837", ]
o1$p1["2_20070837"]
o1$p2["2_20070837"]

## ----fig.alt="Scatterplot of SNP index (x-axis) by outlier probability (y-axis)."----
graphics::plot(
  mout1$outprob[mout1$snp == "2_20070837"][[1]], 
  ylim = c(0, 1),
  ylab = "Outlier Probability")

## ----echo = TRUE, eval = FALSE------------------------------------------------
# future::plan(future::multisession(workers = 2))
# mout3 <- multi_lrt(
#   g = o2$g,
#   p1 = o2$p1,
#   p2 = o2$p2
# )
# future::plan(future::sequential())

## ----echo = FALSE, eval = TRUE------------------------------------------------
future::plan(future::sequential())
mout3 <- multi_lrt(
  g = o2$g,
  p1 = o2$p1, 
  p2 = o2$p2
)

## ----fig.alt="Scatterplot of p-values from seg_lrt() (x-axis) by multi_lrt() (y-axis)."----
plot(
  mout2$p_value,
  mout3$p_value,
  xlab = "seg_multi(outlier = FALSE)", 
  ylab = "multi_lrt()")
abline(0, 1, lty = 2, col = 2)

## -----------------------------------------------------------------------------
i <- which.max(abs(mout2$p_value - mout3$p_value))
mout2$df[[i]]
mout3$df[[i]]

