/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.generators;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import moa.capabilities.CapabilitiesHandler;
import moa.capabilities.Capability;
import moa.capabilities.ImmutableCapabilities;
import moa.core.FastVector;
import moa.core.InstanceExample;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.streams.InstanceStream;
import moa.tasks.TaskMonitor;

public class RandomTreeGenerator
extends AbstractOptionHandler
implements InstanceStream,
CapabilitiesHandler {
    private static final long serialVersionUID = 1L;
    public IntOption treeRandomSeedOption = new IntOption("treeRandomSeed", 'r', "Seed for random generation of tree.", 1);
    public IntOption instanceRandomSeedOption = new IntOption("instanceRandomSeed", 'i', "Seed for random generation of instances.", 1);
    public IntOption numClassesOption = new IntOption("numClasses", 'c', "The number of classes to generate.", 2, 2, Integer.MAX_VALUE);
    public IntOption numNominalsOption = new IntOption("numNominals", 'o', "The number of nominal attributes to generate.", 5, 0, Integer.MAX_VALUE);
    public IntOption numNumericsOption = new IntOption("numNumerics", 'u', "The number of numeric attributes to generate.", 5, 0, Integer.MAX_VALUE);
    public IntOption numValsPerNominalOption = new IntOption("numValsPerNominal", 'v', "The number of values to generate per nominal attribute.", 5, 2, Integer.MAX_VALUE);
    public IntOption maxTreeDepthOption = new IntOption("maxTreeDepth", 'd', "The maximum depth of the tree concept.", 5, 0, Integer.MAX_VALUE);
    public IntOption firstLeafLevelOption = new IntOption("firstLeafLevel", 'l', "The first level of the tree above maxTreeDepth that can have leaves.", 3, 0, Integer.MAX_VALUE);
    public FloatOption leafFractionOption = new FloatOption("leafFraction", 'f', "The fraction of leaves per level from firstLeafLevel onwards.", 0.15, 0.0, 1.0);
    protected Node treeRoot;
    protected InstancesHeader streamHeader;
    protected Random instanceRandom;

    @Override
    public String getPurposeString() {
        return "Generates a stream based on a randomly generated tree.";
    }

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        monitor.setCurrentActivity("Preparing random tree...", -1.0);
        this.generateHeader();
        this.generateRandomTree();
        this.restart();
    }

    @Override
    public long estimatedRemainingInstances() {
        return -1L;
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    @Override
    public void restart() {
        this.instanceRandom = new Random(this.instanceRandomSeedOption.getValue());
    }

    @Override
    public InstancesHeader getHeader() {
        return this.streamHeader;
    }

    @Override
    public boolean hasMoreInstances() {
        return true;
    }

    @Override
    public InstanceExample nextInstance() {
        double[] attVals = new double[this.numNominalsOption.getValue() + this.numNumericsOption.getValue()];
        InstancesHeader header = this.getHeader();
        DenseInstance inst = new DenseInstance((double)header.numAttributes());
        for (int i = 0; i < attVals.length; ++i) {
            attVals[i] = i < this.numNominalsOption.getValue() ? (double)this.instanceRandom.nextInt(this.numValsPerNominalOption.getValue()) : this.instanceRandom.nextDouble();
            inst.setValue(i, attVals[i]);
        }
        inst.setDataset(header);
        inst.setClassValue(this.classifyInstance(this.treeRoot, attVals));
        return new InstanceExample(inst);
    }

    protected int classifyInstance(Node node, double[] attVals) {
        if (node.children == null) {
            return node.classLabel;
        }
        if (node.splitAttIndex < this.numNominalsOption.getValue()) {
            return this.classifyInstance(node.children[(int)attVals[node.splitAttIndex]], attVals);
        }
        return this.classifyInstance(node.children[attVals[node.splitAttIndex] < node.splitAttValue ? 0 : 1], attVals);
    }

    protected void generateHeader() {
        int i;
        FastVector<Attribute> attributes = new FastVector<Attribute>();
        FastVector<String> nominalAttVals = new FastVector<String>();
        for (i = 0; i < this.numValsPerNominalOption.getValue(); ++i) {
            nominalAttVals.addElement("value" + (i + 1));
        }
        for (i = 0; i < this.numNominalsOption.getValue(); ++i) {
            attributes.addElement(new Attribute("nominal" + (i + 1), nominalAttVals));
        }
        for (i = 0; i < this.numNumericsOption.getValue(); ++i) {
            attributes.addElement(new Attribute("numeric" + (i + 1)));
        }
        FastVector<String> classLabels = new FastVector<String>();
        for (int i2 = 0; i2 < this.numClassesOption.getValue(); ++i2) {
            classLabels.addElement("class" + (i2 + 1));
        }
        attributes.addElement(new Attribute("class", classLabels));
        this.streamHeader = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), attributes, 0));
        this.streamHeader.setClassIndex(this.streamHeader.numAttributes() - 1);
    }

    protected void generateRandomTree() {
        Random treeRand = new Random(this.treeRandomSeedOption.getValue());
        ArrayList<Integer> nominalAttCandidates = new ArrayList<Integer>(this.numNominalsOption.getValue());
        for (int i = 0; i < this.numNominalsOption.getValue(); ++i) {
            nominalAttCandidates.add(i);
        }
        double[] minNumericVals = new double[this.numNumericsOption.getValue()];
        double[] maxNumericVals = new double[this.numNumericsOption.getValue()];
        for (int i = 0; i < this.numNumericsOption.getValue(); ++i) {
            minNumericVals[i] = 0.0;
            maxNumericVals[i] = 1.0;
        }
        this.treeRoot = this.generateRandomTreeNode(0, nominalAttCandidates, minNumericVals, maxNumericVals, treeRand);
    }

    protected Node generateRandomTreeNode(int currentDepth, ArrayList<Integer> nominalAttCandidates, double[] minNumericVals, double[] maxNumericVals, Random treeRand) {
        if (currentDepth >= this.maxTreeDepthOption.getValue() || currentDepth >= this.firstLeafLevelOption.getValue() && this.leafFractionOption.getValue() >= 1.0 - treeRand.nextDouble()) {
            Node leaf = new Node();
            leaf.classLabel = treeRand.nextInt(this.numClassesOption.getValue());
            return leaf;
        }
        Node node = new Node();
        int chosenAtt = treeRand.nextInt(nominalAttCandidates.size() + this.numNumericsOption.getValue());
        if (chosenAtt < nominalAttCandidates.size()) {
            node.splitAttIndex = nominalAttCandidates.get(chosenAtt);
            node.children = new Node[this.numValsPerNominalOption.getValue()];
            ArrayList<Integer> newNominalCandidates = new ArrayList<Integer>(nominalAttCandidates);
            newNominalCandidates.remove(new Integer(node.splitAttIndex));
            newNominalCandidates.trimToSize();
            for (int i = 0; i < node.children.length; ++i) {
                node.children[i] = this.generateRandomTreeNode(currentDepth + 1, newNominalCandidates, minNumericVals, maxNumericVals, treeRand);
            }
        } else {
            int numericIndex = chosenAtt - nominalAttCandidates.size();
            node.splitAttIndex = this.numNominalsOption.getValue() + numericIndex;
            double minVal = minNumericVals[numericIndex];
            double maxVal = maxNumericVals[numericIndex];
            node.splitAttValue = (maxVal - minVal) * treeRand.nextDouble() + minVal;
            node.children = new Node[2];
            double[] newMaxVals = (double[])maxNumericVals.clone();
            newMaxVals[numericIndex] = node.splitAttValue;
            node.children[0] = this.generateRandomTreeNode(currentDepth + 1, nominalAttCandidates, minNumericVals, newMaxVals, treeRand);
            double[] newMinVals = (double[])minNumericVals.clone();
            newMinVals[numericIndex] = node.splitAttValue;
            node.children[1] = this.generateRandomTreeNode(currentDepth + 1, nominalAttCandidates, newMinVals, maxNumericVals, treeRand);
        }
        return node;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    public ImmutableCapabilities defineImmutableCapabilities() {
        if (this.getClass() == RandomTreeGenerator.class) {
            return new ImmutableCapabilities(Capability.VIEW_STANDARD, Capability.VIEW_LITE);
        }
        return new ImmutableCapabilities(Capability.VIEW_STANDARD);
    }

    protected static class Node
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int classLabel;
        public int splitAttIndex;
        public double splitAttValue;
        public Node[] children;

        protected Node() {
        }
    }
}

