/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.speciation;

import dr.evolution.coalescent.IntervalType;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evolution.util.Taxon;
import dr.evomodel.bigfasttree.BigFastTreeIntervals;
import dr.evomodel.speciation.SpeciationLikelihood;
import dr.evomodel.speciation.SpeciationModel;
import dr.evomodel.speciation.SpeciationModelGradientProvider;
import dr.evomodel.tree.DefaultTreeModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Model;
import dr.math.MathUtils;
import java.util.Set;

public class EfficientSpeciationLikelihood
extends SpeciationLikelihood
implements TreeTraitProvider {
    private final BigFastTreeIntervals treeIntervals;
    private final TreeTraitProvider.Helper treeTraits = new TreeTraitProvider.Helper();
    public static final boolean MEASURE_RUN_TIME = false;
    public double likelihoodTime;
    public int likelihoodCounts;
    private boolean intervalsKnown;
    private final double TOLERANCE = 1.0E-5;
    private SpeciationModelGradientProvider gradientProvider = null;

    public EfficientSpeciationLikelihood(Tree tree, SpeciationModel speciationModel, Set<Taxon> set, String string) {
        super(tree, speciationModel, set, string);
        if (!(tree instanceof DefaultTreeModel)) {
            throw new IllegalArgumentException("Must currently provide a DefaultTreeModel");
        }
        this.likelihoodTime = 0.0;
        this.likelihoodCounts = 0;
        this.fixTimes();
        this.treeIntervals = new BigFastTreeIntervals((TreeModel)tree);
        this.addModel(this.treeIntervals);
    }

    @Override
    protected final void handleModelChangedEvent(Model model, Object object, int n) {
        super.handleModelChangedEvent(model, object, n);
        if (model == this.treeIntervals) {
            this.intervalsKnown = false;
        }
    }

    final TreeModel getTreeModel() {
        return (TreeModel)this.tree;
    }

    final BigFastTreeIntervals getTreeIntervals() {
        return this.treeIntervals;
    }

    @Override
    double calculateLogLikelihood() {
        this.speciationModel.updateLikelihoodModelValues(0);
        double[] dArray = this.speciationModel.getBreakPoints();
        assert (dArray[dArray.length - 1] == Double.POSITIVE_INFINITY);
        int n = 0;
        while (this.treeIntervals.getStartTime() >= dArray[n]) {
            this.speciationModel.updateLikelihoodModelValues(++n);
        }
        double d = this.speciationModel.processSampling(n, this.treeIntervals.getStartTime());
        for (int i = 0; i < this.treeIntervals.getIntervalCount(); ++i) {
            double d2 = this.treeIntervals.getIntervalTime(i);
            double d3 = d2 + this.treeIntervals.getInterval(i);
            int n2 = this.treeIntervals.getLineageCount(i);
            while (d3 >= dArray[n]) {
                double d4 = dArray[n];
                d += this.speciationModel.processModelSegmentBreakPoint(n, d2, d4, n2);
                d2 = d4;
                this.speciationModel.updateLikelihoodModelValues(++n);
            }
            if (d3 > d2) {
                d += this.speciationModel.processInterval(n, d2, d3, n2);
            }
            if (this.treeIntervals.getIntervalType(i) == IntervalType.SAMPLE) {
                d += this.speciationModel.processSampling(n, d3);
                continue;
            }
            if (this.treeIntervals.getIntervalType(i) == IntervalType.COALESCENT) {
                d += this.speciationModel.processCoalescence(n, d3);
                continue;
            }
            throw new RuntimeException("Birth-death tree includes non birth/death/sampling event.");
        }
        d += this.speciationModel.processOrigin(n, this.treeIntervals.getTotalDuration());
        return d += this.speciationModel.logConditioningProbability(n);
    }

    private void fixTimes() {
        int n;
        TreeModel treeModel = this.getTreeModel();
        double[] dArray = this.speciationModel.getBreakPoints();
        block0: for (n = 0; n < treeModel.getExternalNodeCount(); ++n) {
            NodeRef nodeRef = treeModel.getExternalNode(n);
            double d = treeModel.getNodeHeight(nodeRef);
            if (d < 1.0E-5) {
                treeModel.setNodeHeight(nodeRef, 0.0);
                continue;
            }
            for (int i = 0; i < dArray.length; ++i) {
                if (!(Math.abs(d - dArray[i]) < 1.0E-5)) continue;
                treeModel.setNodeHeight(nodeRef, dArray[i]);
                continue block0;
            }
        }
        n = 0;
        block2: for (int i = 0; i < treeModel.getInternalNodeCount(); ++i) {
            NodeRef nodeRef = treeModel.getInternalNode(i);
            double d = treeModel.getNodeHeight(nodeRef);
            if (d == 0.0) {
                n = 1;
                System.err.println("Some births were found at time 0.0 and moved (by no more than 1.0E-5) to avoid numerical issues.");
                treeModel.setNodeHeight(nodeRef, 1.0E-5 * MathUtils.nextBeta(2.0, 1.0));
                continue;
            }
            for (int j = 0; j < dArray.length; ++j) {
                if (d != dArray[j]) continue;
                n = 1;
                double d2 = d > 1.0E-5 ? 1.0E-5 : d;
                double d3 = d2 * MathUtils.nextBeta(2.0, 1.0);
                if (MathUtils.nextBoolean()) {
                    d3 = -d3;
                }
                treeModel.setNodeHeight(nodeRef, d + d3);
                continue block2;
            }
        }
        if (n != 0) {
            System.err.println("Some births were exactly at event-sampling times and have been moved (by no more than 1.0E-5) to avoid numerical issues.");
        }
    }

    @Override
    public SpeciationModelGradientProvider getGradientProvider() {
        if (this.gradientProvider == null) {
            this.gradientProvider = this.speciationModel.getProvider();
        }
        return this.gradientProvider;
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        return this.treeTraits.getTreeTraits();
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        return this.treeTraits.getTreeTrait(string);
    }

    public void addTrait(TreeTrait treeTrait) {
        this.treeTraits.addTrait(treeTrait);
    }

    @Override
    public String getReport() {
        String string = super.getReport();
        return string;
    }
}

