/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.app.tools.NexusExporter;
import dr.evolution.io.Importer;
import dr.evolution.io.NewickImporter;
import dr.evolution.io.TreeTrace;
import dr.evolution.tree.CladeSet;
import dr.evolution.tree.FlexibleTree;
import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.stats.DiscreteStatistics;
import dr.util.FrequencySet;
import dr.util.NumberFormatter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Set;
import jebl.evolution.treemetrics.RobinsonsFouldMetric;
import jebl.evolution.trees.SimpleRootedTree;

public class TreeTraceAnalysis {
    private int burnin = -1;
    private final TreeTrace[] traces;
    private CladeSet cladeSet;
    private FrequencySet<String> treeSet;

    private TreeTraceAnalysis(TreeTrace[] treeTraceArray, int n, boolean bl) {
        this.traces = treeTraceArray;
        int n2 = Integer.MAX_VALUE;
        for (TreeTrace treeTrace : treeTraceArray) {
            if (treeTrace.getMaximumState() >= n2) continue;
            n2 = treeTrace.getMaximumState();
        }
        if (n < 0 || n >= n2) {
            this.burnin = n2 / (10 * treeTraceArray[0].getStepSize());
            if (bl) {
                String string = n < 0 ? "Defalt burn-in" : "WARNING: Burn-in larger than total number of states";
                System.out.println(string + " - using 10% of smallest trace");
            }
        } else {
            this.burnin = n;
        }
        this.analyze(bl);
    }

    public static double[] getSymmetricTreeDistanceTrace(TreeTrace treeTrace, Tree tree) {
        double[] dArray = new double[treeTrace.getTreeCount(0)];
        RobinsonsFouldMetric robinsonsFouldMetric = new RobinsonsFouldMetric();
        SimpleRootedTree simpleRootedTree = TreeUtils.asJeblTree(tree);
        for (int i = 0; i < dArray.length; ++i) {
            SimpleRootedTree simpleRootedTree2 = TreeUtils.asJeblTree(treeTrace.getTree(i, 0));
            dArray[i] = robinsonsFouldMetric.getMetric(simpleRootedTree, simpleRootedTree2);
        }
        return dArray;
    }

    void analyze(boolean bl) {
        if (bl && this.traces.length > 1) {
            System.out.println("Combining " + this.traces.length + " traces.");
        }
        Tree tree = this.getTree(0);
        double[][] dArray = new double[tree.getNodeCount()][tree.getNodeCount()];
        double[] dArray2 = new double[tree.getNodeCount()];
        boolean bl2 = false;
        this.cladeSet = new CladeSet(tree);
        this.treeSet = new FrequencySet();
        this.treeSet.add(TreeUtils.uniqueNewick(tree, tree.getRoot()));
        TreeTrace[] treeTraceArray = this.traces;
        int n = treeTraceArray.length;
        for (int i = 0; i < n; ++i) {
            TreeTrace treeTrace = treeTraceArray[i];
            int n2 = treeTrace.getTreeCount(this.burnin * treeTrace.getStepSize());
            double d = (double)n2 / 60.0;
            int n3 = 1;
            if (bl) {
                System.out.println("Analyzing " + n2 + " trees...");
                System.out.println("0              25             50             75            100");
                System.out.println("|--------------|--------------|--------------|--------------|");
                System.out.print("*");
            }
            for (int j = 1; j < n2; ++j) {
                Tree tree2 = treeTrace.getTree(j, this.burnin * treeTrace.getStepSize());
                for (int k = 0; k < tree2.getNodeCount(); ++k) {
                    if (tree2.getNode(k) == tree2.getRoot() || tree2.getNodeAttribute(tree2.getNode(k), "changed") == null) continue;
                    bl2 = true;
                    Object object = tree2.getNodeAttribute(tree2.getNode(k), "changed");
                    if (object == null) continue;
                    boolean bl3 = this.getChanged(tree2, k);
                    if (bl3) {
                        int n4 = k;
                        dArray2[n4] = dArray2[n4] + (Double)tree2.getNodeAttribute(tree2.getNode(k), "rate");
                    }
                    for (int i2 = 0; i2 < tree2.getNodeCount(); ++i2) {
                        if (tree2.getNode(i2) == tree2.getRoot()) continue;
                        double[] dArray3 = dArray[k];
                        int n5 = i2;
                        dArray3[n5] = dArray3[n5] + (bl3 && this.getChanged(tree2, i2) ? 1.0 : 0.0);
                    }
                }
                this.cladeSet.add(tree2);
                this.treeSet.add(TreeUtils.uniqueNewick(tree2, tree2.getRoot()));
                if (!bl || j < (int)Math.round((double)n3 * d) || n3 > 60) continue;
                System.out.print("*");
                System.out.flush();
                ++n3;
            }
            if (!bl) continue;
            System.out.println("*");
        }
        if (bl2) {
            int n6;
            for (n6 = 0; n6 < tree.getNodeCount(); ++n6) {
                System.out.println(n6 + "\t" + dArray2[n6]);
            }
            System.out.println();
            for (n6 = 0; n6 < tree.getNodeCount(); ++n6) {
                for (n = 0; n < tree.getNodeCount(); ++n) {
                    System.out.print(dArray[n6][n] + "\t");
                }
                System.out.println();
            }
        }
    }

    private boolean getChanged(Tree tree, int n) {
        Object object = tree.getNodeAttribute(tree.getNode(n), "changed");
        if (object instanceof Integer) {
            return (Integer)object == 1;
        }
        return (Boolean)object;
    }

    final MutableTree analyzeTree(String string) {
        int n;
        int n2 = this.getTreeCount();
        FlexibleTree flexibleTree = null;
        for (n = 0; n < n2; ++n) {
            Tree tree = this.getTree(n);
            if (!TreeUtils.uniqueNewick(tree, tree.getRoot()).equals(string)) continue;
            flexibleTree = new FlexibleTree(tree);
            break;
        }
        if (flexibleTree == null) {
            throw new RuntimeException("No target tree in trace");
        }
        n = flexibleTree.getInternalNodeCount();
        for (int i = 0; i < n; ++i) {
            double[] dArray = new double[n2];
            NodeRef nodeRef = flexibleTree.getInternalNode(i);
            Set<String> set = TreeUtils.getDescendantLeaves(flexibleTree, nodeRef);
            for (int j = 0; j < n2; ++j) {
                Tree tree = this.getTree(j);
                NodeRef nodeRef2 = TreeUtils.getCommonAncestorNode(tree, set);
                dArray[j] = tree.getNodeHeight(nodeRef2);
            }
            flexibleTree.setNodeHeight(nodeRef, DiscreteStatistics.mean(dArray));
            double d = DiscreteStatistics.quantile(0.975, dArray);
            flexibleTree.setNodeAttribute(nodeRef, "upper", d);
            double d2 = DiscreteStatistics.quantile(0.025, dArray);
            flexibleTree.setNodeAttribute(nodeRef, "lower", d2);
            flexibleTree.setNodeAttribute(nodeRef, "range", new Double[]{d2, d});
        }
        return flexibleTree;
    }

    final int getTreeCount() {
        int n = 0;
        for (TreeTrace treeTrace : this.traces) {
            n += treeTrace.getTreeCount(this.burnin * treeTrace.getStepSize());
        }
        return n;
    }

    final Tree getTree(int n) {
        int n2 = 0;
        int n3 = 0;
        for (TreeTrace treeTrace : this.traces) {
            int n4 = this.burnin * treeTrace.getStepSize();
            if (n < (n3 += treeTrace.getTreeCount(n4))) {
                return treeTrace.getTree(n - n2, n4);
            }
            n2 = n3;
        }
        throw new RuntimeException("Couldn't find tree " + n);
    }

    public void report(int n) throws IOException {
        this.report(0.5, 0.95, n);
    }

    public void report(double d, int n) throws IOException {
        this.report(d, 0.95, n);
    }

    public void report(double d, double d2, int n) throws IOException {
        Object object;
        double d3;
        int n2;
        int n3;
        int n4;
        System.err.println("making report");
        NumberFormatter numberFormatter = new NumberFormatter(6);
        numberFormatter.setPadding(true);
        numberFormatter.setFieldWidth(14);
        int n5 = this.treeSet.size();
        int n6 = this.treeSet.getSumFrequency();
        System.out.println();
        System.out.println("burnIn=" + this.burnin);
        System.out.println("total trees used =" + n6);
        System.out.println();
        System.out.println(Math.round(d2 * 100.0) + "% credible set (" + n5 + " unique trees, " + n6 + " total):");
        System.out.println("Count\tPercent\tTree");
        int n7 = (int)(d2 * (double)n6);
        int n8 = 0;
        int n9 = 0;
        NumberFormatter numberFormatter2 = new NumberFormatter(8);
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = this.treeSet.getFrequency(n4);
            n2 = 1;
            if (n > 0 && n3 <= n) {
                n2 = 0;
                ++n9;
            }
            d3 = (double)n3 / (double)n6;
            if (n2 != 0) {
                System.out.print(n3);
                System.out.print("\t" + numberFormatter2.formatDecimal(d3 * 100.0, 2) + "%");
            }
            double d4 = (double)(n8 += n3) / (double)n6;
            if (n2 != 0) {
                System.out.print("\t" + numberFormatter2.formatDecimal(d4 * 100.0, 2) + "%");
                object = this.treeSet.get(n4);
                if (n3 > 100) {
                    MutableTree mutableTree = this.analyzeTree((String)object);
                    System.out.println("\t" + TreeUtils.newick(mutableTree));
                } else {
                    System.out.println("\t" + (String)object);
                }
            }
            if (n8 < n7) continue;
            if (n9 > 0) {
                System.out.println();
                System.out.println("... (" + n9 + ") trees.");
            }
            System.out.println();
            System.out.println("95% credible set has " + (n4 + 1) + " trees.");
            break;
        }
        System.out.println();
        System.out.println(Math.round(d * 100.0) + "%-rule clades (" + this.cladeSet.size() + " unique clades):");
        n4 = this.cladeSet.size();
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = this.cladeSet.getFrequency(n3);
            d3 = (double)n2 / (double)n6;
            if (!(d3 >= d)) continue;
            System.out.print(n2);
            System.out.print("\t" + numberFormatter2.formatDecimal(d3 * 100.0, 2) + "%");
            System.out.print("\t" + this.cladeSet.getMeanNodeHeight(n3));
            System.out.println("\t" + this.cladeSet.getClade(n3));
        }
        System.out.flush();
        System.out.println("Clade credible sets:");
        n3 = 5 * n6 / 100;
        n2 = 50 * n6 / 100;
        n8 = 0;
        assert (n5 == this.treeSet.size());
        CladeSet cladeSet = new CladeSet();
        for (int i = 0; i < n5; ++i) {
            n8 += this.treeSet.getFrequency(i);
            String string = this.treeSet.get(i);
            NewickImporter newickImporter = new NewickImporter(new StringReader(string));
            try {
                object = newickImporter.importNextTree();
                cladeSet.add((Tree)object);
            }
            catch (Importer.ImportException importException) {
                System.err.println("Err");
            }
            if (n8 >= n3) {
                System.out.println();
                System.out.println("5% credible set has " + cladeSet.getCladeCount() + " clades.");
                n3 = n6 + 1;
            }
            if (n8 < n2) continue;
            System.out.println();
            System.out.println("50% credible set has " + cladeSet.getCladeCount() + " clades.");
            n2 = n6 + 1;
        }
        System.out.flush();
    }

    public void shortReport(String string, Tree tree, boolean bl) {
        this.shortReport(string, tree, bl, 0.95);
    }

    public void shortReport(String string, Tree tree, boolean bl, double d) {
        String string2 = "";
        if (tree != null) {
            string2 = TreeUtils.uniqueNewick(tree, tree.getRoot());
        }
        int n = this.treeSet.size();
        int n2 = this.treeSet.getSumFrequency();
        double d2 = (double)this.treeSet.getFrequency(0) / (double)n2;
        String string3 = this.treeSet.get(0);
        if (bl) {
            System.out.println("file\ttrees\tuniqueTrees\tp(MAP)\tMAP tree\t" + (int)d * 100 + "credSize\ttrue_I\tp(true)\tcum(true)");
        }
        System.out.print(string + "\t");
        System.out.print(n2 + "\t");
        System.out.print(n + "\t");
        System.out.print(d2 + "\t");
        System.out.print(string3 + "\t");
        int n3 = (int)(d * (double)n2);
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        double d3 = 0.0;
        double d4 = 1.0;
        for (int i = 0; i < n; ++i) {
            int n7 = this.treeSet.getFrequency(i);
            double d5 = (double)n7 / (double)n2;
            double d6 = (double)(n4 += n7) / (double)n2;
            String string4 = this.treeSet.get(i);
            if (string4.equals(string2)) {
                n6 = i + 1;
                d3 = d5;
                d4 = d6;
            }
            if (n4 < n3 || n5 != -1) continue;
            n5 = i + 1;
        }
        System.out.print(n5 + "\t");
        System.out.print(n6 + "\t");
        System.out.print(d3 + "\t");
        System.out.println(d4);
    }

    public void export(PrintStream printStream, double d, int n, boolean bl) {
        boolean bl2;
        NexusExporter nexusExporter = new NexusExporter(printStream);
        int n2 = this.treeSet.size();
        if (n < 0) {
            n = n2;
        }
        int n3 = this.treeSet.getSumFrequency();
        ArrayList<MutableTree> arrayList = new ArrayList<MutableTree>();
        int n4 = Math.min(n, n2);
        boolean bl3 = bl2 = bl && n4 > 60;
        if (bl2) {
            System.out.println("Exporting " + n4 + " trees...");
            System.out.println("0              25             50             75            100");
            System.out.println("|--------------|--------------|--------------|--------------|");
            System.out.print("*");
        }
        for (int i = 0; i < n2; ++i) {
            int n5 = this.treeSet.getFrequency(i);
            double d2 = (double)n5 / (double)n3;
            if (d2 < d) continue;
            String string = this.treeSet.get(i);
            MutableTree mutableTree = this.analyzeTree(string);
            mutableTree.setAttribute("weight", d2);
            double d3 = this.cladeSet.annotate(mutableTree, "posterior");
            mutableTree.setNodeAttribute(mutableTree.getRoot(), "posterior", Math.exp(d3 / (double)mutableTree.getInternalNodeCount()));
            arrayList.add(mutableTree);
            if (bl2 && (i + 1) % (n4 / 60) == 0) {
                System.out.print("*");
            }
            if (arrayList.size() == n) break;
        }
        if (arrayList.size() > 0) {
            nexusExporter.exportTrees(arrayList, true);
        }
    }

    public int getBurnin() {
        return this.burnin;
    }

    public static TreeTraceAnalysis analyzeLogFile(Reader[] readerArray, int n, boolean bl) throws IOException {
        TreeTrace[] treeTraceArray = new TreeTrace[readerArray.length];
        for (int i = 0; i < readerArray.length; ++i) {
            try {
                treeTraceArray[i] = TreeTrace.loadTreeTrace(readerArray[i]);
            }
            catch (Importer.ImportException importException) {
                throw new RuntimeException(importException.toString());
            }
            readerArray[i].close();
        }
        return new TreeTraceAnalysis(treeTraceArray, n, bl);
    }
}

