/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.Objects;
import org.ohdsi.circe.check.WarningSeverity;
import org.ohdsi.circe.check.checkers.BaseCorelatedCriteriaCheck;
import org.ohdsi.circe.check.checkers.Comparisons;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.check.operations.Operations;
import org.ohdsi.circe.check.utils.CriteriaNameHelper;
import org.ohdsi.circe.cohortdefinition.CohortExpression;
import org.ohdsi.circe.cohortdefinition.CorelatedCriteria;
import org.ohdsi.circe.cohortdefinition.ObservationFilter;

public class TimeWindowCheck
extends BaseCorelatedCriteriaCheck {
    private static final String WARNING = "%s criteria have time window range that is longer than required time for initial event";
    private ObservationFilter observationFilter;

    @Override
    protected WarningSeverity defineSeverity() {
        return WarningSeverity.INFO;
    }

    @Override
    protected void beforeCheck(WarningReporter reporter, CohortExpression expression) {
        this.observationFilter = expression.primaryCriteria.observationWindow;
    }

    @Override
    protected void checkCriteria(CorelatedCriteria criteria, String groupName, WarningReporter reporter) {
        String name = groupName + " " + CriteriaNameHelper.getCriteriaName(criteria.criteria);
        Operations.match(criteria).when(c -> Objects.nonNull(c.startWindow) && Comparisons.compareTo(this.observationFilter, c.startWindow) < 0).then(() -> reporter.add(WARNING, name));
    }
}

