/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.border.BackgroundBorder;
import ch.randelshofer.quaqua.color.PaintableColor;
import ch.randelshofer.quaqua.util.Debug;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class QuaquaPanelUI
extends BasicPanelUI {
    private static PanelUI panelUI;

    public static ComponentUI createUI(JComponent c) {
        if (panelUI == null) {
            panelUI = new QuaquaPanelUI();
        }
        return panelUI;
    }

    protected void installDefaults(JPanel p) {
        super.installDefaults(p);
        QuaquaUtilities.installProperty(p, "opaque", UIManager.get("Panel.opaque"));
    }

    protected void uninstallDefaults(JPanel p) {
        super.uninstallDefaults(p);
    }

    public static boolean isInTabbedPane(Component comp) {
        if (comp == null) {
            return false;
        }
        for (Container parent = comp.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof JTabbedPane) {
                return true;
            }
            if (parent instanceof JRootPane) {
                return false;
            }
            if (parent instanceof RootPaneContainer) {
                return false;
            }
            if (!(parent instanceof Window)) continue;
            return false;
        }
        return false;
    }

    public void paint(Graphics gr, JComponent c) {
        Border titledBorderBorder;
        Graphics2D g = (Graphics2D)gr;
        Object oldHints = QuaquaUtilities.beginGraphics(g);
        if (c.isOpaque()) {
            g.setPaint(PaintableColor.getPaint(c.getBackground(), c));
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        Border backgroundBorder = null;
        Insets insets = new Insets(0, 0, 0, 0);
        if (c.getBorder() instanceof BackgroundBorder) {
            backgroundBorder = ((BackgroundBorder)c.getBorder()).getBackgroundBorder();
        } else if (c.getBorder() instanceof TitledBorder && (titledBorderBorder = ((TitledBorder)c.getBorder()).getBorder()) instanceof BackgroundBorder) {
            backgroundBorder = ((BackgroundBorder)titledBorderBorder).getBackgroundBorder();
            insets = c.getBorder().getBorderInsets(c);
        }
        if (backgroundBorder != null) {
            backgroundBorder.paintBorder(c, gr, insets.left, insets.top, c.getWidth() - insets.left - insets.right, c.getHeight() - insets.top - insets.bottom);
        }
        Debug.paint(gr, c, this);
        QuaquaUtilities.endGraphics(g, oldHints);
    }
}

