/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.fitness;

import java.util.ArrayList;
import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;
import net.sf.jclec.IFitness;
import net.sf.jclec.base.AbstractFitness;
import net.sf.jclec.fitness.ICompositeFitness;
import net.sf.jclec.fitness.ISimpleFitness;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class CompositeFitness
extends AbstractFitness
implements ICompositeFitness {
    protected static final XmlFormat<CompositeFitness> XML = new XmlFormat<CompositeFitness>(CompositeFitness.class){

        @Override
        public void format(CompositeFitness compositeFitness, XmlElement xml) {
            xml.add(compositeFitness.components, "components", COMPONENTS_FITNESS_XML);
        }

        @Override
        public CompositeFitness parse(XmlElement xml) {
            CompositeFitness result = (CompositeFitness)xml.object();
            result.components = (ISimpleFitness[])xml.get("components", COMPONENTS_FITNESS_XML);
            return result;
        }

        @Override
        public String defaultName() {
            return "composite-fitness";
        }
    };
    protected static final XmlFormat<ISimpleFitness[]> COMPONENTS_FITNESS_XML = new XmlFormat<ISimpleFitness[]>(ISimpleFitness[].class){

        @Override
        public void format(ISimpleFitness[] components, XmlElement xml) {
            ISimpleFitness[] iSimpleFitnessArray = components;
            int n = 0;
            int n2 = iSimpleFitnessArray.length;
            while (n < n2) {
                ISimpleFitness component = iSimpleFitnessArray[n];
                xml.add(component, "component");
                ++n;
            }
        }

        @Override
        public ISimpleFitness[] parse(XmlElement xml) {
            ArrayList<ISimpleFitness> componentsList = new ArrayList<ISimpleFitness>();
            while (xml.hasNext()) {
                componentsList.add((ISimpleFitness)xml.get("component"));
            }
            return componentsList.toArray(new ISimpleFitness[0]);
        }
    };
    private static final long serialVersionUID = 3257291339740559156L;
    protected ISimpleFitness[] components;

    public CompositeFitness() {
        this(null);
    }

    public CompositeFitness(ISimpleFitness[] components) {
        this.setComponents(components);
    }

    public ISimpleFitness[] getComponents() {
        return this.components;
    }

    public void setComponents(ISimpleFitness[] components) {
        this.components = components;
    }

    public ISimpleFitness getComponent(int cidx) {
        try {
            return this.components[cidx];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.valueOf(cidx) + "isn't a valid component index");
        }
    }

    public void setComponent(int cidx, ISimpleFitness cval) {
        try {
            this.components[cidx] = cval;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.valueOf(cidx) + "isn't a valid component index");
        }
    }

    public IFitness copy() {
        CompositeFitness result = new CompositeFitness();
        int cl = this.components.length;
        result.components = new ISimpleFitness[cl];
        int i = 0;
        while (i < cl) {
            result.components[i] = (ISimpleFitness)this.components[i].copy();
            ++i;
        }
        return result;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        ISimpleFitness[] iSimpleFitnessArray = this.components;
        int n = 0;
        int n2 = iSimpleFitnessArray.length;
        while (n < n2) {
            ISimpleFitness fitness = iSimpleFitnessArray[n];
            hcb.append(fitness);
            ++n;
        }
        return hcb.toHashCode();
    }

    public boolean equals(Object oth) {
        if (oth instanceof CompositeFitness) {
            CompositeFitness coth = (CompositeFitness)oth;
            int cl = this.components.length;
            int ocl = coth.components.length;
            if (cl == ocl) {
                EqualsBuilder eb = new EqualsBuilder();
                int i = 0;
                while (i < cl) {
                    eb.append(this.components[i], coth.components[i]);
                    ++i;
                }
                return eb.isEquals();
            }
            return false;
        }
        return false;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(this);
        tsb.append("components", this.components);
        return tsb.toString();
    }
}

