/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.swing.Icon;
import weka.core.Utils;
import weka.core.WekaPackageClassLoaderManager;
import weka.gui.knowledgeflow.StepVisual;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.steps.KFStep;
import weka.knowledgeflow.steps.Step;
import weka.knowledgeflow.steps.WekaAlgorithmWrapper;

public class StepTreeLeafDetails
implements Serializable {
    private static final long serialVersionUID = 6347861816716877761L;
    protected Class m_stepClazz;
    protected String m_wrappedWekaAlgoName = "";
    protected String m_leafLabel = "";
    protected transient Icon m_scaledIcon = null;
    protected String m_toolTipText = null;
    protected boolean m_showTipText = true;

    public StepTreeLeafDetails(Object step) {
        this(step, true);
    }

    public StepTreeLeafDetails(Object step, boolean showTipText) {
        String globalInfo;
        Annotation[] annotations;
        this.m_stepClazz = step.getClass();
        for (Annotation a : annotations = this.m_stepClazz.getAnnotations()) {
            if (!(a instanceof KFStep)) continue;
            this.m_leafLabel = ((KFStep)a).name();
            if (!showTipText) break;
            this.m_toolTipText = ((KFStep)a).toolTipText();
            break;
        }
        if (step instanceof Step) {
            this.m_leafLabel = ((Step)step).getName();
        }
        if (step instanceof WekaAlgorithmWrapper) {
            this.m_wrappedWekaAlgoName = ((WekaAlgorithmWrapper)step).getWrappedAlgorithm().getClass().getCanonicalName();
        }
        if (showTipText && (globalInfo = Utils.getGlobalInfo(step, false)) != null) {
            this.m_toolTipText = globalInfo;
        }
        this.m_scaledIcon = StepVisual.scaleIcon(StepVisual.iconForStep((Step)step), 0.33);
    }

    public void setShowTipTexts(boolean show) {
        this.m_showTipText = show;
    }

    public String getToolTipText() {
        return this.m_showTipText ? this.m_toolTipText : null;
    }

    public String toString() {
        return this.m_leafLabel;
    }

    protected Icon getIcon() {
        return this.m_scaledIcon;
    }

    public boolean isWrappedAlgorithm() {
        return this.m_wrappedWekaAlgoName != null && this.m_wrappedWekaAlgoName.length() > 0;
    }

    public StepVisual instantiateStep() throws Exception {
        Step step = null;
        step = (Step)this.m_stepClazz.newInstance();
        StepManagerImpl manager = new StepManagerImpl(step);
        if (step instanceof WekaAlgorithmWrapper) {
            Object algo = WekaPackageClassLoaderManager.objectForName(this.m_wrappedWekaAlgoName);
            ((WekaAlgorithmWrapper)step).setWrappedAlgorithm(algo);
        }
        StepVisual visual = StepVisual.createVisual(manager);
        return visual;
    }
}

