*-------------------------------------------------------------------------*
*                                                                          
*                     SPSS SETUP FILE FOR ICPSR 37842
*       MONITORING THE FUTURE: A CONTINUING STUDY OF AMERICAN YOUTH
*                   (8TH- AND 10TH-GRADE SURVEYS), 2019
*                      (DATASET 0001: MAIN DATA FILE)
* 
*
*  SPSS setup sections are provided for the ASCII version of this data
*  collection.  These sections are listed below:
*
*  DATA LIST:  assigns the name, type, decimal specification (if any),
*  and specifies the beginning and ending column locations for each
*  variable in the data file. Users must replace the "data-filename"
*  in the DATA LIST statement with a filename specifying the directory
*  on the user's computer system in which the downloaded and unzipped
*  data file is physically located (e.g., "c:\temp\37842-0001-data.txt").
*
*  VARIABLE LABELS:  assigns descriptive labels to all variables.
*  Labels and variable names may be identical for some data files.
*
*  MISSING VALUES: declares user-defined missing values. Not all
*  variables in this data set necessarily have user-defined missing
*  values. These values can be treated specially in data transformations,
*  statistical calculations, and case selection.
*
*  VALUE LABELS: assigns descriptive labels to codes found in the data
*  file.  Not all codes necessarily have assigned value labels.
*
*  VARIABLE LEVEL: assigns measurement level to each variable (scale,
*  nominal, or ordinal).
*
*  NOTE:  Users should modify this setup file to suit their specific
*  needs. The MISSING VALUES section has been commented out (i.e., '*').
*  To include the MISSING VALUES section in the final SPSS setup, remove
*  the comment indicators from the desired section.
*
*  CREATING A PERMANENT SPSS DATA FILE: If users wish to create and save
*  an SPSS data file for further analysis using SPSS for Windows, the
*  necessary "SAVE OUTFILE" command is provided in the last line of
*  this file.  To activate the command, users must delete the leading
*  asterisk (*) and replace "spss-filename" with a filename specifying
*  the location on the user's computer system to which the new data file
*  will be saved (e.g., SAVE OUTFILE="c:\spsswin\data\da37842-0001.sav").
*
*-------------------------------------------------------------------------.

* SPSS FILE HANDLE AND DATA LIST COMMANDS.

FILE HANDLE DATA / NAME="data-filename" LRECL=1275.
DATA LIST FILE=DATA /
              CASEID 1-5              AI_08 6-10             AI_10 11-15
                V1 16-19                   V3 20           V5 21-35 (13)
              V501 36-37                 V507 38                 V508 39
                 V509 40               TABLET 41        RANDOMDRAW 42-43
             V7101 44-45             V7104 46-47             V7105 48-49
             V7112 50-51             V7115 52-53             V7118 54-55
             V7127 56-57             V7097 58-59             V7133 60-61
             V7139 62-63             V7142 64-65             V8451 66-67
             V7426 68-69             V7121 70-71             V7124 72-73
             V7164 74-75             V7145 76-77             V7109 78-79
             V7152 80-81             V7155 82-83             V7158 84-85
             V7161 86-87             V7601 88-89             V8480 90-91
             V7648 92-93             V7693 94-95             V7755 96-97
             V7758 98-99           V7761 100-101           V7764 102-103
           V7767 104-105           V7728 106-107           V7106 108-109
           V7113 110-111           V7116 112-113           V7119 114-115
           V7128 116-117           V7098 118-119           V7134 120-121
           V7140 122-123           V7143 124-125           V8452 126-127
           V7122 128-129           V7125 130-131           V7165 132-133
           V7146 134-135           V7110 136-137           V7153 138-139
           V7156 140-141           V7159 142-143           V7162 144-145
           V7602 146-147           V7488 148-149           V7489 150-151
           V7491 152-153           V7492 154-155           V8481 156-157
           V7495 158-159           V7554 160-161           V7561 162-163
           V7564 164-165           V7566 166-167           V7568 168-169
           V7569 170-171           V7640 172-173           V7694 174-175
           V7756 176-177           V7759 178-179           V7762 180-181
           V7765 182-183           V7768 184-185           V7729 186-187
           V7102 188-189           V7107 190-191           V7114 192-193
           V7117 194-195           V7120 196-197           V7129 198-199
           V7099 200-201           V7135 202-203           V7141 204-205
           V7144 206-207           V8453 208-209           V7427 210-211
           V7123 212-213           V7126 214-215           V7166 216-217
           V7147 218-219           V7111 220-221           V7154 222-223
           V7157 224-225           V7160 226-227           V7163 228-229
           V7603 230-231           V8482 232-233           V7615 234-235
           V7616 236-237           V7617 238-239           V7642 240-241
           V7695 242-243           V7669 244-245           V7757 246-247
           V7760 248-249           V7763 250-251           V7766 252-253
           V7769 254-255           V7730 256-257           V7108 258-259
           V7641 260-261           V8454 262-263           V7726 264-265
           V7727 266-267           V7731 268-269           V7442 270-271
           V7441 272-273           V8413 274-275           V7443 276-277
           V7444 278-279           V7445 280-281           V8417 282-283
           V8418 284-285           V8419 286-287           V8483 288-289
           V8421 290-291           V7446 292-293           V7447 294-295
           V8424 296-297           V8425 298-299           V7448 300-301
           V7449 302-303           V8564 304-305           V7548 306-307
           V7638 308-309           V7103 310-311           V7180 312-313
           V7181 314-315           V7475 316-317           V7476 318-319
           V7477 320-321           V7478 322-323           V7479 324-325
           V7480 326-327           V7771 328-329           V7739 330-331
           V7547 332-333           V7549 334-335           V7550 336-337
           V7643 338-339           V7176 340-341           V7587 342-343
           V7722 344-345           V7723 346-347           V7724 348-349
           V7725 350-351           V7733 352-353           V7732 354-355
           V7557 356-357           V7558 358-359           V7428 360-361
           V7432 362-363           V7433 364-365           V7435 366-367
           V7430 368-369           V7431 370-371           V7434 372-373
           V7429 374-375           V7436 376-377           V8473 378-379
           V8474 380-381           V8475 382-383           V7752 384-385
           V7754 386-387           V7437 388-389           V7438 390-391
           V7439 392-393           V7440 394-395           V7414 396-397
           V7415 398-399           V7416 400-401           V7417 402-403
           V7494 404-405           V7419 406-407           V7420 408-409
           V7421 410-411           V7422 412-413           V7423 414-415
           V7412 416-417           V7413 418-419           V7490 420-421
           V7425 422-423           V7424 424-425           V8544 426-427
           V8477 428-429           V7658 430-431           V7659 432-433
           V7750 434-435           V7167 436-437           V7168 438-439
           V7169 440-441           V7170 442-443           V7171 444-445
           V7172 446-447           V7173 448-449           V7174 450-451
           V7175 452-453           V7177 454-455           V7178 456-457
           V7179 458-459           V7199 460-461           V7200 462-463
           V7185 464-465           V7458 466-467           V7186 468-469
           V7187 470-471           V7188 472-473           V7666 474-475
           V7668 476-477           V7184 478-479           V7451 480-481
           V7452 482-483           V7453 484-485           V7454 486-487
           V7455 488-489           V7456 490-491           V7457 492-493
           V8441 494-495           V8442 496-497           V8443 498-499
           V8444 500-501           V8445 502-503           V8446 504-505
           V8447 506-507           V8476 508-509           V8540 510-511
           V8541 512-513           V8542 514-515           V7481 516-517
           V7734 518-519           V7183 520-521           V7772 522-523
           V7740 524-525           V7459 526-527           V7460 528-529
           V7461 530-531           V7462 532-533           V7463 534-535
           V7464 536-537           V7465 538-539           V7466 540-541
           V7467 542-543           V7468 544-545           V7469 546-547
           V7470 548-549           V7471 550-551           V7472 552-553
           V7473 554-555           V7474 556-557           V7773 558-559
           V7774 560-561           V7775 562-563           V7776 564-565
           V7777 566-567           V7778 568-569           V7779 570-571
           V7735 572-573           V7736 574-575           V7737 576-577
           V7738 578-579           V7741 580-581           V7742 582-583
           V7743 584-585           V7744 586-587           V7745 588-589
           V7746 590-591           V7747 592-593           V7182 594-595
           V7403 596-597           V7404 598-599           V7613 600-601
           V8455 602-603           V7405 604-605           V7406 606-607
           V7407 608-609           V7408 610-611           V7409 612-613
           V7410 614-615           V7411 616-617           V7482 618-619
           V7701 620-621           V7702 622-623           V7703 624-625
           V7704 626-627           V7705 628-629           V7593 630-631
           V7344 632-633           V7345 634-635           V7346 636-637
           V7347 638-639           V7348 640-641           V7349 642-643
           V7350 644-645           V7351 646-647           V7352 648-649
           V7353 650-651           V7354 652-653           V7355 654-655
           V7356 656-657           V7357 658-659           V8547 660-661
           V8548 662-663           V7540 664-665           V7541 666-667
           V8562 668-669           V8563 670-671           V7646 672-673
           V7647 674-675           V7697 676-677           V7698 678-679
           V8456 680-681           V8457 682-683           V8458 684-685
           V8459 686-687           V8460 688-689           V8461 690-691
           V8462 692-693           V7661 694-695           V7662 696-697
           V7663 698-699           V7664 700-701           V7665 702-703
           V7718 704-705           V7716 706-707           V7717 708-709
           V7719 710-711           V7720 712-713           V7721 714-715
           V7753 716-717           V7359 718-719           V7360 720-721
           V7361 722-723           V7362 724-725           V7363 726-727
           V8545 728-729           V8546 730-731           V7364 732-733
           V7365 734-735           V7366 736-737           V7367 738-739
           V7368 740-741           V7369 742-743           V7370 744-745
           V8560 746-747           V8561 748-749           V7371 750-751
           V7372 752-753           V7542 754-755           V7543 756-757
           V7377 758-759           V7577 760-761           V7578 762-763
           V7573 764-765           V7574 766-767           V7579 768-769
           V7580 770-771           V7581 772-773           V7582 774-775
           V7583 776-777           V7584 778-779           V7585 780-781
           V7586 782-783           V7612 784-785           V7644 786-787
           V7645 788-789           V7699 790-791           V7700 792-793
           V7710 794-795           V7712 796-797           V7713 798-799
           V7706 800-801           V7708 802-803           V7709 804-805
           V7591 806-807           V7592 808-809           V7670 810-811
           V7671 812-813           V7672 814-815           V7673 816-817
           V7189 818-819           V7190 820-821           V7191 822-823
           V7192 824-825           V7193 826-827           V7194 828-829
           V7195 830-831           V7196 832-833           V7197 834-835
           V7222 836-837           V7221 838-839           V7223 840-841
           V7327 842-843           V7516 844-845           V7517 846-847
           V7518 848-849           V7519 850-851           V7329 852-853
           V7330 854-855           V7331 856-857           V7332 858-859
           V7334 860-861           V7335 862-863           V7232 864-865
           V7233 866-867           V7301 868-869           V7333 870-871
           V7251 872-873           V7252 874-875           V7384 876-877
           V7385 878-879           V7386 880-881           V7496 882-883
           V7497 884-885           V7387 886-887           V7498 888-889
           V7388 890-891           V7389 892-893           V7499 894-895
           V7390 896-897           V7391 898-899           V7392 900-901
           V7393 902-903           V7394 904-905           V7395 906-907
           V7396 908-909           V7397 910-911           V7500 912-913
           V7398 914-915           V7399 916-917           V7400 918-919
           V7522 920-921           V7523 922-923           V7524 924-925
           V7525 926-927           V7526 928-929           V7527 930-931
           V7528 932-933           V7529 934-935           V7530 936-937
           V7531 938-939           V8537 940-941           V8538 942-943
           V7537 944-945           V7253 946-947           V7228 948-949
           V7229 950-951           V7230 952-953           V7231 954-955
           V8539 956-957           V8516 958-959           V8522 960-961
           V7509 962-963           V7510 964-965           V7511 966-967
           V7512 968-969           V7513 970-971           V7514 972-973
           V7515 974-975           V7234 976-977           V8543 978-979
           V7534 980-981           V7535 982-983           V7536 984-985
           V7538 986-987           V7224 988-989           V7225 990-991
           V7227 992-993           V7226 994-995           V7235 996-997
           V7238 998-999         V7236 1000-1001         V7237 1002-1003
         V7374 1004-1005         V7240 1006-1007         V7309 1008-1009
         V7310 1010-1011         V7311 1012-1013         V7312 1014-1015
         V7313 1016-1017         V7378 1018-1019         V7379 1020-1021
         V7380 1022-1023         V7319 1024-1025         V7320 1026-1027
         V7321 1028-1029         V7214 1030-1031         V7239 1032-1033
         V7676 1034-1035         V7677 1036-1037         V7678 1038-1039
         V7682 1040-1041         V7684 1042-1043         V7685 1044-1045
         V7686 1046-1047         V7687 1048-1049         V7688 1050-1051
         V7689 1052-1053         V7690 1054-1055         V7683 1056-1057
         V7341 1058-1059         V7532 1060-1061         V7533 1062-1063
         V7339 1064-1065         V7340 1066-1067         V7401 1068-1069
         V7402 1070-1071         V7219 1072-1073         V7220 1074-1075
         V7255 1076-1077         V7241 1078-1079         V7242 1080-1081
         V7243 1082-1083         V7244 1084-1085         V7258 1086-1087
         V7375 1088-1089         V7254 1090-1091         V7259 1092-1093
         V7260 1094-1095         V7261 1096-1097         V7262 1098-1099
         V7565 1100-1101         V7302 1102-1103         V8512 1104-1105
         V8502 1106-1107         V8505 1108-1109         V8509 1110-1111
         V8514 1112-1113         V8536 1114-1115         V8501 1116-1117
         V8504 1118-1119         V8508 1120-1121         V8503 1122-1123
         V8507 1124-1125         V8511 1126-1127         V8513 1128-1129
         V7660 1130-1131         V7674 1132-1133         V7675 1134-1135
         V7501 1136-1137         V7502 1138-1139         V7504 1140-1141
         V7505 1142-1143         V7507 1144-1145         V7508 1146-1147
         V7503 1148-1149         V7506 1150-1151         V8555 1152-1153
         V8556 1154-1155         V8557 1156-1157         V8558 1158-1159
         V8565 1160-1161         V8566 1162-1163         V1252 1164-1165
         V7202 1166-1167         V1070 1168-1169         V7215 1170-1171
         V7216 1172-1173         V7217 1174-1175         V7206 1176-1177
         V7207 1178-1179         V7208 1180-1181         V7205 1182-1183
         V8517 1184-1185         V8518 1186-1187         V8519 1188-1189
         V8520 1190-1191         V8521 1192-1193         V8523 1194-1195
         V8515 1196-1197         V7691 1198-1199         V7692 1200-1201
         V8526 1202-1203         V8527 1204-1205         V8528 1206-1207
         V8529 1208-1209         V8530 1210-1211         V8531 1212-1213
         V7555 1214-1215         V7639 1216-1217        V7101D 1218-1219
        V7102D 1220-1221        V7105D 1222-1223        V7106D 1224-1225
        V7107D 1226-1227        V7112D 1228-1229        V7113D 1230-1231
        V7114D 1232-1233        V7115D 1234-1235        V7116D 1236-1237
        V7117D 1238-1239        V7118D 1240-1241        V7119D 1242-1243
        V7120D 1244-1245        V7127D 1246-1247        V7128D 1248-1249
        V7129D 1250-1251        V7097D 1252-1253        V7098D 1254-1255
        V7099D 1256-1257        V7133D 1258-1259        V7134D 1260-1261
        V7135D 1262-1263        V7142D 1264-1265        V7143D 1266-1267
        V7144D 1268-1269        V7139D 1270-1271        V7140D 1272-1273
        V7141D 1274-1275
   .

* SPSS VARIABLE LABELS COMMAND

VARIABLE LABELS
   CASEID    'CASE IDENTIFICATION NUMBER' /
   AI_08     '80136:ARCHIVE ID - 8TH' /
   AI_10     '80136:ARCHIVE ID - 10TH' /
   V1        '80001:YEAR OF ADMIN (4-DIGITS)' /
   V3        '80003:FORM ID' /
   V5        '80005:STANDARD SAMPLING WEIGHT' /
   V501      '80501:GRADE' /
   V507      '80013:SCHOOL REGION' /
   V508      '80016:SELF-REP/NOT=0' /
   V509      '80017:MSA/NON-MSA=0' /
   TABLET    '89976:TABLET=1 PAPER=0' /
   RANDOMDRAW '89977:MID=0 END=1' /
   V7101     '00760:A01a EVR SMK CIG,REGL F1234' /
   V7104     '00790:A01a EVER DRINK       F1234' /
   V7105     '00810:A01a #X DRNK/LIFETIME F1234' /
   V7112     '00860:A01a #XMJ+HS/LIFETIME F1234' /
   V7115     '00890:A01a #X LSD/LIFETIME  F1234' /
   V7118     '00920:A01a #X PSYD/LIFETIME F1234' /
   V7127     '00980:A01a #X AMPH/LIFETIME F1234' /
   V7097     '01040:A01a #X SED/BARB/LIFE F134' /
   V7133     '01070:A01a #X TRQL/LIFETIME F1234' /
   V7139     '01130:A01a #X NARC/LIFETIME F34' /
   V7142     '01160:A01a #X INHL/LIFETIME F234' /
   V8451     '11000:A01a #X BEER/LIFETIME F2' /
   V7426     '22230:A01a #X SMKLESS/EVER  F13' /
   V7121     '22260:A01a #X CRACK/LIFETIM F1234' /
   V7124     '22320:A01a #XOTH COKE/LIFE  F1234' /
   V7164     '22660:A01a #X MDMA/LIFETIME  F123' /
   V7145     '22690:A01a #X STRD/LIFETIME F1234' /
   V7109     '25020:A01a #XDRUNK/LIFETIME F1234' /
   V7152     '29630:A01a #X H LIF USE NDL F134' /
   V7155     '29660:A01a #X H LIF W/O NDL F134' /
   V7158     '29710:A01a #X INJECTOTH/LIF F1234' /
   V7161     '29770:A01a #X ROHYPNOL/LIFETIME  F4' /
   V7601     '30800:A01a #X METHAMPH/LIFE F1' /
   V8480     '31360:A01a #X FLVRDALC/LIFE F2' /
   V7648     '34230:A01a EVER VAPE F12' /
   V7693     '34820:A01a #X SNIFF PEN/MARK/LIFETIME F2' /
   V7755     '35320:A01a #DAYS E-CIG/LIFETIME  F4' /
   V7758     '35350:A01a #DAYS JUUL/LIFETIME  F4' /
   V7761     '35140:A01a #DAYS VAPE NIC/LIFE  F12' /
   V7764     '35170:A01a #DAYS VAPE MJ/LIFE  F12' /
   V7767     '35200:A01a #DAYS VAPE FLAV/LIFE  F12' /
   V7728     '35351:A01a #DAYS JUUL/LIFETIME - TABLET  F12' /
   V7106     '00820:A01b #X DRNK/LAST12MO F1234' /
   V7113     '00870:A01b #XMJ+HS/LAST12MO F1234' /
   V7116     '00900:A01b #X LSD/LAST 12MO F1234' /
   V7119     '00930:A01b #X PSYD/LAST12MO F1234' /
   V7128     '00990:A01b #X AMPH/LAST12MO F1234' /
   V7098     '01050:A01b #X SED/BARB/12MO F134' /
   V7134     '01080:A01b #X TRQL/LAST12MO F1234' /
   V7140     '01140:A01b #X NARC/LAST12MO F34' /
   V7143     '01170:A01b #X INHL/LAST12MO F234' /
   V8452     '11010:A01b #X BEER/LAST12MO F2' /
   V7122     '22270:A01b #X CRACK/LAST12M F1234' /
   V7125     '22330:A01b #XOTH COKE/12MO  F1234' /
   V7165     '22670:A01b #X MDMA/LAST12M  F123' /
   V7146     '22700:A01b #X STRD/LAST12MO F1234' /
   V7110     '25030:A01b #XDRUNK/LAST12MO F1234' /
   V7153     '29640:A01b #X H 12M USE NDL F134' /
   V7156     '29670:A01b #X H 12M W/O NDL F134' /
   V7159     '29720:A01b #X INJECTOTH/12M F1234' /
   V7162     '29780:A01b #X ROHYPNOL/LAST12MO  F4' /
   V7602     '30810:A01b #X METHAMPH/12MO F1' /
   V7488     '31170:A01b #X CREATINE/12MO F1' /
   V7489     '31180:A01b #X RITALIN/12MO  F1' /
   V7491     '31310:A01b #X OXYCONTN/12MO F1' /
   V7492     '31320:A01b #X VICODIN/12MO  F1' /
   V8481     '31370:A01b #X FLVRDALC/12MO F2' /
   V7495     '31670:A01b #X COUGHMED/12MO F1' /
   V7554     '32450:A01b #X ADDERALL/12MO F1' /
   V7561     '32500:A01b #X SALVIA/12MO   F1' /
   V7564     '32690:A01b #X ALCL+CAFFN/12MO F1' /
   V7566     '32700:A01b #X SYNTH MJ/12MO F1' /
   V7568     '32710:A01b #X DISLV TOB/12M0 F1' /
   V7569     '32720:A01b #X SNUS/12MO     F1' /
   V7640     '34040:A01b #X PWD ALCOHOL/12MO F1' /
   V7694     '34830:A01b #X SNIFF PEN/MARK/LAST12MO F2' /
   V7756     '35330:A01b #DAYS E-CIG/LAST12MO  F4' /
   V7759     '35360:A01b #DAYS JUUL/LAST12MO  F4' /
   V7762     '35150:A01b #DAYS VAPE NIC/12MO  F12' /
   V7765     '35180:A01b #DAYS VAPE MJ/12MO  F12' /
   V7768     '35210:A01b #DAYS VAPE FLAV/12MO  F12' /
   V7729     '35361:A01b #DAYS JUUL/LAST12MO - TABLET  F12' /
   V7102     '00780:A01c #CIGS SMKD/30DAY F1234' /
   V7107     '00830:A01c #X DRNK/LAST30DA F1234' /
   V7114     '00880:A01c #XMJ+HS/LAST30DA F1234' /
   V7117     '00910:A01c #X LSD/LAST 30DA F1234' /
   V7120     '00940:A01c #X PSYD/LAST30DA F1234' /
   V7129     '01000:A01c #X AMPH/LAST30DA F1234' /
   V7099     '01060:A01c #X SED/BARB/30DA F134' /
   V7135     '01090:A01c #X TRQL/LAST30DA F1234' /
   V7141     '01150:A01c #X NARC/LAST30DA F34' /
   V7144     '01180:A01c #X INHL/LAST30DA F234' /
   V8453     '11020:A01c #X BEER/LAST30DA F2' /
   V7427     '22240:A01c #X SMKLESS/30DAY F13' /
   V7123     '22280:A01c #X CRACK/LAST30D F1234' /
   V7126     '22340:A01c #XOTH COKE/30DA  F1234' /
   V7166     '22680:A01c #X MDMA/LAST30D  F123' /
   V7147     '22710:A01c #X STRD/LAST30DA F1234' /
   V7111     '25040:A01c #XDRUNK/LAST30DA F1234' /
   V7154     '29650:A01c #X H 30D USE NDL F134' /
   V7157     '29680:A01c #X H 30D W/O NDL F134' /
   V7160     '29730:A01c #X INJECTOTH/30D F1234' /
   V7163     '29790:A01c #X ROHYPNOL/LAST30DA  F4' /
   V7603     '30820:A01c #X METHAMPH/30DA F1' /
   V8482     '31380:A01c #X FLVRDALC/30DA F2' /
   V7615     '33720:A01c #X LRG CIGAR/30DAY F2' /
   V7616     '33730:A01c #X FLVD SML CIGAR/30DAY F2' /
   V7617     '33740:A01c #X REG SML CIGAR/30DAY F2' /
   V7642     '34050:A01c #X TOB HOOKAH/30DAY F2' /
   V7695     '34840:A01c #X SNIFF PEN/MARK/LAST30DAY F2' /
   V7669     '34390:A01c #X DAYS SMKLESS TOB/30DAY F2' /
   V7757     '35340:A01c #DAYS E-CIG/LAST30DA  F4' /
   V7760     '35370:A01c #DAYS JUUL/LAST30DA  F4' /
   V7763     '35160:A01c #DAYS VAPE NIC/30DA  F12' /
   V7766     '35190:A01c #DAYS VAPE MJ/30DA F12' /
   V7769     '35220:A01c #DAYS VAPE FLAV/30DA  F12' /
   V7730     '35371:A01c #DAYS JUUL/LAST30DAY - TABLET  F12' /
   V7108     '00850:A01d 5+DRK ROW/LST 2W F1234' /
   V7641     '00853:A01d 10+DRK ROW/2WK F34' /
   V8454     '11030:A01d 5+BR/LST2WK,10+X F2' /
   V7726     '35620:A01d #X/DAY PICK UP DEVICE VAPE NIC  F12' /
   V7727     '35630:A01d #PUFFS VAPE DEVICE  F12' /
   V7731     '35640:A01d AMT NIC JUUL POD  F12' /
   V7442     '05570:A01g GR 1ST SMOK DLY  F1234' /
   V7441     '05575:A01g GR 1ST SMOK EVR  F1234' /
   V8413     '05576:A01g GR 1ST SMOKELESS F24' /
   V7443     '05580:A01g GR 1ST TRY ALC   F1234' /
   V7444     '05585:A01g GR 1ST DRUNK     F1234' /
   V7445     '05590:A01g GR 1ST TRY MJ    F1234' /
   V8417     '05600:A01g GR 1ST TRY LSD   F24' /
   V8418     '05610:A01g GR 1ST TRY PSY   F24' /
   V8419     '05620:A01g GR 1ST TRY AMP   F24' /
   V8483     '05645:A01g GR 1ST TRY SED/B F4' /
   V8421     '05650:A01g GR 1ST TRY TRN   F24' /
   V7446     '05661:A01g GR 1ST TRY CRACK F1234' /
   V7447     '05663:A01g GR 1STTRY POWCOK F1234' /
   V8424     '05670:A01g GR 1ST TRY HER   F24' /
   V8425     '05680:A01g GR 1ST TRY NRC   F24' /
   V7448     '05688:A01g GR 1ST TRY INHAL F1234' /
   V7449     '23810:A01g GR 1ST TRY STRDS F3' /
   V8564     '31190:A01g GR 1ST TRY MDMA  F2' /
   V7548     '31470:A01g AGE 1ST AD STIM  F1' /
   V7638     '33960:A01g GR 1ST TRY E-CIG F124' /
   V7103     '01690:A01i TRY STP SMK+FL  F1234' /
   V7180     '01691:A01i #X TRY STOP SMK  F34' /
   V7181     '01700:A01i WNT STP SMK NW  F34' /
   V7475     '25890:A01i DIF TRY QUIT CIG F13' /
   V7476     '25900:A01i DIF TRY QUIT ALC F13' /
   V7477     '25910:A01i DIF TRY QUIT MJ  F13' /
   V7478     '25920:A01i DIF TRY QUIT COK F13' /
   V7479     '25930:A01i DIF TRY QUIT "H" F13' /
   V7480     '25940:A01i DIF TRY QUIT OTD F13' /
   V7771     '01690:A01i TRY STP SMK&FL (2019 TABLET)  F12' /
   V7739     '35740:A01i TRY STP JUUL&FL  F12' /
   V7547     '31460:A01j EVER AD STIM DR  F1' /
   V7549     '31480:A01j # YRS TK AD STIM F1' /
   V7550     '31490:A01j EVER AD NONSTIM  F1' /
   V7643     '34180:A01j MEDICAL MJ EVER  F1' /
   V7176     '30065:A01l USUAL CIG BRAND  F134' /
   V7587     '32890:A01l SMOKE MENTHOL CIG F34' /
   V7722     '35550:A01l VAPE DEVICE BRAND MST OFTN  F12' /
   V7723     '35570:A01l VAPE DEVICE BRAND 2ND MST OFTN  F12' /
   V7724     '35590:A01l EVER VAPE OTHR THAN NIC MJ FLAV  F12' /
   V7725     '35610:A01l EVER VAPE SMTHG NOT KNOW  F12' /
   V7733     '35670:A01l JUUL FLVR MOST OFTN  F12' /
   V7732     '35650:A01n JUUL SOURCE  F12' /
   V7557     '32540:A01o # ENERGY DRINKS/DAY F1' /
   V7558     '32550:A01o # ENERGY SHOTS/DAY F1' /
   V7428     '07070:A02a ALL FRD SMK CIGS F234' /
   V7432     '07080:A02a ALL FRD SMK MJ F234' /
   V7433     '07151:A02a # FRNDS TK CRACK F234' /
   V7435     '07160:A02a ALL FRD TK HERON F234' /
   V7430     '07190:A02a ALL FRD DRK ALCL F234' /
   V7431     '07200:A02a ALL FRD GT DRUNK F234' /
   V7434     '23990:A02a # FRNDS TK C PWD F234' /
   V7429     '25280:A02a ALL FRD SMKLESS  F234' /
   V7436     '25290:A02a ALL FRND INHALNT F234' /
   V8473     '30850:A02a STDNTS SMK +1CIG F2' /
   V8474     '30860:A02a STDNTS DRNK/MO   F2' /
   V8475     '30870:A02a STDNTS USE MJ/MO F2' /
   V7752     '34000:A02a ALL FRD VAPE F2' /
   V7754     '35310:A02a ALL FRD JUUL  F34' /
   V7437     '25300:A02b PRESR TO SMK CIG F34' /
   V7438     '25310:A02b PRESR TO DRK ALC F34' /
   V7439     '25320:A02b PRESR TO USE MJ  F34' /
   V7440     '25330:A02b PRSR TO OTH DRUG F34' /
   V7414     '06750:A03a EASY GT MARIJUAN F1234' /
   V7415     '06760:A03a EASY GT LSD      F1234' /
   V7416     '06771:A03a EASY GT PCP      F13' /
   V7417     '06780:A03a EASY GT AMPHTMNS F1234' /
   V7494     '06795:A03a EASY GT SED/BARB F13' /
   V7419     '06800:A03a EASY GT TRANQLIZ F1234' /
   V7420     '06811:A03a EASY GT CRACK    F1234' /
   V7421     '06812:A03a EASY GT COK PWDR F1234' /
   V7422     '06820:A03a EASY GT HEROIN   F1234' /
   V7423     '06830:A03a EASY GT NARCOTIC F13' /
   V7412     '06831:A03a EASY GT CIGS     F1234' /
   V7413     '06832:A03a EASY GT ALCOHOL  F1234' /
   V7490     '23050:A03a EASY GT MDMA     F13' /
   V7425     '23060:A03a EASY GT STEROIDS F1234' /
   V7424     '24410:A03a EASY GT ICE      F13' /
   V8544     '25820:A03a ILL DRG SOLD@SCH F24' /
   V8477     '30880:A03a DRG SL NBHD/12MO F2' /
   V7658     '34330:A03a EASY GT VAPE DEVICE F2' /
   V7659     '34340:A03a EASY GT NICOTIN VAPE F24' /
   V7750     '35230:A03a EASY GT JUUL  F134' /
   V7167     '29970:A03b CIG HOW BUY-FRND F34' /
   V7168     '29980:A03b CIG HOW BUY-VEND F34' /
   V7169     '29990:A03b CIG HOW BUY-MAIL F34' /
   V7170     '30000:A03b CIG HOW BUY-PKUP F34' /
   V7171     '30010:A03b CIG HOW BUY-CLRK F34' /
   V7172     '30020:A03b CIG WHERE-SUPMKT F34' /
   V7173     '30030:A03b CIG WHERE-SMLGRC F34' /
   V7174     '30040:A03b CIG WHERE-DRGSTR F34' /
   V7175     '30050:A03b CIG WHERE-CNVGAS F34' /
   V7177     '30070:A03b CIG PROOF OF AGE F34' /
   V7178     '30080:A03b CIG SHOW ID/SELL F34' /
   V7179     '30090:A03b CIG STORE BUY<20 F34' /
   V7199     '31330:A03b CIG HOW BUY-OTHR F34' /
   V7200     '31340:A03b CIG WHERE-WEB    F34' /
   V7185     '01710:A04a NO SMK IN 5 YR   F34' /
   V7458     '09010:A04a NXT 12MOS USE MJ F1' /
   V7186     '30130:A04a NEVER CIG ADDICT F34' /
   V7187     '30140:A04a QUIT CIG WN WANT F34' /
   V7188     '30150:A04a SMK -DANGER QUIT F34' /
   V7666     '34360:A04a SMK REG CIG BEST FRND F3' /
   V7668     '34380:A04a SMK MJ CIG BEST FRND F3' /
   V7184     '30120:A04b START SMK THISYR F34' /
   V7451     '25360:A05c #X USE DRUG HOME F1' /
   V7452     '25370:A05c #X USE DRG FRNDS F1' /
   V7453     '25380:A05c #X US DRG SCHEVE F1' /
   V7454     '25390:A05c #X USE DRG ATSCH F1' /
   V7455     '25400:A05c #X USE DRG NRSCH F1' /
   V7456     '25410:A05c #X USE DRG INCAR F1' /
   V7457     '25420:A05c #X USE DRG PARTY F1' /
   V8441     '25590:A05c #X USE ALC HOME  F2' /
   V8442     '25600:A05c #X USE ALC FRNDS F2' /
   V8443     '25610:A05c #X USEALC SCHEVE F2' /
   V8444     '25620:A05c #X USE ALC ATSCH F2' /
   V8445     '25630:A05c #X USE ALC NRSCH F2' /
   V8446     '25640:A05c #X USE ALC INCAR F2' /
   V8447     '25650:A05c #X USE ALC PARTY F2' /
   V8476     '25655:A05c #X USE ALC@PARK  F2' /
   V8540     '25690:A05c 4WKS ALC@SCHOOL  F2' /
   V8541     '25700:A05c 4WKS MJ/OTD@SCHL F2' /
   V8542     '25710:A05c 4WKS TOBACCO@SCH F2' /
   V7481     '30830:A05c #X USE DRG@PARK  F1' /
   V7734     '35690:A05c USED JUUL@SCHL PAST 30DAYS  F12' /
   V7183     '30110:A06a START SMK LOSEWT F34' /
   V7772     '35470:A06a CIG HARD TO QUIT  F12' /
   V7740     '35750:A06a JUUL HARD TO QUIT  F12' /
   V7459     '25430:A06b MJ CRN PSYC DAMG F1' /
   V7460     '25440:A06b MJ CRN PHYS DAMG F1' /
   V7461     '25450:A06b MJ CRN GT ARREST F1' /
   V7462     '25460:A06b MJ CRN ADDICTED  F1' /
   V7463     '25470:A06b MJ AGNST BELIEFS F1' /
   V7464     '25480:A06b MJ CRN < ENGYAMB F1' /
   V7465     '25490:A06b MJ CRN < CONTROL F1' /
   V7466     '25500:A06b MJ->STRNGR DRUGS F1' /
   V7467     '25510:A06b MJ NOT ENJOYABLE F1' /
   V7468     '25520:A06b MJ PRNTS DISAPP  F1' /
   V7469     '25530:A06b MJ B/GFRND DISAP F1' /
   V7470     '25540:A06b MJ DISLIKE USERS F1' /
   V7471     '25550:A06b MJ FRNDS NOT USE F1' /
   V7472     '25560:A06b MJ TOO EXPENSIVE F1' /
   V7473     '25570:A06b MJ NOT AVAILABLE F1' /
   V7474     '25580:A06b MJ NOT WNT GT HI F1' /
   V7773     '35480:A06b EVER FELT ADCTD CIG  F12' /
   V7774     '35490:A06b CRAVINGS SMK CIG  F12' /
   V7775     '35500:A06b HARD NOT SMK CIG WHERE NOT SUP TO  F12' /
   V7776     '35510:A06b HARD CONC CDNT SMK CIG  F12' /
   V7777     '35520:A06b IRRTBLE CDNT SMK CIG  F12' /
   V7778     '35530:A06b FEEL STRNG NEED SMK CIG  F12' /
   V7779     '35540:A06b FEEL NRVS CDNT SMK CIG  F12' /
   V7735     '35700:A06b HOW ADCTVE JUUL REG  F12' /
   V7736     '35710:A06b HOW ADCTVE CIG REG  F12' /
   V7737     '35720:A06b HOW ADCTVE MJ REG  F12' /
   V7738     '35730:A06b HOW ADCTVE ALC REG  F12' /
   V7741     '35760:A06b FELT ADDCTD TO JUUL  F12' /
   V7742     '35770:A06b CRAVINGS JUUL  F12' /
   V7743     '35780:A06b HARD NOT USE JUUL WHERE NOT SUP TO  F12' /
   V7744     '35790:A06b HARD CONC CDNT USE JUUL  F12' /
   V7745     '35800:A06b IRRTBLE CDNT USE JUUL  F12' /
   V7746     '35810:A06b FEEL STRNG NEED USE JUUL  F12' /
   V7747     '35820:A06b FEEL NRVS CDNT USE JUUL  F12' /
   V7182     '30100:A06c QUIT SMK WRY FAT F34' /
   V7403     '01815:A07a #X/2W RIDE+ALCL  F13' /
   V7404     '01816:A07a #X/2W RIDE+5DRK  F13' /
   V7613     '33700:A07a #X/2W RIDE+MARJ  F3' /
   V8455     '22365:A08a GT HELP FR DRUGS F24' /
   V7405     '07690:A10a HAD DRUG EDUCATN F3' /
   V7406     '07840:A10a DG ED,>DG INTRST F3' /
   V7407     '07850:A10a DG ED,SPC COURSE F3' /
   V7408     '07860:A10a DG ED,IN REG CRS F3' /
   V7409     '07870:A10a DG ED,NT REG CRS F3' /
   V7410     '07880:A10a DG ED,SPC DISCUS F3' /
   V7411     '07890:A10a DG ED,GRT VALUE  F3' /
   V7482     '30840:A10a DARE EVR IN SCHL F12' /
   V7701     '30260:A10b #X ANTISMK TV/RD F34' /
   V7702     '30270:A10b #X ANTISMK PRINT F34' /
   V7703     '30280:A10b ANTISMK ADS<FVRB F34' /
   V7704     '30290:A10b ANTISMK ADS<LKLY F34' /
   V7705     '30300:A10b ANTISMK ADS EXAG F34' /
   V7593     '33290: A10b SMKRS IN MOVIE  F34' /
   V7344     '24850:A11a DISAP 1+PK CIGS  F12' /
   V7345     '24860:A11a DISAP SMOKELESS  F12' /
   V7346     '24870:A11a DISAP MJ 1-2 X   F12' /
   V7347     '24880:A11a DISAP MJ OCCAS   F12' /
   V7348     '24890:A11a DISAP MJ REG     F12' /
   V7349     '24900:A11a DISAP COKP 1-2 X F12' /
   V7350     '24910:A11a DISAP COKP OCCAS F12' /
   V7351     '24920:A11a DISAP CRK 1-2 X  F12' /
   V7352     '24930:A11a DISAP CRK OCCAS  F12' /
   V7353     '24940:A11a DISAP ALC 1-2 X  F12' /
   V7354     '24950:A11a DISAP ALC EVRYDA F12' /
   V7355     '24960:A11a DISAP 5+ALC WKND F12' /
   V7356     '24970:A11a DISAP INHAL 1-2X F12' /
   V7357     '24980:A11a DISAP INHAL REG  F12' /
   V8547     '24981:A11a DISAP LSD 1-2TM  F2' /
   V8548     '24982:A11a DISAP LSD REGULY F2' /
   V7540     '36710:A11a DISAP H -NDL 1-2X  F1' /
   V7541     '36720:A11a DISAP H -NDL OCC   F1' /
   V8562     '36730:A11a DISAP MDMA 1-2X  F2' /
   V8563     '29965:A11a DISAP MDMA OCC   F2' /
   V7646     '36740:A11a DISAP VAPE NIC OCC F2' /
   V7647     '36750:A11a DISAP VAPE NIC REG F2' /
   V7697     '36760:A11a DISAP JUUL OCC  F1' /
   V7698     '36770:A11a DISAP JUUL REG  F1' /
   V8456     '21000:A11c SMKRS ENJOY LIFE F24' /
   V8457     '21010:A11c PRFR DATE N-SMKR F24' /
   V8458     '21020:A11c HARMFUL CIG EXAG F24' /
   V8459     '21030:A11c SMKR POOR JDGMNT F24' /
   V8460     '21040:A11c DONT MIND SMOKNG F24' /
   V8461     '21050:A11c SMKG DIRTY HABIT F24' /
   V8462     '21055:A11c DTEST NEAR SMKRS F24' /
   V7661     '11380:A12a PRNT DAP CIGS     F2' /
   V7662     '11390:A12a PRNT DAP TRY MARJ F2' /
   V7663     '11400:A12a PRNT DAP MJ OCC F2' /
   V7664     '11410:A12a PRNT DAP MJ REG F2' /
   V7665     '11460:A12a PRNT DAP 5+DR/WE  F2' /
   V7718     '11470:A12b FRD DAP CIGS     F34' /
   V7716     '30380:A12b FRND DAP CIG OCC F34' /
   V7717     '30390:A12b FRND DAP CIG DLY F34' /
   V7719     '30400:A12b FRND DAP SMKL OC F34' /
   V7720     '30410:A12b FRND DAP SMKL DL F34' /
   V7721     '30420:A12b FRND DAP SMKL D+ F34' /
   V7753     '35300:A12b FRND DAP DRIVE MJ F34' /
   V7359     '12360:A14a RSK OF CIG1+PK/D F1234' /
   V7360     '12365:A14a RSK SMKLESS REG  F1234' /
   V7361     '12370:A14a RSK OF MJ 1-2 X  F12' /
   V7362     '12380:A14a RSK OF MJ OCSNLY F12' /
   V7363     '12390:A14a RSK OF MJ REGLY  F12' /
   V8545     '12400:A14a RSK OF LSD 1-2X  F2' /
   V8546     '12410:A14a RSK OF LSD REGLY F2' /
   V7364     '12501:A14a RSK COK PWDR 1-2 F12' /
   V7365     '12502:A14a RSK COK PWDR OCC F12' /
   V7366     '12504:A14a RSK CRACK 1-2X   F12' /
   V7367     '12505:A14a RSK CRACK OCC    F12' /
   V7368     '12510:A14a RSK OF 1-2 DRINK F12' /
   V7369     '12520:A14a RSK OF 1-2 DR/DA F12' /
   V7370     '12540:A14a RSK OF 5+DR/WKND F12' /
   V8560     '23040:A14a RSK MDMA 1-2X   F12' /
   V8561     '23045:A14a RSK MDMA OCC    F12' /
   V7371     '25000:A14a RSK INHALANT 1-2 F12' /
   V7372     '25010:A14a RSK INHALANT REG F12' /
   V7542     '29600:A14a RSK H -NDL 1-2X  F1' /
   V7543     '29610:A14a RSK H -NDL OCC   F1' /
   V7377     '30750:A14a RSK 1-5 CIGS/DAY F34' /
   V7577     '32630:A14a RSK ADDERALL 1-2X F34' /
   V7578     '32640:A14a RSK ADDERALL OCC F34' /
   V7573     '32770:A14a RSK SYNTHETIC MJ 1-2X F34' /
   V7574     '32780:A14a RSK SYNTHETIC MJ OCC F34' /
   V7579     '32810:A14a RSK OXYCON 1-2X  F34' /
   V7580     '32820:A14a RSK OXYCON OCC   F34' /
   V7581     '32830:A14a RSK VICODIN 1-2X F34' /
   V7582     '32840:A14a RSK VICODIN OCC  F34' /
   V7583     '32850:A14a RSK COUGHMD 1-2X F34' /
   V7584     '32860:A14a RSK COUGHMD OCC  F34' /
   V7585     '32870:A14a RSK DISLV TOB REG F34' /
   V7586     '32880:A14a RSK SNUS REG     F34' /
   V7612     '33690:A14a RSK SML CIGAR REG F34' /
   V7644     '34190:A14a RSK VAPE NIC OCC F2' /
   V7645     '34200:A14a RSK VAPE NIC REGLY F2' /
   V7699     '35120:A14a RSK JUUL OCC  F134' /
   V7700     '35130:A14a RSK JUUL REG  F134' /
   V7710     '22380:A17a USE DRUGS-ATHLTS  F34' /
   V7712     '22400:A17a USE DRUGS-ACTORS  F34' /
   V7713     '22405:A17a USE DRUGS-PEERS  F34' /
   V7706     '30310:A17a CIG SMKRS-ATHLTS F34' /
   V7708     '30330:A17a CIG SMKRS-ACTORS F34' /
   V7709     '30340:A17a CIG SMKRS-PEERS  F34' /
   V7591     '33270:A17a CIG SMKRS-MUSIC  F34' /
   V7592     '33280:A17a USE DRUGS-MUSIC  F34' /
   V7670     '34400:A18a MJ ADS STOREFRONT F4' /
   V7671     '34410:A18a MJ ADS BILLBOARDS F4' /
   V7672     '34420:A18a MJ ADS SCREEN F4' /
   V7673     '34430:A18a MJ ADS RADIO F4' /
   V7189     '30160:A18b OWN TOBACCO LOGO F34' /
   V7190     '30170:A18b CIG LOGO CAMEL   F34' /
   V7191     '30180:A18b CIG LOGO KOOL    F34' /
   V7192     '30190:A18b CIG LOGO MARLB   F34' /
   V7193     '30200:A18b CIG LOGO NEWPT   F34' /
   V7194     '30210:A18b CIG LOGO VASLM   F34' /
   V7195     '30220:A18b CIG LOGO OTHER   F34' /
   V7196     '30230:A18c SAVED CIG COUPON F34' /
   V7197     '30240:A18c SAVE CIG CPN NOW F34' /
   V7222     '00400:B01 R''S HS PROGRAM   F1234' /
   V7221     '00470:B01 R HS GRADE/D=1   F1234' /
   V7223     '00481:B01 R WL GRADUATE HS F1234' /
   V7327     '07640:B01 HRS/WK SPND HMWK F1234' /
   V7516     '22170:B01 SCH ACTV-PBLCTNS F13' /
   V7517     '22180:B01 SCH ACTV-PRF ART F13' /
   V7518     '22190:B01 SCH ACTV-ATHLTCS F13' /
   V7519     '22200:B01 SCH ACTV-OTH ACT F13' /
   V7329     '23090:B01 LSTYR/ENJOY SCHL F1234' /
   V7330     '23100:B01 LSTYR/HATE SCHL  F1234' /
   V7331     '23110:B01 LSTYR/DO BEST WK F1234' /
   V7332     '23120:B01 LSTYR/SCH 2 HARD F1234' /
   V7334     '23140:B01 LSTYR/WK NT DONE F1234' /
   V7335     '23160:B01 LSTYR/U MISBEHAV F1234' /
   V7232     '23530:B01 EVER HELD BACK   F1234' /
   V7233     '23540:B01 NEED SUMMER SCHL F1234' /
   V7301     '24770:B01 WHAT GRADE LEVL  F1234' /
   V7333     '24840:B01 LSTYR/WK INTRSTG F1234' /
   V7251     '25830:B01 THNK FUT BYND SC F1234' /
   V7252     '25840:B01 PLANS AFTER SCHL F1234' /
   V7384     '31500:B01 SPORT/12M NONE   F1' /
   V7385     '31510:B01 SPORT/12M BASEBL F1' /
   V7386     '31520:B01 SPORT/12M BSKTBL F1' /
   V7496     '31525:B01 SPORT/12M CHEERLDG F1' /
   V7497     '31528:B01 SPORT/12M CREW   F1' /
   V7387     '31530:B01 SPORT/12M XCNTRY F1' /
   V7498     '31535:B01 SPORT/12M EQUESTRN F1' /
   V7388     '31540:B01 SPORT/12M FLDHKY F1' /
   V7389     '31550:B01 SPORT/12M FOOTBL F1' /
   V7499     '31555:B01 SPORT/12M GOLF   F1' /
   V7390     '31560:B01 SPORT/12M GYMNST F1' /
   V7391     '31570:B01 SPORT/12M ICEHKY F1' /
   V7392     '31580:B01 SPORT/12M LCRSSE F1' /
   V7393     '31590:B01 SPORT/12M SWIM   F1' /
   V7394     '31600:B01 SPORT/12M SOCCER F1' /
   V7395     '31610:B01 SPORT/12M TENNIS F1' /
   V7396     '31620:B01 SPORT/12M TRACK  F1' /
   V7397     '31630:B01 SPORT/12M VLLYBL F1' /
   V7500     '31635:B01 SPORT/12M WATER POLO F1' /
   V7398     '31640:B01 SPORT/12M WTLIFT F1' /
   V7399     '31650:B01 SPORT/12M WRESTL F1' /
   V7400     '31660:B01 SPORT/12M OTHER  F1' /
   V7522     '05730:B04 LOT CMPTN GRADE  F13' /
   V7523     '05740:B04 STDTS DSLK CHTG  F13' /
   V7524     '05750:B04 ST -LK PROV TCH  F13' /
   V7525     '05760:B04 FRD NCG/TCH -LK  F13' /
   V7526     '13580:B04 STS SCH RT FAMLY F13' /
   V7527     '13590:B04 STS SCH LDS STU  F13' /
   V7528     '13600:B04 STS SCH NIC CAR  F13' /
   V7529     '13610:B04 STS SCH HI GRDE  F13' /
   V7530     '13620:B04 STS SCH GD ATHLT F13' /
   V7531     '13640:B04 STS SCH PLN CLG  F13' /
   V8537     '25730:B04 #X TCHR INTRUPT  F2' /
   V8538     '25740:B04 #X MISBHVR INT U F2' /
   V7537     '25760:B04 SCHL RULES FAIR  F1' /
   V7253     '25850:B04 FRNDS DROP OUT   F1234' /
   V7228     '00430:B06 #DA/4W SC MS ILL F1234' /
   V7229     '00440:B06 #DA/4W SC MS CUT F1234' /
   V7230     '00450:B06 #DA/4W SC MS OTH F1234' /
   V7231     '00460:B06 #DA/4W SKP CLASS F1234' /
   V8539     '25750:B06 #X U UNEXCSD LAT F2' /
   V8516     '06540:B07 FRQ FGT WRK/SCHL F2' /
   V8522     '06650:B07 FRQ DMG SCH PPTY F24' /
   V7509     '09871:B07 SM1 SCL ROB <$50 F1' /
   V7510     '09872:B07 SM1 SCL ROB >$50 F1' /
   V7511     '09873:B07 SM1 SCL DMG PRTY F1' /
   V7512     '09874:B07 SM1 SCL IN U W/W F1' /
   V7513     '09875:B07 SM1 SCL TH U W/W F1' /
   V7514     '09876:B07 SM1 SCL IN U -WP F1' /
   V7515     '09877:B07 SM1 SCL TH U W/I F1' /
   V7234     '25140:B07 EVER SUSPENDED   F1234' /
   V8543     '25720:B07 4WKS WEAPON@SCHL F2' /
   V7534     '25770:B07 FEEL UNSAFE@SCHL F1' /
   V7535     '25780:B07 UNSAF TO/FRM SCH F1' /
   V7536     '25790:B07 4WK/UNSAF AVDSCH F1' /
   V7538     '29590:B07 #DA GUN SCHL/4WK F1' /
   V7224     '00480:B09 R WL DO VOC/TEC  F1234' /
   V7225     '00482:B09 R WL GO TO CLG   F1234' /
   V7227     '00490:B09 R WL DO ARMD FC  F1234' /
   V7226     '00510:B09 R WL DO 4YR CLG  F1234' /
   V7235     '25150:C01 HRS/WK PAID JOB  F1234' /
   V7238     '25160:C01 KIND OF PAID JOB F12' /
   V7236     '00600:C02 R$/AVG WEEK JOB  F1234' /
   V7237     '00610:C02 R$/AVG WEEK OTH  F1234' /
   V7374     '25800:C04 # HRS PREF WORK  F234' /
   V7240     '00630:C07 #X DATE 3+/WK    F1234' /
   V7309     '05830:C07 DALY GO TO MOVIE F1!2!3!4!' /
   V7310     '05846:C07 DALY MUSIC CNCRT F1!2!3!4!' /
   V7311     '05850:C07 DALY RIDE FORFUN F1!2!3!4!' /
   V7312     '05860:C07 DALY CMNTY AFFRS F1!2!3!4!' /
   V7313     '05890:C07 DALY ACTV SPORTS F1!2!3!4!' /
   V7378     '05925:C07 DALY VIS FRDS FR F1!2!3!4!' /
   V7379     '05935:C07 DALY GO TO MALL  F1!2!3!4!' /
   V7380     '05945:C07 DALY ALONE LS/FR F1!2!3!4!' /
   V7319     '05970:C07 DALY GO TO PARTY F1!2!3!4!' /
   V7320     '24780:C07 #XUSE RADIO4NEWS F1!2!3!4!' /
   V7321     '24790:C07 #XUSE TV 4 NEWS  F1!2!3!4!' /
   V7214     '25120:C07 AFTER SCHL ALONE F1234' /
   V7239     '25170:C07 #X OUT W/O PRNT  F1234' /
   V7676     '34640:C07 #X PRINT NWSP/MAG 4NEWS F1234' /
   V7677     '34650:C07 #X SOCIAL/MEDIA 4NEWS F1234' /
   V7678     '34660:CO7 #X OTH ONLINE SOURCE 4NEWS F1234' /
   V7682     '34700:C07 HRS/DAY GAMING/DEVICE F1234' /
   V7684     '34720:C07 HRS/DAY TALK PHONE F1234' /
   V7685     '34730:C07 HRS/DAY SOCIAL/NETW F1234' /
   V7686     '34740:C07 HRS/DAY VIDEO CHAT F1234' /
   V7687     '34750:C07 HRS/DAY SHOP ONLINE F1234' /
   V7688     '34760:C07 HRS/DAY EMAILING F1234' /
   V7689     '34770:C07 WKDAY HRS WATCH/VIDEO F1234' /
   V7690     '34780:C07 WKEND HRS WATCH/VIDEO F1234' /
   V7683     '34710:C10 HRS/DAY TEXTING  F1234' /
   V7341     '07970:D05 MN=ACHV/WMN=HOME F2' /
   V7532     '10530:D05 MO SH B W CHL>TM F3' /
   V7533     '12180:D05 FTHR>TIME W CHLD F3' /
   V7339     '07930:D06 MEN+WOMN/=$,=WRK F2' /
   V7340     '07950:D06 WMN SHD =JOB OPP F2' /
   V7401     '00640:F07 DRIVE>200 MI/WK  F13' /
   V7402     '22220:F07 USE SEATBLT-RIDR F13' /
   V7219     '00370:G R''ATTND REL SVC  F1234' /
   V7220     '00380:G RLGN IMP R''S LF  F1234' /
   V7255     '25870:M02 TALK PROB W/ADLT F1234' /
   V7241     '25180:M03 #X PRNT CHK HMWK F12' /
   V7242     '25190:M03 #X PRNT HLP HMWK F12' /
   V7243     '25200:M03 #X PRNT GV CHORE F12' /
   V7244     '25210:M03 #X PRNT LIMIT TV F12' /
   V7258     '25225:M03 #X PRNT ALW OUT  F12' /
   V7375     '25810:M03 PRT #HR PREF WRK F2' /
   V7254     '25860:M03 TALK PROB W/PRNT F1234' /
   V7259     '30760:M03 PRN KNW AFT SCHL F34' /
   V7260     '30770:M03 PRN KNW WHO@NITE F34' /
   V7261     '30780:M03 PRN KNW WHER@NGT F34' /
   V7262     '30790:M03 R''S WKND CURFEW  F34' /
   V7565     '32740:M03 DINNER W/PARENT  F1' /
   V7302     '01190:P01 VRY HPY THS DAY  F1234' /
   V8512     '12620:P01 SATISFD W MYSELF F24' /
   V8502     '23700:P01 LIFE MEANINGLESS F24' /
   V8505     '23710:P01 I ENJOY LIFE     F24' /
   V8509     '23720:P01 FUTURE HOPELESS  F24' /
   V8514     '23730:P01 GOOD TO BE ALIVE F24' /
   V8536     '25670:P01 FUTR R LIFE WRSE F2' /
   V8501     '12550:Q01 POS ATT TWD SELF F24' /
   V8504     '12570:Q01 AM PRSN OF WORTH F24' /
   V8508     '12580:Q01 DO WELL AS OTHRS F24' /
   V8503     '12660:Q01 -MUCH TO B PROUD F24' /
   V8507     '12680:Q01 I AM NO GOOD     F24' /
   V8511     '12720:Q01 I DO WRONG THING F24' /
   V8513     '12750:Q01 MY LIFE NT USEFL F24' /
   V7660     '34350:Q01 OFTEN FEEL ANXIOUS F24' /
   V7674     '34440:Q01 WRY HOW PPL REACT TO ME F4' /
   V7675     '34450:Q01 CONTROL TEMPER F4' /
   V7501     '12650:Q03 OFTN FEEL LONELY F3' /
   V7502     '12670:Q03 ALWYS SM1 HELP R F3' /
   V7504     '12690:Q03 OFTN FL LEFT OUT F3' /
   V7505     '12710:Q03 USLY SM1 TALK TO F3' /
   V7507     '12730:Q03 OFT WSH MOR FRND F3' /
   V7508     '12760:Q03 USLY FRDS BE WTH F3' /
   V7503     '07050:Q04 KICK DO DANGR TH F234' /
   V7506     '07060:Q04 LIKE RISK SOME X F234' /
   V8555     '31080:Q04 LIK XPLOR STRANG F2' /
   V8556     '31090:Q04 LIK DO FRIGHT TG F2' /
   V8557     '31100:Q04 LIK EVN BRK RULE F2' /
   V8558     '31110:Q04 PRF FRND EXCITNG F2' /
   V8565     '32000:Q10 I AM OFTEN BORED F2' /
   V8566     '32010:Q10 OFT NOTHNG TO DO F2' /
   V1252     '89838:R01 AGE <>16 DICHOTOMY (10TH GR ONLY)' /
   V7202     '00030:R01 R''S SEX          F1234' /
   V1070     '89501:RACE--B/W/H  F1234' /
   V7215     '00310:R02 FATHR EDUC LEVEL F1234' /
   V7216     '00320:R02 MOTHR EDUC LEVEL F1234' /
   V7217     '25130:R02 MOTHER PAID JOB  F1234' /
   V7206     '00090:R03 R''S HSHLD FATHER F1234' /
   V7207     '00100:R03 R''S HSHLD MOTHER F1234' /
   V7208     '00111:R03 R''S HSHLD SIBLING F1234' /
   V7205     '25110:R03 WHERE LIVE NOW   F1234' /
   V8517     '06550:S01 FRQ GANG FIGHT   F2' /
   V8518     '06560:S01 FRQ HURT SM1 BAD F2' /
   V8519     '06580:S01 FRQ STEAL <$50   F24' /
   V8520     '06590:S01 FRQ STEAL >$50   F24' /
   V8521     '06630:S01 FRQ TRESPAS BLDG F2' /
   V8523     '23610:S01 FRQ SELL DRUGS   F2' /
   V8515     '25660:S01 FRQ RUN AWAY HOM F2' /
   V7691     '34790:S03 FEEL BULLIED@SCHL F1' /
   V7692     '34800:S03 FEEL BULLIED ONLINE F1' /
   V8526     '20740:T02 OFTN EAT BRKFST  F2' /
   V8527     '20750:T02 OFTN EAT GN VEG  F2' /
   V8528     '20760:T02 OFTN EAT FRUIT   F2' /
   V8529     '20770:T02 OFTN EXERCISE    F2' /
   V8530     '20780:T02 OFTN 7HRS SLEEP  F2' /
   V8531     '20790:T02 OFTN SLEEP <SHLD F2' /
   V7555     '32520:T02 #DA/WK ACTV 60 MIN F1' /
   V7639     '34030:T05 CONCUSSION EVER F1' /
   V7101D    '00760: A01a EVR SMK CIG,REGL F1234 (dichotomous recode)' /
   V7102D    '00780: A01c #CIGS SMKD/30DAY F1234 (dichotomous recode)' /
   V7105D    '00810: A01a #X DRNK/LIFETIME F1234 (dichotomous recode)' /
   V7106D    '00820: A01b #X DRNK/LAST12MO F1234 (dichotomous recode)' /
   V7107D    '00830: A01c #X DRNK/LAST30DA F1234 (dichotomous recode)' /
   V7112D    '00860: A01a #XMJ+HS/LIFETIME F1234 (dichotomous recode)' /
   V7113D    '00870: A01b #XMJ+HS/LAST12MO F1234 (dichotomous recode)' /
   V7114D    '00880: A01c #XMJ+HS/LAST30DA F1234 (dichotomous recode)' /
   V7115D    '00890: A01a #X LSD/LIFETIME  F1234 (dichotomous recode)' /
   V7116D    '00900: A01b #X LSD/LAST 12MO F1234 (dichotomous recode)' /
   V7117D    '00910: A01c #X LSD/LAST 30DA F1234 (dichotomous recode)' /
   V7118D    '00920: A01a #X PSYD/LIFETIME F1234 (dichotomous recode)' /
   V7119D    '00930: A01b #X PSYD/LAST12MO F1234 (dichotomous recode)' /
   V7120D    '00940: A01c #X PSYD/LAST30DA F1234 (dichotomous recode)' /
   V7127D    '00980: A01a #X AMPH/LIFETIME F1234 (dichotomous recode)' /
   V7128D    '00990: A01b #X AMPH/LAST12MO F1234 (dichotomous recode)' /
   V7129D    '01000: A01c #X AMPH/LAST30DA F1234 (dichotomous recode)' /
   V7097D    '01040: A01a #X SED/BARB/LIFE F134 (dichotomous recode)' /
   V7098D    '01050: A01b #X SED/BARB/12MO F134 (dichotomous recode)' /
   V7099D    '01060: A01c #X SED/BARB/30DA F134 (dichotomous recode)' /
   V7133D    '01070: A01a #X TRQL/LIFETIME F1234 (dichotomous recode)' /
   V7134D    '01080: A01b #X TRQL/LAST12MO F1234 (dichotomous recode)' /
   V7135D    '01090: A01c #X TRQL/LAST30DA F1234 (dichotomous recode)' /
   V7142D    '01160: A01a #X INHL/LIFETIME F234 (dichotomous recode)' /
   V7143D    '01170: A01b #X INHL/LAST12MO F234 (dichotomous recode)' /
   V7144D    '01180: A01c #X INHL/LAST30DA F234 (dichotomous recode)' /
   V7139D    '01130: A01a #X NARC/LIFETIME F34 (dichotomous recode)' /
   V7140D    '01140: A01b #X NARC/LAST12MO F34 (dichotomous recode)' /
   V7141D    '01150: A01c #X NARC/LAST30DA F34 (dichotomous recode)' /
   .


* SPSS VALUE LABELS COMMAND.

VALUE LABELS
   V3        1 'FORM 1:(1)' 2 'FORM 2:(2)' 3 'FORM 3:(3)' 4 'FORM 4:(4)' /
   V507      1 'NORTHEAST:(1)' 2 'MIDWEST:(2)' 3 'SOUTH:(3)' 4 'WEST:(4)' /
   V508      0 'NOT SELF REPRESENTING:(0)' 1 'SELF REPRESENT METRO:(1)' /
   V509      0 'NON SMSA:(0)' 1 'STANDARD METRO STAT AREA:(1)' /
   TABLET    0 'PAPER:(0)' 1 'TABLET:(1)' /
   RANDOMDRAW -5 'R NT ASKD TAB Q:(-5)' 0 'MID:(0)' 1 'END:(1)' /
   V7101     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 '1-2X:(2)' 3 'OCCASIONALLY:(3)' 4 'REGULAR PAST:(4)'
             5 'REGULAR NOW:(5)' /
   V7104     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'YES:(2)' /
   V7105     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7112     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7115     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7118     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7127     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7097     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7133     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7139     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7142     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V8451     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7426     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 '1-2X:(2)' 3 'OCCASIONALLY:(3)' 4 'REGULAR PAST:(4)'
             5 'REGULAR NOW:(5)' /
   V7121     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7124     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7164     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7145     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7109     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7152     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7155     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7158     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7161     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7601     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V8480     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7648     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NO:(0)'
             1 'YES:(1)' /
   V7693     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7755     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 DAYS:(1)'
             2 '1-2 DAYS:(2)' 3 '3-5 DAYS:(3)' 4 '6-9 DAYS:(4)'
             5 '10-19 DAYS:(5)' 6 '20 OR MORE:(6)' /
   V7758     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT@ALL:(1)'
             2 '<1/MONTH:(2)' 3 '1-3X/MON:(3)' 4 '1-3/WEEK:(4)' 5 'DAILY:(5)'
             6 '>1/DAY:(6)' /
   V7761     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 DAYS:(1)'
             2 '1-2 DAYS:(2)' 3 '3-5 DAYS:(3)' 4 '6-9 DAYS:(4)'
             5 '10-19 DAYS:(5)' 6 '20 OR MORE:(6)' /
   V7764     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 DAYS:(1)'
             2 '1-2 DAYS:(2)' 3 '3-5 DAYS:(3)' 4 '6-9 DAYS:(4)'
             5 '10-19 DAYS:(5)' 6 '20 OR MORE:(6)' /
   V7767     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 DAYS:(1)'
             2 '1-2 DAYS:(2)' 3 '3-5 DAYS:(3)' 4 '6-9 DAYS:(4)'
             5 '10-19 DAYS:(5)' 6 '20 OR MORE:(6)' /
   V7728     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 '0 DAYS:(1)' 2 '1-2 DAYS:(2)'
             3 '3-5 DAYS:(3)' 4 '6-9 DAYS:(4)' 5 '10-19 DAYS:(5)'
             6 '20 OR MORE:(6)' /
   V7106     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7113     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7116     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7119     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7128     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7098     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7134     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7140     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7143     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V8452     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7122     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7125     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7165     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7146     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7110     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7153     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7156     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7159     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7162     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7602     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7488     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7489     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7491     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7492     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V8481     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7495     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7554     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7561     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7564     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7566     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7568     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7569     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7640     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7694     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7756     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 DAYS:(1)'
             2 '1-2 DAYS:(2)' 3 '3-5 DAYS:(3)' 4 '6-9 DAYS:(4)'
             5 '10-19 DAYS:(5)' 6 '20 OR MORE:(6)' /
   V7759     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT@ALL:(1)'
             2 '<1/MONTH:(2)' 3 '1-3X/MON:(3)' 4 '1-3/WEEK:(4)' 5 'DAILY:(5)'
             6 '>1/DAY:(6)' /
   V7762     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 DAYS:(1)'
             2 '1-2 DAYS:(2)' 3 '3-5 DAYS:(3)' 4 '6-9 DAYS:(4)'
             5 '10-19 DAYS:(5)' 6 '20 OR MORE:(6)' /
   V7765     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 DAYS:(1)'
             2 '1-2 DAYS:(2)' 3 '3-5 DAYS:(3)' 4 '6-9 DAYS:(4)'
             5 '10-19 DAYS:(5)' 6 '20 OR MORE:(6)' /
   V7768     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 DAYS:(1)'
             2 '1-2 DAYS:(2)' 3 '3-5 DAYS:(3)' 4 '6-9 DAYS:(4)'
             5 '10-19 DAYS:(5)' 6 '20 OR MORE:(6)' /
   V7729     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 '0 DAYS:(1)' 2 '1-2 DAYS:(2)'
             3 '3-5 DAYS:(3)' 4 '6-9 DAYS:(4)' 5 '10-19 DAYS:(5)'
             6 '20 OR MORE:(6)' /
   V7102     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '<1 CIG DAY:(2)' 3 '1-5 CIG DAY:(3)' 4 '1/2 PACK DAY:(4)'
             5 '1 PACK DAY:(5)' 6 '1.5 PACK DAY:(6)' 7 '2+ PACKS DAY:(7)' /
   V7107     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7114     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7117     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7120     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7129     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7099     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7135     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7141     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7144     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V8453     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7427     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '1-2 X:(2)' 3 '1-2/WK:(3)' 4 '3-5/WK:(4)' 5 '1/DAY:(5)'
             6 '>1/DAY:(6)' /
   V7123     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7126     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7166     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7147     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7111     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7154     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7157     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7160     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7163     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7603     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V8482     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7615     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '1-2 DAYS:(2)' 3 '3-5 DAYS:(3)' 4 '6-9 DAYS:(4)'
             5 '10-19 DAYS:(5)' 6 '20-30 DAYS:(6)' /
   V7616     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '1-2 DAYS:(2)' 3 '3-5 DAYS:(3)' 4 '6-9 DAYS:(4)'
             5 '10-19 DAYS:(5)' 6 '20-30 DAYS:(6)' /
   V7617     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '1-2 DAYS:(2)' 3 '3-5 DAYS:(3)' 4 '6-9 DAYS:(4)'
             5 '10-19 DAYS:(5)' 6 '20-30 DAYS:(6)' /
   V7642     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '1-2 DAYS:(2)' 3 '3-5 DAYS:(3)' 4 '6-9 DAYS:(4)'
             5 '10-19 DAYS:(5)' 6 '20-30 DAYS:(6)' /
   V7695     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 OCCASIONS:(1)'
             2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)' 5 '10-19X:(5)'
             6 '20-39X:(6)' 7 '40+X:(7)' /
   V7669     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '1-2 DAYS:(2)' 3 '3-5 DAYS:(3)' 4 '6-9 DAYS:(4)'
             5 '10-19 DAYS:(5)' 6 '20-30 DAYS:(6)' /
   V7757     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 DAYS:(1)'
             2 '1-2 DAYS:(2)' 3 '3-5 DAYS:(3)' 4 '6-9 DAYS:(4)'
             5 '10-19 DAYS:(5)' 6 '20 OR MORE:(6)' /
   V7760     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT@ALL:(1)'
             2 '<1/MONTH:(2)' 3 '1-3X/MON:(3)' 4 '1-3/WEEK:(4)' 5 'DAILY:(5)'
             6 '>1/DAY:(6)' /
   V7763     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 DAYS:(1)'
             2 '1-2 DAYS:(2)' 3 '3-5 DAYS:(3)' 4 '6-9 DAYS:(4)'
             5 '10-19 DAYS:(5)' 6 '20 OR MORE:(6)' /
   V7766     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 DAYS:(1)'
             2 '1-2 DAYS:(2)' 3 '3-5 DAYS:(3)' 4 '6-9 DAYS:(4)'
             5 '10-19 DAYS:(5)' 6 '20 OR MORE:(6)' /
   V7769     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 DAYS:(1)'
             2 '1-2 DAYS:(2)' 3 '3-5 DAYS:(3)' 4 '6-9 DAYS:(4)'
             5 '10-19 DAYS:(5)' 6 '20 OR MORE:(6)' /
   V7730     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 '0 DAYS:(1)' 2 '1-2 DAYS:(2)'
             3 '3-5 DAYS:(3)' 4 '6-9 DAYS:(4)' 5 '10-19 DAYS:(5)'
             6 '20 OR MORE:(6)' /
   V7108     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)' 5 '6-9 TIMES:(5)'
             6 '10+ TIMES:(6)' /
   V7641     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)' 5 '6-9 TIMES:(5)'
             6 '10+ TIMES:(6)' /
   V8454     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)' 5 '6-9 TIMES:(5)'
             6 '10+ TIMES:(6)' /
   V7726     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 '1-2 TIMES/DAY:(1)'
             2 '3-9 TIMES/DAY:(2)' 3 '10-14 TIMES/DAY:(3)'
             4 '15-20 TIMES/DAY:(4)' 5 '> 20 TIMES/DAY:(5)' /
   V7727     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 '1-2 PUFFS:(1)' 2 '3-9 PUFFS:(2)'
             3 '10-14 PUFFS:(3)' 4 '15-20 PUFFS:(4)' 5 '> 20 PUFFS:(5)' /
   V7731     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 'JUUL PD NO NIC(1)'
             2 '1 CIG OR <:(2)' 3 '2-5 CIG:(3)' 4 '6-10 CIG:(4)'
             5 '11-19 CIG:(5)' 6 '1 PACK (20 CIG):(6)'
             7 '2 PACK (40 CIG):(7)' 8 'DK:(8)' /
   V7442     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE 4 OR <:(1)'
             2 'GRADE 5:(2)' 3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)'
             6 'GRADE 9:(6)' 7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V7441     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE 4 OR <:(1)'
             2 'GRADE 5:(2)' 3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)'
             6 'GRADE 9:(6)' 7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V8413     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE 4 OR <:(1)'
             2 'GRADE 5:(2)' 3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)'
             6 'GRADE 9:(6)' 7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V7443     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE 4 OR <:(1)'
             2 'GRADE 5:(2)' 3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)'
             6 'GRADE 9:(6)' 7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V7444     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE 4 OR <:(1)'
             2 'GRADE 5:(2)' 3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)'
             6 'GRADE 9:(6)' 7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V7445     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE 4 OR <:(1)'
             2 'GRADE 5:(2)' 3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)'
             6 'GRADE 9:(6)' 7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V8417     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE 4 OR <:(1)'
             2 'GRADE 5:(2)' 3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)'
             6 'GRADE 9:(6)' 7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V8418     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE 4 OR <:(1)'
             2 'GRADE 5:(2)' 3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)'
             6 'GRADE 9:(6)' 7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V8419     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE 4 OR <:(1)'
             2 'GRADE 5:(2)' 3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)'
             6 'GRADE 9:(6)' 7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V8483     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE 4 OR <:(1)'
             2 'GRADE 5:(2)' 3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)'
             6 'GRADE 9:(6)' 7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V8421     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE 4 OR <:(1)'
             2 'GRADE 5:(2)' 3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)'
             6 'GRADE 9:(6)' 7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V7446     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE 4 OR <:(1)'
             2 'GRADE 5:(2)' 3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)'
             6 'GRADE 9:(6)' 7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V7447     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE 4 OR <:(1)'
             2 'GRADE 5:(2)' 3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)'
             6 'GRADE 9:(6)' 7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V8424     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE 4 OR <:(1)'
             2 'GRADE 5:(2)' 3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)'
             6 'GRADE 9:(6)' 7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V8425     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE 4 OR <:(1)'
             2 'GRADE 5:(2)' 3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)'
             6 'GRADE 9:(6)' 7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V7448     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE 4 OR <:(1)'
             2 'GRADE 5:(2)' 3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)'
             6 'GRADE 9:(6)' 7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V7449     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE 4 OR <:(1)'
             2 'GRADE 5:(2)' 3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)'
             6 'GRADE 9:(6)' 7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V8564     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE 4 OR <:(1)'
             2 'GRADE 5:(2)' 3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)'
             6 'GRADE 9:(6)' 7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V7548     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '1-4 YRS:(1)'
             2 '5-9:(2)' 3 '10-14:(3)' 4 '15+ YRS:(4)' /
   V7638     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE 4:(1)'
             2 'GRADE 5:(2)' 3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)'
             6 'GRADE 9:(6)' 7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V7103     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'YES:(1)'
             2 'NO:(2)' /
   V7180     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)' 5 '6-9 TIMES:(5)'
             6 '10+ TIMES:(6)' /
   V7181     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'YES:(1)'
             2 'NO:(2)' 8 'DONT SMOKE:(8)' /
   V7475     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'YES:(2)' 8 'NEVER USED:(8)' /
   V7476     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'YES:(2)' 8 'NEVER USED:(8)' /
   V7477     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'YES:(2)' 8 'NEVER USED:(8)' /
   V7478     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'YES:(2)' 8 'NEVER USED:(8)' /
   V7479     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'YES:(2)' 8 'NEVER USED:(8)' /
   V7480     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'YES:(2)' 8 'NEVER USED:(8)' /
   V7771     -9 'DID NOT ANSWER:(-9)' -8 'NO CIGS 30 DAYS:(-8)'
             -7 'NEVER SMOKED CIGS:(-7)' -5 'R NT ASKD TAB Q:(-5)'
             1 'YES:(1)' 2 'NO:(2)' /
   V7739     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 'YES:(1)' 2 'NO:(2)' /
   V7547     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'YES PAST:(2)' 3 'YES NOW:(3)' /
   V7549     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '<1 YEAR:(1)'
             2 '1 YEAR:(2)' 3 '2 YRS:(3)' 4 '3-5 YRS:(4)' 5 '6-9 YRS:(5)'
             6 '10+ YRS:(6)' /
   V7550     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'YES PAST:(2)' 3 'YES NOW:(3)' 8 'DONT KNOW:(8)' /
   V7643     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'YES, USING MED MARJ:(2)' 3 'USED MED MARJ, BUT NOT NOW:(3)' /
   V7176     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'BASIC:(1)'
             2 'BEN&HEDGE:(2)' 3 'BLK&WHITE:(3)' 4 'CAMBRIDGE:(4)'
             5 'CAMEL:(5)' 6 'CAPRI:(6)' 7 'CARLTON:(7)' 8 'DORAL:(8)'
             9 'GPC:(9)' 10 'KENT:(10)' 11 'KOOL:(11)' 12 'MARLBORO:(12)'
             13 'MERIT:(13)' 14 'MISTY:(14)' 15 'MONARCH:(15)' 16 'MORE:(16)'
             17 'NEWPORT:(17)' 18 'PALLMALL:(18)' 19 'PARLMENT:(19)'
             20 'SALEM:(20)' 22 'VA SLIMS:(22)' 23 'WINSTON:(23)'
             24 'OTHER:(24)' 25 'NONE:(25)' 26 'AMER SPIRIT:(26)' /
   V7587     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'YES:(1)'
             2 'NO:(2)' /
   V7722     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 'JUUL:(1)' 2 'KANDYPENS:(2)'
             3 'VUSE:(3)' 4 'BLU:(4)' 5 'OTHER:(5)' 6 'MARKTEN:(6)'
             7 'LOGIC:(7)' 8 'BO:(8)' 9 'MYLE:(9)' 10 'PHIX:(10)'
             11 'SMOK:(11)' 12 'SMPO:(12)' 13 'SUORIN:(13)' 14 'ZOOR:(14)' /
   V7723     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 0 'NO OTHR BRND:(0)' 1 'JUUL:(1)'
             2 'KANDYPENS:(2)' 3 'VUSE:(3)' 4 'BLU:(4)' 5 'OTHER:(5)'
             6 'MARKTEN:(6)' 7 'LOGIC:(7)' 8 'BO:(8)' 9 'MYLE:(9)'
             10 'PHIX:(10)' 11 'SMOK:(11)' 12 'SMPO:(12)' 13 'SUORIN:(13)'
             14 'ZOOR:(14)' /
   V7724     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 'YES:(1)' 2 'NO:(2)' /
   V7725     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 'YES:(1)' 2 'NO:(2)' /
   V7733     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 'CLASSIC TOBACCO:(1)' 2 'CREME:(2)'
             3 'CUCUMBER:(3)' 4 'FRUIT:(4)' 5 'MANGO:(5)' 6 'MENTHOL:(6)'
             7 'MINT:(7)' 8 'VIRGINIA TOBACCO:(8)' 9 'OTHER:(9)' /
   V7732     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 0 'TK FRM REL WO ASK:(0)'
             1 'GVN FREE BY FRND:(1)' 2 'GVN FREE BY REL: (2)'
             3 'BOUGHT FRM FRND:(3)' 4 'BOUGHT FRM REL:(4)'
             5 'CONVENIENCE STOR:(5)' 6 'AT VAPE STOR:(6)'
             7 'OVER INTERNET:(7)' 8 'FRM JUUL DEALER:(8)' 9 'OTHER:(9)' /
   V7557     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NONE:(0)'
             1 '< ONE:(1)' 2 'ONE:(2)' 3 'TWO:(3)' 4 'THREE:(4)' 5 'FOUR:(5)'
             6 'FIVE-SIX:(6)' 7 '7 OR +:(7)' /
   V7558     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NONE:(0)'
             1 '< ONE:(1)' 2 'ONE:(2)' 3 'TWO:(3)' 4 'THREE:(4)' 5 'FOUR:(5)'
             6 'FIVE-SIX:(6)' 7 '7 OR +:(7)' /
   V7428     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST:(4)' 5 'ALL:(5)' /
   V7432     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST:(4)' 5 'ALL:(5)' /
   V7433     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST:(4)' 5 'ALL:(5)' /
   V7435     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST:(4)' 5 'ALL:(5)' /
   V7430     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST:(4)' 5 'ALL:(5)' /
   V7431     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST:(4)' 5 'ALL:(5)' /
   V7434     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST:(4)' 5 'ALL:(5)' /
   V7429     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST:(4)' 5 'ALL:(5)' /
   V7436     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST:(4)' 5 'ALL:(5)' /
   V8473     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0%-10%:(1)'
             2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)' 5 '71%-90%:(5)'
             6 '91%-100%:(6)' /
   V8474     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0%-10%:(1)'
             2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)' 5 '71%-90%:(5)'
             6 '91%-100%:(6)' /
   V8475     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0%-10%:(1)'
             2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)' 5 '71%-90%:(5)'
             6 '91%-100%:(6)' /
   V7752     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST:(4)' 5 'ALL:(5)' /
   V7754     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST:(4)' 5 'ALL:(5)' /
   V7437     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'A LITTLE:(2)' 3 'SOME:(3)' 4 'A LOT:(4)' /
   V7438     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'A LITTLE:(2)' 3 'SOME:(3)' 4 'A LOT:(4)' /
   V7439     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'A LITTLE:(2)' 3 'SOME:(3)' 4 'A LOT:(4)' /
   V7440     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'A LITTLE:(2)' 3 'SOME:(3)' 4 'A LOT:(4)' /
   V7414     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'PROBABLY IMPOSSIBLE:(1)' 2 'VERY DIFFICULT:(2)'
             3 'FAIRLY DIFFICULT:(3)' 4 'FAIRLY EASY:(4)' 5 'VERY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7415     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'PROBABLY IMPOSSIBLE:(1)' 2 'VERY DIFFICULT:(2)'
             3 'FAIRLY DIFFICULT:(3)' 4 'FAIRLY EASY:(4)' 5 'VERY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7416     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'PROBABLY IMPOSSIBLE:(1)' 2 'VERY DIFFICULT:(2)'
             3 'FAIRLY DIFFICULT:(3)' 4 'FAIRLY EASY:(4)' 5 'VERY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7417     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'PROBABLY IMPOSSIBLE:(1)' 2 'VERY DIFFICULT:(2)'
             3 'FAIRLY DIFFICULT:(3)' 4 'FAIRLY EASY:(4)' 5 'VERY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7494     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'PROBABLY IMPOSSIBLE:(1)' 2 'VERY DIFFICULT:(2)'
             3 'FAIRLY DIFFICULT:(3)' 4 'FAIRLY EASY:(4)' 5 'VERY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7419     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'PROBABLY IMPOSSIBLE:(1)' 2 'VERY DIFFICULT:(2)'
             3 'FAIRLY DIFFICULT:(3)' 4 'FAIRLY EASY:(4)' 5 'VERY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7420     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'PROBABLY IMPOSSIBLE:(1)' 2 'VERY DIFFICULT:(2)'
             3 'FAIRLY DIFFICULT:(3)' 4 'FAIRLY EASY:(4)' 5 'VERY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7421     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'PROBABLY IMPOSSIBLE:(1)' 2 'VERY DIFFICULT:(2)'
             3 'FAIRLY DIFFICULT:(3)' 4 'FAIRLY EASY:(4)' 5 'VERY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7422     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'PROBABLY IMPOSSIBLE:(1)' 2 'VERY DIFFICULT:(2)'
             3 'FAIRLY DIFFICULT:(3)' 4 'FAIRLY EASY:(4)' 5 'VERY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7423     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'PROBABLY IMPOSSIBLE:(1)' 2 'VERY DIFFICULT:(2)'
             3 'FAIRLY DIFFICULT:(3)' 4 'FAIRLY EASY:(4)' 5 'VERY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7412     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'PROBABLY IMPOSSIBLE:(1)' 2 'VERY DIFFICULT:(2)'
             3 'FAIRLY DIFFICULT:(3)' 4 'FAIRLY EASY:(4)' 5 'VERY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7413     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'PROBABLY IMPOSSIBLE:(1)' 2 'VERY DIFFICULT:(2)'
             3 'FAIRLY DIFFICULT:(3)' 4 'FAIRLY EASY:(4)' 5 'VERY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7490     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'PROBABLY IMPOSSIBLE:(1)' 2 'VERY DIFFICULT:(2)'
             3 'FAIRLY DIFFICULT:(3)' 4 'FAIRLY EASY:(4)' 5 'VERY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7425     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'PROBABLY IMPOSSIBLE:(1)' 2 'VERY DIFFICULT:(2)'
             3 'FAIRLY DIFFICULT:(3)' 4 'FAIRLY EASY:(4)' 5 'VERY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7424     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'PROBABLY IMPOSSIBLE:(1)' 2 'VERY DIFFICULT:(2)'
             3 'FAIRLY DIFFICULT:(3)' 4 'FAIRLY EASY:(4)' 5 'VERY EASY:(5)'
             8 'CANT SAY:(8)' /
   V8544     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'YES:(1)'
             2 'NO:(2)' /
   V8477     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'FEW TIMES YEAR:(2)' 3 '1-2X MONTH:(3)' 4 'ONCE A WEEK+:(4)'
             5 'ALMOST DAILY:(5)' /
   V7658     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'PROBABLY IMPOSSIBLE:(1)' 2 'VERY DIFFICULT:(2)'
             3 'FAIRLY DIFFICULT:(3)' 4 'FAIRLY EASY:(4)' 5 'VERY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7659     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'PROBABLY IMPOSSIBLE:(1)' 2 'VERY DIFFICULT:(2)'
             3 'FAIRLY DIFFICULT:(3)' 4 'FAIRLY EASY:(4)' 5 'VERY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7750     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'PROB IMP:(1)'
             2 'VRY DIFF:(2)' 3 'FRLY DIF:(3)' 4 'FRLY EAS:(4)'
             5 'VRY EASY:(5)' 8 'CANT SAY:(8)' /
   V7167     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)' 5 '6-9 TIMES:(5)'
             6 '10+ TIMES:(6)' /
   V7168     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)' 5 '6-9 TIMES:(5)'
             6 '10+ TIMES:(6)' /
   V7169     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)' 5 '6-9 TIMES:(5)'
             6 '10+ TIMES:(6)' /
   V7170     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)' 5 '6-9 TIMES:(5)'
             6 '10+ TIMES:(6)' /
   V7171     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)' 5 '6-9 TIMES:(5)'
             6 '10+ TIMES:(6)' /
   V7172     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)' 5 '6-9 TIMES:(5)'
             6 '10+ TIMES:(6)' /
   V7173     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)' 5 '6-9 TIMES:(5)'
             6 '10+ TIMES:(6)' /
   V7174     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)' 5 '6-9 TIMES:(5)'
             6 '10+ TIMES:(6)' /
   V7175     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)' 5 '6-9 TIMES:(5)'
             6 '10+ TIMES:(6)' /
   V7177     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER TRIED:(1)'
             2 'NO & SOLD:(2)' 3 'NO & NOSALE:(3)' 4 'YES:(4)' /
   V7178     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'ID & GOT:(1)'
             2 'ID & NOSALE:(2)' 3 'NO ID & SOLD:(3)' 4 'NO ID & NOSALE:(4)'
             /
   V7179     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'PAST 12MO:(2)' 3 'NOT PAST12MO:(3)' /
   V7199     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)' 5 '6-9 TIMES:(5)'
             6 '10+ TIMES:(6)' /
   V7200     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)' 5 '6-9 TIMES:(5)'
             6 '10+ TIMES:(6)' /
   V7185     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DEF WILL:(1)'
             2 'PRB WILL:(2)' 3 'PRB WONT:(3)' 4 'DEF WONT:(4)' /
   V7458     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DEF WILL:(1)'
             2 'PRB WILL:(2)' 3 'PRB WONT:(3)' 4 'DEF WONT:(4)' /
   V7186     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V7187     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V7188     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V7666     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DEF WILL:(1)'
             2 'PRB WILL:(2)' 3 'PRB WONT:(3)' 4 'DEF WONT:(4)' /
   V7668     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DEF WILL:(1)'
             2 'PRB WILL:(2)' 3 'PRB WONT:(3)' 4 'DEF WONT:(4)' /
   V7184     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'ALREADY TRIED:(1)'
             2 'DEF WILL:(2)' 3 'PRB WILL:(3)' 4 'PRB WONT:(4)'
             5 'DEF WONT:(5)' /
   V7451     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V7452     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V7453     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V7454     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V7455     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V7456     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V7457     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V8441     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V8442     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V8443     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V8444     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V8445     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V8446     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V8447     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V8476     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V8540     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONE DAY:(2)' 3 'TWO DAYS:(3)' 4 '3-5 DAYS:(4)'
             5 '6-9 DAYS:(5)' 6 '10+ DAYS:(6)' /
   V8541     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONE DAY:(2)' 3 'TWO DAYS:(3)' 4 '3-5 DAYS:(4)'
             5 '6-9 DAYS:(5)' 6 '10+ DAYS:(6)' /
   V8542     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONE DAY:(2)' 3 'TWO DAYS:(3)' 4 '3-5 DAYS:(4)'
             5 '6-9 DAYS:(5)' 6 '10+ DAYS:(6)' /
   V7481     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V7734     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 'YES:(1)' 2 'NO:(2)' /
   V7183     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'A LITTLE:(2)' 3 'SOME:(3)' 4 'A LOT:(4)' /
   V7772     -9 'DID NOT ANSWER:(-9)' -8 'NO CIGS 30 DAYS:(-8)'
             -7 'NEVER SMOKED CIGS:(-7)' -5 'R NT ASKD TAB Q:(-5)'
             1 'YES:(1)' 2 'NO:(2)' /
   V7740     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 'YES:(1)' 2 'NO:(2)' /
   V7459     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'SOMEWHAT:(2)' 3 'VERY IMPORTANT:(3)' /
   V7460     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'SOMEWHAT:(2)' 3 'VERY IMPORTANT:(3)' /
   V7461     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'SOMEWHAT:(2)' 3 'VERY IMPORTANT:(3)' /
   V7462     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'SOMEWHAT:(2)' 3 'VERY IMPORTANT:(3)' /
   V7463     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'SOMEWHAT:(2)' 3 'VERY IMPORTANT:(3)' /
   V7464     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'SOMEWHAT:(2)' 3 'VERY IMPORTANT:(3)' /
   V7465     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'SOMEWHAT:(2)' 3 'VERY IMPORTANT:(3)' /
   V7466     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'SOMEWHAT:(2)' 3 'VERY IMPORTANT:(3)' /
   V7467     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'SOMEWHAT:(2)' 3 'VERY IMPORTANT:(3)' /
   V7468     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'SOMEWHAT:(2)' 3 'VERY IMPORTANT:(3)' /
   V7469     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'SOMEWHAT:(2)' 3 'VERY IMPORTANT:(3)' /
   V7470     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'SOMEWHAT:(2)' 3 'VERY IMPORTANT:(3)' /
   V7471     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'SOMEWHAT:(2)' 3 'VERY IMPORTANT:(3)' /
   V7472     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'SOMEWHAT:(2)' 3 'VERY IMPORTANT:(3)' /
   V7473     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'SOMEWHAT:(2)' 3 'VERY IMPORTANT:(3)' /
   V7474     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'SOMEWHAT:(2)' 3 'VERY IMPORTANT:(3)' /
   V7773     -9 'DID NOT ANSWER:(-9)' -8 'NO CIGS 30 DAYS:(-8)'
             -7 'NEVER SMOKED CIGS:(-7)' -5 'R NT ASKD TAB Q:(-5)'
             1 'YES:(1)' 2 'NO:(2)' /
   V7774     -9 'DID NOT ANSWER:(-9)' -8 'NO CIGS 30 DAYS:(-8)'
             -7 'NEVER SMOKED CIGS:(-7)' -5 'R NT ASKD TAB Q:(-5)'
             1 'YES:(1)' 2 'NO:(2)' /
   V7775     -9 'DID NOT ANSWER:(-9)' -8 'NO CIGS 30 DAYS:(-8)'
             -7 'NEVER SMOKED CIGS:(-7)' -5 'R NT ASKD TAB Q:(-5)'
             1 'YES:(1)' 2 'NO:(2)' /
   V7776     -9 'DID NOT ANSWER:(-9)' -8 'NO CIGS 30 DAYS:(-8)'
             -7 'NEVER SMOKED CIGS:(-7)' -5 'R NT ASKD TAB Q:(-5)'
             1 'YES:(1)' 2 'NO:(2)' /
   V7777     -9 'DID NOT ANSWER:(-9)' -8 'NO CIGS 30 DAYS:(-8)'
             -7 'NEVER SMOKED CIGS:(-7)' -5 'R NT ASKD TAB Q:(-5)'
             1 'YES:(1)' 2 'NO:(2)' /
   V7778     -9 'DID NOT ANSWER:(-9)' -8 'NO CIGS 30 DAYS:(-8)'
             -7 'NEVER SMOKED CIGS:(-7)' -5 'R NT ASKD TAB Q:(-5)'
             1 'YES:(1)' 2 'NO:(2)' /
   V7779     -9 'DID NOT ANSWER:(-9)' -8 'NO CIGS 30 DAYS:(-8)'
             -7 'NEVER SMOKED CIGS:(-7)' -5 'R NT ASKD TAB Q:(-5)'
             1 'YES:(1)' 2 'NO:(2)' /
   V7735     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 'NT AT ALL ADDICT:(1)'
             2 'A LITTLE ADDICT:(2)' 3 'SOME WHAT ADDICT:(3)'
             4 'VERY ADDICT:(4)' 8 'DK:(8)' /
   V7736     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 'NT AT ALL ADDICT:(1)'
             2 'A LITTLE ADDICT:(2)' 3 'SOME WHAT ADDICT:(3)'
             4 'VERY ADDICT:(4)' 8 'DK:(8)' /
   V7737     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 'NT AT ALL ADDICT:(1)'
             2 'A LITTLE ADDICT:(2)' 3 'SOME WHAT ADDICT:(3)'
             4 'VERY ADDICT:(4)' 8 'DK:(8)' /
   V7738     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 'NT AT ALL ADDICT:(1)'
             2 'A LITTLE ADDICT:(2)' 3 'SOME WHAT ADDICT:(3)'
             4 'VERY ADDICT:(4)' 8 'DK:(8)' /
   V7741     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 'YES:(1)' 2 'NO:(2)' /
   V7742     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 'YES:(1)' 2 'NO:(2)' /
   V7743     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 'YES:(1)' 2 'NO:(2)' /
   V7744     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 'YES:(1)' 2 'NO:(2)' /
   V7745     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 'YES:(1)' 2 'NO:(2)' /
   V7746     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 'YES:(1)' 2 'NO:(2)' /
   V7747     -9 'DID NOT ANSWER:(-9)' -8 'NO JUUL VAPING:(-8)'
             -7 'NO VAPING 30 DAYS:(-7)' -6 'NO VAPING:(-6)'
             -5 'R NT ASKD TAB Q:(-5)' 1 'YES:(1)' 2 'NO:(2)' /
   V7182     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'A LITTLE:(2)' 3 'SOME:(3)' 4 'A LOT:(4)' /
   V7403     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)' 5 '6-9 TIMES:(5)'
             6 '10+ TIMES:(6)' /
   V7404     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)' 5 '6-9 TIMES:(5)'
             6 '10+ TIMES:(6)' /
   V7613     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)' 5 '6-9 TIMES:(5)'
             6 '10+ TIMES:(6)' /
   V8455     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'NOT PAST YEAR:(2)' 3 'IN PAST YEAR:(3)' /
   V7405     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'WISH HAD:(2)' 3 'YES:(3)' /
   V7406     -9 'MISSING: (-9)' -8 'NT ON ALL FRMS:(-8)' 1 '<INTERST:(1)'
             2 'NO CHNGE:(2)' 3 '>INTERST:(3)' /
   V7407     -9 'MISSING: (-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7408     -9 'MISSING: (-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7409     -9 'MISSING: (-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7410     -9 'MISSING: (-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7411     -9 'MISSING: (-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO VALUE:(1)'
             2 'SOME:(2)' 3 'CNSIDRBL:(3)' 4 'GT VALUE:(4)' /
   V7482     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'YES:(1)'
             2 'NO:(2)' 8 'NOT SURE:(8)' /
   V7701     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '<1X MONTH:(2)' 3 '1-3X MONTH:(3)' 4 '1-3X WEEK:(4)'
             5 'ABOUT DAILY:(5)' 6 '>DAILY:(6)' /
   V7702     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '<1X MONTH:(2)' 3 '1-3X MONTH:(3)' 4 '1-3X WEEK:(4)'
             5 'ABOUT DAILY:(5)' 6 '>DAILY:(6)' /
   V7703     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'LITTLE:(2)' 3 'SOME:(3)' 4 'GREAT:(4)' 5 'VERY GREAT:(5)' /
   V7704     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'LITTLE:(2)' 3 'SOME:(3)' 4 'GREAT:(4)' 5 'VERY GREAT:(5)' /
   V7705     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'LITTLE:(2)' 3 'SOME:(3)' 4 'GREAT:(4)' 5 'VERY GREAT:(5)' /
   V7593     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'SOME:(2)' 3 'A LOT:(3)' 4 'DONT REMEMBER:(4)' /
   V7344     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V7345     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V7346     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V7347     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V7348     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V7349     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V7350     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V7351     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V7352     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V7353     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V7354     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V7355     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V7356     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V7357     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V8547     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V8548     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V7540     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V7541     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V8562     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V8563     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V7646     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V7647     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DISAP:(1)'
             2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)' 8 'CANT SAY:(8)' /
   V7697     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DIS:(1)'
             2 'DISAPPRV:(2)' 3 'STRG DIS:(3)' 8 'CANT SAY:(8)' /
   V7698     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DONT DIS:(1)'
             2 'DISAPPRV:(2)' 3 'STRG DIS:(3)' 8 'CANT SAY:(8)' /
   V8456     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8457     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8458     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8459     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8460     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8461     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8462     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V7661     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'NOT DISAPPROVE:(1)' 2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)'
             /
   V7662     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'NOT DISAPPROVE:(1)' 2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)'
             /
   V7663     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'NOT DISAPPROVE:(1)' 2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)'
             /
   V7664     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'NOT DISAPPROVE:(1)' 2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)'
             /
   V7665     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'NOT DISAPPROVE:(1)' 2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)'
             /
   V7718     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'NOT DISAPPROVE:(1)' 2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)'
             /
   V7716     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'NOT DISAPPROVE:(1)' 2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)'
             /
   V7717     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'NOT DISAPPROVE:(1)' 2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)'
             /
   V7719     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'NOT DISAPPROVE:(1)' 2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)'
             /
   V7720     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'NOT DISAPPROVE:(1)' 2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)'
             /
   V7721     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'NOT DISAPPROVE:(1)' 2 'DISAPPROVE:(2)' 3 'STRONGLY DISAP:(3)'
             /
   V7753     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NT DISAP:(1)'
             2 'DISAPRV:(2)' 3 'ST DISAP:(3)' /
   V7359     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7360     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7361     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7362     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7363     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V8545     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V8546     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7364     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7365     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7366     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7367     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7368     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7369     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7370     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V8560     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V8561     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7371     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7372     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7542     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7543     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7377     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7577     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7578     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7573     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7574     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7579     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7580     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7581     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7582     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7583     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7584     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7585     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7586     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7612     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7644     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7645     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT RISK:(2)' 3 'MODERATE RISK:(3)' 4 'GREAT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7699     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7700     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO RISK:(1)'
             2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7710     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0%-10%:(1)'
             2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)' 5 '71%-90%:(5)'
             6 '91%-100%:(6)' 8 'NO IDEA:(8)' /
   V7712     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0%-10%:(1)'
             2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)' 5 '71%-90%:(5)'
             6 '91%-100%:(6)' 8 'NO IDEA:(8)' /
   V7713     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0%-10%:(1)'
             2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)' 5 '71%-90%:(5)'
             6 '91%-100%:(6)' 8 'NO IDEA:(8)' /
   V7706     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0%-10%:(1)'
             2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)' 5 '71%-90%:(5)'
             6 '91%-100%:(6)' 8 'NO IDEA:(8)' /
   V7708     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0%-10%:(1)'
             2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)' 5 '71%-90%:(5)'
             6 '91%-100%:(6)' 8 'NO IDEA:(8)' /
   V7709     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0%-10%:(1)'
             2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)' 5 '71%-90%:(5)'
             6 '91%-100%:(6)' 8 'NO IDEA:(8)' /
   V7591     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0%-10%:(1)'
             2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)' 5 '71%-90%:(5)'
             6 '91%-100%:(6)' 8 'NO IDEA:(8)' /
   V7592     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0%-10%:(1)'
             2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)' 5 '71%-90%:(5)'
             6 '91%-100%:(6)' 8 'NO IDEA:(8)' /
   V7670     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '<1X MONTH:(2)' 3 '1-3X MONTH:(3)' 4 '1-3X WEEK:(4)'
             5 'ABOUT DAILY:(5)' 6 '>DAILY:(6)' /
   V7671     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '<1X MONTH:(2)' 3 '1-3X MONTH:(3)' 4 '1-3X WEEK:(4)'
             5 'ABOUT DAILY:(5)' 6 '>DAILY:(6)' /
   V7672     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '<1X MONTH:(2)' 3 '1-3X MONTH:(3)' 4 '1-3X WEEK:(4)'
             5 'ABOUT DAILY:(5)' 6 '>DAILY:(6)' /
   V7673     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 '<1X MONTH:(2)' 3 '1-3X MONTH:(3)' 4 '1-3X WEEK:(4)'
             5 'ABOUT DAILY:(5)' 6 '>DAILY:(6)' /
   V7189     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'YES:(2)' /
   V7190     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7191     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7192     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7193     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7194     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7195     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7196     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'YES:(2)' /
   V7197     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'YES:(2)' /
   V7222     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'ACADEMIC/COLLEGE PREP:(1)' 2 'GENERAL:(2)'
             3 'VOC/TECH/COMMERCIAL:(3)' 4 'OTHER/DK:(4)' /
   V7221     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'D:(1)' 2 'C-:(2)'
             3 'C:(3)' 4 'C+:(4)' 5 'B-:(5)' 6 'B:(6)' 7 'B+:(7)' 8 'A-:(8)'
             9 'A:(9)' /
   V7223     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DEF WONT:(1)'
             2 'PRB WONT:(2)' 3 'PRB WILL:(3)' 4 'DEF WILL:(4)' /
   V7327     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '1-4 HRS:(2)' 3 '5-9 HRS:(3)' 4 '10-14HRS:(4)'
             5 '15-19HRS:(5)' 6 '20-24HRS:(6)' 7 '25+ HRS:(7)' /
   V7516     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'SLIGHT:(2)' 3 'MODERATE:(3)' 4 'CONSIDERABLE:(4)'
             5 'GREAT EXTENT:(5)' /
   V7517     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'SLIGHT:(2)' 3 'MODERATE:(3)' 4 'CONSIDERABLE:(4)'
             5 'GREAT EXTENT:(5)' /
   V7518     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'SLIGHT:(2)' 3 'MODERATE:(3)' 4 'CONSIDERABLE:(4)'
             5 'GREAT EXTENT:(5)' /
   V7519     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'SLIGHT:(2)' 3 'MODERATE:(3)' 4 'CONSIDERABLE:(4)'
             5 'GREAT EXTENT:(5)' /
   V7329     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'SELDOM:(2)' 3 'SOMETIME:(3)' 4 'OFTEN:(4)' 5 'ALWAYS:(5)' /
   V7330     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'SELDOM:(2)' 3 'SOMETIME:(3)' 4 'OFTEN:(4)' 5 'ALWAYS:(5)' /
   V7331     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'SELDOM:(2)' 3 'SOMETIME:(3)' 4 'OFTEN:(4)' 5 'ALWAYS:(5)' /
   V7332     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'SELDOM:(2)' 3 'SOMETIME:(3)' 4 'OFTEN:(4)' 5 'ALWAYS:(5)' /
   V7334     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'SELDOM:(2)' 3 'SOMETIME:(3)' 4 'OFTEN:(4)' 5 'ALWAYS:(5)' /
   V7335     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'SELDOM:(2)' 3 'SOMETIME:(3)' 4 'OFTEN:(4)' 5 'ALWAYS:(5)' /
   V7232     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NO:(0)'
             1 'YES:(1)' /
   V7233     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NO:(0)'
             1 'YES:(1)' /
   V7301     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '7TH:(1)'
             2 '8TH:(2)' 3 '9TH:(3)' 4 '10TH:(4)' 5 '11TH:(5)' 6 '12TH:(6)' /
   V7333     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'SELDOM:(2)' 3 'SOMETIME:(3)' 4 'OFTEN:(4)' 5 'ALWAYS:(5)' /
   V7251     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'SELDOM:(2)' 3 'SOMETIME:(3)' 4 'OFTEN:(4)' /
   V7252     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO IDEA:(1)'
             2 'A FEW:(2)' 3 'PRTYWELL:(3)' 4 'EXACTLY:(4)' /
   V7384     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7385     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7386     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7496     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7497     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7387     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7498     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7388     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7389     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7499     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7390     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7391     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7392     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7393     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7394     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7395     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7396     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7397     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7500     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7398     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7399     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7400     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7522     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'A LITTLE:(2)' 3 'SOME:(3)' 4 'QUITEBIT:(4)' 5 'GRT DEAL:(5)'
             /
   V7523     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'LIKE VERY MUCH:(1)' 2 'LIKE IT:(2)' 3 'NOT CARE:(3)'
             4 'DISLIKE:(4)' 5 'DISLIKE VERY MUCH:(5)' /
   V7524     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)'
             1 'LIKE VERY MUCH:(1)' 2 'LIKE IT:(2)' 3 'NOT CARE:(3)'
             4 'DISLIKE:(4)' 5 'DISLIKE VERY MUCH:(5)' /
   V7525     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'SELDOM:(2)' 3 'SOMTIMES:(3)' 4 'OFTEN:(4)' 5 'ALWAYS:(5)' /
   V7526     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO IMPORTANCE:(1)'
             2 'LITTLE IMPORTANCE:(2)' 3 'MODERATE IMPORTANCE:(3)'
             4 'GREAT IMPORTANCE:(4)' 5 'VERY GREAT IMPORTANCE:(5)' /
   V7527     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO IMPORTANCE:(1)'
             2 'LITTLE IMPORTANCE:(2)' 3 'MODERATE IMPORTANCE:(3)'
             4 'GREAT IMPORTANCE:(4)' 5 'VERY GREAT IMPORTANCE:(5)' /
   V7528     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO IMPORTANCE:(1)'
             2 'LITTLE IMPORTANCE:(2)' 3 'MODERATE IMPORTANCE:(3)'
             4 'GREAT IMPORTANCE:(4)' 5 'VERY GREAT IMPORTANCE:(5)' /
   V7529     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO IMPORTANCE:(1)'
             2 'LITTLE IMPORTANCE:(2)' 3 'MODERATE IMPORTANCE:(3)'
             4 'GREAT IMPORTANCE:(4)' 5 'VERY GREAT IMPORTANCE:(5)' /
   V7530     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO IMPORTANCE:(1)'
             2 'LITTLE IMPORTANCE:(2)' 3 'MODERATE IMPORTANCE:(3)'
             4 'GREAT IMPORTANCE:(4)' 5 'VERY GREAT IMPORTANCE:(5)' /
   V7531     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO IMPORTANCE:(1)'
             2 'LITTLE IMPORTANCE:(2)' 3 'MODERATE IMPORTANCE:(3)'
             4 'GREAT IMPORTANCE:(4)' 5 'VERY GREAT IMPORTANCE:(5)' /
   V8537     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 '< 1/WK:(2)' 3 '1-2X/WK:(3)' 4 '3-5X/WK:(4)' 5 '6-9X/WK:(5)'
             6 '10-19X/W:(6)' 7 '20+:(7)' /
   V8538     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 '< 1/WK:(2)' 3 '1-2X/WK:(3)' 4 '3-5X/WK:(4)' 5 '6-9X/WK:(5)'
             6 '10-19X/W:(6)' 7 '20+:(7)' /
   V7537     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'NO MSTLY:(2)' 3 'DK:(3)' 4 'YES MSTL:(4)' 5 'YES:(5)' /
   V7253     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST/ALL:(4)' /
   V7228     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '1 DAY:(2)' 3 '2 DAYS:(3)' 4 '3 DAYS:(4)' 5 '4-5 DAYS:(5)'
             6 '6-10 DA:(6)' 7 '11+ DAYS:(7)' /
   V7229     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '1 DAY:(2)' 3 '2 DAYS:(3)' 4 '3 DAYS:(4)' 5 '4-5 DAYS:(5)'
             6 '6-10 DA:(6)' 7 '11+ DAYS:(7)' /
   V7230     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '1 DAY:(2)' 3 '2 DAYS:(3)' 4 '3 DAYS:(4)' 5 '4-5 DAYS:(5)'
             6 '6-10 DA:(6)' 7 '11+ DAYS:(7)' /
   V7231     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '1-2:(2)' 3 '3-5:(3)' 4 '6-10:(4)' 5 '11-20:(5)' 6 '21+:(6)' /
   V8539     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 '< 1/WK:(2)' 3 '1-2X/WK:(3)' 4 '3-5X/WK:(4)' 5 '6-9X/WK:(5)'
             6 '10-19X/W:(6)' 7 '20+:(7)' /
   V8516     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4TIMES:(4)' 5 '5+ TIMES:(5)' /
   V8522     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4TIMES:(4)' 5 '5+ TIMES:(5)' /
   V7509     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4 X:(4)' 5 '5+ TIMES:(5)' /
   V7510     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4 X:(4)' 5 '5+ TIMES:(5)' /
   V7511     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4 X:(4)' 5 '5+ TIMES:(5)' /
   V7512     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4 X:(4)' 5 '5+ TIMES:(5)' /
   V7513     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4 X:(4)' 5 '5+ TIMES:(5)' /
   V7514     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4 X:(4)' 5 '5+ TIMES:(5)' /
   V7515     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT AT ALL:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4 X:(4)' 5 '5+ TIMES:(5)' /
   V7234     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NO:(0)'
             1 'YES:(1)' /
   V8543     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONE DAY:(2)' 3 'TWO DAYS:(3)' 4 '3-5 DAYS:(4)'
             5 '6-9 DAYS:(5)' 6 '10+ DAYS:(6)' /
   V7534     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'RARELY:(2)' 3 'SOMEDAYS:(3)' 4 'MOSTDAYS:(4)'
             5 'EVERYDAY:(5)' /
   V7535     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'RARELY:(2)' 3 'SOMEDAYS:(3)' 4 'MOSTDAYS:(4)'
             5 'EVERYDAY:(5)' /
   V7536     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '0 DAYS:(1)'
             2 '1 DAY:(2)' 3 '2 OR 3:(3)' 4 '4+ DAYS:(4)' /
   V7538     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '1 DAY:(2)' 3 '2 DAYS:(3)' 4 '3-5 DAYS:(4)' 5 '6-9 DAYS:(5)'
             6 '10+ DAYS:(6)' /
   V7224     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DEF WONT:(1)'
             2 'PRB WONT:(2)' 3 'PRB WILL:(3)' 4 'DEF WILL:(4)' /
   V7225     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DEF WONT:(1)'
             2 'PRB WONT:(2)' 3 'PRB WILL:(3)' 4 'DEF WILL:(4)' /
   V7227     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DEF WONT:(1)'
             2 'PRB WONT:(2)' 3 'PRB WILL:(3)' 4 'DEF WILL:(4)' /
   V7226     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DEF WONT:(1)'
             2 'PRB WONT:(2)' 3 'PRB WILL:(3)' 4 'DEF WILL:(4)' /
   V7235     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '5 OR <:(2)' 3 '6-10 HRS:(3)' 4 '11-15 HR:(4)'
             5 '16-20 HR:(5)' 6 '21-25 HR:(6)' 7 '26-30 HR:(7)'
             8 '30+ HRS:(8)' /
   V7238     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO WORK:(1)'
             2 'LAWN WK:(2)' 3 'FASTFOOD:(3)' 4 'WAITER:(4)' 5 'OTH REST:(5)'
             6 'PAPER RT:(6)' 7 'BABYSIT:(7)' 8 'FARM WK:(8)'
             9 'SALES WK:(9)' 10 'OFFICE:(10)' 11 'ODD JOBS:(11)'
             12 'OTHER:(12)' /
   V7236     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '$1-5:(2)' 3 '$6-10:(3)' 4 '$11-20:(4)' 5 '$21-35:(5)'
             6 '$36-50:(6)' 7 '$51-75:(7)' 8 '$76-125:(8)' 9 '$126-175:(9)'
             10 '$176+:(10)' /
   V7237     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '$1-5:(2)' 3 '$6-10:(3)' 4 '$11-20:(4)' 5 '$21-35:(5)'
             6 '$36-50:(6)' 7 '$51-75:(7)' 8 '$76-125:(8)' 9 '$126-175:(9)'
             10 '$176+:(10)' /
   V7374     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '5 OR <:(2)' 3 '6-10:(3)' 4 '11-15:(4)' 5 '16-20:(5)'
             6 '21-25:(6)' 7 '26-30:(7)' 8 '31+:(8)' 9 'DK:(9)' /
   V7240     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 '1/MO OR<:(2)' 3 '2-3/MO:(3)' 4 '1/WK:(4)' 5 '2-3/WK:(5)'
             6 '3+/WK:(6)' /
   V7309     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'FEW TIMES YEAR:(2)' 3 '1-2X MONTH:(3)' 4 'ONCE A WEEK+:(4)'
             5 'ALMOST DAILY:(5)' 6 'EVERY DAY:(6)' /
   V7310     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'FEW TIMES YEAR:(2)' 3 '1-2X MONTH:(3)' 4 'ONCE A WEEK+:(4)'
             5 'ALMOST DAILY:(5)' 6 'EVERY DAY:(6)' /
   V7311     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'FEW TIMES YEAR:(2)' 3 '1-2X MONTH:(3)' 4 'ONCE A WEEK+:(4)'
             5 'ALMOST DAILY:(5)' 6 'EVERY DAY:(6)' /
   V7312     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'FEW TIMES YEAR:(2)' 3 '1-2X MONTH:(3)' 4 'ONCE A WEEK+:(4)'
             5 'ALMOST DAILY:(5)' 6 'EVERY DAY:(6)' /
   V7313     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'FEW TIMES YEAR:(2)' 3 '1-2X MONTH:(3)' 4 'ONCE A WEEK+:(4)'
             5 'ALMOST DAILY:(5)' 6 'EVERY DAY:(6)' /
   V7378     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'FEW TIMES YEAR:(2)' 3 '1-2X MONTH:(3)' 4 'ONCE A WEEK+:(4)'
             5 'ALMOST DAILY:(5)' 6 'EVERY DAY:(6)' /
   V7379     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'FEW TIMES YEAR:(2)' 3 '1-2X MONTH:(3)' 4 'ONCE A WEEK+:(4)'
             5 'ALMOST DAILY:(5)' 6 'EVERY DAY:(6)' /
   V7380     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'FEW TIMES YEAR:(2)' 3 '1-2X MONTH:(3)' 4 'ONCE A WEEK+:(4)'
             5 'ALMOST DAILY:(5)' 6 'EVERY DAY:(6)' /
   V7319     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'FEW TIMES YEAR:(2)' 3 '1-2X MONTH:(3)' 4 'ONCE A WEEK+:(4)'
             5 'ALMOST DAILY:(5)' 6 'EVERY DAY:(6)' /
   V7320     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'FEW TIMES YEAR:(2)' 3 '1-2X MONTH:(3)' 4 'ONCE A WEEK+:(4)'
             5 'ALMOST DAILY:(5)' 6 'EVERY DAY:(6)' /
   V7321     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'FEW TIMES YEAR:(2)' 3 '1-2X MONTH:(3)' 4 'ONCE A WEEK+:(4)'
             5 'ALMOST DAILY:(5)' 6 'EVERY DAY:(6)' /
   V7214     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'LT 1 HR:(2)' 3 '1-2 HRS:(3)' 4 '2-3 HRS:(4)' 5 '4-5 HRS:(5)'
             6 '>5 HRS(6)' /
   V7239     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '< 1:(1)'
             2 'ONE:(2)' 3 'TWO:(3)' 4 'THREE:(4)' 5 '4-5:(5)' 6 '6-7:(6)' /
   V7676     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'FEW TIMES YEAR:(2)' 3 '1-2X MONTH:(3)' 4 'ONCE A WEEK+:(4)'
             5 'ALMOST DAILY:(5)' 6 'EVERY DAY:(6)' /
   V7677     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'FEW TIMES YEAR:(2)' 3 '1-2X MONTH:(3)' 4 'ONCE A WEEK+:(4)'
             5 'ALMOST DAILY:(5)' 6 'EVERY DAY:(6)' /
   V7678     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'FEW TIMES YEAR:(2)' 3 '1-2X MONTH:(3)' 4 'ONCE A WEEK+:(4)'
             5 'ALMOST DAILY:(5)' 6 'EVERY DAY:(6)' /
   V7682     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '<1 HOUR:(2)' 3 '1-2 HRS:(3)' 4 '3-4 HRS:(4)' 5 '5-6 HRS:(5)'
             6 '7-8 HRS:(6)' 7 '9+ HRS:(7)' /
   V7684     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '<1 HOUR:(2)' 3 '1-2 HRS:(3)' 4 '3-4 HRS:(4)' 5 '5-6 HRS:(5)'
             6 '7-8 HRS:(6)' 7 '9+ HRS:(7)' /
   V7685     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '<1 HOUR:(2)' 3 '1-2 HRS:(3)' 4 '3-4 HRS:(4)' 5 '5-6 HRS:(5)'
             6 '7-8 HRS:(6)' 7 '9+ HRS:(7)' /
   V7686     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '<1 HOUR:(2)' 3 '1-2 HRS:(3)' 4 '3-4 HRS:(4)' 5 '5-6 HRS:(5)'
             6 '7-8 HRS:(6)' 7 '9+ HRS:(7)' /
   V7687     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '<1 HOUR:(2)' 3 '1-2 HRS:(3)' 4 '3-4 HRS:(4)' 5 '5-6 HRS:(5)'
             6 '7-8 HRS:(6)' 7 '9+ HRS:(7)' /
   V7688     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '<1 HOUR:(2)' 3 '1-2 HRS:(3)' 4 '3-4 HRS:(4)' 5 '5-6 HRS:(5)'
             6 '7-8 HRS:(6)' 7 '9+ HRS:(7)' /
   V7689     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '<1 HOUR:(2)' 3 '1-2 HRS:(3)' 4 '3-4 HRS:(4)' 5 '5-6 HRS:(5)'
             6 '7-8 HRS:(6)' 7 '9+ HRS:(7)' /
   V7690     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '<1 HOUR:(2)' 3 '1-2 HRS:(3)' 4 '3-4 HRS:(4)' 5 '5-6 HRS:(5)'
             6 '7-8 HRS:(6)' 7 '9+ HRS:(7)' /
   V7683     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '<1 HOUR:(2)' 3 '1-2 HRS:(3)' 4 '3-4 HRS:(4)' 5 '5-6 HRS:(5)'
             6 '7-8 HRS:(6)' 7 '9+ HRS:(7)' /
   V7341     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V7532     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V7533     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V7339     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V7340     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V7401     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '1-10 MI:(2)' 3 '11-50:(3)' 4 '51-100:(4)' 5 '101-200:(5)'
             6 '> 200:(6)' /
   V7402     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'SELDOM:(2)' 3 'SOMETIME:(3)' 4 'OFTEN:(4)' 5 'ALWAYS:(5)'
             8 'INAP:(8)' /
   V7219     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'RARELY:(2)' 3 '1-2X/MO:(3)' 4 '1/WK OR+:(4)' /
   V7220     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT IMPORTANT:(1)'
             2 'LITTLE IMPORTANT:(2)' 3 'PRETTY IMPORTANT:(3)'
             4 'VERY IMPORTANT:(4)' /
   V7255     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'YES SOME:(2)' 3 'YES M/AL:(3)' /
   V7241     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'RARELY:(2)' 3 'SOMETIME:(3)' 4 'OFTEN:(4)' /
   V7242     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'RARELY:(2)' 3 'SOMETIME:(3)' 4 'OFTEN:(4)' /
   V7243     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'RARELY:(2)' 3 'SOMETIME:(3)' 4 'OFTEN:(4)' /
   V7244     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'RARELY:(2)' 3 'SOMETIME:(3)' 4 'OFTEN:(4)' /
   V7258     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'RARELY:(2)' 3 'SOMETIME:(3)' 4 'OFTEN:(4)' /
   V7375     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 '5 OR <:(2)' 3 '6-10:(3)' 4 '11-15:(4)' 5 '16-20:(5)'
             6 '21-25:(6)' 7 '26-30:(7)' 8 '31+:(8)' 9 'DK:(9)' /
   V7254     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'YES SOME:(2)' 3 'YES M/AL:(3)' /
   V7259     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'RARELY:(2)' 3 'SOMETIMES:(3)' 4 'MOST:(4)' 5 'ALL:(5)' /
   V7260     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'RARELY:(2)' 3 'SOMETIMES:(3)' 4 'MOST:(4)' 5 'ALL:(5)' /
   V7261     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'RARELY:(2)' 3 'SOMETIMES:(3)' 4 'MOST:(4)' 5 'ALL:(5)' /
   V7262     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'RARELY:(2)' 3 'SOMETIMES:(3)' 4 'MOST:(4)' 5 'ALL:(5)' /
   V7565     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '<1 DAY/WK:(1)'
             2 '1 DAY/WK:(2)' 3 '2 DAYS/WK:(3)' 4 '3 DAYS/WK:(4)'
             5 '4-5 DAYS/WK:(5)' 6 '6-7 DAYS/WK:(6)' /
   V7302     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NOT HAPPY:(1)'
             2 'PRETTY HAPPY:(2)' 3 'VERY HAPPY:(3)' /
   V8512     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8502     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8505     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8509     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8514     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8536     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'MUCH BETTER:(1)'
             2 'SOMEWHAT BETTER:(2)' 3 'SAME:(3)' 4 'SOMEWHAT WORSE:(4)'
             5 'MUCH WORSE:(5)' /
   V8501     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8504     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8508     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8503     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8507     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8511     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8513     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V7660     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V7674     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V7675     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V7501     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V7502     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V7504     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V7505     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V7507     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V7508     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V7503     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V7506     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8555     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8556     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8557     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8558     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8565     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V8566     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'DISAGREE:(1)'
             2 'MOSTLY DISAGREE:(2)' 3 'NEITHER:(3)' 4 'MOSTLY AGREE:(4)'
             5 'AGREE:(5)' /
   V1252     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 '< 16 YRS:(1)'
             2 '16 OR + YRS:(2)' /
   V7202     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'MALE:(1)'
             2 'FEMALE:(2)' /
   V1070     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'BLACK:(1)'
             2 'WHITE:(2)' 3 'HISPANIC:(3)' /
   V7215     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE SCH:(1)'
             2 'SOME HS:(2)' 3 'HS GRAD:(3)' 4 'SOME CLG:(4)'
             5 'CLG GRAD:(5)' 6 'GRAD SCH:(6)' 7 'DK:(7)' /
   V7216     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'GRADE SCH:(1)'
             2 'SOME HS:(2)' 3 'HS GRAD:(3)' 4 'SOME CLG:(4)'
             5 'CLG GRAD:(5)' 6 'GRAD SCH:(6)' 7 'DK:(7)' /
   V7217     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'YES P/T:(2)' 3 'YES F/T:(3)' /
   V7206     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7207     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7208     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NOT MARKED:(0)'
             1 'MARKED:(1)' /
   V7205     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'FARM:(1)'
             2 'COUNTRY:(2)' 3 'CITYTOWN:(3)' /
   V8517     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4TIMES:(4)' 5 '5+ TIMES:(5)' /
   V8518     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4TIMES:(4)' 5 '5+ TIMES:(5)' /
   V8519     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4TIMES:(4)' 5 '5+ TIMES:(5)' /
   V8520     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4TIMES:(4)' 5 '5+ TIMES:(5)' /
   V8521     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4TIMES:(4)' 5 '5+ TIMES:(5)' /
   V8523     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4TIMES:(4)' 5 '5+ TIMES:(5)' /
   V8515     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NONE:(1)'
             2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4TIMES:(4)' 5 '5+ TIMES:(5)' /
   V7691     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'RARELY:(2)' 3 'SOMEDAYS:(3)' 4 'MOSTDAYS:(4)'
             5 'EVERYDAY:(5)' /
   V7692     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'RARELY:(2)' 3 'SOMEDAYS:(3)' 4 'MOSTDAYS:(4)'
             5 'EVERYDAY:(5)' /
   V8526     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'SELDOM:(2)' 3 'SOMETIMES:(3)' 4 'MOST DAYS:(4)'
             5 'NEARLY EVERY DAY:(5)' 6 'EVERYDAY:(6)' /
   V8527     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'SELDOM:(2)' 3 'SOMETIMES:(3)' 4 'MOST DAYS:(4)'
             5 'NEARLY EVERY DAY:(5)' 6 'EVERYDAY:(6)' /
   V8528     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'SELDOM:(2)' 3 'SOMETIMES:(3)' 4 'MOST DAYS:(4)'
             5 'NEARLY EVERY DAY:(5)' 6 'EVERYDAY:(6)' /
   V8529     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'SELDOM:(2)' 3 'SOMETIMES:(3)' 4 'MOST DAYS:(4)'
             5 'NEARLY EVERY DAY:(5)' 6 'EVERYDAY:(6)' /
   V8530     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'SELDOM:(2)' 3 'SOMETIMES:(3)' 4 'MOST DAYS:(4)'
             5 'NEARLY EVERY DAY:(5)' 6 'EVERYDAY:(6)' /
   V8531     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NEVER:(1)'
             2 'SELDOM:(2)' 3 'SOMETIMES:(3)' 4 'MOST DAYS:(4)'
             5 'NEARLY EVERY DAY:(5)' 6 'EVERYDAY:(6)' /
   V7555     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 0 '0 DAYS:(0)'
             1 '1 DAY:(1)' 2 '2 DAYS:(2)' 3 '3 DAYS:(3)' 4 '4 DAYS:(4)'
             5 '5 DAYS:(5)' 6 '6 DAYS:(6)' 7 '7 DAYS:(7)' /
   V7639     -9 'MISSING:(-9)' -8 'NT ON ALL FRMS:(-8)' 1 'NO:(1)'
             2 'YES, ONCE:(2)' 3 'YES, MORE THAN ONCE:(3)' /
   V7101D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7102D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7105D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7106D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7107D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7112D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7113D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7114D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7115D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7116D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7117D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7118D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7119D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7120D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7127D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7128D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7129D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7097D    -9 'MISSING: (-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NO: (0)'
             1 'YES: (1)' /
   V7098D    -9 'MISSING: (-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NO: (0)'
             1 'YES: (1)' /
   V7099D    -9 'MISSING: (-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NO: (0)'
             1 'YES: (1)' /
   V7133D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7134D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7135D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7142D    -9 'MISSING: (-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NO: (0)'
             1 'YES: (1)' /
   V7143D    -9 'MISSING: (-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NO: (0)'
             1 'YES: (1)' /
   V7144D    -9 'MISSING: (-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NO: (0)'
             1 'YES: (1)' /
   V7139D    -9 'MISSING: (-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NO: (0)'
             1 'YES: (1)' /
   V7140D    -9 'MISSING: (-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NO: (0)'
             1 'YES: (1)' /
   V7141D    -9 'MISSING: (-9)' -8 'NT ON ALL FRMS:(-8)' 0 'NO: (0)'
             1 'YES: (1)' /
   .

* SPSS MISSING VALUES COMMAND.

* MISSING VALUES
     RANDOMDRAW (low thru -1) /
     V7101 (low thru -1) /
     V7104 (low thru -1) /
     V7105 (low thru -1) /
     V7112 (low thru -1) /
     V7115 (low thru -1) /
     V7118 (low thru -1) /
     V7127 (low thru -1) /
     V7097 (low thru -1) /
     V7133 (low thru -1) /
     V7139 (low thru -1) /
     V7142 (low thru -1) /
     V8451 (low thru -1) /
     V7426 (low thru -1) /
     V7121 (low thru -1) /
     V7124 (low thru -1) /
     V7164 (low thru -1) /
     V7145 (low thru -1) /
     V7109 (low thru -1) /
     V7152 (low thru -1) /
     V7155 (low thru -1) /
     V7158 (low thru -1) /
     V7161 (low thru -1) /
     V7601 (low thru -1) /
     V8480 (low thru -1) /
     V7648 (low thru -1) /
     V7693 (low thru -1) /
     V7755 (low thru -1) /
     V7758 (low thru -1) /
     V7761 (low thru -1) /
     V7764 (low thru -1) /
     V7767 (low thru -1) /
     V7728 (low thru -1) /
     V7106 (low thru -1) /
     V7113 (low thru -1) /
     V7116 (low thru -1) /
     V7119 (low thru -1) /
     V7128 (low thru -1) /
     V7098 (low thru -1) /
     V7134 (low thru -1) /
     V7140 (low thru -1) /
     V7143 (low thru -1) /
     V8452 (low thru -1) /
     V7122 (low thru -1) /
     V7125 (low thru -1) /
     V7165 (low thru -1) /
     V7146 (low thru -1) /
     V7110 (low thru -1) /
     V7153 (low thru -1) /
     V7156 (low thru -1) /
     V7159 (low thru -1) /
     V7162 (low thru -1) /
     V7602 (low thru -1) /
     V7488 (low thru -1) /
     V7489 (low thru -1) /
     V7491 (low thru -1) /
     V7492 (low thru -1) /
     V8481 (low thru -1) /
     V7495 (low thru -1) /
     V7554 (low thru -1) /
     V7561 (low thru -1) /
     V7564 (low thru -1) /
     V7566 (low thru -1) /
     V7568 (low thru -1) /
     V7569 (low thru -1) /
     V7640 (low thru -1) /
     V7694 (low thru -1) /
     V7756 (low thru -1) /
     V7759 (low thru -1) /
     V7762 (low thru -1) /
     V7765 (low thru -1) /
     V7768 (low thru -1) /
     V7729 (low thru -1) /
     V7102 (low thru -1) /
     V7107 (low thru -1) /
     V7114 (low thru -1) /
     V7117 (low thru -1) /
     V7120 (low thru -1) /
     V7129 (low thru -1) /
     V7099 (low thru -1) /
     V7135 (low thru -1) /
     V7141 (low thru -1) /
     V7144 (low thru -1) /
     V8453 (low thru -1) /
     V7427 (low thru -1) /
     V7123 (low thru -1) /
     V7126 (low thru -1) /
     V7166 (low thru -1) /
     V7147 (low thru -1) /
     V7111 (low thru -1) /
     V7154 (low thru -1) /
     V7157 (low thru -1) /
     V7160 (low thru -1) /
     V7163 (low thru -1) /
     V7603 (low thru -1) /
     V8482 (low thru -1) /
     V7615 (low thru -1) /
     V7616 (low thru -1) /
     V7617 (low thru -1) /
     V7642 (low thru -1) /
     V7695 (low thru -1) /
     V7669 (low thru -1) /
     V7757 (low thru -1) /
     V7760 (low thru -1) /
     V7763 (low thru -1) /
     V7766 (low thru -1) /
     V7769 (low thru -1) /
     V7730 (low thru -1) /
     V7108 (low thru -1) /
     V7641 (low thru -1) /
     V8454 (low thru -1) /
     V7726 (low thru -1) /
     V7727 (low thru -1) /
     V7731 (low thru -1) /
     V7442 (low thru -1) /
     V7441 (low thru -1) /
     V8413 (low thru -1) /
     V7443 (low thru -1) /
     V7444 (low thru -1) /
     V7445 (low thru -1) /
     V8417 (low thru -1) /
     V8418 (low thru -1) /
     V8419 (low thru -1) /
     V8483 (low thru -1) /
     V8421 (low thru -1) /
     V7446 (low thru -1) /
     V7447 (low thru -1) /
     V8424 (low thru -1) /
     V8425 (low thru -1) /
     V7448 (low thru -1) /
     V7449 (low thru -1) /
     V8564 (low thru -1) /
     V7548 (low thru -1) /
     V7638 (low thru -1) /
     V7103 (low thru -1) /
     V7180 (low thru -1) /
     V7181 (low thru -1) /
     V7475 (low thru -1) /
     V7476 (low thru -1) /
     V7477 (low thru -1) /
     V7478 (low thru -1) /
     V7479 (low thru -1) /
     V7480 (low thru -1) /
     V7771 (low thru -1) /
     V7739 (low thru -1) /
     V7547 (low thru -1) /
     V7549 (low thru -1) /
     V7550 (low thru -1) /
     V7643 (low thru -1) /
     V7176 (low thru -1) /
     V7587 (low thru -1) /
     V7722 (low thru -1) /
     V7723 (low thru -1) /
     V7724 (low thru -1) /
     V7725 (low thru -1) /
     V7733 (low thru -1) /
     V7732 (low thru -1) /
     V7557 (low thru -1) /
     V7558 (low thru -1) /
     V7428 (low thru -1) /
     V7432 (low thru -1) /
     V7433 (low thru -1) /
     V7435 (low thru -1) /
     V7430 (low thru -1) /
     V7431 (low thru -1) /
     V7434 (low thru -1) /
     V7429 (low thru -1) /
     V7436 (low thru -1) /
     V8473 (low thru -1) /
     V8474 (low thru -1) /
     V8475 (low thru -1) /
     V7752 (low thru -1) /
     V7754 (low thru -1) /
     V7437 (low thru -1) /
     V7438 (low thru -1) /
     V7439 (low thru -1) /
     V7440 (low thru -1) /
     V7414 (low thru -1) /
     V7415 (low thru -1) /
     V7416 (low thru -1) /
     V7417 (low thru -1) /
     V7494 (low thru -1) /
     V7419 (low thru -1) /
     V7420 (low thru -1) /
     V7421 (low thru -1) /
     V7422 (low thru -1) /
     V7423 (low thru -1) /
     V7412 (low thru -1) /
     V7413 (low thru -1) /
     V7490 (low thru -1) /
     V7425 (low thru -1) /
     V7424 (low thru -1) /
     V8544 (low thru -1) /
     V8477 (low thru -1) /
     V7658 (low thru -1) /
     V7659 (low thru -1) /
     V7750 (low thru -1) /
     V7167 (low thru -1) /
     V7168 (low thru -1) /
     V7169 (low thru -1) /
     V7170 (low thru -1) /
     V7171 (low thru -1) /
     V7172 (low thru -1) /
     V7173 (low thru -1) /
     V7174 (low thru -1) /
     V7175 (low thru -1) /
     V7177 (low thru -1) /
     V7178 (low thru -1) /
     V7179 (low thru -1) /
     V7199 (low thru -1) /
     V7200 (low thru -1) /
     V7185 (low thru -1) /
     V7458 (low thru -1) /
     V7186 (low thru -1) /
     V7187 (low thru -1) /
     V7188 (low thru -1) /
     V7666 (low thru -1) /
     V7668 (low thru -1) /
     V7184 (low thru -1) /
     V7451 (low thru -1) /
     V7452 (low thru -1) /
     V7453 (low thru -1) /
     V7454 (low thru -1) /
     V7455 (low thru -1) /
     V7456 (low thru -1) /
     V7457 (low thru -1) /
     V8441 (low thru -1) /
     V8442 (low thru -1) /
     V8443 (low thru -1) /
     V8444 (low thru -1) /
     V8445 (low thru -1) /
     V8446 (low thru -1) /
     V8447 (low thru -1) /
     V8476 (low thru -1) /
     V8540 (low thru -1) /
     V8541 (low thru -1) /
     V8542 (low thru -1) /
     V7481 (low thru -1) /
     V7734 (low thru -1) /
     V7183 (low thru -1) /
     V7772 (low thru -1) /
     V7740 (low thru -1) /
     V7459 (low thru -1) /
     V7460 (low thru -1) /
     V7461 (low thru -1) /
     V7462 (low thru -1) /
     V7463 (low thru -1) /
     V7464 (low thru -1) /
     V7465 (low thru -1) /
     V7466 (low thru -1) /
     V7467 (low thru -1) /
     V7468 (low thru -1) /
     V7469 (low thru -1) /
     V7470 (low thru -1) /
     V7471 (low thru -1) /
     V7472 (low thru -1) /
     V7473 (low thru -1) /
     V7474 (low thru -1) /
     V7773 (low thru -1) /
     V7774 (low thru -1) /
     V7775 (low thru -1) /
     V7776 (low thru -1) /
     V7777 (low thru -1) /
     V7778 (low thru -1) /
     V7779 (low thru -1) /
     V7735 (low thru -1) /
     V7736 (low thru -1) /
     V7737 (low thru -1) /
     V7738 (low thru -1) /
     V7741 (low thru -1) /
     V7742 (low thru -1) /
     V7743 (low thru -1) /
     V7744 (low thru -1) /
     V7745 (low thru -1) /
     V7746 (low thru -1) /
     V7747 (low thru -1) /
     V7182 (low thru -1) /
     V7403 (low thru -1) /
     V7404 (low thru -1) /
     V7613 (low thru -1) /
     V8455 (low thru -1) /
     V7405 (low thru -1) /
     V7406 (low thru -1) /
     V7407 (low thru -1) /
     V7408 (low thru -1) /
     V7409 (low thru -1) /
     V7410 (low thru -1) /
     V7411 (low thru -1) /
     V7482 (low thru -1) /
     V7701 (low thru -1) /
     V7702 (low thru -1) /
     V7703 (low thru -1) /
     V7704 (low thru -1) /
     V7705 (low thru -1) /
     V7593 (low thru -1) /
     V7344 (low thru -1) /
     V7345 (low thru -1) /
     V7346 (low thru -1) /
     V7347 (low thru -1) /
     V7348 (low thru -1) /
     V7349 (low thru -1) /
     V7350 (low thru -1) /
     V7351 (low thru -1) /
     V7352 (low thru -1) /
     V7353 (low thru -1) /
     V7354 (low thru -1) /
     V7355 (low thru -1) /
     V7356 (low thru -1) /
     V7357 (low thru -1) /
     V8547 (low thru -1) /
     V8548 (low thru -1) /
     V7540 (low thru -1) /
     V7541 (low thru -1) /
     V8562 (low thru -1) /
     V8563 (low thru -1) /
     V7646 (low thru -1) /
     V7647 (low thru -1) /
     V7697 (low thru -1) /
     V7698 (low thru -1) /
     V8456 (low thru -1) /
     V8457 (low thru -1) /
     V8458 (low thru -1) /
     V8459 (low thru -1) /
     V8460 (low thru -1) /
     V8461 (low thru -1) /
     V8462 (low thru -1) /
     V7661 (low thru -1) /
     V7662 (low thru -1) /
     V7663 (low thru -1) /
     V7664 (low thru -1) /
     V7665 (low thru -1) /
     V7718 (low thru -1) /
     V7716 (low thru -1) /
     V7717 (low thru -1) /
     V7719 (low thru -1) /
     V7720 (low thru -1) /
     V7721 (low thru -1) /
     V7753 (low thru -1) /
     V7359 (low thru -1) /
     V7360 (low thru -1) /
     V7361 (low thru -1) /
     V7362 (low thru -1) /
     V7363 (low thru -1) /
     V8545 (low thru -1) /
     V8546 (low thru -1) /
     V7364 (low thru -1) /
     V7365 (low thru -1) /
     V7366 (low thru -1) /
     V7367 (low thru -1) /
     V7368 (low thru -1) /
     V7369 (low thru -1) /
     V7370 (low thru -1) /
     V8560 (low thru -1) /
     V8561 (low thru -1) /
     V7371 (low thru -1) /
     V7372 (low thru -1) /
     V7542 (low thru -1) /
     V7543 (low thru -1) /
     V7377 (low thru -1) /
     V7577 (low thru -1) /
     V7578 (low thru -1) /
     V7573 (low thru -1) /
     V7574 (low thru -1) /
     V7579 (low thru -1) /
     V7580 (low thru -1) /
     V7581 (low thru -1) /
     V7582 (low thru -1) /
     V7583 (low thru -1) /
     V7584 (low thru -1) /
     V7585 (low thru -1) /
     V7586 (low thru -1) /
     V7612 (low thru -1) /
     V7644 (low thru -1) /
     V7645 (low thru -1) /
     V7699 (low thru -1) /
     V7700 (low thru -1) /
     V7710 (low thru -1) /
     V7712 (low thru -1) /
     V7713 (low thru -1) /
     V7706 (low thru -1) /
     V7708 (low thru -1) /
     V7709 (low thru -1) /
     V7591 (low thru -1) /
     V7592 (low thru -1) /
     V7670 (low thru -1) /
     V7671 (low thru -1) /
     V7672 (low thru -1) /
     V7673 (low thru -1) /
     V7189 (low thru -1) /
     V7190 (low thru -1) /
     V7191 (low thru -1) /
     V7192 (low thru -1) /
     V7193 (low thru -1) /
     V7194 (low thru -1) /
     V7195 (low thru -1) /
     V7196 (low thru -1) /
     V7197 (low thru -1) /
     V7222 (low thru -1) /
     V7221 (low thru -1) /
     V7223 (low thru -1) /
     V7327 (low thru -1) /
     V7516 (low thru -1) /
     V7517 (low thru -1) /
     V7518 (low thru -1) /
     V7519 (low thru -1) /
     V7329 (low thru -1) /
     V7330 (low thru -1) /
     V7331 (low thru -1) /
     V7332 (low thru -1) /
     V7334 (low thru -1) /
     V7335 (low thru -1) /
     V7232 (low thru -1) /
     V7233 (low thru -1) /
     V7301 (low thru -1) /
     V7333 (low thru -1) /
     V7251 (low thru -1) /
     V7252 (low thru -1) /
     V7384 (low thru -1) /
     V7385 (low thru -1) /
     V7386 (low thru -1) /
     V7496 (low thru -1) /
     V7497 (low thru -1) /
     V7387 (low thru -1) /
     V7498 (low thru -1) /
     V7388 (low thru -1) /
     V7389 (low thru -1) /
     V7499 (low thru -1) /
     V7390 (low thru -1) /
     V7391 (low thru -1) /
     V7392 (low thru -1) /
     V7393 (low thru -1) /
     V7394 (low thru -1) /
     V7395 (low thru -1) /
     V7396 (low thru -1) /
     V7397 (low thru -1) /
     V7500 (low thru -1) /
     V7398 (low thru -1) /
     V7399 (low thru -1) /
     V7400 (low thru -1) /
     V7522 (low thru -1) /
     V7523 (low thru -1) /
     V7524 (low thru -1) /
     V7525 (low thru -1) /
     V7526 (low thru -1) /
     V7527 (low thru -1) /
     V7528 (low thru -1) /
     V7529 (low thru -1) /
     V7530 (low thru -1) /
     V7531 (low thru -1) /
     V8537 (low thru -1) /
     V8538 (low thru -1) /
     V7537 (low thru -1) /
     V7253 (low thru -1) /
     V7228 (low thru -1) /
     V7229 (low thru -1) /
     V7230 (low thru -1) /
     V7231 (low thru -1) /
     V8539 (low thru -1) /
     V8516 (low thru -1) /
     V8522 (low thru -1) /
     V7509 (low thru -1) /
     V7510 (low thru -1) /
     V7511 (low thru -1) /
     V7512 (low thru -1) /
     V7513 (low thru -1) /
     V7514 (low thru -1) /
     V7515 (low thru -1) /
     V7234 (low thru -1) /
     V8543 (low thru -1) /
     V7534 (low thru -1) /
     V7535 (low thru -1) /
     V7536 (low thru -1) /
     V7538 (low thru -1) /
     V7224 (low thru -1) /
     V7225 (low thru -1) /
     V7227 (low thru -1) /
     V7226 (low thru -1) /
     V7235 (low thru -1) /
     V7238 (low thru -1) /
     V7236 (low thru -1) /
     V7237 (low thru -1) /
     V7374 (low thru -1) /
     V7240 (low thru -1) /
     V7309 (low thru -1) /
     V7310 (low thru -1) /
     V7311 (low thru -1) /
     V7312 (low thru -1) /
     V7313 (low thru -1) /
     V7378 (low thru -1) /
     V7379 (low thru -1) /
     V7380 (low thru -1) /
     V7319 (low thru -1) /
     V7320 (low thru -1) /
     V7321 (low thru -1) /
     V7214 (low thru -1) /
     V7239 (low thru -1) /
     V7676 (low thru -1) /
     V7677 (low thru -1) /
     V7678 (low thru -1) /
     V7682 (low thru -1) /
     V7684 (low thru -1) /
     V7685 (low thru -1) /
     V7686 (low thru -1) /
     V7687 (low thru -1) /
     V7688 (low thru -1) /
     V7689 (low thru -1) /
     V7690 (low thru -1) /
     V7683 (low thru -1) /
     V7341 (low thru -1) /
     V7532 (low thru -1) /
     V7533 (low thru -1) /
     V7339 (low thru -1) /
     V7340 (low thru -1) /
     V7401 (low thru -1) /
     V7402 (low thru -1) /
     V7219 (low thru -1) /
     V7220 (low thru -1) /
     V7255 (low thru -1) /
     V7241 (low thru -1) /
     V7242 (low thru -1) /
     V7243 (low thru -1) /
     V7244 (low thru -1) /
     V7258 (low thru -1) /
     V7375 (low thru -1) /
     V7254 (low thru -1) /
     V7259 (low thru -1) /
     V7260 (low thru -1) /
     V7261 (low thru -1) /
     V7262 (low thru -1) /
     V7565 (low thru -1) /
     V7302 (low thru -1) /
     V8512 (low thru -1) /
     V8502 (low thru -1) /
     V8505 (low thru -1) /
     V8509 (low thru -1) /
     V8514 (low thru -1) /
     V8536 (low thru -1) /
     V8501 (low thru -1) /
     V8504 (low thru -1) /
     V8508 (low thru -1) /
     V8503 (low thru -1) /
     V8507 (low thru -1) /
     V8511 (low thru -1) /
     V8513 (low thru -1) /
     V7660 (low thru -1) /
     V7674 (low thru -1) /
     V7675 (low thru -1) /
     V7501 (low thru -1) /
     V7502 (low thru -1) /
     V7504 (low thru -1) /
     V7505 (low thru -1) /
     V7507 (low thru -1) /
     V7508 (low thru -1) /
     V7503 (low thru -1) /
     V7506 (low thru -1) /
     V8555 (low thru -1) /
     V8556 (low thru -1) /
     V8557 (low thru -1) /
     V8558 (low thru -1) /
     V8565 (low thru -1) /
     V8566 (low thru -1) /
     V1252 (low thru -1) /
     V7202 (low thru -1) /
     V1070 (low thru -1) /
     V7215 (low thru -1) /
     V7216 (low thru -1) /
     V7217 (low thru -1) /
     V7206 (low thru -1) /
     V7207 (low thru -1) /
     V7208 (low thru -1) /
     V7205 (low thru -1) /
     V8517 (low thru -1) /
     V8518 (low thru -1) /
     V8519 (low thru -1) /
     V8520 (low thru -1) /
     V8521 (low thru -1) /
     V8523 (low thru -1) /
     V8515 (low thru -1) /
     V7691 (low thru -1) /
     V7692 (low thru -1) /
     V8526 (low thru -1) /
     V8527 (low thru -1) /
     V8528 (low thru -1) /
     V8529 (low thru -1) /
     V8530 (low thru -1) /
     V8531 (low thru -1) /
     V7555 (low thru -1) /
     V7639 (low thru -1) /
     V7101D (low thru -1) /
     V7102D (low thru -1) /
     V7105D (low thru -1) /
     V7106D (low thru -1) /
     V7107D (low thru -1) /
     V7112D (low thru -1) /
     V7113D (low thru -1) /
     V7114D (low thru -1) /
     V7115D (low thru -1) /
     V7116D (low thru -1) /
     V7117D (low thru -1) /
     V7118D (low thru -1) /
     V7119D (low thru -1) /
     V7120D (low thru -1) /
     V7127D (low thru -1) /
     V7128D (low thru -1) /
     V7129D (low thru -1) /
     V7097D (low thru -1) /
     V7098D (low thru -1) /
     V7099D (low thru -1) /
     V7133D (low thru -1) /
     V7134D (low thru -1) /
     V7135D (low thru -1) /
     V7142D (low thru -1) /
     V7143D (low thru -1) /
     V7144D (low thru -1) /
     V7139D (low thru -1) /
     V7140D (low thru -1) /
     V7141D (low thru -1) /
   .

EXECUTE.

* SPSS VARIABLE LEVEL COMMAND.

VARIABLE LEVEL
   CASEID
   AI_08
   AI_10
   V1
   V5
   V501
    (scale).

VARIABLE LEVEL
   V3
   V507
   V508
   V509
   TABLET
   RANDOMDRAW
   V7101
   V7104
   V7105
   V7112
   V7115
   V7118
   V7127
   V7097
   V7133
   V7139
   V7142
   V8451
   V7426
   V7121
   V7124
   V7164
   V7145
   V7109
   V7152
   V7155
   V7158
   V7161
   V7601
   V8480
   V7648
   V7693
   V7755
   V7758
   V7761
   V7764
   V7767
   V7728
   V7106
   V7113
   V7116
   V7119
   V7128
   V7098
   V7134
   V7140
   V7143
   V8452
   V7122
   V7125
   V7165
   V7146
   V7110
   V7153
   V7156
   V7159
   V7162
   V7602
   V7488
   V7489
   V7491
   V7492
   V8481
   V7495
   V7554
   V7561
   V7564
   V7566
   V7568
   V7569
   V7640
   V7694
   V7756
   V7759
   V7762
   V7765
   V7768
   V7729
   V7102
   V7107
   V7114
   V7117
   V7120
   V7129
   V7099
   V7135
   V7141
   V7144
   V8453
   V7427
   V7123
   V7126
   V7166
   V7147
   V7111
   V7154
   V7157
   V7160
   V7163
   V7603
   V8482
   V7615
   V7616
   V7617
   V7642
   V7695
   V7669
   V7757
   V7760
   V7763
   V7766
   V7769
   V7730
   V7108
   V7641
   V8454
   V7726
   V7727
   V7731
   V7442
   V7441
   V8413
   V7443
   V7444
   V7445
   V8417
   V8418
   V8419
   V8483
   V8421
   V7446
   V7447
   V8424
   V8425
   V7448
   V7449
   V8564
   V7548
   V7638
   V7103
   V7180
   V7181
   V7475
   V7476
   V7477
   V7478
   V7479
   V7480
   V7771
   V7739
   V7547
   V7549
   V7550
   V7643
   V7176
   V7587
   V7722
   V7723
   V7724
   V7725
   V7733
   V7732
   V7557
   V7558
   V7428
   V7432
   V7433
   V7435
   V7430
   V7431
   V7434
   V7429
   V7436
   V8473
   V8474
   V8475
   V7752
   V7754
   V7437
   V7438
   V7439
   V7440
   V7414
   V7415
   V7416
   V7417
   V7494
   V7419
   V7420
   V7421
   V7422
   V7423
   V7412
   V7413
   V7490
   V7425
   V7424
   V8544
   V8477
   V7658
   V7659
   V7750
   V7167
   V7168
   V7169
   V7170
   V7171
   V7172
   V7173
   V7174
   V7175
   V7177
   V7178
   V7179
   V7199
   V7200
   V7185
   V7458
   V7186
   V7187
   V7188
   V7666
   V7668
   V7184
   V7451
   V7452
   V7453
   V7454
   V7455
   V7456
   V7457
   V8441
   V8442
   V8443
   V8444
   V8445
   V8446
   V8447
   V8476
   V8540
   V8541
   V8542
   V7481
   V7734
   V7183
   V7772
   V7740
   V7459
   V7460
   V7461
   V7462
   V7463
   V7464
   V7465
   V7466
   V7467
   V7468
   V7469
   V7470
   V7471
   V7472
   V7473
   V7474
   V7773
   V7774
   V7775
   V7776
   V7777
   V7778
   V7779
   V7735
   V7736
   V7737
   V7738
   V7741
   V7742
   V7743
   V7744
   V7745
   V7746
   V7747
   V7182
   V7403
   V7404
   V7613
   V8455
   V7405
   V7406
   V7407
   V7408
   V7409
   V7410
   V7411
   V7482
   V7701
   V7702
   V7703
   V7704
   V7705
   V7593
   V7344
   V7345
   V7346
   V7347
   V7348
   V7349
   V7350
   V7351
   V7352
   V7353
   V7354
   V7355
   V7356
   V7357
   V8547
   V8548
   V7540
   V7541
   V8562
   V8563
   V7646
   V7647
   V7697
   V7698
   V8456
   V8457
   V8458
   V8459
   V8460
   V8461
   V8462
   V7661
   V7662
   V7663
   V7664
   V7665
   V7718
   V7716
   V7717
   V7719
   V7720
   V7721
   V7753
   V7359
   V7360
   V7361
   V7362
   V7363
   V8545
   V8546
   V7364
   V7365
   V7366
   V7367
   V7368
   V7369
   V7370
   V8560
   V8561
   V7371
   V7372
   V7542
   V7543
   V7377
   V7577
   V7578
   V7573
   V7574
   V7579
   V7580
   V7581
   V7582
   V7583
   V7584
   V7585
   V7586
   V7612
   V7644
   V7645
   V7699
   V7700
   V7710
   V7712
   V7713
   V7706
   V7708
   V7709
   V7591
   V7592
   V7670
   V7671
   V7672
   V7673
   V7189
   V7190
   V7191
   V7192
   V7193
   V7194
   V7195
   V7196
   V7197
   V7222
   V7221
   V7223
   V7327
   V7516
   V7517
   V7518
   V7519
   V7329
   V7330
   V7331
   V7332
   V7334
   V7335
   V7232
   V7233
   V7301
   V7333
   V7251
   V7252
   V7384
   V7385
   V7386
   V7496
   V7497
   V7387
   V7498
   V7388
   V7389
   V7499
   V7390
   V7391
   V7392
   V7393
   V7394
   V7395
   V7396
   V7397
   V7500
   V7398
   V7399
   V7400
   V7522
   V7523
   V7524
   V7525
   V7526
   V7527
   V7528
   V7529
   V7530
   V7531
   V8537
   V8538
   V7537
   V7253
   V7228
   V7229
   V7230
   V7231
   V8539
   V8516
   V8522
   V7509
   V7510
   V7511
   V7512
   V7513
   V7514
   V7515
   V7234
   V8543
   V7534
   V7535
   V7536
   V7538
   V7224
   V7225
   V7227
   V7226
   V7235
   V7238
   V7236
   V7237
   V7374
   V7240
   V7309
   V7310
   V7311
   V7312
   V7313
   V7378
   V7379
   V7380
   V7319
   V7320
   V7321
   V7214
   V7239
   V7676
   V7677
   V7678
   V7682
   V7684
   V7685
   V7686
   V7687
   V7688
   V7689
   V7690
   V7683
   V7341
   V7532
   V7533
   V7339
   V7340
   V7401
   V7402
   V7219
   V7220
   V7255
   V7241
   V7242
   V7243
   V7244
   V7258
   V7375
   V7254
   V7259
   V7260
   V7261
   V7262
   V7565
   V7302
   V8512
   V8502
   V8505
   V8509
   V8514
   V8536
   V8501
   V8504
   V8508
   V8503
   V8507
   V8511
   V8513
   V7660
   V7674
   V7675
   V7501
   V7502
   V7504
   V7505
   V7507
   V7508
   V7503
   V7506
   V8555
   V8556
   V8557
   V8558
   V8565
   V8566
   V1252
   V7202
   V1070
   V7215
   V7216
   V7217
   V7206
   V7207
   V7208
   V7205
   V8517
   V8518
   V8519
   V8520
   V8521
   V8523
   V8515
   V7691
   V7692
   V8526
   V8527
   V8528
   V8529
   V8530
   V8531
   V7555
   V7639
   V7101D
   V7102D
   V7105D
   V7106D
   V7107D
   V7112D
   V7113D
   V7114D
   V7115D
   V7116D
   V7117D
   V7118D
   V7119D
   V7120D
   V7127D
   V7128D
   V7129D
   V7097D
   V7098D
   V7099D
   V7133D
   V7134D
   V7135D
   V7142D
   V7143D
   V7144D
   V7139D
   V7140D
   V7141D
    (nominal).

* SPSS PRINT FORMAT COMMAND.

PRINT FORMAT
   CASEID (F5)
   AI_08 (F5)
   AI_10 (F5)
   V1 (F4)
   V3 (F1)
   V5 (F15.13)
   V501 (F2)
   V507 (F1)
   V508 (F1)
   V509 (F1)
   TABLET (F1)
   RANDOMDRAW (F2)
   V7101 (F2)
   V7104 (F2)
   V7105 (F2)
   V7112 (F2)
   V7115 (F2)
   V7118 (F2)
   V7127 (F2)
   V7097 (F2)
   V7133 (F2)
   V7139 (F2)
   V7142 (F2)
   V8451 (F2)
   V7426 (F2)
   V7121 (F2)
   V7124 (F2)
   V7164 (F2)
   V7145 (F2)
   V7109 (F2)
   V7152 (F2)
   V7155 (F2)
   V7158 (F2)
   V7161 (F2)
   V7601 (F2)
   V8480 (F2)
   V7648 (F2)
   V7693 (F2)
   V7755 (F2)
   V7758 (F2)
   V7761 (F2)
   V7764 (F2)
   V7767 (F2)
   V7728 (F2)
   V7106 (F2)
   V7113 (F2)
   V7116 (F2)
   V7119 (F2)
   V7128 (F2)
   V7098 (F2)
   V7134 (F2)
   V7140 (F2)
   V7143 (F2)
   V8452 (F2)
   V7122 (F2)
   V7125 (F2)
   V7165 (F2)
   V7146 (F2)
   V7110 (F2)
   V7153 (F2)
   V7156 (F2)
   V7159 (F2)
   V7162 (F2)
   V7602 (F2)
   V7488 (F2)
   V7489 (F2)
   V7491 (F2)
   V7492 (F2)
   V8481 (F2)
   V7495 (F2)
   V7554 (F2)
   V7561 (F2)
   V7564 (F2)
   V7566 (F2)
   V7568 (F2)
   V7569 (F2)
   V7640 (F2)
   V7694 (F2)
   V7756 (F2)
   V7759 (F2)
   V7762 (F2)
   V7765 (F2)
   V7768 (F2)
   V7729 (F2)
   V7102 (F2)
   V7107 (F2)
   V7114 (F2)
   V7117 (F2)
   V7120 (F2)
   V7129 (F2)
   V7099 (F2)
   V7135 (F2)
   V7141 (F2)
   V7144 (F2)
   V8453 (F2)
   V7427 (F2)
   V7123 (F2)
   V7126 (F2)
   V7166 (F2)
   V7147 (F2)
   V7111 (F2)
   V7154 (F2)
   V7157 (F2)
   V7160 (F2)
   V7163 (F2)
   V7603 (F2)
   V8482 (F2)
   V7615 (F2)
   V7616 (F2)
   V7617 (F2)
   V7642 (F2)
   V7695 (F2)
   V7669 (F2)
   V7757 (F2)
   V7760 (F2)
   V7763 (F2)
   V7766 (F2)
   V7769 (F2)
   V7730 (F2)
   V7108 (F2)
   V7641 (F2)
   V8454 (F2)
   V7726 (F2)
   V7727 (F2)
   V7731 (F2)
   V7442 (F2)
   V7441 (F2)
   V8413 (F2)
   V7443 (F2)
   V7444 (F2)
   V7445 (F2)
   V8417 (F2)
   V8418 (F2)
   V8419 (F2)
   V8483 (F2)
   V8421 (F2)
   V7446 (F2)
   V7447 (F2)
   V8424 (F2)
   V8425 (F2)
   V7448 (F2)
   V7449 (F2)
   V8564 (F2)
   V7548 (F2)
   V7638 (F2)
   V7103 (F2)
   V7180 (F2)
   V7181 (F2)
   V7475 (F2)
   V7476 (F2)
   V7477 (F2)
   V7478 (F2)
   V7479 (F2)
   V7480 (F2)
   V7771 (F2)
   V7739 (F2)
   V7547 (F2)
   V7549 (F2)
   V7550 (F2)
   V7643 (F2)
   V7176 (F2)
   V7587 (F2)
   V7722 (F2)
   V7723 (F2)
   V7724 (F2)
   V7725 (F2)
   V7733 (F2)
   V7732 (F2)
   V7557 (F2)
   V7558 (F2)
   V7428 (F2)
   V7432 (F2)
   V7433 (F2)
   V7435 (F2)
   V7430 (F2)
   V7431 (F2)
   V7434 (F2)
   V7429 (F2)
   V7436 (F2)
   V8473 (F2)
   V8474 (F2)
   V8475 (F2)
   V7752 (F2)
   V7754 (F2)
   V7437 (F2)
   V7438 (F2)
   V7439 (F2)
   V7440 (F2)
   V7414 (F2)
   V7415 (F2)
   V7416 (F2)
   V7417 (F2)
   V7494 (F2)
   V7419 (F2)
   V7420 (F2)
   V7421 (F2)
   V7422 (F2)
   V7423 (F2)
   V7412 (F2)
   V7413 (F2)
   V7490 (F2)
   V7425 (F2)
   V7424 (F2)
   V8544 (F2)
   V8477 (F2)
   V7658 (F2)
   V7659 (F2)
   V7750 (F2)
   V7167 (F2)
   V7168 (F2)
   V7169 (F2)
   V7170 (F2)
   V7171 (F2)
   V7172 (F2)
   V7173 (F2)
   V7174 (F2)
   V7175 (F2)
   V7177 (F2)
   V7178 (F2)
   V7179 (F2)
   V7199 (F2)
   V7200 (F2)
   V7185 (F2)
   V7458 (F2)
   V7186 (F2)
   V7187 (F2)
   V7188 (F2)
   V7666 (F2)
   V7668 (F2)
   V7184 (F2)
   V7451 (F2)
   V7452 (F2)
   V7453 (F2)
   V7454 (F2)
   V7455 (F2)
   V7456 (F2)
   V7457 (F2)
   V8441 (F2)
   V8442 (F2)
   V8443 (F2)
   V8444 (F2)
   V8445 (F2)
   V8446 (F2)
   V8447 (F2)
   V8476 (F2)
   V8540 (F2)
   V8541 (F2)
   V8542 (F2)
   V7481 (F2)
   V7734 (F2)
   V7183 (F2)
   V7772 (F2)
   V7740 (F2)
   V7459 (F2)
   V7460 (F2)
   V7461 (F2)
   V7462 (F2)
   V7463 (F2)
   V7464 (F2)
   V7465 (F2)
   V7466 (F2)
   V7467 (F2)
   V7468 (F2)
   V7469 (F2)
   V7470 (F2)
   V7471 (F2)
   V7472 (F2)
   V7473 (F2)
   V7474 (F2)
   V7773 (F2)
   V7774 (F2)
   V7775 (F2)
   V7776 (F2)
   V7777 (F2)
   V7778 (F2)
   V7779 (F2)
   V7735 (F2)
   V7736 (F2)
   V7737 (F2)
   V7738 (F2)
   V7741 (F2)
   V7742 (F2)
   V7743 (F2)
   V7744 (F2)
   V7745 (F2)
   V7746 (F2)
   V7747 (F2)
   V7182 (F2)
   V7403 (F2)
   V7404 (F2)
   V7613 (F2)
   V8455 (F2)
   V7405 (F2)
   V7406 (F2)
   V7407 (F2)
   V7408 (F2)
   V7409 (F2)
   V7410 (F2)
   V7411 (F2)
   V7482 (F2)
   V7701 (F2)
   V7702 (F2)
   V7703 (F2)
   V7704 (F2)
   V7705 (F2)
   V7593 (F2)
   V7344 (F2)
   V7345 (F2)
   V7346 (F2)
   V7347 (F2)
   V7348 (F2)
   V7349 (F2)
   V7350 (F2)
   V7351 (F2)
   V7352 (F2)
   V7353 (F2)
   V7354 (F2)
   V7355 (F2)
   V7356 (F2)
   V7357 (F2)
   V8547 (F2)
   V8548 (F2)
   V7540 (F2)
   V7541 (F2)
   V8562 (F2)
   V8563 (F2)
   V7646 (F2)
   V7647 (F2)
   V7697 (F2)
   V7698 (F2)
   V8456 (F2)
   V8457 (F2)
   V8458 (F2)
   V8459 (F2)
   V8460 (F2)
   V8461 (F2)
   V8462 (F2)
   V7661 (F2)
   V7662 (F2)
   V7663 (F2)
   V7664 (F2)
   V7665 (F2)
   V7718 (F2)
   V7716 (F2)
   V7717 (F2)
   V7719 (F2)
   V7720 (F2)
   V7721 (F2)
   V7753 (F2)
   V7359 (F2)
   V7360 (F2)
   V7361 (F2)
   V7362 (F2)
   V7363 (F2)
   V8545 (F2)
   V8546 (F2)
   V7364 (F2)
   V7365 (F2)
   V7366 (F2)
   V7367 (F2)
   V7368 (F2)
   V7369 (F2)
   V7370 (F2)
   V8560 (F2)
   V8561 (F2)
   V7371 (F2)
   V7372 (F2)
   V7542 (F2)
   V7543 (F2)
   V7377 (F2)
   V7577 (F2)
   V7578 (F2)
   V7573 (F2)
   V7574 (F2)
   V7579 (F2)
   V7580 (F2)
   V7581 (F2)
   V7582 (F2)
   V7583 (F2)
   V7584 (F2)
   V7585 (F2)
   V7586 (F2)
   V7612 (F2)
   V7644 (F2)
   V7645 (F2)
   V7699 (F2)
   V7700 (F2)
   V7710 (F2)
   V7712 (F2)
   V7713 (F2)
   V7706 (F2)
   V7708 (F2)
   V7709 (F2)
   V7591 (F2)
   V7592 (F2)
   V7670 (F2)
   V7671 (F2)
   V7672 (F2)
   V7673 (F2)
   V7189 (F2)
   V7190 (F2)
   V7191 (F2)
   V7192 (F2)
   V7193 (F2)
   V7194 (F2)
   V7195 (F2)
   V7196 (F2)
   V7197 (F2)
   V7222 (F2)
   V7221 (F2)
   V7223 (F2)
   V7327 (F2)
   V7516 (F2)
   V7517 (F2)
   V7518 (F2)
   V7519 (F2)
   V7329 (F2)
   V7330 (F2)
   V7331 (F2)
   V7332 (F2)
   V7334 (F2)
   V7335 (F2)
   V7232 (F2)
   V7233 (F2)
   V7301 (F2)
   V7333 (F2)
   V7251 (F2)
   V7252 (F2)
   V7384 (F2)
   V7385 (F2)
   V7386 (F2)
   V7496 (F2)
   V7497 (F2)
   V7387 (F2)
   V7498 (F2)
   V7388 (F2)
   V7389 (F2)
   V7499 (F2)
   V7390 (F2)
   V7391 (F2)
   V7392 (F2)
   V7393 (F2)
   V7394 (F2)
   V7395 (F2)
   V7396 (F2)
   V7397 (F2)
   V7500 (F2)
   V7398 (F2)
   V7399 (F2)
   V7400 (F2)
   V7522 (F2)
   V7523 (F2)
   V7524 (F2)
   V7525 (F2)
   V7526 (F2)
   V7527 (F2)
   V7528 (F2)
   V7529 (F2)
   V7530 (F2)
   V7531 (F2)
   V8537 (F2)
   V8538 (F2)
   V7537 (F2)
   V7253 (F2)
   V7228 (F2)
   V7229 (F2)
   V7230 (F2)
   V7231 (F2)
   V8539 (F2)
   V8516 (F2)
   V8522 (F2)
   V7509 (F2)
   V7510 (F2)
   V7511 (F2)
   V7512 (F2)
   V7513 (F2)
   V7514 (F2)
   V7515 (F2)
   V7234 (F2)
   V8543 (F2)
   V7534 (F2)
   V7535 (F2)
   V7536 (F2)
   V7538 (F2)
   V7224 (F2)
   V7225 (F2)
   V7227 (F2)
   V7226 (F2)
   V7235 (F2)
   V7238 (F2)
   V7236 (F2)
   V7237 (F2)
   V7374 (F2)
   V7240 (F2)
   V7309 (F2)
   V7310 (F2)
   V7311 (F2)
   V7312 (F2)
   V7313 (F2)
   V7378 (F2)
   V7379 (F2)
   V7380 (F2)
   V7319 (F2)
   V7320 (F2)
   V7321 (F2)
   V7214 (F2)
   V7239 (F2)
   V7676 (F2)
   V7677 (F2)
   V7678 (F2)
   V7682 (F2)
   V7684 (F2)
   V7685 (F2)
   V7686 (F2)
   V7687 (F2)
   V7688 (F2)
   V7689 (F2)
   V7690 (F2)
   V7683 (F2)
   V7341 (F2)
   V7532 (F2)
   V7533 (F2)
   V7339 (F2)
   V7340 (F2)
   V7401 (F2)
   V7402 (F2)
   V7219 (F2)
   V7220 (F2)
   V7255 (F2)
   V7241 (F2)
   V7242 (F2)
   V7243 (F2)
   V7244 (F2)
   V7258 (F2)
   V7375 (F2)
   V7254 (F2)
   V7259 (F2)
   V7260 (F2)
   V7261 (F2)
   V7262 (F2)
   V7565 (F2)
   V7302 (F2)
   V8512 (F2)
   V8502 (F2)
   V8505 (F2)
   V8509 (F2)
   V8514 (F2)
   V8536 (F2)
   V8501 (F2)
   V8504 (F2)
   V8508 (F2)
   V8503 (F2)
   V8507 (F2)
   V8511 (F2)
   V8513 (F2)
   V7660 (F2)
   V7674 (F2)
   V7675 (F2)
   V7501 (F2)
   V7502 (F2)
   V7504 (F2)
   V7505 (F2)
   V7507 (F2)
   V7508 (F2)
   V7503 (F2)
   V7506 (F2)
   V8555 (F2)
   V8556 (F2)
   V8557 (F2)
   V8558 (F2)
   V8565 (F2)
   V8566 (F2)
   V1252 (F2)
   V7202 (F2)
   V1070 (F2)
   V7215 (F2)
   V7216 (F2)
   V7217 (F2)
   V7206 (F2)
   V7207 (F2)
   V7208 (F2)
   V7205 (F2)
   V8517 (F2)
   V8518 (F2)
   V8519 (F2)
   V8520 (F2)
   V8521 (F2)
   V8523 (F2)
   V8515 (F2)
   V7691 (F2)
   V7692 (F2)
   V8526 (F2)
   V8527 (F2)
   V8528 (F2)
   V8529 (F2)
   V8530 (F2)
   V8531 (F2)
   V7555 (F2)
   V7639 (F2)
   V7101D (F2)
   V7102D (F2)
   V7105D (F2)
   V7106D (F2)
   V7107D (F2)
   V7112D (F2)
   V7113D (F2)
   V7114D (F2)
   V7115D (F2)
   V7116D (F2)
   V7117D (F2)
   V7118D (F2)
   V7119D (F2)
   V7120D (F2)
   V7127D (F2)
   V7128D (F2)
   V7129D (F2)
   V7097D (F2)
   V7098D (F2)
   V7099D (F2)
   V7133D (F2)
   V7134D (F2)
   V7135D (F2)
   V7142D (F2)
   V7143D (F2)
   V7144D (F2)
   V7139D (F2)
   V7140D (F2)
   V7141D (F2)
  .

* Create SPSS system file.

*SAVE OUTFILE="spss-filename.sav".
