## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, include=FALSE-----------------------------------------------------
library(mosaicCalc)

## -----------------------------------------------------------------------------
# misguided!
f0 <- function(x) a*x + b 
g0 <- function(t) a*exp(-k*t)

## -----------------------------------------------------------------------------
f1 <- function(x, a, b) a*x + b 
g1 <- function(t, k, a) a*exp(-k*t)

## -----------------------------------------------------------------------------
f2 <- function(x, a=2, b=-3) a*x + b 
g2 <- function(t, k=0.5, a=10) a*exp(-k*t)

## -----------------------------------------------------------------------------
f3 <- makeFun(a*x + b ~ . , a=2, b=3)
g3 <- makeFun(a*exp(-k*t) ~ . , a=10, k=0.5)

## -----------------------------------------------------------------------------
D(f3(x)*g3(t) ~ x & t)
D(f3(x, a=10) * g3(t, k=1) ~ x & t)

## -----------------------------------------------------------------------------
slice_plot(dnorm(x) ~ x, bounds(x=-3:2))
Integrate(dnorm(x) ~ x, bounds(x=-2:2))

## -----------------------------------------------------------------------------
lm(mpg ~ wt + cyl, data = mtcars)

## -----------------------------------------------------------------------------
f <- makeFun(m*x + b ~ .)
f

## -----------------------------------------------------------------------------
makeFun(m*x + b ~ b/(m*x)) # bad style!

## -----------------------------------------------------------------------------
# Defining a function
g <- makeFun(1/x ~ .)
# Differentiation
D(g(x) ~ x)
D(g(x) ~ x & x) # 2nd derivative
# Integration
antiD(g(x) ~ x)

## -----------------------------------------------------------------------------
x <- spliner(x ~ t, data = Robot_stations) # makes a function from data
y <- spliner(y ~ t, data = Robot_stations) # ditto
traj_plot(y(t) ~ x(t), domain(t=1:16))

## -----------------------------------------------------------------------------
vectorfield_plot(x ~ -y, dy ~ x, domain(x=-1:1, y=-1:1))

## -----------------------------------------------------------------------------
T1 <- integrateODE(dx ~ sigma*(y-x),    # x dynamics
                   dy ~(x*(rho-z) - y), # y dynamics
                   dz ~ (x*y - beta*z), # z dynamics
                   domain(t=0:10), 
                   x=-5, y=-7, z=19.4,  # initial conditions
                   rho=28, sigma=10, beta = 8/3) # parameters
traj_plot(z(t) ~ y(t), T1, npts=1000)   # T1 is the solution

## -----------------------------------------------------------------------------
f <- makeFun(a*x^2 + b*x + c ~ .)
f

## -----------------------------------------------------------------------------
y <- makeFun(-9.8*t^2/2 + v0*t + y0 ~ .)
y

## -----------------------------------------------------------------------------
y <- makeFun(g*t^2/2 + v0*t + y0 ~ ., g=-9.8)
y

## -----------------------------------------------------------------------------
v_y <- D(y(t) ~ t)
v_y

## ----results=FALSE------------------------------------------------------------
Zeros(v_y(t, v0=20) ~ t, domain(t=0:20))

## -----------------------------------------------------------------------------
Zeros(v_y(t, v0=20, g=-1.6) ~ t, bounds(t=0:20))

## ----error=TRUE---------------------------------------------------------------
Zeros(v_y(t, v0=20, g=-1.6) ~ t, bounds(t=0:20))

## -----------------------------------------------------------------------------
v_y_on_moon <- D(y(t) ~ t, g=-1.6)
v_y_on_moon

## -----------------------------------------------------------------------------
Zeros(v_y_on_moon(t, v0=20) ~ t, bounds(t=0:20))

