/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.AbstractAction;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.IconView;
import javax.swing.text.Keymap;
import javax.swing.text.LabelView;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class NoWrapTextPane
extends JTextPane {
    public static final String LINE_BREAK_ATTRIBUTE_NAME = "line_break_attribute";
    private MyHierarchyListener hirearchyListener = null;

    public NoWrapTextPane() {
        this.setEditorKit(new WrapEditorKit());
        this.initKeyMap();
    }

    protected void insertLineBreak() {
        try {
            int n = this.getCaretPosition();
            Document document = this.getDocument();
            SimpleAttributeSet simpleAttributeSet = document instanceof StyledDocument ? new SimpleAttributeSet(((StyledDocument)document).getCharacterElement(n).getAttributes()) : new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(LINE_BREAK_ATTRIBUTE_NAME, Boolean.TRUE);
            document.insertString(n, "\r", simpleAttributeSet);
            this.setCaretPosition(n + 1);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    protected void initKeyMap() {
        Keymap keymap = this.getKeymap();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NoWrapTextPane.this.insertLineBreak();
            }
        };
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 1), abstractAction);
    }

    class WrapColumnFactory
    implements ViewFactory {
        WrapColumnFactory() {
        }

        @Override
        public View create(Element element) {
            String string = element.getName();
            if (string != null) {
                if (string.equals("content")) {
                    return new WrapLabelView(element);
                }
                if (string.equals("paragraph")) {
                    return new NoWrapParagraphView(element);
                }
                if (string.equals("section")) {
                    return new BoxView(element, 1);
                }
                if (string.equals("component")) {
                    return new ComponentView(element);
                }
                if (string.equals("icon")) {
                    return new IconView(element);
                }
            }
            return new LabelView(element);
        }
    }

    class WrapEditorKit
    extends StyledEditorKit {
        ViewFactory defaultFactory;

        WrapEditorKit() {
            this.defaultFactory = new WrapColumnFactory();
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.defaultFactory;
        }

        @Override
        public MutableAttributeSet getInputAttributes() {
            MutableAttributeSet mutableAttributeSet = super.getInputAttributes();
            mutableAttributeSet.removeAttribute(NoWrapTextPane.LINE_BREAK_ATTRIBUTE_NAME);
            return mutableAttributeSet;
        }
    }

    class WrapLabelView
    extends LabelView {
        public WrapLabelView(Element element) {
            super(element);
        }

        @Override
        public int getBreakWeight(int n, float f, float f2) {
            if (n == 0) {
                this.checkPainter();
                int n2 = this.getStartOffset();
                int n3 = this.getGlyphPainter().getBoundedPosition(this, n2, f, f2);
                if (n3 == n2) {
                    return 0;
                }
                try {
                    if (this.getDocument().getText(n2, n3 - n2).indexOf("\r") >= 0) {
                        return 3000;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return super.getBreakWeight(n, f, f2);
        }

        @Override
        public View breakView(int n, int n2, float f, float f2) {
            if (n == 0) {
                this.checkPainter();
                int n3 = this.getGlyphPainter().getBoundedPosition(this, n2, f, f2);
                try {
                    int n4 = this.getDocument().getText(n2, n3 - n2).indexOf("\r");
                    if (n4 >= 0) {
                        GlyphView glyphView = (GlyphView)this.createFragment(n2, n2 + n4 + 1);
                        return glyphView;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return super.breakView(n, n2, f, f2);
        }
    }

    class NoWrapParagraphView
    extends ParagraphView {
        public NoWrapParagraphView(Element element) {
            super(element);
        }

        @Override
        public void layout(int n, int n2) {
            super.layout(Short.MAX_VALUE, n2);
        }

        @Override
        public float getMinimumSpan(int n) {
            return super.getPreferredSpan(n);
        }
    }

    public class MyHierarchyListener
    implements HierarchyListener {
        private Container oldParent;
        Component comp;
        JTextPane textPane;

        public MyHierarchyListener(Component component, JTextPane jTextPane) {
            this.comp = component;
            this.textPane = jTextPane;
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            Container container = this.comp.getParent();
            if (container != this.oldParent) {
                if (this.oldParent != null) {
                    this.textPane.remove(this.oldParent);
                }
                this.oldParent = container;
            }
        }
    }
}

