/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.matrices.decomposition.ElementaryTransformations;
import jdplus.toolkit.base.core.math.matrices.decomposition.ISingularValueDecomposition;

public class SingularValueDecomposition
implements ISingularValueDecomposition {
    private double[] m_U;
    private double[] m_V;
    private double[] m_s;
    private int m_m;
    private int m_n;

    @Override
    public void decompose(FastMatrix A) throws MatrixException {
        this.init(A);
    }

    private void init(FastMatrix matrix) {
        int i;
        double t;
        int j;
        int k;
        int i2;
        double[] A = matrix.toArray();
        this.m_m = matrix.getRowsCount();
        this.m_n = matrix.getColumnsCount();
        int nu = Math.min(this.m_m, this.m_n);
        this.m_s = new double[Math.min(this.m_m + 1, this.m_n)];
        this.m_U = new double[this.m_m * nu];
        this.m_V = new double[this.m_n * this.m_n];
        if (this.m_n == 1) {
            DataBlock a = DataBlock.of(A);
            this.m_s[0] = a.norm2();
            for (int i3 = 0; i3 < this.m_m; ++i3) {
                this.m_U[i3] = A[i3] / this.m_s[0];
            }
            this.m_V[0] = 1.0;
            return;
        }
        double[] e = new double[this.m_n];
        double[] work = new double[this.m_m];
        boolean wantu = true;
        boolean wantv = true;
        int nct = Math.min(this.m_m - 1, this.m_n);
        int nrt = Math.max(0, Math.min(this.m_n - 2, this.m_m));
        int k2 = 0;
        int mk = 0;
        while (k2 < Math.max(nct, nrt)) {
            int i4;
            int i5;
            if (k2 < nct) {
                this.m_s[k2] = 0.0;
                for (i5 = mk + k2; i5 < mk + this.m_m; ++i5) {
                    this.m_s[k2] = ElementaryTransformations.hypotenuse(this.m_s[k2], A[i5]);
                }
                if (this.m_s[k2] != 0.0) {
                    if (A[k2 + mk] < 0.0) {
                        this.m_s[k2] = -this.m_s[k2];
                    }
                    i5 = mk + k2;
                    while (i5 < mk + this.m_m) {
                        int n = i5++;
                        A[n] = A[n] / this.m_s[k2];
                    }
                    int n = k2 + mk;
                    A[n] = A[n] + 1.0;
                }
                this.m_s[k2] = -this.m_s[k2];
            }
            int j2 = k2 + 1;
            int mj = this.m_m * j2;
            while (j2 < this.m_n) {
                if (k2 < nct && this.m_s[k2] != 0.0) {
                    double t2 = 0.0;
                    for (i4 = k2; i4 < this.m_m; ++i4) {
                        t2 += A[i4 + mk] * A[i4 + mj];
                    }
                    t2 = -t2 / A[k2 + mk];
                    for (i4 = k2; i4 < this.m_m; ++i4) {
                        int n = i4 + mj;
                        A[n] = A[n] + t2 * A[i4 + mk];
                    }
                }
                e[j2] = A[k2 + mj];
                ++j2;
                mj += this.m_m;
            }
            if (wantu & k2 < nct) {
                System.arraycopy(A, k2 + mk, this.m_U, k2 + mk, this.m_m - k2);
            }
            if (k2 < nrt) {
                e[k2] = 0.0;
                for (i5 = k2 + 1; i5 < this.m_n; ++i5) {
                    e[k2] = ElementaryTransformations.hypotenuse(e[k2], e[i5]);
                }
                if (e[k2] != 0.0) {
                    if (e[k2 + 1] < 0.0) {
                        e[k2] = -e[k2];
                    }
                    i5 = k2 + 1;
                    while (i5 < this.m_n) {
                        int n = i5++;
                        e[n] = e[n] / e[k2];
                    }
                    int n = k2 + 1;
                    e[n] = e[n] + 1.0;
                }
                e[k2] = -e[k2];
                if (k2 + 1 < this.m_m && e[k2] != 0.0) {
                    for (i5 = k2 + 1; i5 < this.m_m; ++i5) {
                        work[i5] = 0.0;
                    }
                    j2 = k2 + 1;
                    mj = this.m_m * j2;
                    while (j2 < this.m_n) {
                        for (int i6 = k2 + 1; i6 < this.m_m; ++i6) {
                            int n = i6;
                            work[n] = work[n] + e[j2] * A[i6 + mj];
                        }
                        ++j2;
                        mj += this.m_m;
                    }
                    j2 = k2 + 1;
                    mj = this.m_m * j2;
                    while (j2 < this.m_n) {
                        double t3 = -e[j2] / e[k2 + 1];
                        for (i4 = k2 + 1; i4 < this.m_m; ++i4) {
                            int n = i4 + mj;
                            A[n] = A[n] + t3 * work[i4];
                        }
                        ++j2;
                        mj += this.m_m;
                    }
                }
                if (wantv) {
                    System.arraycopy(e, k2 + 1, this.m_V, this.m_n * k2 + k2 + 1, this.m_n - k2 - 1);
                }
            }
            ++k2;
            mk += this.m_m;
        }
        int p = Math.min(this.m_n, this.m_m + 1);
        if (nct < this.m_n) {
            this.m_s[nct] = A[nct + this.m_m * nct];
        }
        if (this.m_m < p) {
            this.m_s[p - 1] = 0.0;
        }
        if (nrt + 1 < p) {
            e[nrt] = A[nrt + this.m_m * (p - 1)];
        }
        e[p - 1] = 0.0;
        if (wantu) {
            int j3 = nct;
            int mj = this.m_m * j3;
            while (j3 < nu) {
                for (i2 = 0; i2 < this.m_m; ++i2) {
                    this.m_U[i2 + mj] = 0.0;
                }
                this.m_U[j3 + mj] = 1.0;
                ++j3;
                mj += this.m_m;
            }
            k = nct - 1;
            int mk2 = this.m_m * k;
            while (k >= 0) {
                if (this.m_s[k] != 0.0) {
                    j = k + 1;
                    int mj2 = this.m_m * j;
                    while (j < nu) {
                        t = 0.0;
                        for (i = k; i < this.m_m; ++i) {
                            t += this.m_U[i + mk2] * this.m_U[i + mj2];
                        }
                        t = -t / this.m_U[k + mk2];
                        for (i = k; i < this.m_m; ++i) {
                            int n = i + mj2;
                            this.m_U[n] = this.m_U[n] + t * this.m_U[i + mk2];
                        }
                        ++j;
                        mj2 += this.m_m;
                    }
                    for (i2 = k; i2 < this.m_m; ++i2) {
                        this.m_U[i2 + mk2] = -this.m_U[i2 + mk2];
                    }
                    this.m_U[k + mk2] = 1.0 + this.m_U[k + mk2];
                    for (i2 = 0; i2 < k - 1; ++i2) {
                        this.m_U[i2 + mk2] = 0.0;
                    }
                } else {
                    for (i2 = 0; i2 < this.m_m; ++i2) {
                        this.m_U[i2 + mk2] = 0.0;
                    }
                    this.m_U[k + mk2] = 1.0;
                }
                --k;
                mk2 -= this.m_m;
            }
        }
        if (wantv) {
            k = this.m_n - 1;
            int nk = this.m_n * k;
            while (k >= 0) {
                if (k < nrt && e[k] != 0.0) {
                    j = k + 1;
                    int nj = this.m_n * j;
                    while (j < nu) {
                        t = 0.0;
                        for (i = k + 1; i < this.m_n; ++i) {
                            t += this.m_V[i + nk] * this.m_V[i + nj];
                        }
                        t = -t / this.m_V[k + 1 + nk];
                        for (i = k + 1; i < this.m_n; ++i) {
                            int n = i + nj;
                            this.m_V[n] = this.m_V[n] + t * this.m_V[i + nk];
                        }
                        ++j;
                        nj += this.m_n;
                    }
                }
                for (i2 = 0; i2 < this.m_n; ++i2) {
                    this.m_V[i2 + nk] = 0.0;
                }
                this.m_V[k + nk] = 1.0;
                --k;
                nk -= this.m_n;
            }
        }
        int pp = p - 1;
        int iter = 0;
        double eps = Constants.getEpsilon();
        block34: while (p > 0) {
            int kase;
            int k3;
            for (k3 = p - 2; k3 >= -1 && k3 != -1; --k3) {
                if (!(Math.abs(e[k3]) <= eps * (Math.abs(this.m_s[k3]) + Math.abs(this.m_s[k3 + 1])))) continue;
                e[k3] = 0.0;
                break;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k3 && ks != k3; --ks) {
                    double t4 = (ks != p ? Math.abs(e[ks]) : 0.0) + (ks != k3 + 1 ? Math.abs(e[ks - 1]) : 0.0);
                    if (!(Math.abs(this.m_s[ks]) <= eps * t4)) continue;
                    this.m_s[ks] = 0.0;
                    break;
                }
                kase = ks == k3 ? 3 : (ks == p - 1 ? 1 : 2);
                k3 = ks;
            }
            ++k3;
            switch (kase) {
                case 1: {
                    int i7;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[p - 2];
                    e[p - 2] = 0.0;
                    for (int j4 = p - 2; j4 >= k3; --j4) {
                        t5 = ElementaryTransformations.hypotenuse(this.m_s[j4], f);
                        cs = this.m_s[j4] / t5;
                        sn = f / t5;
                        this.m_s[j4] = t5;
                        if (j4 != k3) {
                            f = -sn * e[j4 - 1];
                            e[j4 - 1] = cs * e[j4 - 1];
                        }
                        if (!wantv) continue;
                        int np = this.m_n * (p - 1);
                        int nj = this.m_n * j4;
                        for (i7 = 0; i7 < this.m_n; ++i7) {
                            t5 = cs * this.m_V[i7 + nj] + sn * this.m_V[i7 + np];
                            this.m_V[i7 + np] = -sn * this.m_V[i7 + nj] + cs * this.m_V[i7 + np];
                            this.m_V[i7 + nj] = t5;
                        }
                    }
                    continue block34;
                }
                case 2: {
                    int i7;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[k3 - 1];
                    e[k3 - 1] = 0.0;
                    for (int j5 = k3; j5 < p; ++j5) {
                        t5 = ElementaryTransformations.hypotenuse(this.m_s[j5], f);
                        cs = this.m_s[j5] / t5;
                        sn = f / t5;
                        this.m_s[j5] = t5;
                        f = -sn * e[j5];
                        e[j5] = cs * e[j5];
                        if (!wantu) continue;
                        int mk3 = this.m_m * (k3 - 1);
                        int mj = this.m_m * j5;
                        for (i7 = 0; i7 < this.m_m; ++i7) {
                            t5 = cs * this.m_U[i7 + mj] + sn * this.m_U[i7 + mk3];
                            this.m_U[i7 + mk3] = -sn * this.m_U[i7 + mj] + cs * this.m_U[i7 + mk3];
                            this.m_U[i7 + mj] = t5;
                        }
                    }
                    continue block34;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this.m_s[p - 1]), Math.abs(this.m_s[p - 2])), Math.abs(e[p - 2])), Math.abs(this.m_s[k3])), Math.abs(e[k3]));
                    double sp = this.m_s[p - 1] / scale;
                    double spm1 = this.m_s[p - 2] / scale;
                    double epm1 = e[p - 2] / scale;
                    double sk = this.m_s[k3] / scale;
                    double ek = e[k3] / scale;
                    double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b != 0.0 || c != 0.0) {
                        shift = Math.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (sk + sp) * (sk - sp) + shift;
                    double g = sk * ek;
                    for (int j6 = k3; j6 < p - 1; ++j6) {
                        int nj = this.m_n * j6;
                        int nj1 = nj + this.m_n;
                        double t6 = ElementaryTransformations.hypotenuse(f, g);
                        double cs = f / t6;
                        double sn = g / t6;
                        if (j6 != k3) {
                            e[j6 - 1] = t6;
                        }
                        f = cs * this.m_s[j6] + sn * e[j6];
                        e[j6] = cs * e[j6] - sn * this.m_s[j6];
                        g = sn * this.m_s[j6 + 1];
                        this.m_s[j6 + 1] = cs * this.m_s[j6 + 1];
                        if (wantv) {
                            for (int i8 = 0; i8 < this.m_n; ++i8) {
                                t6 = cs * this.m_V[i8 + nj] + sn * this.m_V[i8 + nj1];
                                this.m_V[i8 + nj1] = -sn * this.m_V[i8 + nj] + cs * this.m_V[i8 + nj1];
                                this.m_V[i8 + nj] = t6;
                            }
                        }
                        t6 = ElementaryTransformations.hypotenuse(f, g);
                        cs = f / t6;
                        sn = g / t6;
                        this.m_s[j6] = t6;
                        f = cs * e[j6] + sn * this.m_s[j6 + 1];
                        this.m_s[j6 + 1] = -sn * e[j6] + cs * this.m_s[j6 + 1];
                        g = sn * e[j6 + 1];
                        e[j6 + 1] = cs * e[j6 + 1];
                        if (!wantu || j6 >= this.m_m - 1) continue;
                        int mj = this.m_m * j6;
                        int mj1 = mj + this.m_m;
                        for (int i9 = 0; i9 < this.m_m; ++i9) {
                            t6 = cs * this.m_U[i9 + mj] + sn * this.m_U[i9 + mj1];
                            this.m_U[i9 + mj1] = -sn * this.m_U[i9 + mj] + cs * this.m_U[i9 + mj1];
                            this.m_U[i9 + mj] = t6;
                        }
                    }
                    e[p - 2] = f;
                    ++iter;
                    break;
                }
                case 4: {
                    if (this.m_s[k3] <= 0.0) {
                        double d = this.m_s[k3] = this.m_s[k3] < 0.0 ? -this.m_s[k3] : 0.0;
                        if (wantv) {
                            for (int i10 = this.m_n * k3; i10 <= this.m_n * k3 + pp; ++i10) {
                                this.m_V[i10] = -this.m_V[i10];
                            }
                        }
                    }
                    while (k3 < pp && !(this.m_s[k3] >= this.m_s[k3 + 1])) {
                        int i11;
                        double t7 = this.m_s[k3];
                        this.m_s[k3] = this.m_s[k3 + 1];
                        this.m_s[k3 + 1] = t7;
                        if (wantv && k3 < this.m_n - 1) {
                            int nk = this.m_n * k3;
                            int nk1 = nk + this.m_n;
                            for (i11 = 0; i11 < this.m_n; ++i11) {
                                t7 = this.m_V[i11 + nk1];
                                this.m_V[i11 + nk1] = this.m_V[i11 + nk];
                                this.m_V[i11 + nk] = t7;
                            }
                        }
                        if (wantu && k3 < this.m_m - 1) {
                            int mk4 = this.m_m * k3;
                            int mk1 = mk4 + this.m_m;
                            for (i11 = 0; i11 < this.m_m; ++i11) {
                                t7 = this.m_U[i11 + mk1];
                                this.m_U[i11 + mk1] = this.m_U[i11 + mk4];
                                this.m_U[i11 + mk4] = t7;
                            }
                        }
                        ++k3;
                    }
                    iter = 0;
                    --p;
                }
            }
        }
    }

    @Override
    public FastMatrix U() {
        return new FastMatrix(this.m_U, this.m_m, Math.min(this.m_m, this.m_n));
    }

    @Override
    public FastMatrix V() {
        return new FastMatrix(this.m_V, this.m_n, this.m_n);
    }

    public double[] getSingularValues() {
        return this.m_s;
    }

    @Override
    public DoubleSeq S() {
        return DoubleSeq.of((double[])this.m_s);
    }

    public double norm2() {
        return this.m_s[0];
    }

    public double cond() {
        return this.m_s[0] / this.m_s[Math.min(this.m_m, this.m_n) - 1];
    }

    @Override
    public int rank() {
        double eps = Constants.getEpsilon();
        double tol = (double)Math.max(this.m_m, this.m_n) * this.m_s[0] * eps;
        int r = 0;
        for (int i = 0; i < this.m_s.length; ++i) {
            if (!(this.m_s[i] > tol)) continue;
            ++r;
        }
        return r;
    }

    @Override
    public boolean isFullRank() {
        return this.rank() == this.m_s.length;
    }

    private double[] solve(double[] b) throws MatrixException {
        if (b.length != this.m_m) {
            throw new MatrixException("Incompatible dimensions");
        }
        double[] rslt = new double[this.m_n];
        int r = this.rank();
        int idxU = 0;
        int idxV = 0;
        for (int i = 0; i < r; ++i) {
            double x = 0.0;
            int j = 0;
            while (j < this.m_m) {
                x += this.m_U[idxU] * b[j];
                ++j;
                ++idxU;
            }
            x /= this.m_s[i];
            j = 0;
            while (j < this.m_n) {
                int n = j++;
                rslt[n] = rslt[n] + this.m_V[idxV] * x;
                ++idxV;
            }
        }
        return rslt;
    }

    public void solve(DoubleSeq xin, DataBlock xout) throws MatrixException {
        double[] data = new double[xin.length()];
        xin.copyTo(data, 0);
        double[] rslt = this.solve(data);
        xout.copyFrom(rslt, 0);
    }

    public void solve(FastMatrix B, FastMatrix X) {
        DataBlockIterator b = B.columnsIterator();
        DataBlockIterator x = X.columnsIterator();
        while (b.hasNext()) {
            this.solve((DoubleSeq)b.next(), x.next());
        }
    }
}

