## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width  =  6,
  fig.height =  6,
  fig.align = "center",
  fig.path = ""
)

## -----------------------------------------------------------------------------
library(lavaan)
library(semlrtp)

## -----------------------------------------------------------------------------
data(data_sem16)
print(head(data_sem16), digits = 2)

## -----------------------------------------------------------------------------
mod <-
"
f1 =~ x1 + x2 + x3
f2 =~ x5 + x6 + x7
f3 =~ x9 + x10 + x11
f4 =~ x13 + x14 + x15
f3 ~ f1 + f2
f4 ~ f3
"

## -----------------------------------------------------------------------------
fit <- sem(mod,
           data_sem16)

## -----------------------------------------------------------------------------
fit_lrtp <- lrtp(fit)

## -----------------------------------------------------------------------------
fit_lrtp

## -----------------------------------------------------------------------------
mod_f3_f2 <-
"
f1 =~ x1 + x2 + x3
f2 =~ x5 + x6 + x7
f3 =~ x9 + x10 + x11
f4 =~ x13 + x14 + x15
f3 ~ f1 + 0*f2
f4 ~ f3
"
fit_f3_f2 <- sem(mod_f3_f2,
                 data_sem16)
lavTestLRT(fit_f3_f2,
           fit)

## ----echo = FALSE-------------------------------------------------------------
est <- parameterEstimates(fit)
f3_f2_wald_p <- est[14, "pvalue"]
f3_f2_lrt_p <- fit_lrtp[14, "LRTp"]

## -----------------------------------------------------------------------------
mod2 <-
"
f1 =~ x2 + x1 + x3
f2 =~ x7 + x5 + x6
f3 =~ x11 + x9 + x10
f4 =~ x14 + x13 + x15
f3 ~ f1 + f2
f4 ~ f3
"
fit2 <- sem(mod2,
            data_sem16)

## -----------------------------------------------------------------------------
fitMeasures(fit, c("chisq", "df"))
fitMeasures(fit2, c("chisq", "df"))

## ----echo = FALSE-------------------------------------------------------------
est2 <- parameterEstimates(fit2, output = "text")
tmp <- capture.output(est2)
f3_f2_wald_p2 <- est2[14, "pvalue"]

## ----echo = FALSE-------------------------------------------------------------
cat(tmp[21:27], sep = "\n")

## -----------------------------------------------------------------------------
fit2_lrtp <- lrtp(fit2)
fit2_lrtp

## -----------------------------------------------------------------------------
fit_lrtp_loadings <- lrtp(fit,
                          op = "=~")
fit_lrtp_loadings

