## ----echo=FALSE---------------------------------------------------------------
knitr::opts_chunk$set(comment = "")

## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, paged.print=FALSE)

## -----------------------------------------------------------------------------
library(sp)
getMethod("$", "SpatialPoints")

## -----------------------------------------------------------------------------
data(meuse)
names(meuse)

## -----------------------------------------------------------------------------
coordinates(meuse) <- ~ x + y
names(meuse)

## -----------------------------------------------------------------------------
colnames(slot(meuse, "coords"))

## -----------------------------------------------------------------------------
str(meuse$x)

## -----------------------------------------------------------------------------
run <- requireNamespace("sf", quietly = TRUE)

## ----eval=run-----------------------------------------------------------------
meuse_rt <- as(sf::st_as_sf(meuse), "Spatial")
names(meuse_rt)

## ----eval=run-----------------------------------------------------------------
colnames(slot(meuse_rt, "coords"))

## ----echo=FALSE---------------------------------------------------------------
run <- requireNamespace("terra", quietly=TRUE)
run <- run && require("raster", quietly=TRUE)

## ----eval=run-----------------------------------------------------------------
v <- terra::vect(matrix(c(0, 0), nrow=1), crs="OGC:CRS84")

## ----eval=run-----------------------------------------------------------------
library(raster)
slot(as(v, "Spatial"), "proj4string")

