library(spdep)
library(sf)
columbus <- st_read(system.file("shapes/columbus.gpkg", package="spData")[1], quiet=TRUE)
rn <- row.names(columbus)
col.gal.nb <- poly2nb(columbus, row.names=rn)
col_geoms <- st_geometry(columbus)
col_geoms[21] <- st_buffer(col_geoms[21], dist=-0.05)
st_geometry(columbus) <- col_geoms
expect_warning(col_nb21 <- poly2nb(columbus, row.names=rn))
expect_warning(pl1 <- diffnb(col.gal.nb, col_nb21, legacy=TRUE))
expect_warning(pl2 <- diffnb(col.gal.nb, col_nb21, legacy=FALSE))
expect_true(isTRUE(all.equal(pl1, pl2, check.attributes=FALSE)))
expect_warning(pl3 <- union.nb(setdiff.nb(col.gal.nb, col_nb21), setdiff.nb(col_nb21, col.gal.nb)))
expect_true(isTRUE(all.equal(pl1, pl3, check.attributes=FALSE)))
coords <- st_coordinates(st_centroid(columbus))
rn <- row.names(columbus)
nb0 <- tri2nb(coords)
nb1 <- graph2nb(soi.graph(nb0, coords), row.names=rn)
expect_warning(diffst <- diffnb(nb0, nb1, legacy=TRUE))
expect_warning(diffst0 <- diffnb(nb1, nb0, legacy=TRUE))
expect_true(isTRUE(all.equal(diffst, diffst0, check.attributes=FALSE)))
nb2 <- graph2nb(gabrielneigh(coords), row.names=rn)
diffs <- diffnb(nb2, nb1, legacy=TRUE)
diffs0 <- diffnb(nb1, nb2, legacy=TRUE)
expect_true(isTRUE(all.equal(diffs, diffs0, check.attributes=FALSE)))
diffsl <- diffnb(nb2, nb1, legacy=FALSE)
expect_true(isTRUE(all.equal(diffs, diffsl, check.attributes=FALSE)))
expect_warning(diffsd <- union.nb(setdiff.nb(nb1, nb2), setdiff.nb(nb2, nb1)))
expect_true(isTRUE(all.equal(diffs, diffsd, check.attributes=FALSE)))
cpl1 <- complement.nb(col_nb21)
expect_warning(ccpl1 <- complement.nb(cpl1))
expect_true(isTRUE(all.equal(col_nb21, ccpl1, check.attributes=FALSE)))
expect_warning(ipl1 <- intersect.nb(col.gal.nb, col_nb21))
expect_true(isTRUE(all.equal(ipl1, col_nb21, check.attributes=FALSE)))
